import showErrors from '@/support/showErrors'
import {mapListings} from '@/services/IntegrationsService'

export default {
  data () {
    return {
      showMapProductModal: false,
      selectedRowToMap: null,
      mappingLoading: false,
      initialMapping: false,
      showCreateProducts: false,
      dataForProductsCreation: {
        items: [],
        allSelected: false,
        filters: null
      },
      updateMappings: false,
      mappingVariantPropertyName: null,
    }
  },
  computed: {
    isUpdateMappings () {
      return this.updateMappings
    },
  },
  methods: {
    async selectProduct (product) {
      try {
        this.mappingLoading = true
        const sendData = this.getSendDataForSelectData(product)

        await this.mapListings(this.$route.params.instanceId, sendData)
        this.$notification.$emit('success', { html: 'Updated successfully!' })

        this.reloadData()
        this.showMapProductModal = false
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.mappingLoading = false
      }
    },
    createProduct (item) {
      this.resetDataForProductCreation()
      this.dataForProductsCreation.items = [item]
      this.showCreateProducts = true
      this.initialMapping = false
    },
    resetDataForProductCreation () {
      this.dataForProductsCreation = {
        items: [],
        allSelected: false,
        filters: null
      }
    },
    createSkuProducts (usefulProps, items) {
      this.resetDataForProductCreation()

      if (this.getSelectedAllRows) {
        this.dataForProductsCreation.allSelected = true
        this.dataForProductsCreation.filters = this.getFilteringCriteria
      } else {
        this.dataForProductsCreation.items = items
      }

      this.showCreateProducts = true
      this.initialMapping = true
      usefulProps.closeMenu()
    },
    openSKUMapping () {
      this.dataForProductsCreation.items = []
      this.showCreateProducts = true
      this.initialMapping = true
      this.updateMappings = true
    },
    onCloseCreateProductModal () {
      this.showCreateProducts = false
      this.updateMappings = false
    },
    async mapListings (instanceId, sendData) {
      return await mapListings(instanceId, sendData)
    },
    getSendDataForSelectData (product, isBulk = false) {
      if (!this.mappingVariantPropertyName) return console.warn(`The "mappingVariantPropertyName" property is not valid and must be changed for the current integration`)
      const mapping = isBulk ?
        this.getSelectedRowsObjects.map( r => ({
          sales_channel_listing_id: r[this.mappingVariantPropertyName] ? r[this.mappingVariantPropertyName].toString() : null,
          mapped_sku: product ? product.sku : null
        })):
        [
          {
            sales_channel_listing_id: this.selectedRowToMap[this.mappingVariantPropertyName] ? this.selectedRowToMap[this.mappingVariantPropertyName].toString(): null,
            mapped_sku: product ? product.sku : null
          }
        ]
      return { mapping }
    }
  }
}
