export default {
  data () {
    return {
      inventoryLocations: [],
      initialValues: {},
      initialLoading: false
    }
  },
  methods: {
    initValues (settings) {
      this.initialLoading = true
      this.inventoryLocations = []

      if (settings.inventory === undefined || settings.inventory.locations === undefined) {
        this.inventoryLocations = []
      } else {
        this.inventoryLocations = settings.inventory.locations
      }

      // clone
      this.initialValues = JSON.parse(JSON.stringify({
        inventoryLocations: this.inventoryLocations
      }))

      this.$nextTick(() => {
        this.initialLoading = false
      })
    },
    updateLocation (value, index) {
      this.$set(this.locations, index, value)
    },
    revertChanges () {
      this.initValues(this.initialValues)
    }
  }
}
