import { mapGetters, mapActions } from 'vuex'
import showErrors from '@/support/showErrors'

export default {
  computed: {
    ...mapGetters('NominalCodes', ['getFormattedNominalCodes',]),
    nominalCodes () {
      return [
        { id: null, name_with_code: 'Select Nominal Code', },
        ...this.getFormattedNominalCodes,
      ]
    },
  },
  methods: {
    ...mapActions('FinancialLineTypesModule', [
      'fetchFinancialLineTypes',
    ]),
    ...mapActions('NominalCodes', { fetchNominalCodes: 'getItemsRequest', }),
    async fetchInitData () {
      Promise.allSettled([
        this.fetchFinancialLineTypes(),
        this.fetchNominalCodes({ limit: -1 })
      ])
      .catch(e => this.showErrors(e))
    },
    showErrors (e) {
      showErrors.call(this, e)
    },
  },
}