import { mapGetters } from 'vuex'

export default {
  computed: {
    ...mapGetters('ConstantsModule', ['getCurrencies']),
  },
  methods: {
    symbolByCurrencyCode (code) {
      const currency = this.getCurrencies.find((i) => i.code === code) || null
      return currency ? currency.symbol : '$'
    },
  },
}
