import { getRequestFiltersObject } from '@/support/helpers'

export default {
  data () {
    return {
      chartRange: {
        start: this.moment().subtract(30, 'days'),
        end: this.moment(),
      },
      chartLoading: false,
      customRangeLoading: false,
      analytics: {
        today: {
          current: [],
          previous: []
        },
        yesterday: {
          current: [],
          previous: []
        },
        lastWeek: {
          current: [],
          previous: []
        },
        custom: { // Default is this week
          current: [],
          previous: []
        }
      },
      rangeLimits: {
        today: {
          current: [this.moment(), this.moment()],
          previous: [this.moment().subtract(1, 'days'), this.moment().subtract(1, 'days')]
        },
        yesterday: {
          current: [this.moment().subtract(1, 'days'), this.moment().subtract(1, 'days')],
          previous: [this.moment().subtract(2, 'days'), this.moment().subtract(2, 'days')]
        },
        lastWeek: {
          current: [this.moment().subtract(7, 'days'), this.moment()],
          previous: [this.moment().subtract(14, 'days'), this.moment().subtract(7, 'days')]
        },
        custom: { // Default is this week
          current: [this.moment().startOf('week'), this.moment()],
          previous: [this.moment().subtract(1, 'weeks').startOf('week'), this.moment().subtract(1, 'weeks').endOf('week')]
        }
      }
    }
  },
  computed: {
    getDateRange () {
      let acc = []
      Object.keys(this.getRangeLimits).forEach(prop => {
        Object.keys(this.getRangeLimits[prop]).forEach(childProp => {
          if (Array.isArray(this.getRangeLimits[prop][childProp])) {
            this.getRangeLimits[prop][childProp].forEach(date => {
              const formattedDate = this.formattedDate(date)
              const dateCount = acc.length
              let index = -1
              let count = 0

              if (dateCount === 0) acc.push(formattedDate)
              else if (dateCount === 1) {
                index = (acc[0] < formattedDate) ? 1 : 0
              } else {
                if (acc[0] > formattedDate) index = 0
                if (acc[1] < formattedDate) index = 1
                if (index !== -1) count = 1
              }

              if (index !== -1) acc.splice(index, count, formattedDate)
            })
          }
        })
      })
      return acc
    },
    getRangeLimits () {
      return this.rangeLimits
    }
  },
  methods: {
    formattedDate (momentDate) {
      return momentDate.format('YYYY-MM-DD')
    },
    mutateDashboardData (field, value) {
      this.SET_DASHBOARD_DATA({field,value})
    },
    async changeChartRange ({start, end}) {
      this.chartLoading = true
      const data = await this.fetchReportingData(start,end)
      const chartData = this.aggregateChartData(data,  start,  end)

      this.mutateDashboardData('chart', chartData)
      this.chartLoading = false
    },
    async changeCustomRange ({start, end}, fieldName = 'order_date') {
      this.customRangeLoading = true
      const data = await this.fetchReportingData(start,end)
      this.rangeLimits.custom.current = [this.moment(start), this.moment(end)]
      if (data.length) {
        Object.keys(this.rangeLimits.custom).forEach(prop => {
          const [start, end] = this.rangeLimits.custom[prop]
          this.analytics.custom[prop] = this.filteredByPeriod(data, start, end, fieldName)
        })
      } else {
        ['current', 'previous'].forEach(prop => {
          this.analytics.custom[prop] = []
        })
      }
      this.customRangeLoading = false
    },
    getSummaryRequestData (itemIdFieldName = null, params = {}, filters = {}) {
      const defaultFiltersData = itemIdFieldName ? {[itemIdFieldName]: this.getSelectedItem.id} : {}

      return {
        ...params,
        ...getRequestFiltersObject({...defaultFiltersData,...filters})
      }
    },
    convertData (data, dataName='order_date', revenueName='total_revenue', costName='total_cost', qtyName='quantity_sold') {
      return data.map(row => {
        return {
          ...row,
          order_date: row[dataName],
          total_revenue: row[revenueName],
          total_cost: row[costName],
          quantity_sold: row[qtyName],
        }
      })
    },
  }
}
