import { mapGetters } from 'vuex'
import { CONTEXT_NAMES } from '@/assets/constants'
import {openDrawerByModelPath} from '@/support/drawerHelper'

const ENUM_CONTEXT = CONTEXT_NAMES.AMAZON.LEDGER

export default {
  computed: {
    ...mapGetters('EnumsModule', [
      'getEnumText',
      'getAll',
    ]),
    getSkuLinks () {
      return this.getAll({context: ENUM_CONTEXT, variableName: 'sku_link', })
    },
    getReportDetails () {
      return this.getAll({context: ENUM_CONTEXT, variableName: 'detail_report', })
    },
  },
  methods: {
    getSkuLinkName (value) {
      const reportDetails = this.getSkuLinks.find(item => item.value === value)
      return reportDetails ? reportDetails.text : value
    },
    openLinkDrawer (link) {
      openDrawerByModelPath(this, link.type, link.id)
    },
    getReportDetailsName ({type, id}) {
      const reportDetails = this.getReportDetails.find(item => item.value === type)
      const friendlyName = reportDetails ? reportDetails.text : type
      return `${friendlyName} # ${id}`
    },
  },
}
