import { mapGetters, mapActions } from 'vuex'
import showErrors from '@/support/showErrors'
import { showDeletePaymentsConfirmationModal } from '@/support/accountingHelpers'

export default {
  data () {
    return {
      loading: false,
      bannerTypeClass: '',
      bannerColor: '',
      lookupOptions: [],
      lookupPage: 1,
      actionName: null,
      isShowConfirmModal: false,
      actionProccessing: false,
      selectedId: null,
    }
  },
  computed: {
    ...mapGetters('AccountingModule', [
      'getAccountingIntegration'
    ]),
    ...mapGetters('EnumsModule', ['getEnumText']),
    getSyncToActionName () {
      return `Sync To ${this.getAccountingIntegration.name}`
    },
    getDeletePaymentsActionName () {
      return `Delete Payments on ${this.getAccountingIntegration.name}`
    },
  },
  methods: {
    ...mapActions('AccountingModule', [
      'fetchAccountingIntegration'
    ]),
    showApiUsingBanner () {
      this.bannerTypeClass = this.getAccountingIntegration?.integration_settings?.remainingApiUsage ? 'banner-info' : 'banner-warning'
      this.bannerColor = this.getAccountingIntegration?.integration_settings?.remainingApiUsage ? '#cceae7' : '#ffeacc'
    },
    showAllErrors (errors) {
      this.$drawer.$emit('show-last-errors', errors)
    },
    async fetchIntegration () {
      try {
        await this.fetchAccountingIntegration()
      } catch (e) {
        this.showRequestErrors(e)
      }
    },
    showRequestErrors (e) {
      showErrors.call(this, e)
    },
    setLoading (loading = true) {
      this.loading = loading
    },
    onIntegrationsLink (link) {
      window.open(link)
    },
    getFriendlyName ({variableName, dataName}) {
      return this.getEnumText({
        context: this.enumContext,
        variableName,
        dataName
      })
    },
    showDeletePaymentsConfirmationModal (id, closeMenu = null) {
      this.selectedId = id
      showDeletePaymentsConfirmationModal(this)
      if (typeof closeMenu === 'function') closeMenu()
    },
    async processDeletePayments (ids = null, closeMenu = null) {
      let payload = {}
      if (this.getSelectedAllRows) {
        payload.filters = JSON.stringify(this.getFilteringCriteria)
      } else {
        payload.ids = ids
      }
      this.actionProccessing = true

      try {
        if (typeof closeMenu === 'function') closeMenu()
        await this.deletePayments(payload)
        this.$notification.$emit('success', {html:`Successefull delete`})
        this.reloadData()
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.actionProccessing = false
        this.isShowConfirmModal = false
      }
    },
  }
}
