const elementClickKey = '_vueDismissClick'
const elementMousedownKey = '_vueDismissMousedown'
const elementContextKey = '_vueDismissContext'
const elementKeyupKey = '_vueDismissKeyup'

function setup (el, binding) {
  let callback, shouldBind

  if (typeof binding.value === 'function') {
    callback = binding.value
    shouldBind = true
  } else {
    callback = binding.value.callback
    shouldBind = binding.value.hasOwnProperty('watch')
      ? Boolean(binding.value.watch)
      : true
  }

  if (shouldBind) {
    if (typeof document !== 'undefined' && !el[elementClickKey]) {
      // do not close element on mouseup if mousedown started inside of the element
      let mousedownTarget = null

      const handler = function (event) {
        if (event.keyCode) {
          event.keyCode === 27 && callback()
        } else if (!(event.target === el) && !el.contains(event.target) && !el.contains(mousedownTarget)) {
          callback()
          mousedownTarget = null
        }
      }

      const onMousedown = function (event) {
        mousedownTarget = event.target
      }

      setTimeout(function () {
        document.addEventListener('mousedown', onMousedown)
        document.addEventListener('mouseup', handler)
        document.addEventListener('contextmenu', handler)
        document.addEventListener('keyup', handler)
      }, 10)

      el[elementClickKey] = el[elementKeyupKey] = el[elementContextKey] = handler
      el[elementMousedownKey] = onMousedown
    }
  } else {
    unbind(el)
  }
}

function unbind (el) {
  if (el[elementClickKey] && el[elementContextKey] && typeof document !== 'undefined') {
    document.removeEventListener('mousedown', el[elementMousedownKey])
    document.removeEventListener('mouseup', el[elementClickKey])
    document.removeEventListener('contextmenu', el[elementContextKey])
    document.removeEventListener('keyup', el[elementKeyupKey])
    delete el[elementMousedownKey]
    delete el[elementClickKey]
    delete el[elementContextKey]
    delete el[elementKeyupKey]
  }
}

export default {
  directives: {
    onDismiss: {
      bind: setup,
      update: setup,
      unbind: unbind
    }
  }
}
