import { isEqual, differenceWith } from 'lodash'

export default ({
  editedMappingsPropName = 'selectedMappingsValues',
  initialMappingsPropName = 'initialMappingsValues',
}) => {
  return {
    methods: {
      buildSendData () {
        return differenceWith(
          this.prepareMapping(this[editedMappingsPropName]),
          this.prepareMapping(this[initialMappingsPropName]),
          isEqual
        )
      },
      prepareMapping (mappings) {
        return Object.keys(mappings).reduce((acc,key) => {
          acc = [...acc, {key, value: mappings[key]?.id || null}]
          return acc
        },[])
      },
    },
  }
}