import { mapGetters, mapActions } from 'vuex'

export default {
  computed: {
    ...mapGetters('SettingsModule', [
      'getSettingByKey',
    ]),
    ...mapGetters('NominalCodes', {
      getNominalCodes: 'getItemsList',
      getNominalCodeByKey: 'getNominalCodeByKey',
    }),
    getDefaultNominalCodeName () {
      const defaultNominalCodeSetting = this.getSettingByKey('nominal_code_mapping_cost_of_goods_sold')
      if (!defaultNominalCodeSetting?.value) return null
      return this.findNominalCodeName(defaultNominalCodeSetting.value)
    },
  },
  methods: {
    ...mapActions('NominalCodes', {
      fetchNominalCodes: 'getItemsRequest',
    }),
    figureSupplierStock (row) {
      if (row.supplier_stock === null) {
        return 'not available'
      } else if (row.supplier_stock && (row.supplier_stock.in_stock === 1 || row.supplier_stock.in_stock === 0)) {
        return row.supplier_stock.in_stock ? 'in stock' : 'out of stock'
      } else if (row.supplier_stock) {
        return row.supplier_stock.quantity || 0
      }
      return 0
    },
    findNominalCodeName (id) {
      const code = this.getNominalCodes.find(c => c.id === id)
      return code ? code.name : null
    },
  }
}
