import {
  isWarehouseNotFulfillable,
} from '@/support/salesOrdersProductListHelpers'

export default {
  computed: {
    showDropshipButton () {
      return !this.isWarehouseFulfilled && this.warehouse?.supplier_name && !this.isDropshipRequested
    },
    isDropshipRequested () {
      if (this.getSelectedItem?.purchase_orders) {
        let requestPO = this.getSelectedItem.purchase_orders.find(p => p.supplier_warehouse_id === this.warehouse?.id)
        if (requestPO) return true
      }
      return false
    },
    isFulfillable () {
      return (this.showSimpleFulfillButton || this.showDropshipFulfillButton) && !this.isWarehouseNotFulfillable
    },
    isWarehouseFulfilled () {
      let isFulfilled = true
      for (let i = 0; i <= this.warehouseProducts.length; i++) {
        let product = this.warehouseProducts[i]
        if (product && !product?.is_fulfilled) {
          isFulfilled = false
          break
        }
      }
      return isFulfilled
    },
    showSimpleFulfillButton () {
      return !this.isWarehouseFulfilled && !this.warehouse?.supplier_name
    },
    showDropshipFulfillButton () {
      return !this.isWarehouseFulfilled && this.warehouse?.supplier_name && this.isDropshipRequested
    },
    isWarehouseNotFulfillable () {
      // if all items are not fulfillable then warehouse is not fulfillable
      return isWarehouseNotFulfillable(this.warehouseProducts)
    },
  },
}
