import { isEqual, cloneDeep } from 'lodash'
import { editIntegrationInstance } from '@/services/IntegrationsService'
import showErrors from '@/support/showErrors'

export default {
  computed: {
    somethingChanged () {
      return !isEqual(this.editedValues, this.initialValues) || !isEqual(this.customFieldValues, this.initialValues)
    }
  },
  data () {
    return {
      saveLoading: false,
    }
  },
  methods: {
    revertChanges () {
      this.editedValues = cloneDeep(this.initialValues)
      this.customFieldValues = cloneDeep(this.initialValues)
    },
    async save () {
      try {
        this.saveLoading = true
        const {data} = await editIntegrationInstance(this.$route.params.instanceId, this.getSendData())
        this.initValues(data)
        this.UPDATE_INTEGRATION_DATA(data)
        this.$notification.$emit('success')
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.saveLoading = false
      }
    }
  },
}
