import { getAllNominalCodes } from '@/services/NominalCodesService'
import showErrors from '@/support/showErrors'

export default {
  data () {
    return {
      codes: [],
      loadingNominalCodes: false,
    }
  },
  computed: {
    nominalCodes () {
      return this.codes
    },
  },
  methods: {
    async fetchNominalCodes () {
      this.loadingNominalCodes = true
      try {
        const {data} = await getAllNominalCodes({
          limit: -1,
          included: JSON.stringify(['name', 'code']),
        })
        this.codes = data
      } catch (e) {
        this.showErrors(e)
      } finally {
        this.loadingNominalCodes = false
      }
    },
    showErrors (e) {
      showErrors.call(this,e)
    },
  },
}
