import { openSalesOrderDrawer } from '@/support/drawerHelper'

export default {
  methods: {
    archiveItemByIdMixinMethod (id) {
      return archiveInstanceOrder(this.$route.params.instanceId, id)
    },
    unarchiveItemByIdMixinMethod (id) {
      return unarchiveInstanceOrder(this.$route.params.instanceId, id)
    },
    archiveItemsMixinMethod (ids) {
      return archiveInstanceOrders(this.$route.params.instanceId, ids)
    },
    unarchiveItemsMixinMethod (ids) {
      return unarchiveInstanceOrders(this.$route.params.instanceId, ids)
    },
    createOrder (row, callback) {
      this.createOrdersRequest({ ids: [row.id] }, callback)
    },
    createOrders (callback) {
      let sendData = {}
      if (!this.getSelectedAllRows) {
        let ids = []
        for (let key in this.getSelectedRows) {
          if (this.getSelectedRows.hasOwnProperty(key)) {
            ids.push(key)
          }
        }
        sendData.ids = ids
      } else {
        sendData.filters = JSON.stringify(this.getFilteringCriteria)
      }

      this.createOrdersRequest(sendData, callback)
    },
    isShowSalesOrder(orderValue) {
      return !!orderValue?.id && !!orderValue?.number 
    },
    openSalesOrder (id) {
      if (!id) return
      openSalesOrderDrawer(this,id)
    },
    onForceRefresh () {
      this.SET_FORCE_REFRESH(true)
    },
  },
}
