import showErrors from '@/support/showErrors'

export default {
  data () {
    return {
      deleteLoading: false,
      message: 'Instance deletion is in progress.',
    }
  },
  methods: {
    async deleteIntegrationInstance () {
      try {
        this.deleteLoading = true
        await this.deleteIntegrationHandler(this.$route.params.instanceId)
        this.$notification.$emit('success', { html: this.message })
        this.$router.push('/dashboard')
        // a hack to force the reload on the integrations page
        setTimeout(() => {
          this.$router.push('/integrations')
        }, 100)
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.deleteLoading = false
      }
    },
  },
}
