// following values are expected to be present in parent component:
// getSelectedAllRows, getSelectedRowsObjects, getFilteringCriteria

import showErrors from '@/support/showErrors'

export default (confirmationSource, idKey = 'id') => ({
  data() {
    return {
      unmapListingsLoading: false
    }
  },

  mounted() {
    this.$confirm.$on('confirm-unmap-' + confirmationSource, this.confirmedUnmap)
  },
  beforeDestroy() {
    this.$confirm.$off('confirm-unmap-' + confirmationSource, this.confirmedUnmap)
  },
  methods: {
    unmapListings(usefulProps) {
      usefulProps.closeMenu()
      this.$confirm.$emit('open', {
        source: 'unmap-' + confirmationSource,
        message: `
          <div class="p-3 pb-5 rounded-sm bg-orange-200">Are you sure you want to unmap all selected items?</div>
        `
      })
    },
    unmapListingRequest() {
      console.warn('Functions `unmapListingRequest` should be implemented for current integration')
      return Promise.resolve()
    },
    async confirmedUnmap() {
      try {
        this.unmapListingsLoading = true
        await this.unmapListingRequest()
        this.reloadData()
        this.$notification.$emit('success')
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.unmapListingsLoading = false
      }
    }
  }
})
