import { authEbayIntegrationInstance } from '@/services/ebay/EbayIntegrationService'
import showErrors from '@/support/showErrors'

export default {
  data () {
    return {
      finalizing: false,
    }
  },
  methods: {
    async authInstance (id) {
      try {
        this.finalizing = true
        const { data } = await authEbayIntegrationInstance(id)
        if (data) window.location.href = data
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.finalizing = false
      }
    },
  }
}
