import { createAccountingTransaction } from '@/services/AmazonIntegrationFinancesService'
import showErrors from '@/support/showErrors'

export default {
  data () {
    return {
      creatingTransaction: false,
    }
  },
  methods: {
    async createAccountingTransaction (sendData) {
      this.creatingTransaction = true
      try {
        const response = await createAccountingTransaction(this.$route.params.instanceId, sendData)
        let html = null
        if (response.hasOwnProperty('message')) html = response.message
        this.$notification.$emit('success', {html})
        return response
      } catch (e) {
        this.showErrors(e)
        throw e
      } finally {
        this.creatingTransaction = false
      }
    },
    showErrors (e) {
      showErrors.call(this, e)
    },
  },
}
