import { openAmazonLedgerDrawer } from '@/support/drawerHelper'

export default {
  data () {
    return {
      unmatchedItems: [],
      loading: false
    }
  },
  async mounted () {
    await this.fetchInitialData(this.instance.i)
  },
  computed: {
    getSelectedItemIndex () {
      return this.getItemsList.findIndex(({ id }) => id === this.getSelectedItem?.id)
    },
    getLedgerEvent () {
      return this.getSelectedItem?.ledger_id ? { action: 'showLedger', id: this.getSelectedItem.ledger_id } : null
    }
  },
  methods: {
    async selectNewItem (id) {
      try {
        await this.fetchNewItem(this.getParams(id))
      } catch (e) {
        this.showErrors(e)
      }
    },
    fetchInitialData (id) {
      this.loading = true
      return Promise.allSettled([
        this.fetchNewItem(this.getParams(id))
      ])
        .catch(e => this.showErrors(e))
        .finally(() => this.loading = false)
    },
    getParams (id) {
      return { instanceId: this.$route.params.instanceId, id }
    },
    eventHandler ({ action, id }) {
      switch (action) {
        case 'showLedger':
          openAmazonLedgerDrawer(this, id)
          break
      }
    }
  }
}
