import { Line, mixins } from 'vue-chartjs'
const { reactiveProp } = mixins

export default {

  mixins: [
    Line,
    reactiveProp
  ],
  props: {
    options: {
      type: Object,
      required: false,
      default: () => {
        return {
          responsive: true,
          maintainAspectRatio: false,
          scales: {
            xAxes: [{
              gridLines: { display: false }
            }]
          },
          legend: {
            display: false
          }
        }
      }
    }
  },

  mounted () {
    this.renderChart(this.chartData, this.options)
  }

}
