import { HorizontalBar, mixins } from 'vue-chartjs'
const { reactiveProp } = mixins

export default {

  mixins: [
    HorizontalBar,
    reactiveProp
  ],
  props: {
    options: {
      type: Object,
      required: false,
      default: () => {
        return {
          responsive: true,
          maintainAspectRatio: false,
          scales: {
            xAxes: [{
              gridLines: { display: true }
            }],
          },
          legend: {
            display: false
          }
        }
      }
    }
  },

  mounted () {
    this.renderChart(this.chartData, this.options)
  }

}
