import { getEnumsList, getEnumDictionary, getModelDictionaries } from '@/support/enumHelpers'
import { CONTEXT_NAMES, API_MODELS } from '@/assets/constants'

const statuses = [
  { data_name: 'completed', friendly_name: 'Completed', },
  { data_name: 'pending', friendly_name: 'Pending', },
  { data_name: 'processing', friendly_name: 'Processing', },
  { data_name: 'failed', friendly_name: 'Failed', },
]
const types = [
  API_MODELS.SALES_ORDER,
]

const ENUMS = [
  ...getEnumDictionary(statuses, 'status'),
  ...getModelDictionaries(types,'related_model'),
]

export default (() => { return getEnumsList(ENUMS, CONTEXT_NAMES.TRACKED_JOB_LOGS)})()
