import { getEnumsList, getEnumDictionary } from '@/support/enumHelpers'
import { CONTEXT_NAMES, API_MODELS } from '@/assets/constants'

const statuses = [
  { data_name: 'active', friendly_name: 'Active', },
  { data_name: 'reserved', friendly_name: 'Reserved', },
  { data_name: 'in_transit', friendly_name: 'In Transit', },
]

const types = [
  { data_name: 'sale', friendly_name: 'Sale', },
  { data_name: 'return', friendly_name: 'Return', },
  { data_name: 'assembly', friendly_name: 'Assembly', },
  { data_name: 'adjustment', friendly_name: 'Adjustment', },
  { data_name: 'stock_take', friendly_name: 'Stock Take', },
  { data_name: 'transfer', friendly_name: 'Warehouse Transfer', },
  { data_name: 'initial_count', friendly_name: 'Initial Count', },
  { data_name: 'purchase_receipt', friendly_name: 'Purchase Receipt', },
]

const layerTypes = [
  { data_name: API_MODELS.FIFO_LAYER, friendly_name: 'FIFO Layer', },
  { data_name: API_MODELS.BACKORDER_QUEUE, friendly_name: 'Backorder Queue', },
]

const ENUMS = [
  ...getEnumDictionary(layerTypes,'layer_type'),
  ...getEnumDictionary(statuses,'inventory_status'),
  ...getEnumDictionary(types,'type'),
]

export default (() => { return getEnumsList(ENUMS, CONTEXT_NAMES.INVENTORY.MOVEMENTS) })()
