import { getEnumsList, getModelDictionaries, getEnumDictionary, } from '@/support/enumHelpers'
import { CONTEXT_NAMES, API_MODELS } from '@/assets/constants'

const CONTEXT = CONTEXT_NAMES.AMAZON.LEDGER
const MODULE_ENTITY_PATH = 'Modules\\Amazon\\Entities\\'

const skuLink = [
  API_MODELS.WAREHOUSE_TRANSFER,
  API_MODELS.INVENTORY_ADJUSTMENT,
  API_MODELS.SALES_ORDER_FULFILLMENT,
]

const detailReports = [
  { data_name: `${MODULE_ENTITY_PATH}AmazonFbaReportShipment`, friendly_name: 'Shipment', },
  { data_name: `${MODULE_ENTITY_PATH}AmazonFbaReportCustomerReturn`, friendly_name: 'Customer Return', },
  { data_name: `${MODULE_ENTITY_PATH}AmazonFbaReportRemovalShipment`, friendly_name: 'Removal Shipment', },
]

const eventTypes = [
  { data_name: 'Adjustments', friendly_name: 'Adjustments', },
  { data_name: 'CustomerReturns', friendly_name: 'Customer Returns', },
  { data_name: 'Receipts', friendly_name: 'Receipts', },
  { data_name: 'Shipments', friendly_name: 'Shipments', },
  { data_name: 'VendorReturns', friendly_name: 'Vendor Returns', },
  { data_name: 'WhseTransfers', friendly_name: 'Warehouse Transfers', },
]

const ENUMS = [
  ...getEnumDictionary(detailReports,'detail_report'),
  ...getEnumDictionary(eventTypes,'event_type'),
  ...getModelDictionaries(skuLink,'sku_link'),
]

export default (() => { return getEnumsList(ENUMS, CONTEXT) })()
