import { getEnumsList } from '@/support/enumHelpers'
import { CONTEXT_NAMES } from '@/assets/constants'

const TYPABLE = [
  {
    variable_name: null,
    data_name: 'sales_order',
    friendly_name: 'Sales Order',
  },
  {
    variable_name: null,
    data_name: 'stock_take',
    friendly_name: 'Stock Take',
  },
  {
    variable_name: null,
    data_name: 'purchase_order',
    friendly_name: 'Purchase Order',
  },
  {
    variable_name: null,
    data_name: 'sales_credit',
    friendly_name: 'Sales Credit',
  },
  {
    variable_name: null,
    data_name: 'inventory_adjustment',
    friendly_name: 'Inventory Adjustment',
  },
  {
    variable_name: null,
    data_name: 'sales_order_fulfillment',
    friendly_name: 'Sales Order Fulfillment',
  },
  {
    variable_name: null,
    data_name: 'sales_order_invoice',
    friendly_name: 'Sales Order Invoice',
  },
  {
    variable_name: null,
    data_name: 'purchase_order_receipt',
    friendly_name: 'Purchase Order Receipt',
  },
  {
    variable_name: null,
    data_name: 'customer_return',
    friendly_name: 'Customer Return',
  },
  {
    variable_name: null,
    data_name: 'purchase_order_invoice',
    friendly_name: 'Purchase Order Invoice',
  },
  {
    variable_name: null,
    data_name: 'batch_sales_order_invoice',
    friendly_name: 'Batch Sales Order Invoice',
  },
  {
    variable_name: null,
    data_name: 'warehouse_transfer_shipment',
    friendly_name: 'Warehouse Transfer Shipment',
  },
  {
    variable_name: null,
    data_name: 'warehouse_transfer_receipt',
    friendly_name: 'Warehouse Transfer Receipt',
  },
]

const TYPE_PARENT_TYPE_ENUMS = ['type','parent_type'].reduce((acc,variableName) => {
  const enums = TYPABLE.map(t => {
    return { ...t, variable_name: variableName, }
  })
  acc = [...acc, ...enums]
  return acc
}, [])

const ENUMS = [
  {
    variable_name: 'status',
    data_name: 'toSync',
    friendly_name: 'To Sync',
  },
  {
    variable_name: 'status',
    data_name: 'synced',
    friendly_name: 'Synced',
  },
  {
    variable_name: 'status',
    data_name: 'hasErrors',
    friendly_name: 'Has Errors',
  },
  {
    variable_name: 'status',
    data_name: 'ineligibleToSync',
    friendly_name: 'Ineligible To Sync',
  },
  {
    variable_name: 'status',
    data_name: 'submissionInProgress',
    friendly_name: 'Submission in Progress',
  },
  ...TYPE_PARENT_TYPE_ENUMS,
]

export default (() => { return getEnumsList(ENUMS, CONTEXT_NAMES.ACCOUNTING) })()
