import amazonInstanceConstants from '@/assets/constants/amazonInstanceConstants'
import apiModels from '@/assets/constants/apiModelNames'
import contextNames from '@/assets/constants/contextNames'

export const PAYMENT_ACTIONS = {
  ADD_PAYMENT: 'add_payment',
  ADD_REFUND: 'add_refund',
}

export const PO_SETTING_KEYS = {
  PREFIX: 'purchase_order_prefix',
  FORMAT: 'purchase_order_format',
  NUM_DIGITS: 'purchase_order_num_of_digits',
  START_NUMBER: 'purchase_order_start_number',
  STORE: 'purchase_order_default_store',
  WAREHOUSE: 'purchase_order_default_warehouse',
  SHIPPING_METHOD: 'purchase_order_default_shipping_method',
  PAYMENT_TYPE: 'purchase_order_default_payment_type',
  LEAD_TIME: 'purchase_order_lead_time',
  CC_OUTGOING: 'purchase_order_cc_outgoing',
  BUILDER_ROUNDING_METHOD: 'purchase_order_builder_default_rounding_method',
  BUILDER_USE_MOQ: 'purchase_order_builder_default_use_moq',
  BUILDER_USE_LEAD_TIME: 'purchase_order_builder_default_use_lead_time',
  BUILDER_FORECAST_TYPE: 'purchase_order_builder_default_forecast_type',
  BUILDER_TARGET_QUANTITY: 'purchase_order_builder_target_quantity',
  BUILDER_SALES_HISTORY: 'purchase_order_builder_sales_history_days',
  BUILDER_TARGET_DAYS_OF_STOCK: 'purchase_order_builder_target_days_of_stock',
}

export const CONTEXT_NAMES = contextNames

export const INSTANCES_LIST = {
  AMAZON_US: 'Amazon US',
  MAGENTO: 'Magento',
  XERO: 'Xero',
  SHIP_STASHION: 'ShipStation',
  E_BAY: 'eBay',
  SHOPIFY: 'Shopify',
  STARSHIPIT: 'Starshipit',
  SHIP_MY_ORDERS: 'ShipMyOrders',
  WOO_COMMERCE: 'WooCommerce',
  QUICK_BOOKS: 'QuickBooks'
}

export const DRAWER_MODE = {
  PO: {
    EDIT: 'editPurchaseOrder',
    VIEW: 'viewPurchaseOrder',
    CREATE: 'createPurchaseOrder',
  },
}

export const FINANCIALS = {
  LINES: {
    CLASSIFICATIONS: {
      REVENUE: 'revenue',
      COST: 'cost',
    }
  }
}

export const AMAZON_INSTANCE = amazonInstanceConstants

export const API_MODELS = apiModels
