<?php

namespace Database\Seeders;

use App\Models\Product;
use App\Models\Warehouse;
use Illuminate\Database\Seeder;

class InitialInventorySeeder extends Seeder
{
    public function run(): void
    {
        $products = Product::factory()->count(3)->create();
        $warehouse = Warehouse::first();

        $products->each(function (Product $product) use ($warehouse) {
            $product->setInitialInventory($warehouse->id, 10, 100);
        });
    }
}
