<?php

namespace Database\Seeders\InitialData;

use Illuminate\Database\Seeder;

class ZipLocationsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $filePath = database_path('seeders/DummyData/zip_code_data.xls');
        $fileContent = file_get_contents($filePath);
        $data = collect(explode("\n", $fileContent))
            ->skip(1)
            ->map(function ($row) {
                $columns = explode(',', $row);
                if (! isset($columns[1])) {
                    return null;
                }

                return [
                    'zip' => $columns[0],
                    'lat' => $columns[1],
                    'lng' => $columns[2],
                ];
            })
            ->filter()
            ->values();
        $data->chunk(1000)->each(function ($chunk) {
            \DB::table('zip_locations')->insert($chunk->toArray());
        });
    }
}
