<?php

namespace Database\Seeders\InitialData;

use App\Models\Setting;
use App\Models\Warehouse;
use App\Models\WarehouseLocation;
use Illuminate\Database\Seeder;

/**
 * Class WarehouseSeeder
 */
class WarehouseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // If a warehouse doesn't exist, create it and the default settings to go with it
        Warehouse::query()->firstOr(function () {
            /** @var Warehouse $defaultWarehouse */
            $defaultWarehouse = Warehouse::query()->create([
                'name' => Warehouse::DEFAULT_WAREHOUSE_NAME,
                'type' => Warehouse::TYPE_DIRECT,
                'order_fulfillment' => 'manual',
            ]);

            WarehouseLocation::query()->create([
                'warehouse_id' => $defaultWarehouse->id,
                'aisle' => 'Default',
                'is_default' => true,
            ]);

            Setting::query()->create([
                'key' => Setting::KEY_WAREHOUSE_PRIORITY,
                'description' => 'The priority of warehouses.',
                'type' => Setting::TYPE_JSON,
                'value' => json_encode([$defaultWarehouse->id]),
                'default_value' => json_encode([$defaultWarehouse->id]),
            ]);

            Setting::query()->create([
                'key' => Setting::KEY_PO_DEFAULT_WAREHOUSE,
                'description' => 'Default Warehouse for Purchase Orders',
                'type' => Setting::TYPE_INTEGER,
                'value' => $defaultWarehouse->id,
                'default_value' => $defaultWarehouse->id,
            ]);

            Setting::query()->create([
                'key' => Setting::KEY_SC_DEFAULT_WAREHOUSE,
                'description' => 'Default Warehouse for Sales Credits',
                'type' => Setting::TYPE_INTEGER,
                'value' => $defaultWarehouse->id,
                'default_value' => $defaultWarehouse->id,
            ]);
        });
    }
}
