<?php

namespace Database\Seeders\InitialData;

use App\Models\User;
use App\Models\UserApi;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create an admin user if there is no existing user
        /** @var User $user */
        if ($user = User::query()->firstOrCreate([], [
            'name' => 'Administrator',
            'email' => 'dev@sku.io',
            'password' => Hash::make('m45t3r605#!'),
            'is_admin' => true,
        ])) {
            /*
             * TODO: Not sure what the purpose of this is.  Dev has multiple records in user_apis that seem unnecessary
             */
            UserApi::query()->firstOrCreate([], [
                'user_id' => $user->id,
                'key' => md5(uniqid('key_')),
                'password' => md5(uniqid('secret_')),
            ]);
        }
    }
}
