<?php

namespace Database\Seeders\InitialData;

use App\Models\Store;
use App\Models\StoreEmailTemplate;
use Illuminate\Database\Seeder;

class StoreEmailTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create email template for the first store

        /** @var Store $store */
        $store = Store::query()->first();

        StoreEmailTemplate::with([])->firstOrCreate(['type' => StoreEmailTemplate::TYPE_PURCHASE_ORDER], [
            'type' => StoreEmailTemplate::TYPE_PURCHASE_ORDER,
            'subject' => 'Purchase Order from {{company_name}}',
            'html_body' => '<p>Hello {{supplier_contact_name}}</p><p>We request the following order from {{supplier_name}} to be delivered promptly to:</p><p>{{destination_name}}<br>{{destination_address_full}}</p><p>Find attached Order {{purchase_order_number}}</p><p>Please note:<br>{{supplier_notes}}</p><p></p><p>Thank you!<br>{{company_contact_name}}<br>{{company_email}}</p>',
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true,
            'store_id' => $store->id,
        ]);

        StoreEmailTemplate::with([])->firstOrCreate(['type' => StoreEmailTemplate::TYPE_PURCHASE_ORDER_UPDATE], [
            'type' => StoreEmailTemplate::TYPE_PURCHASE_ORDER_UPDATE,
            'subject' => 'Update: Purchase Order',
            'html_body' => '<p>Please find attached the update.</p><p>{{supplier_notes}}</p>',
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true,
            'store_id' => $store->id,
        ]);

        StoreEmailTemplate::with([])->firstOrCreate(['type' => StoreEmailTemplate::TYPE_SALES_ORDER_CONFIRMATION], [
            'type' => StoreEmailTemplate::TYPE_SALES_ORDER_CONFIRMATION,
            'subject' => 'Order {{sales_order_number}} from {{store_name}}',
            'html_body' => "<p>{{store_logo_url}}</p><h1>Order #{{sales_order_number}}</h1><p>Hi {{customer_name}}, we're getting your order ready to be shipped.<br>We will notify you when it has ben sent.</p><h2>Order Summary</h2><p>{{sales_order_lines}}</p><p>Product subtotal: {{product_total}}<br>Shipping: {{shipping_cost}}<br>Additional: {{additional_cost}}</p><h2><strong>Order total is {{product_total}}</strong></h2><p></p><h3><strong>Customer Information</strong></h3><ul><li><p>Shipping</p><p><em>{{shipping_address_full}}</em></p></li><li><p>Billing</p><p><em>{{billing_address_full}}</em></p></li><li><p>Shipping Method</p><p><em>{{shipping_method}}</em></p></li><li><p>Payment Status</p><p><em>{{payment_status}}</em></p></li></ul><p>Thanks for your purchase!<br>If you have any questions, reply to this email or reach out to {{store_email}}</p>",
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true,
            'store_id' => $store->id,
        ]);

        StoreEmailTemplate::with([])->firstOrCreate(['type' => StoreEmailTemplate::TYPE_SALES_ORDER_UPDATED], [
            'type' => StoreEmailTemplate::TYPE_SALES_ORDER_UPDATED,
            'subject' => 'UPDATE: Order {{sales_order_number}} from {{store_name}}',
            'html_body' => '<p>{{store_logo_url}}</p><h1>Order #{{sales_order_number}}</h1><p>Hi {{customer_name}}, Your order has been updated.</p><h2>Order Summary</h2><p>{{sales_order_lines}}</p><p>Product subtotal: {{product_total}}<br>Shipping: {{shipping_cost}}<br>Additional: {{additional_cost}}</p><h2><strong>Order total is {{product_total}}</strong></h2><p></p><h3><strong>Customer Information</strong></h3><ul><li><p>Shipping</p><p><em>{{shipping_address_full}}</em></p></li><li><p>Billing</p><p><em>{{billing_address_full}}</em></p></li><li><p>Shipping Method</p><p><em>{{shipping_method}}</em></p></li><li><p>Payment Status</p><p><em>{{payment_status}}</em></p></li></ul><p>Thanks for your purchase!<br>If you have any questions, reply to this email or reach out to {{store_email}}</p>',
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true,
            'store_id' => $store->id,
        ]);

        StoreEmailTemplate::with([])->firstOrCreate(['type' => StoreEmailTemplate::TYPE_SALES_ORDER_FULFILLED], [
            'type' => StoreEmailTemplate::TYPE_SALES_ORDER_FULFILLED,
            'subject' => 'Fulfillment: Order {{sales_order_number}} from {{store_name}}',
            'html_body' => '<p>{{store_logo_url}}</p><h1>Order #{{sales_order_number}}</h1><p>Hi {{customer_name}}, There has been a fulfillment to your order. <h2>Order Summary</h2><p>{{sales_order_lines}}</p><p>Product subtotal: {{product_total}}<br>Shipping: {{shipping_cost}}<br>Additional: {{additional_cost}}</p><h2><strong>Order total is {{currency_name}} {{product_total}}</strong></h2><p></p><h3><strong>Customer Information</strong></h3><ul><li><p>Shipping</p><p><em>{{shipping_address_full}}</em></p></li><li><p>Billing</p><p><em>{{billing_address_full}}</em></p></li><li><p>Shipping Method</p><p><em>{{shipping_method}} {{tracking_number}}</em></p></li><li><p>Payment Status</p><p><em>{{payment_status}}</em></p></li></ul> <p>Thanks for your purchase!<br>If you have any questions, reply to this email or reach out to {{store_email}}</p>',
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true,
            'store_id' => $store->id,
        ]);

        StoreEmailTemplate::with([])->firstOrCreate(['type' => StoreEmailTemplate::TYPE_SALES_CREDIT_ISSUED], [
            'type' => StoreEmailTemplate::TYPE_SALES_CREDIT_ISSUED,
            'subject' => 'You have store credit from {{store_name}}',
            'html_body' => "<p>{{store_logo_url}}</p><p>Hello {{customer_name}},</p><p>You have store credit from {{store_name}}<br>The credit amount totals: {{total_credit}}</p><p>You've requested a replacement item for the same value.<br>It will be delivered soon.</p><p></p><p>Thank you,</p><p>{{store_name}}<br>{{store_email}}<br><br></p><hr><p></p><p>{{store_logo_url}}</p><p>Hello {{customer_name}},</p><p>We've received your returned item:<br>{{sales_credit_lines}}<br>Return reason: {{reason_reason}} {{return_sales}}<br><br>We've reviewed the item and will grant you store credit for the amount: {{total_credit}}</p><p>Please reply this email if you with to receive a refund or a new item.</p><p></p><p>Thank you,</p><p>{{store_name}}<br>{{store_email}}</p>",
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true,
            'store_id' => $store->id,
        ]);

        StoreEmailTemplate::with([])->firstOrCreate(['type' => StoreEmailTemplate::TYPE_BULK_PURCHASE_ORDER], [
            'type' => StoreEmailTemplate::TYPE_BULK_PURCHASE_ORDER,
            'subject' => 'Purchase Order from {{company_name}}',
            'html_body' => '<p>Hello {{supplier_contact_name}}</p><p>We request the following orders from {{supplier_name}} to be delivered promptly to:</p><p>{{destination_name}}<br>{{destination_address_full}}</p><p>Find the orders attached to this email.</p><p>Please note:<br>{{supplier_notes}}</p><p></p><p>Thank you!<br>{{company_contact_name}}<br>{{company_email}}</p>',
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true,
            'store_id' => $store->id,
        ]);
    }
}
