<?php

namespace Database\Seeders\InitialData;

use App\Models\PurchaseOrder;
use App\Models\Setting;
use App\Services\PurchaseOrder\PurchaseOrderBuilder\Builders\SalesBasedPurchaseOrderBuilder;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        /*
        |--------------------------------------------------------------------------
        | Inventory Settings
        |--------------------------------------------------------------------------
        */

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_ADJUST_FORECAST_OUT_OF_STOCK],
            [
                'description' => 'Adjust forecast using out-of-stock information',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => false,
                'default_value' => false,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_DAYS_SALES_HISTORY],
            [
                'description' => 'Days of sales history',
                'type' => Setting::TYPE_INTEGER,
                'value' => 90,
                'default_value' => 90,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_MAX_PROJECTION_DAYS],
            [
                'description' => 'Max number of days of inventory projection.',
                'type' => Setting::TYPE_INTEGER,
                'value' => 90,
                'default_value' => 90,
            ]);

        $inventoryStartDate = Carbon::now('America/Los_Angeles')->subYear()->startOfYear()->setTimezone('UTC')->format('Y-m-d H:i:s');
        // Inventory Start Date
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_INVENTORY_START_DATE],
            [
                'description' => 'Set the date you will start tracking inventory in sku.io.',
                'type' => Setting::TYPE_TIME,
                'value' => $inventoryStartDate,
                'default_value' => $inventoryStartDate,
            ]);

        /*
        |--------------------------------------------------------------------------
        | Sales Order Settings
        |--------------------------------------------------------------------------
        */

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_PREFIX],
            [
                'description' => 'Prefix',
                'type' => Setting::TYPE_STRING,
                'value' => 'SO-',
                'default_value' => 'SO-',
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_NUM_OF_DIGITS],
            [
                'description' => '# of Digits',
                'type' => Setting::TYPE_INTEGER,
                'value' => 4,
                'default_value' => 4,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_START_NUMBER],
            [
                'description' => 'Starting Number',
                'type' => Setting::TYPE_INTEGER,
                'value' => 1,
                'default_value' => 1,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_DEFAULT_HANDLING_DAYS],
            [
                'description' => 'Default Handling Days',
                'type' => Setting::TYPE_INTEGER,
                'value' => 0,
                'default_value' => 0,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_SHOW_TAX_RATE],
            [
                'description' => 'Indicator to show tax rate',
                'type' => Setting::TYPE_INTEGER,
                'value' => 0,
                'default_value' => 0,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_SHOW_TAX_AMOUNT],
            [
                'description' => 'Indicator to show tax amount',
                'type' => Setting::TYPE_INTEGER,
                'value' => 0,
                'default_value' => 0,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_SAME_DAY_SHIPPING_CUTOFF],
            [
                'description' => 'Same Day Shipping Cutoff (PST)',
                'type' => Setting::TYPE_TIME,
                'value' => '13:00',
                'default_value' => '13:00',
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_UNPAID_ORDERS_AS_RESERVED],
            [
                'description' => 'Set unpaid orders as Reserved (won\'t auto fulfill)',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => false,
                'default_value' => false,
            ]);

        /*
        |--------------------------------------------------------------------------
        | Supplier Settings
        |--------------------------------------------------------------------------
        */

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SUPPLIER_LEADTIME],
            [
                'description' => 'Supplier Lead Time',
                'type' => Setting::TYPE_INTEGER,
                'value' => 3,
                'default_value' => 3,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SUPPLIER_MOQ],
            [
                'description' => 'Supplier MOQ',
                'type' => Setting::TYPE_INTEGER,
                'value' => 1,
                'default_value' => 1,
            ]);

        /*
        |--------------------------------------------------------------------------
        | Purchase Order Settings
        |--------------------------------------------------------------------------
        */

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_PREFIX],
            [
                'description' => 'Purchase Order Prefix',
                'type' => Setting::TYPE_STRING,
                'value' => 'PO-',
                'default_value' => 'PO-',
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_NUM_DIGITS],
            [
                'description' => 'Purchase Order number of digits',
                'type' => Setting::TYPE_INTEGER,
                'value' => 4,
                'default_value' => 4,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_START_NUMBER],
            [
                'description' => 'Purchase Order starting number',
                'type' => Setting::TYPE_INTEGER,
                'value' => 1,
                'default_value' => 1,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_FORMAT],
            [
                'description' => 'Purchase Order format',
                'type' => Setting::TYPE_STRING,
                'value' => PurchaseOrder::SUBMISSION_FORMAT_PDF_ATTACHMENT,
                'default_value' => PurchaseOrder::SUBMISSION_FORMAT_PDF_ATTACHMENT,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_LEAD_TIME],
            [
                'description' => 'Purchase order lead time (in days)',
                'type' => Setting::TYPE_INTEGER,
                'value' => 5,
                'default_value' => 5,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_CC_OUTGOING],
            [
                'description' => "CC email for PO's",
                'type' => Setting::TYPE_EMAIL,
                'value' => null,
                'default_value' => null,
            ]);

        /*
        |--------------------------------------------------------------------------
        | PO Builder Settings
        |--------------------------------------------------------------------------
        */
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_BUILDER_DEFAULT_USE_MOQ],
            [
                'description' => 'PO Builder Use MOQ',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => false,
                'default_value' => false,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_BUILDER_DEFAULT_USE_LEAD_TIME],
            [
                'description' => 'Purchase Order Builder use lead time',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => false,
                'default_value' => false,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_BUILDER_DEFAULT_ROUNDING_METHOD],
            [
                'description' => 'Purchase Order Builder rounding method',
                'type' => Setting::TYPE_STRING,
                'value' => SalesBasedPurchaseOrderBuilder::ROUNDING_METHOD_HALF_UP,
                'default_value' => SalesBasedPurchaseOrderBuilder::ROUNDING_METHOD_HALF_UP,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_BUILDER_DEFAULT_FORECASt_TYPE],
            [
                'description' => 'Purchase Order Builder forecast type',
                'type' => Setting::TYPE_STRING,
                'value' => SalesBasedPurchaseOrderBuilder::BUILDER_TYPE_TARGET_STOCK_LEVEL,
                'default_value' => SalesBasedPurchaseOrderBuilder::BUILDER_TYPE_TARGET_STOCK_LEVEL,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_BUILDER_DEFAULT_TARGET_QUANTITY],
            [
                'description' => 'Purchase Order Builder target quantity',
                'type' => Setting::TYPE_INTEGER,
                'value' => null,
                'default_value' => null,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_BUILDER_DEFAULT_SALES_HISTORY_DAYS],
            [
                'description' => 'Purchase Order Builder sales history day',
                'type' => Setting::TYPE_INTEGER,
                'value' => null,
                'default_value' => null,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_BUILDER_DEFAULT_TARGET_DAYS_OF_STOCK],
            [
                'description' => 'Purchase Order Builder target days of stock',
                'type' => Setting::TYPE_INTEGER,
                'value' => null,
                'default_value' => null,
            ]);
        /*
        |--------------------------------------------------------------------------
        | Warehouse Transfer Settings
        |--------------------------------------------------------------------------
        */

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_WH_TRANSFER_PREFIX],
            [
                'description' => 'Warehouse Transfer Prefix',
                'type' => Setting::TYPE_STRING,
                'value' => 'WH-',
                'default_value' => 'WH-',
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_WH_TRANSFER_NUM_OF_DIGITS],
            [
                'description' => 'Warehouse Transfer number of digits',
                'type' => Setting::TYPE_INTEGER,
                'value' => 4,
                'default_value' => 4,
            ]);

        /*
        |--------------------------------------------------------------------------
        | Date & Time Settings
        |--------------------------------------------------------------------------
        */

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_DEFAULT_TIMEZONE],
            [
                'description' => 'Default Timezone',
                'type' => Setting::TYPE_STRING,
                'value' => 'America/Los_Angeles',
                'default_value' => 'America/Los_Angeles',
            ]);

        Setting::query()->firstOrCreate(['key' => Setting::KEY_DEFAULT_DATE_FORMAT],
            [
                'description' => 'Default Date Format',
                'type' => Setting::TYPE_STRING,
                'value' => 'MM/DD/YYYY',
                'default_value' => 'MM/DD/YYYY',
            ]);

        /*
        |--------------------------------------------------------------------------
        | Product Settings
        |--------------------------------------------------------------------------
        */

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SC_SHOW_BARCODE_IN_FRONTEND],
            [
                'description' => 'Show Barcode In Frontend',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => 1,
                'default_value' => 1,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_DEFAULT_WEIGHT_UNIT],
            [
                'description' => 'Default product weight unit of measurement',
                'type' => Setting::TYPE_STRING,
                'value' => 'lb',
                'default_value' => 'lb',
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_DEFAULT_DIMENSION_UNIT],
            [
                'description' => 'Default product dimension unit of measurement',
                'type' => Setting::TYPE_STRING,
                'value' => 'in',
                'default_value' => 'in',
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PRIORITIZE_CLOSEST_WAREHOUSE_TO_CUSTOMER],
            [
                'description' => 'warehouse selection based on location',
                'type' => 'integer',
                'value' => false,
                'default_value' => false,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_AUTO_SPLIT_SALES_ORDER_LINE_ACROSS_WAREHOUSES],
            [
                'description' => 'warehouse selection based on location',
                'type' => 'integer',
                'value' => true,
                'default_value' => true,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_WAREHOUSE_IGNORE_SUPPLIER_TYPE],
            [
                'description' => 'warehouse ignore supplier type',
                'type' => 'integer',
                'value' => true,
                'default_value' => true,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_WAREHOUSE_IGNORE_AMAZON_FBA_TYPE],
            [
                'description' => 'warehouse ignore amazon fba type',
                'type' => 'integer',
                'value' => true,
                'default_value' => true,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_NEVER_SPLIT_SALES_ORDERS_ACROSS_WAREHOUSES],
            [
                'description' => 'never split sales orders across warehouses',
                'type' => 'integer',
                'value' => false,
                'default_value' => false,
            ]);

        /*
        |--------------------------------------------------------------------------
        | Accounting Settings
        |--------------------------------------------------------------------------
        */

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_ACCOUNTING_ENABLED],
            [
                'description' => 'Accounting Enabled',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => 0,
                'default_value' => 0,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_ACCOUNTING_START_DATE],
            [
                'description' => 'Accounting Start Date',
                'type' => Setting::TYPE_TIME,
                'value' => null,
                'default_value' => null,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_ACCOUNTING_LOCK_DATE],
            [
                'description' => 'Accounting Lock Date',
                'type' => Setting::TYPE_TIME,
                'value' => null,
                'default_value' => null,
            ]);



        // Auto fulfillment settings
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_FULFILL_ON_MAPPED_SHIPPING_METHOD],
            [
                'description' => 'Fulfill on mapped shipping method',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => 0,
                'default_value' => 0,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_AUTO_FULFILLMENT_EMAIL],
            [
                'description' => 'Auto fulfillment email',
                'type' => Setting::TYPE_EMAIL,
                'value' => null,
                'default_value' => null,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_AUTO_FULFILLMENT_FAILURE_NOTIFICATIONS],
            [
                'description' => 'Auto fulfillment failure notifications.',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => 0,
                'default_value' => 0,
            ]);

        Setting::with([])->firstOrCreate(['key' => Setting::KEY_BLEMISHED_SKU_PATTERN],
            [
                'description' => 'Blemished Sku Pattern',
                'type' => Setting::TYPE_STRING,
                'value' => 'RETURN-{{sku}}-{{date:YYYYMMDD}}',
                'default_value' => 'RETURN-{{sku}}-{{date:YYYYMMDD}}',
            ]);
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_USE_BLEMISHED_SKU_PATTERN],
            [
                'description' => 'Enable/Disable the use of Blemished SKU Pattern',
                'type' => Setting::TYPE_INTEGER,
                'value' => 0,
                'default_value' => 0,
            ]);
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_ASN_CC_EMAIL],
            [
                'description' => 'Advanced shipment notices CC email address',
                'type' => Setting::TYPE_EMAIL,
                'value' => null,
                'default_value' => null,
            ]);
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_ASN_FILE_FORMAT],
            [
                'description' => 'Advanced shipment notices file format',
                'type' => Setting::TYPE_STRING,
                'value' => 'csv',
                'default_value' => 'csv',
            ]);

        /*
        |--------------------------------------------------------------------------
        | Reporting Settings
        |--------------------------------------------------------------------------
        */

        Setting::firstOrCreate(['key' => Setting::KEY_FINANCIAL_ALERTS_ENABLED],
            [
                'description' => 'Enable Financial Alerts',
                'type' => Setting::TYPE_CHECKBOX,
                'value' => 0,
                'default_value' => 0,
            ]);

        Setting::firstOrCreate(['key' => Setting::KEY_FINANCIAL_ALERTS_LOW_MARGIN_THRESHOLD],
            [
                'description' => 'Financial Alerts Low Margin Threshold',
                'type' => Setting::TYPE_FLOAT,
                'value' => 0,
                'default_value' => 0,
            ]);

        Setting::firstOrCreate(['key' => Setting::KEY_FINANCIAL_ALERTS_IGNORE_FILTERS],
            [
                'description' => 'Financial Alerts Ignore Filters',
                'type' => Setting::TYPE_JSON,
                'value' => null,
                'default_value' => null,
            ]);

        Setting::firstOrCreate(['key' => Setting::KEY_FINANCIAL_ALERTS_NOTIFICATION_TYPE],
            [
                'description' => 'financial Alerts Notification Type',
                'type' => Setting::TYPE_STRING,
                'value' => 'slack',
                'default_value' => 'slack',
            ]);

        Setting::firstOrCreate(['key' => Setting::KEY_FINANCIAL_ALERTS_NOTIFICATION_DESTINATION],
            [
                'description' => 'financial Alerts Notification Destination',
                'type' => Setting::TYPE_STRING,
                'value' => null,
                'default_value' => null,
            ]);

        Setting::firstOrCreate(['key' => Setting::KEY_FINANCIAL_ALERTS_NOTIFICATION_CONDITIONS],
            [
                'description' => 'financial Alerts Notification Condition',
                'type' => Setting::TYPE_STRING,
                'value' => null,
                'default_value' => null,
            ]);

        Setting::firstOrCreate(['key' => Setting::KEY_FINANCIAL_ALERTS_LAST_NOTIFICATION_DATE],
            [
                'description' => 'financial Alerts Notification Condition',
                'type' => Setting::TYPE_TIME,
                'value' => null,
                'default_value' => null,
            ]);
    }
}
