<?php

namespace Database\Seeders\InitialData;

use App\Models\Currency;
use App\Models\ProductPricingTier;
use Illuminate\Database\Seeder;

class ProductPricingTiersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // If there is no default pricing tier, create one
        ProductPricingTier::query()->firstOrCreate(['is_default' => true], [
            'name' => 'Retail',
            'currency_code' => Currency::default()->code,
            'is_default' => true,
        ]);
    }
}
