<?php

namespace Database\Seeders\InitialData;

use App\Models\Incoterm;
use Illuminate\Database\Seeder;

class IncotermsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Incoterm::query()->firstOr(function () {
            Incoterm::query()->create(['code' => 'EXW', 'description' => 'Ex Works']);
            Incoterm::query()->create(['code' => 'FCA', 'description' => 'Free Carrier']);
            Incoterm::query()->create(['code' => 'FAS', 'description' => 'Free Alongside Ship']);
            Incoterm::query()->create(['code' => 'FOB', 'description' => 'Free On Board']);
            Incoterm::query()->create(['code' => 'CIF', 'description' => 'Cost, Insurance & Freight	']);
            Incoterm::query()->create(['code' => 'CFR', 'description' => 'Cost and Freight']);
            Incoterm::query()->create(['code' => 'CIP', 'description' => 'Carriage and Insurance Paid To']);
            Incoterm::query()->create(['code' => 'CPT', 'description' => 'Carriage Pad To']);
            Incoterm::query()->create(['code' => 'DAT', 'description' => 'Delivered at Terminal']);
            Incoterm::query()->create(['code' => 'DAP', 'description' => 'Delivered at Place']);
            Incoterm::query()->create(['code' => 'DDP', 'description' => 'Delivered Duty Paid']);
            Incoterm::query()->create(['code' => 'DPU', 'description' => 'Delivered Place Unloaded']);
        });
    }
}
