<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WisconsinSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '53066',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1103000',
                'longitude' => '-88.5017000',
                'city' => 'Oconomowoc',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53118',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9663000',
                'longitude' => '-88.3712000',
                'city' => 'Dousman',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53183',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9663000',
                'longitude' => '-88.3712000',
                'city' => 'Wales',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53147',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5996000',
                'longitude' => '-88.4344000',
                'city' => 'Lake Geneva',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53024',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3011000',
                'longitude' => '-87.9807000',
                'city' => 'Grafton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53105',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6740000',
                'longitude' => '-88.2764000',
                'city' => 'Burlington',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53005',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0422000',
                'longitude' => '-87.9068000',
                'city' => 'Brookfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53203',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0422000',
                'longitude' => '-87.9068000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53202',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0422000',
                'longitude' => '-87.9068000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53045',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0422000',
                'longitude' => '-87.9068000',
                'city' => 'Brookfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53151',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0422000',
                'longitude' => '-87.9068000',
                'city' => 'New Berlin',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53095',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4259000',
                'longitude' => '-88.1820000',
                'city' => 'West Bend',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53040',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4259000',
                'longitude' => '-88.1820000',
                'city' => 'Kewaskum',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53143',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5930000',
                'longitude' => '-87.8282000',
                'city' => 'Kenosha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53144',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5930000',
                'longitude' => '-87.8282000',
                'city' => 'Kenosha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53170',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.4920000',
                'longitude' => '-88.1040000',
                'city' => 'Silver Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53104',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.4920000',
                'longitude' => '-88.1040000',
                'city' => 'Bristol',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53027',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3256000',
                'longitude' => '-88.3833000',
                'city' => 'Hartford',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53226',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0429000',
                'longitude' => '-88.0833000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53012',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3011000',
                'longitude' => '-87.9807000',
                'city' => 'Cedarburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53033',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2348000',
                'longitude' => '-88.2286000',
                'city' => 'Hubertus',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53074',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3923000',
                'longitude' => '-87.8788000',
                'city' => 'Port Washington',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53092',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1922000',
                'longitude' => '-87.9969000',
                'city' => 'Thiensville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53097',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1922000',
                'longitude' => '-87.9969000',
                'city' => 'Mequon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53022',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1922000',
                'longitude' => '-87.9969000',
                'city' => 'Germantown',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53191',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5802000',
                'longitude' => '-88.5461000',
                'city' => 'Williams Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53115',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5802000',
                'longitude' => '-88.5461000',
                'city' => 'Delavan',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53017',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1313000',
                'longitude' => '-88.2038000',
                'city' => 'Colgate',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53089',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1313000',
                'longitude' => '-88.2038000',
                'city' => 'Sussex',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53090',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4259000',
                'longitude' => '-88.1820000',
                'city' => 'West Bend',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53051',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1793000',
                'longitude' => '-88.0984000',
                'city' => 'Menomonee Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53046',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1793000',
                'longitude' => '-88.0984000',
                'city' => 'Lannon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53122',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Elm Grove',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53404',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7285000',
                'longitude' => '-87.7870000',
                'city' => 'Racine',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53405',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7285000',
                'longitude' => '-87.7870000',
                'city' => 'Racine',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53177',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7285000',
                'longitude' => '-87.7870000',
                'city' => 'Sturtevant',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53402',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7285000',
                'longitude' => '-87.7870000',
                'city' => 'Racine',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53403',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7285000',
                'longitude' => '-87.7870000',
                'city' => 'Racine',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53080',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3902000',
                'longitude' => '-87.8732000',
                'city' => 'Saukville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53188',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0098000',
                'longitude' => '-88.2272000',
                'city' => 'Waukesha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53189',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0098000',
                'longitude' => '-88.2272000',
                'city' => 'Waukesha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53195',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5312000',
                'longitude' => '-88.5946000',
                'city' => 'Zenda',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53125',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5312000',
                'longitude' => '-88.5946000',
                'city' => 'Fontana',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53184',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5312000',
                'longitude' => '-88.5946000',
                'city' => 'Walworth',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53157',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5034000',
                'longitude' => '-88.3342000',
                'city' => 'Pell Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53181',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5034000',
                'longitude' => '-88.3342000',
                'city' => 'Twin Lakes',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53159',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5034000',
                'longitude' => '-88.3342000',
                'city' => 'Powers Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53128',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5034000',
                'longitude' => '-88.3342000',
                'city' => 'Genoa City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53013',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4987000',
                'longitude' => '-87.8416000',
                'city' => 'Cedar Grove',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53004',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4987000',
                'longitude' => '-87.8416000',
                'city' => 'Belgium',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53021',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0527000',
                'longitude' => '-87.9204000',
                'city' => 'Fredonia',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53525',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5007000',
                'longitude' => '-88.8675000',
                'city' => 'Clinton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53086',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3327000',
                'longitude' => '-88.2931000',
                'city' => 'Slinger',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53179',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5088000',
                'longitude' => '-88.1201000',
                'city' => 'Trevor',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53002',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4157000',
                'longitude' => '-88.3458000',
                'city' => 'Allenton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53018',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0659000',
                'longitude' => '-88.4132000',
                'city' => 'Delafield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53406',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6673000',
                'longitude' => '-87.8310000',
                'city' => 'Racine',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53186',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0098000',
                'longitude' => '-88.2272000',
                'city' => 'Waukesha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53029',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1002000',
                'longitude' => '-88.3533000',
                'city' => 'Hartland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53146',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0053000',
                'longitude' => '-88.0537000',
                'city' => 'New Berlin',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53108',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8075000',
                'longitude' => '-87.9487000',
                'city' => 'Caledonia',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53126',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7366000',
                'longitude' => '-87.9010000',
                'city' => 'Franksville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53069',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1582000',
                'longitude' => '-88.3685000',
                'city' => 'Okauchee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53058',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1582000',
                'longitude' => '-88.3685000',
                'city' => 'Nashotah',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53008',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0429000',
                'longitude' => '-88.0833000',
                'city' => 'Brookfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53185',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7599000',
                'longitude' => '-88.2153000',
                'city' => 'Waterford',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53190',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8319000',
                'longitude' => '-88.7268000',
                'city' => 'Whitewater',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53205',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5930000',
                'longitude' => '-87.8282000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53076',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5930000',
                'longitude' => '-87.8282000',
                'city' => 'Richfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53141',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5930000',
                'longitude' => '-87.8282000',
                'city' => 'Kenosha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53120',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8626000',
                'longitude' => '-88.3323000',
                'city' => 'East Troy',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53149',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8626000',
                'longitude' => '-88.3323000',
                'city' => 'Mukwonago',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53072',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1331000',
                'longitude' => '-88.3440000',
                'city' => 'Pewaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53007',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1112000',
                'longitude' => '-88.0978000',
                'city' => 'Butler',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53208',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0416000',
                'longitude' => '-87.9993000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53214',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0416000',
                'longitude' => '-87.9993000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53153',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9357000',
                'longitude' => '-88.4000000',
                'city' => 'North Prairie',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53119',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9357000',
                'longitude' => '-88.4000000',
                'city' => 'Eagle',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53223',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0422000',
                'longitude' => '-87.9068000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53142',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.4776000',
                'longitude' => '-88.1072000',
                'city' => 'Kenosha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53037',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3269000',
                'longitude' => '-88.1694000',
                'city' => 'Jackson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53187',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0098000',
                'longitude' => '-88.2272000',
                'city' => 'Waukesha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53233',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53156',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8739000',
                'longitude' => '-88.5917000',
                'city' => 'Palmyra',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53121',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8780000',
                'longitude' => '-88.5888000',
                'city' => 'Elkhorn',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53140',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5930000',
                'longitude' => '-87.8282000',
                'city' => 'Kenosha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53182',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7599000',
                'longitude' => '-88.2153000',
                'city' => 'Union Grove',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53139',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7599000',
                'longitude' => '-88.2153000',
                'city' => 'Kansasville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53056',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1513000',
                'longitude' => '-88.3098000',
                'city' => 'Merton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53167',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7599000',
                'longitude' => '-88.2153000',
                'city' => 'Rochester',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53168',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6009000',
                'longitude' => '-88.2090000',
                'city' => 'Salem',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53152',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6009000',
                'longitude' => '-88.2090000',
                'city' => 'New Munster',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53217',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3256000',
                'longitude' => '-88.3833000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53036',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1103000',
                'longitude' => '-88.5017000',
                'city' => 'Ixonia',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53178',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0162000',
                'longitude' => '-88.5826000',
                'city' => 'Sullivan',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53137',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0162000',
                'longitude' => '-88.5826000',
                'city' => 'Helenville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53549',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0162000',
                'longitude' => '-88.5826000',
                'city' => 'Jefferson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53538',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0162000',
                'longitude' => '-88.5826000',
                'city' => 'Fort Atkinson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53150',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Muskego',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53158',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5930000',
                'longitude' => '-87.8282000',
                'city' => 'Pleasant Prairie',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53010',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5215000',
                'longitude' => '-88.2268000',
                'city' => 'Campbellsport',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53001',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5215000',
                'longitude' => '-88.2268000',
                'city' => 'Adell',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53091',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4218000',
                'longitude' => '-88.3343000',
                'city' => 'Theresa',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53401',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7285000',
                'longitude' => '-87.7870000',
                'city' => 'Racine',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53103',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8856000',
                'longitude' => '-88.2030000',
                'city' => 'Big Bend',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53078',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3194000',
                'longitude' => '-88.3807000',
                'city' => 'Rubicon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53060',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4320000',
                'longitude' => '-88.0352000',
                'city' => 'Newburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53228',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0053000',
                'longitude' => '-88.0537000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53563',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5824000',
                'longitude' => '-88.5516000',
                'city' => 'Milton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53075',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4726000',
                'longitude' => '-87.9914000',
                'city' => 'Random Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53210',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4259000',
                'longitude' => '-88.1820000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53114',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6005000',
                'longitude' => '-88.7069000',
                'city' => 'Darien',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53585',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.4995000',
                'longitude' => '-88.7287000',
                'city' => 'Sharon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53201',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9734000',
                'longitude' => '-88.2815000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53171',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6397000',
                'longitude' => '-87.9072000',
                'city' => 'Somers',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53192',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5109000',
                'longitude' => '-88.1256000',
                'city' => 'Wilmot',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53109',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5487000',
                'longitude' => '-88.1689000',
                'city' => 'Camp Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53154',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Oak Creek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53052',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1817000',
                'longitude' => '-88.1179000',
                'city' => 'Menomonee Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53064',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1331000',
                'longitude' => '-88.3440000',
                'city' => 'North Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53127',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9663000',
                'longitude' => '-88.3712000',
                'city' => 'Genesee Depot',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54466',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8075000',
                'longitude' => '-87.9487000',
                'city' => 'Pittsville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53213',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0416000',
                'longitude' => '-87.9993000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53204',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0422000',
                'longitude' => '-87.9068000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53132',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0422000',
                'longitude' => '-87.9068000',
                'city' => 'Franklin',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53212',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53211',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0428000',
                'longitude' => '-87.9488000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53259',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53209',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1491000',
                'longitude' => '-87.8861000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53110',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9196000',
                'longitude' => '-87.8609000',
                'city' => 'Cudahy',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53222',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0416000',
                'longitude' => '-87.9993000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53206',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0649000',
                'longitude' => '-87.9116000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53220',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53219',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53227',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53215',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53221',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9459000',
                'longitude' => '-87.9550000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53207',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53216',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53218',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53225',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53235',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9904000',
                'longitude' => '-87.8947000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53130',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0381000',
                'longitude' => '-87.9098000',
                'city' => 'Hales Corners',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54904',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0428000',
                'longitude' => '-87.9488000',
                'city' => 'Oshkosh',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53224',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0407000',
                'longitude' => '-87.9433000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53295',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0138000',
                'longitude' => '-87.9414000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53129',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9459000',
                'longitude' => '-87.9550000',
                'city' => 'Greendale',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53172',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9196000',
                'longitude' => '-87.8609000',
                'city' => 'South Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53237',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0428000',
                'longitude' => '-87.9488000',
                'city' => 'Milwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53059',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1537000',
                'longitude' => '-88.0459000',
                'city' => 'Neosho',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53546',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6835000',
                'longitude' => '-89.0198000',
                'city' => 'Janesville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53562',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Middleton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53716',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53719',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53714',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53713',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53704',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53711',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53715',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53705',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53703',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0781000',
                'longitude' => '-89.4469000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53589',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9180000',
                'longitude' => '-89.2140000',
                'city' => 'Stoughton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53545',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Janesville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53511',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5081000',
                'longitude' => '-89.0229000',
                'city' => 'Beloit',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53560',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Mazomanie',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53702',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53593',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Verona',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53701',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53706',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53566',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6017000',
                'longitude' => '-89.6424000',
                'city' => 'Monroe',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53718',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0672000',
                'longitude' => '-89.3210000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53558',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Mc Farland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53575',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Oregon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53532',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'De Forest',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53523',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0819000',
                'longitude' => '-89.3740000',
                'city' => 'Cambridge',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53528',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0819000',
                'longitude' => '-89.3740000',
                'city' => 'Cross Plains',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53536',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Evansville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53597',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1024000',
                'longitude' => '-89.3457000',
                'city' => 'Waunakee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54610',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2320000',
                'longitude' => '-91.8357000',
                'city' => 'Alma',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54622',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2320000',
                'longitude' => '-91.8357000',
                'city' => 'Cochrane',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53940',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6301000',
                'longitude' => '-89.7766000',
                'city' => 'Lake Delton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53944',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6301000',
                'longitude' => '-89.7766000',
                'city' => 'Lyndon Station',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53959',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6301000',
                'longitude' => '-89.7766000',
                'city' => 'Reedsburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53965',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6301000',
                'longitude' => '-89.7766000',
                'city' => 'Wisconsin Dells',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53913',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6301000',
                'longitude' => '-89.7766000',
                'city' => 'Baraboo',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53949',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0676000',
                'longitude' => '-89.4050000',
                'city' => 'Montello',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53792',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0676000',
                'longitude' => '-89.4050000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53717',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0676000',
                'longitude' => '-89.4050000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54656',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9425000',
                'longitude' => '-90.8141000',
                'city' => 'Sparta',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54615',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0909000',
                'longitude' => '-90.8553000',
                'city' => 'Black River Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54620',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0909000',
                'longitude' => '-90.8553000',
                'city' => 'Cataract',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53964',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8833000',
                'longitude' => '-89.4927000',
                'city' => 'Westfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53952',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8833000',
                'longitude' => '-89.4927000',
                'city' => 'Oxford',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53936',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8833000',
                'longitude' => '-89.4927000',
                'city' => 'Grand Marsh',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54650',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8185000',
                'longitude' => '-91.2495000',
                'city' => 'Onalaska',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54601',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8185000',
                'longitude' => '-91.2495000',
                'city' => 'La Crosse',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53821',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0490000',
                'longitude' => '-91.1506000',
                'city' => 'Prairie Du Chien',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54616',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2918000',
                'longitude' => '-91.2373000',
                'city' => 'Blair',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54660',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9755000',
                'longitude' => '-90.5017000',
                'city' => 'Tomah',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53533',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9567000',
                'longitude' => '-90.1261000',
                'city' => 'Dodgeville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54747',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2493000',
                'longitude' => '-91.4993000',
                'city' => 'Independence',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54755',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2493000',
                'longitude' => '-91.4993000',
                'city' => 'Mondovi',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54612',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2493000',
                'longitude' => '-91.4993000',
                'city' => 'Arcadia',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53590',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0819000',
                'longitude' => '-89.3740000',
                'city' => 'Sun Prairie',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53818',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7343000',
                'longitude' => '-90.4771000',
                'city' => 'Platteville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54648',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7250000',
                'longitude' => '-90.5941000',
                'city' => 'Norwalk',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54651',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7250000',
                'longitude' => '-90.5941000',
                'city' => 'Ontario',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53910',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9562000',
                'longitude' => '-89.8186000',
                'city' => 'Adams',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54613',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9562000',
                'longitude' => '-89.8186000',
                'city' => 'Arkdale',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53934',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9562000',
                'longitude' => '-89.8186000',
                'city' => 'Friendship',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53920',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6587000',
                'longitude' => '-89.5869000',
                'city' => 'Briggsville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53807',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7343000',
                'longitude' => '-90.4771000',
                'city' => 'Cuba City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53948',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7931000',
                'longitude' => '-90.0815000',
                'city' => 'Mauston',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '62274',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0532000',
                'longitude' => '-91.1479000',
                'city' => 'Pinckneyville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53943',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4400000',
                'longitude' => '-90.0344000',
                'city' => 'Loganville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53583',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2749000',
                'longitude' => '-89.7257000',
                'city' => 'Sauk City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54666',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9775000',
                'longitude' => '-90.5074000',
                'city' => 'Warrens',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53805',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1316000',
                'longitude' => '-90.7063000',
                'city' => 'Boscobel',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54641',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1304000',
                'longitude' => '-90.5024000',
                'city' => 'Mather',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53816',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9672000',
                'longitude' => '-90.8502000',
                'city' => 'Mount Hope',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53581',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3357000',
                'longitude' => '-90.3863000',
                'city' => 'Richland Center',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54556',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9425000',
                'longitude' => '-90.8141000',
                'city' => 'Prentice',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54625',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0743000',
                'longitude' => '-91.4530000',
                'city' => 'Dodge',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54630',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0743000',
                'longitude' => '-91.4530000',
                'city' => 'Galesville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54603',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8848000',
                'longitude' => '-91.2336000',
                'city' => 'La Crosse',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54642',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1330000',
                'longitude' => '-91.0039000',
                'city' => 'Melrose',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54636',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9569000',
                'longitude' => '-91.2490000',
                'city' => 'Holmen',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53531',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0056000',
                'longitude' => '-89.0195000',
                'city' => 'Deerfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53521',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8656000',
                'longitude' => '-89.5304000',
                'city' => 'Brooklyn',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53508',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8656000',
                'longitude' => '-89.5304000',
                'city' => 'Belleville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54638',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9186000',
                'longitude' => '-90.2715000',
                'city' => 'Kendall',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54618',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9186000',
                'longitude' => '-90.2715000',
                'city' => 'Camp Douglas',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53950',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9186000',
                'longitude' => '-90.2715000',
                'city' => 'New Lisbon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54637',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9186000',
                'longitude' => '-90.2715000',
                'city' => 'Hustler',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53901',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5379000',
                'longitude' => '-89.3031000',
                'city' => 'Portage',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53969',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5379000',
                'longitude' => '-89.3031000',
                'city' => 'Wyocena',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53960',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5379000',
                'longitude' => '-89.3031000',
                'city' => 'Rio',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53923',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5379000',
                'longitude' => '-89.3031000',
                'city' => 'Cambria',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53954',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5379000',
                'longitude' => '-89.3031000',
                'city' => 'Pardeeville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54670',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8184000',
                'longitude' => '-90.5237000',
                'city' => 'Wilton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53517',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0085000',
                'longitude' => '-89.7332000',
                'city' => 'Blue Mounds',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53507',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0085000',
                'longitude' => '-89.7332000',
                'city' => 'Barneveld',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53572',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0085000',
                'longitude' => '-89.7332000',
                'city' => 'Mount Horeb',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53587',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5646000',
                'longitude' => '-89.8760000',
                'city' => 'South Wayne',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53541',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5646000',
                'longitude' => '-89.8760000',
                'city' => 'Gratiot',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53522',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5646000',
                'longitude' => '-89.8760000',
                'city' => 'Browntown',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54614',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8894000',
                'longitude' => '-90.9839000',
                'city' => 'Bangor',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54667',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6991000',
                'longitude' => '-91.0127000',
                'city' => 'Westby',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54621',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6991000',
                'longitude' => '-91.0127000',
                'city' => 'Chaseburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54619',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6991000',
                'longitude' => '-91.0127000',
                'city' => 'Cashton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54623',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6991000',
                'longitude' => '-91.0127000',
                'city' => 'Coon Valley',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54632',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6680000',
                'longitude' => '-91.2160000',
                'city' => 'Genoa',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54658',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6680000',
                'longitude' => '-91.2160000',
                'city' => 'Stoddard',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53811',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1839000',
                'longitude' => '-90.0687000',
                'city' => 'Hazel Green',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53929',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7431000',
                'longitude' => '-90.2714000',
                'city' => 'Elroy',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53962',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7431000',
                'longitude' => '-90.2714000',
                'city' => 'Union Center',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53968',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7431000',
                'longitude' => '-90.2714000',
                'city' => 'Wonewoc',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53941',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6564000',
                'longitude' => '-90.2317000',
                'city' => 'La Valle',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53599',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6514000',
                'longitude' => '-89.8590000',
                'city' => 'Woodford',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53504',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6514000',
                'longitude' => '-89.8590000',
                'city' => 'Argyle',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53726',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54629',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1346000',
                'longitude' => '-91.7164000',
                'city' => 'Fountain City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54631',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1820000',
                'longitude' => '-90.8610000',
                'city' => 'Gays Mills',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54657',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1820000',
                'longitude' => '-90.8610000',
                'city' => 'Steuben',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53826',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1820000',
                'longitude' => '-90.8610000',
                'city' => 'Wauzeka',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54634',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6499000',
                'longitude' => '-90.3420000',
                'city' => 'Hillsboro',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53530',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6841000',
                'longitude' => '-90.1150000',
                'city' => 'Darlington',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54665',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6589000',
                'longitude' => '-91.1027000',
                'city' => 'Viroqua',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54653',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8914000',
                'longitude' => '-90.9896000',
                'city' => 'Rockland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54644',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8914000',
                'longitude' => '-90.9896000',
                'city' => 'Mindoro',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54627',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1372000',
                'longitude' => '-91.0011000',
                'city' => 'Ettrick',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54639',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6499000',
                'longitude' => '-90.3420000',
                'city' => 'La Farge',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53586',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5742000',
                'longitude' => '-90.2372000',
                'city' => 'Shullsburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '61080',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9180000',
                'longitude' => '-89.2140000',
                'city' => 'South Beloit',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53561',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3717000',
                'longitude' => '-89.6236000',
                'city' => 'Merrimac',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53951',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4587000',
                'longitude' => '-89.8596000',
                'city' => 'North Freedom',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53725',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Madison',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53961',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4629000',
                'longitude' => '-89.8708000',
                'city' => 'Rock Springs',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53544',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8166000',
                'longitude' => '-89.8583000',
                'city' => 'Hollandale',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53516',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8166000',
                'longitude' => '-89.8583000',
                'city' => 'Blanchardville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54659',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1695000',
                'longitude' => '-91.2695000',
                'city' => 'Taylor',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53570',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8163000',
                'longitude' => '-89.6341000',
                'city' => 'Monticello',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53574',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8163000',
                'longitude' => '-89.6341000',
                'city' => 'New Glarus',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53930',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7839000',
                'longitude' => '-89.4202000',
                'city' => 'Endeavor',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53573',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1811000',
                'longitude' => '-90.3298000',
                'city' => 'Muscoda',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53506',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1811000',
                'longitude' => '-90.3298000',
                'city' => 'Avoca',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53827',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0937000',
                'longitude' => '-90.8012000',
                'city' => 'Woodman',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54661',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0125000',
                'longitude' => '-91.4376000',
                'city' => 'Trempealeau',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53518',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3350000',
                'longitude' => '-90.5270000',
                'city' => 'Blue River',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54655',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3350000',
                'longitude' => '-90.5270000',
                'city' => 'Soldiers Grove',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54664',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4213000',
                'longitude' => '-90.6091000',
                'city' => 'Viola',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54652',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4213000',
                'longitude' => '-90.6091000',
                'city' => 'Readstown',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53578',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2832000',
                'longitude' => '-89.8886000',
                'city' => 'Prairie Du Sac',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53577',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2832000',
                'longitude' => '-89.8886000',
                'city' => 'Plain',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53588',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2832000',
                'longitude' => '-89.8886000',
                'city' => 'Spring Green',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53534',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8325000',
                'longitude' => '-89.0701000',
                'city' => 'Edgerton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54943',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0822000',
                'longitude' => '-89.8946000',
                'city' => 'Hancock',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54457',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0822000',
                'longitude' => '-89.8946000',
                'city' => 'Nekoosa',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54646',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0263000',
                'longitude' => '-90.0685000',
                'city' => 'Necedah',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53812',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6262000',
                'longitude' => '-90.5905000',
                'city' => 'Kieler',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53820',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6262000',
                'longitude' => '-90.5905000',
                'city' => 'Potosi',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53808',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6262000',
                'longitude' => '-90.5905000',
                'city' => 'Dickeyville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '60606',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0758000',
                'longitude' => '-89.3853000',
                'city' => 'Chicago',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53540',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1836000',
                'longitude' => '-90.1950000',
                'city' => 'Gotham',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53937',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1836000',
                'longitude' => '-90.1950000',
                'city' => 'Hillpoint',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53556',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1836000',
                'longitude' => '-90.1950000',
                'city' => 'Lone Rock',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53924',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3403000',
                'longitude' => '-90.2851000',
                'city' => 'Cazenovia',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53503',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1777000',
                'longitude' => '-90.0660000',
                'city' => 'Arena',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53953',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7839000',
                'longitude' => '-89.4202000',
                'city' => 'Packwaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53529',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3158000',
                'longitude' => '-89.5285000',
                'city' => 'Dane',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53555',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3158000',
                'longitude' => '-89.5285000',
                'city' => 'Lodi',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54669',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8988000',
                'longitude' => '-91.0834000',
                'city' => 'West Salem',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53543',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9685000',
                'longitude' => '-90.3134000',
                'city' => 'Highland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53553',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9685000',
                'longitude' => '-90.3134000',
                'city' => 'Linden',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53554',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9685000',
                'longitude' => '-90.3134000',
                'city' => 'Livingston',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53565',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9685000',
                'longitude' => '-90.3134000',
                'city' => 'Mineral Point',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53569',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9685000',
                'longitude' => '-90.3134000',
                'city' => 'Montfort',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53526',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9685000',
                'longitude' => '-90.3134000',
                'city' => 'Cobb',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53535',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9685000',
                'longitude' => '-90.3134000',
                'city' => 'Edmund',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54624',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6591000',
                'longitude' => '-90.8567000',
                'city' => 'De Soto',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53911',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3938000',
                'longitude' => '-89.4037000',
                'city' => 'Arlington',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53955',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3938000',
                'longitude' => '-89.4037000',
                'city' => 'Poynette',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54628',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4204000',
                'longitude' => '-91.1988000',
                'city' => 'Ferryville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53559',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1691000',
                'longitude' => '-89.0670000',
                'city' => 'Marshall',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53505',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5564000',
                'longitude' => '-88.8636000',
                'city' => 'Avalon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '61087',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.4984000',
                'longitude' => '-89.9900000',
                'city' => 'Warren',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54756',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3257000',
                'longitude' => '-91.9153000',
                'city' => 'Nelson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53813',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8505000',
                'longitude' => '-90.7121000',
                'city' => 'Lancaster',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53806',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7160000',
                'longitude' => '-90.9959000',
                'city' => 'Cassville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54626',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3213000',
                'longitude' => '-90.9919000',
                'city' => 'Eastman',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54654',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3213000',
                'longitude' => '-90.9919000',
                'city' => 'Seneca',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54645',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3213000',
                'longitude' => '-90.9919000',
                'city' => 'Mount Sterling',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53547',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6835000',
                'longitude' => '-89.0198000',
                'city' => 'Janesville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53803',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5716000',
                'longitude' => '-90.3845000',
                'city' => 'Benton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53510',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7391000',
                'longitude' => '-90.3350000',
                'city' => 'Belmont',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53527',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0473000',
                'longitude' => '-89.0748000',
                'city' => 'Cottage Grove',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53515',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1345000',
                'longitude' => '-89.7519000',
                'city' => 'Black Earth',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54602',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8185000',
                'longitude' => '-91.2495000',
                'city' => 'La Crosse',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53802',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8194000',
                'longitude' => '-90.9685000',
                'city' => 'Beetown',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53804',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8194000',
                'longitude' => '-90.9685000',
                'city' => 'Bloomington',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53810',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8194000',
                'longitude' => '-90.9685000',
                'city' => 'Glen Haven',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53809',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9832000',
                'longitude' => '-90.6518000',
                'city' => 'Fennimore',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53598',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2532000',
                'longitude' => '-89.3465000',
                'city' => 'Windsor',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53571',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2532000',
                'longitude' => '-89.3465000',
                'city' => 'Morrisonville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53520',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7105000',
                'longitude' => '-89.4344000',
                'city' => 'Brodhead',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53502',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.7105000',
                'longitude' => '-89.4344000',
                'city' => 'Albany',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53542',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6723000',
                'longitude' => '-89.2093000',
                'city' => 'Hanover',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53537',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6723000',
                'longitude' => '-89.2093000',
                'city' => 'Footville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53576',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.6292000',
                'longitude' => '-89.2600000',
                'city' => 'Orfordville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53582',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0002000',
                'longitude' => '-89.9907000',
                'city' => 'Ridgeway',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53550',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.5932000',
                'longitude' => '-89.5090000',
                'city' => 'Juda',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53825',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9391000',
                'longitude' => '-90.4307000',
                'city' => 'Stitzer',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53580',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.9391000',
                'longitude' => '-90.4307000',
                'city' => 'Rewey',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53942',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4687000',
                'longitude' => '-90.1555000',
                'city' => 'Lime Ridge',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53801',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8839000',
                'longitude' => '-90.9191000',
                'city' => 'Bagley',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53817',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '42.8839000',
                'longitude' => '-90.9191000',
                'city' => 'Patch Grove',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54909',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7742000',
                'longitude' => '-88.6015000',
                'city' => 'Almond',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54732',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1767000',
                'longitude' => '-91.1512000',
                'city' => 'Cornell',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54401',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9510000',
                'longitude' => '-89.6197000',
                'city' => 'Wausau',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54481',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5173000',
                'longitude' => '-89.5675000',
                'city' => 'Stevens Point',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54868',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4980000',
                'longitude' => '-91.7329000',
                'city' => 'Rice Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54768',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9680000',
                'longitude' => '-90.9346000',
                'city' => 'Stanley',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54441',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6642000',
                'longitude' => '-90.1753000',
                'city' => 'Hewitt',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54534',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4474000',
                'longitude' => '-90.1731000',
                'city' => 'Hurley',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54814',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.8081000',
                'longitude' => '-90.8209000',
                'city' => 'Bayfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54703',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8071000',
                'longitude' => '-91.4951000',
                'city' => 'Eau Claire',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54495',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3753000',
                'longitude' => '-89.8182000',
                'city' => 'Wisconsin Rapids',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54701',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8194000',
                'longitude' => '-91.5011000',
                'city' => 'Eau Claire',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54409',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1443000',
                'longitude' => '-89.1526000',
                'city' => 'Antigo',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54157',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Peshtigo',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54452',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1822000',
                'longitude' => '-89.6855000',
                'city' => 'Merrill',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54082',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9830000',
                'longitude' => '-92.7482000',
                'city' => 'Houlton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54449',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6642000',
                'longitude' => '-90.1753000',
                'city' => 'Marshfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54405',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9157000',
                'longitude' => '-90.3161000',
                'city' => 'Abbotsford',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54488',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9157000',
                'longitude' => '-90.3161000',
                'city' => 'Unity',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54422',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9157000',
                'longitude' => '-90.3161000',
                'city' => 'Curtiss',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54411',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9157000',
                'longitude' => '-90.3161000',
                'city' => 'Athens',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54479',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9157000',
                'longitude' => '-90.3161000',
                'city' => 'Spencer',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54421',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9157000',
                'longitude' => '-90.3161000',
                'city' => 'Colby',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54531',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4688000',
                'longitude' => '-89.7338000',
                'city' => 'Hazelhurst',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54487',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4688000',
                'longitude' => '-89.7338000',
                'city' => 'Tomahawk',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54435',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4688000',
                'longitude' => '-89.7338000',
                'city' => 'Gleason',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54442',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4688000',
                'longitude' => '-89.7338000',
                'city' => 'Irma',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54751',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8773000',
                'longitude' => '-91.9274000',
                'city' => 'Menomonie',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54930',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0423000',
                'longitude' => '-89.5162000',
                'city' => 'Coloma',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54498',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9477000',
                'longitude' => '-90.5675000',
                'city' => 'Withee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54460',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9477000',
                'longitude' => '-90.5675000',
                'city' => 'Owen',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54841',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5000000',
                'longitude' => '-91.7388000',
                'city' => 'Haugen',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54857',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5000000',
                'longitude' => '-91.7388000',
                'city' => 'Mikana',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54822',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5000000',
                'longitude' => '-91.7388000',
                'city' => 'Cameron',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54730',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8773000',
                'longitude' => '-91.9274000',
                'city' => 'Colfax',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54817',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5000000',
                'longitude' => '-91.7388000',
                'city' => 'Birchwood',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54724',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2091000',
                'longitude' => '-91.5609000',
                'city' => 'Bloomer',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54757',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2091000',
                'longitude' => '-91.5609000',
                'city' => 'New Auburn',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54728',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2091000',
                'longitude' => '-91.5609000',
                'city' => 'Chetek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54420',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5848000',
                'longitude' => '-90.4598000',
                'city' => 'Chili',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54436',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5848000',
                'longitude' => '-90.4598000',
                'city' => 'Granton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54456',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5848000',
                'longitude' => '-90.4598000',
                'city' => 'Neillsville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54745',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1664000',
                'longitude' => '-91.1511000',
                'city' => 'Holcombe',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54748',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1664000',
                'longitude' => '-91.1511000',
                'city' => 'Jim Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54406',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6271000',
                'longitude' => '-90.1438000',
                'city' => 'Amherst',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54455',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9055000',
                'longitude' => '-89.6087000',
                'city' => 'Mosinee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54474',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9055000',
                'longitude' => '-89.6087000',
                'city' => 'Rothschild',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54476',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9055000',
                'longitude' => '-89.6087000',
                'city' => 'Schofield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54017',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1221000',
                'longitude' => '-92.5366000',
                'city' => 'New Richmond',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54830',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1613000',
                'longitude' => '-92.2349000',
                'city' => 'Danbury',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54880',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1613000',
                'longitude' => '-92.2349000',
                'city' => 'Superior',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54025',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1221000',
                'longitude' => '-92.5366000',
                'city' => 'Somerset',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54020',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1986000',
                'longitude' => '-92.5366000',
                'city' => 'Osceola',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54007',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1986000',
                'longitude' => '-92.5366000',
                'city' => 'Deer Park',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54026',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1986000',
                'longitude' => '-92.5366000',
                'city' => 'Star Prairie',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54966',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1311000',
                'longitude' => '-89.5180000',
                'city' => 'Plainfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54929',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6168000',
                'longitude' => '-88.7531000',
                'city' => 'Clintonville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54151',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.7732000',
                'longitude' => '-88.0012000',
                'city' => 'Niagara',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54427',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8230000',
                'longitude' => '-89.1686000',
                'city' => 'Eland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54486',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8230000',
                'longitude' => '-89.1686000',
                'city' => 'Tigerton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54414',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8230000',
                'longitude' => '-89.1686000',
                'city' => 'Birnamwood',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54499',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8230000',
                'longitude' => '-89.1686000',
                'city' => 'Wittenberg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54446',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7374000',
                'longitude' => '-90.4976000',
                'city' => 'Loyal',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54437',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7374000',
                'longitude' => '-90.4976000',
                'city' => 'Greenwood',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54981',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3560000',
                'longitude' => '-89.0859000',
                'city' => 'Waupaca',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54946',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3560000',
                'longitude' => '-89.0859000',
                'city' => 'King',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54984',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3560000',
                'longitude' => '-89.0859000',
                'city' => 'Wild Rose',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54426',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0298000',
                'longitude' => '-90.0412000',
                'city' => 'Edgar',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54801',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0105000',
                'longitude' => '-92.1184000',
                'city' => 'Spooner',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54893',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0105000',
                'longitude' => '-92.1184000',
                'city' => 'Webster',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54537',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5319000',
                'longitude' => '-90.5859000',
                'city' => 'Kennan',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54403',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9593000',
                'longitude' => '-89.6283000',
                'city' => 'Wausau',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54022',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7502000',
                'longitude' => '-92.7992000',
                'city' => 'River Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54021',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7502000',
                'longitude' => '-92.7992000',
                'city' => 'Prescott',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54005',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2495000',
                'longitude' => '-92.2587000',
                'city' => 'Clear Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54514',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1369000',
                'longitude' => '-90.5758000',
                'city' => 'Butternut',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54527',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1369000',
                'longitude' => '-90.5758000',
                'city' => 'Glidden',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54734',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0570000',
                'longitude' => '-92.1725000',
                'city' => 'Downing',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54013',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0570000',
                'longitude' => '-92.1725000',
                'city' => 'Glenwood City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54862',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.8222000',
                'longitude' => '-91.0091000',
                'city' => 'Ojibwa',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54843',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.8222000',
                'longitude' => '-91.0091000',
                'city' => 'Hayward',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54896',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.8222000',
                'longitude' => '-91.0091000',
                'city' => 'Winter',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54493',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7679000',
                'longitude' => '-90.5985000',
                'city' => 'Willard',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54810',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3098000',
                'longitude' => '-92.3478000',
                'city' => 'Balsam Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54889',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3098000',
                'longitude' => '-92.3478000',
                'city' => 'Turtle Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54001',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3098000',
                'longitude' => '-92.3478000',
                'city' => 'Amery',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54521',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.7810000',
                'longitude' => '-89.3168000',
                'city' => 'Eagle River',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54501',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.7810000',
                'longitude' => '-89.3168000',
                'city' => 'Rhinelander',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54011',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7344000',
                'longitude' => '-92.4906000',
                'city' => 'Ellsworth',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54003',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7344000',
                'longitude' => '-92.4906000',
                'city' => 'Beldenville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54846',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.3264000',
                'longitude' => '-90.6620000',
                'city' => 'High Bridge',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54546',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.3264000',
                'longitude' => '-90.6620000',
                'city' => 'Mellen',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54485',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4334000',
                'longitude' => '-89.1752000',
                'city' => 'Summit Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54424',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4334000',
                'longitude' => '-89.1752000',
                'city' => 'Deerbrook',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54463',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4334000',
                'longitude' => '-89.1752000',
                'city' => 'Pelican Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54428',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4334000',
                'longitude' => '-89.1752000',
                'city' => 'Elcho',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54175',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2974000',
                'longitude' => '-88.5202000',
                'city' => 'Townsend',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54149',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2974000',
                'longitude' => '-88.5202000',
                'city' => 'Mountain',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54138',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2974000',
                'longitude' => '-88.5202000',
                'city' => 'Lakewood',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54114',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2974000',
                'longitude' => '-88.5202000',
                'city' => 'Crivitz',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54174',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2974000',
                'longitude' => '-88.5202000',
                'city' => 'Suring',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54491',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2974000',
                'longitude' => '-88.5202000',
                'city' => 'White Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54539',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.8172000',
                'longitude' => '-89.5915000',
                'city' => 'Lake Tomahawk',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54529',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.8172000',
                'longitude' => '-89.5915000',
                'city' => 'Harshaw',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54806',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4225000',
                'longitude' => '-90.8223000',
                'city' => 'Ashland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54856',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4225000',
                'longitude' => '-90.8223000',
                'city' => 'Mason',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54855',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4225000',
                'longitude' => '-90.8223000',
                'city' => 'Marengo',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54736',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6287000',
                'longitude' => '-91.9638000',
                'city' => 'Durand',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54166',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7742000',
                'longitude' => '-88.6015000',
                'city' => 'Shawano',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54737',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6981000',
                'longitude' => '-92.0175000',
                'city' => 'Eau Galle',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54721',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6981000',
                'longitude' => '-92.0175000',
                'city' => 'Arkansaw',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54740',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6981000',
                'longitude' => '-92.0175000',
                'city' => 'Elmwood',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54761',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6317000',
                'longitude' => '-92.0328000',
                'city' => 'Plum City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54722',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6791000',
                'longitude' => '-91.1244000',
                'city' => 'Augusta',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54741',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6791000',
                'longitude' => '-91.1244000',
                'city' => 'Fairchild',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54726',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6791000',
                'longitude' => '-91.1244000',
                'city' => 'Boyd',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54742',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6791000',
                'longitude' => '-91.1244000',
                'city' => 'Fall Creek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54738',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5762000',
                'longitude' => '-91.4657000',
                'city' => 'Eleva',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54729',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0233000',
                'longitude' => '-91.3922000',
                'city' => 'Chippewa Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54727',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9474000',
                'longitude' => '-91.1568000',
                'city' => 'Cadott',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54766',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3189000',
                'longitude' => '-90.9526000',
                'city' => 'Sheldon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54009',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3200000',
                'longitude' => '-92.6574000',
                'city' => 'Dresser',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54467',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5236000',
                'longitude' => '-89.5846000',
                'city' => 'Plover',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54635',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2995000',
                'longitude' => '-90.8631000',
                'city' => 'Hixton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54754',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2995000',
                'longitude' => '-90.8631000',
                'city' => 'Merrillan',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54526',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3511000',
                'longitude' => '-90.7929000',
                'city' => 'Glen Flora',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54433',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3511000',
                'longitude' => '-90.7929000',
                'city' => 'Gilman',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54530',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4991000',
                'longitude' => '-90.8931000',
                'city' => 'Hawkins',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54563',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4991000',
                'longitude' => '-90.8931000',
                'city' => 'Tony',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54119',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6327000',
                'longitude' => '-87.9894000',
                'city' => 'Dunbar',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54156',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6327000',
                'longitude' => '-87.9894000',
                'city' => 'Pembine',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54494',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3216000',
                'longitude' => '-89.8129000',
                'city' => 'Wisconsin Rapids',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54853',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6608000',
                'longitude' => '-92.4678000',
                'city' => 'Luck',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54840',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6608000',
                'longitude' => '-92.4678000',
                'city' => 'Grantsburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54837',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6608000',
                'longitude' => '-92.4678000',
                'city' => 'Frederic',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54143',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0917000',
                'longitude' => '-87.6118000',
                'city' => 'Marinette',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54555',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6848000',
                'longitude' => '-90.5659000',
                'city' => 'Phillips',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54746',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6042000',
                'longitude' => '-90.9683000',
                'city' => 'Humbird',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54921',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2177000',
                'longitude' => '-89.4855000',
                'city' => 'Bancroft',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54103',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6342000',
                'longitude' => '-88.3585000',
                'city' => 'Armstrong Creek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54120',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6342000',
                'longitude' => '-88.3585000',
                'city' => 'Fence',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54121',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6342000',
                'longitude' => '-88.3585000',
                'city' => 'Florence',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54125',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6342000',
                'longitude' => '-88.3585000',
                'city' => 'Goodman',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54845',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.7823000',
                'longitude' => '-92.3871000',
                'city' => 'Hertel',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54872',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.7823000',
                'longitude' => '-92.3871000',
                'city' => 'Siren',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54448',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9246000',
                'longitude' => '-89.9638000',
                'city' => 'Marathon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54895',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4342000',
                'longitude' => '-91.4081000',
                'city' => 'Weyerhaeuser',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54870',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6575000',
                'longitude' => '-91.5524000',
                'city' => 'Sarona',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54834',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6575000',
                'longitude' => '-91.5524000',
                'city' => 'Edgewater',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54568',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.8877000',
                'longitude' => '-89.7018000',
                'city' => 'Woodruff',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54548',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.8877000',
                'longitude' => '-89.7018000',
                'city' => 'Minocqua',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54812',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4148000',
                'longitude' => '-92.0339000',
                'city' => 'Barron',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54805',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4148000',
                'longitude' => '-92.0339000',
                'city' => 'Almena',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54826',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4148000',
                'longitude' => '-92.0339000',
                'city' => 'Comstock',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54004',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4148000',
                'longitude' => '-92.0339000',
                'city' => 'Clayton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54864',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5929000',
                'longitude' => '-91.7271000',
                'city' => 'Poplar',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54854',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5929000',
                'longitude' => '-91.7271000',
                'city' => 'Maple',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54874',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5815000',
                'longitude' => '-91.8011000',
                'city' => 'South Range',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54820',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5658000',
                'longitude' => '-91.4145000',
                'city' => 'Brule',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54847',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5658000',
                'longitude' => '-91.4145000',
                'city' => 'Iron River',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54891',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.6735000',
                'longitude' => '-90.8800000',
                'city' => 'Washburn',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54842',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4997000',
                'longitude' => '-91.7399000',
                'city' => 'Hawthorne',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54849',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4997000',
                'longitude' => '-91.7399000',
                'city' => 'Lake Nebagamon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54873',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4508000',
                'longitude' => '-91.8396000',
                'city' => 'Solon Springs',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54838',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.2427000',
                'longitude' => '-91.7991000',
                'city' => 'Gordon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54016',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9765000',
                'longitude' => '-92.7595000',
                'city' => 'Hudson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54484',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6642000',
                'longitude' => '-90.1753000',
                'city' => 'Stratford',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54412',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6642000',
                'longitude' => '-90.1753000',
                'city' => 'Auburndale',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54512',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1146000',
                'longitude' => '-89.6398000',
                'city' => 'Boulder Junction',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54557',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1146000',
                'longitude' => '-89.6398000',
                'city' => 'Presque Isle',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54540',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1146000',
                'longitude' => '-89.6398000',
                'city' => 'Land O Lakes',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54538',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.9665000',
                'longitude' => '-89.8944000',
                'city' => 'Lac Du Flambeau',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54702',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8133000',
                'longitude' => '-91.4981000',
                'city' => 'Eau Claire',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54836',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5414000',
                'longitude' => '-92.1150000',
                'city' => 'Foxboro',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54759',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4415000',
                'longitude' => '-92.1505000',
                'city' => 'Pepin',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54848',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4664000',
                'longitude' => '-91.0968000',
                'city' => 'Ladysmith',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54888',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.8241000',
                'longitude' => '-91.8959000',
                'city' => 'Trego',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54829',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5328000',
                'longitude' => '-92.0197000',
                'city' => 'Cumberland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54490',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3247000',
                'longitude' => '-90.2014000',
                'city' => 'Westboro',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54470',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3247000',
                'longitude' => '-90.2014000',
                'city' => 'Rib Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54443',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4971000',
                'longitude' => '-89.8115000',
                'city' => 'Junction City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54489',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4971000',
                'longitude' => '-89.8115000',
                'city' => 'Vesper',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54454',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4971000',
                'longitude' => '-89.8115000',
                'city' => 'Milladore',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54475',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4971000',
                'longitude' => '-89.8115000',
                'city' => 'Rudolph',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54769',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4415000',
                'longitude' => '-92.1505000',
                'city' => 'Stockholm',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54150',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9848000',
                'longitude' => '-88.8178000',
                'city' => 'Neopit',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54977',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4986000',
                'longitude' => '-89.1203000',
                'city' => 'Scandinavia',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54962',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4986000',
                'longitude' => '-89.1203000',
                'city' => 'Ogdensburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54945',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4986000',
                'longitude' => '-89.1203000',
                'city' => 'Iola',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54440',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8818000',
                'longitude' => '-89.3435000',
                'city' => 'Hatley',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54408',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8818000',
                'longitude' => '-89.3435000',
                'city' => 'Aniwa',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54473',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8818000',
                'longitude' => '-89.3435000',
                'city' => 'Rosholt',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54471',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8818000',
                'longitude' => '-89.3435000',
                'city' => 'Ringle',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54447',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1672000',
                'longitude' => '-90.8118000',
                'city' => 'Lublin',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54750',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5624000',
                'longitude' => '-92.3121000',
                'city' => 'Maiden Rock',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54416',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9300000',
                'longitude' => '-89.2066000',
                'city' => 'Bowler',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54731',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3189000',
                'longitude' => '-90.9526000',
                'city' => 'Conrath',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54429',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7842000',
                'longitude' => '-89.2327000',
                'city' => 'Elderon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54763',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2380000',
                'longitude' => '-91.9796000',
                'city' => 'Ridgeland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54762',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2380000',
                'longitude' => '-91.9796000',
                'city' => 'Prairie Farm',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54733',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2380000',
                'longitude' => '-91.9796000',
                'city' => 'Dallas',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54725',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.2380000',
                'longitude' => '-91.9796000',
                'city' => 'Boyceville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54828',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0973000',
                'longitude' => '-91.1975000',
                'city' => 'Couderay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54451',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1531000',
                'longitude' => '-90.3450000',
                'city' => 'Medford',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54875',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0977000',
                'longitude' => '-91.8252000',
                'city' => 'Springbrook',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54859',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0977000',
                'longitude' => '-91.8252000',
                'city' => 'Minong',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54813',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.7513000',
                'longitude' => '-91.9233000',
                'city' => 'Barronett',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54871',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.7513000',
                'longitude' => '-91.9233000',
                'city' => 'Shell Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54566',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4372000',
                'longitude' => '-88.6594000',
                'city' => 'Wabeno',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54515',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5319000',
                'longitude' => '-90.5859000',
                'city' => 'Catawba',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54547',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1688000',
                'longitude' => '-90.0571000',
                'city' => 'Mercer',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54558',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.9168000',
                'longitude' => '-89.2466000',
                'city' => 'Saint Germain',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54519',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.9168000',
                'longitude' => '-89.2466000',
                'city' => 'Conover',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54562',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.9168000',
                'longitude' => '-89.2466000',
                'city' => 'Three Lakes',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54511',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5676000',
                'longitude' => '-88.8989000',
                'city' => 'Argonne',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54520',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5676000',
                'longitude' => '-88.8989000',
                'city' => 'Crandon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54024',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4090000',
                'longitude' => '-92.6492000',
                'city' => 'Saint Croix Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54462',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3674000',
                'longitude' => '-88.9090000',
                'city' => 'Pearson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54465',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3674000',
                'longitude' => '-88.9090000',
                'city' => 'Pickerel',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54824',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4439000',
                'longitude' => '-92.4601000',
                'city' => 'Centuria',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54006',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6923000',
                'longitude' => '-92.6416000',
                'city' => 'Cushing',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54464',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0052000',
                'longitude' => '-89.0429000',
                'city' => 'Phlox',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54450',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0052000',
                'longitude' => '-89.0429000',
                'city' => 'Mattoon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54107',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7311000',
                'longitude' => '-88.4443000',
                'city' => 'Bonduel',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54771',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9670000',
                'longitude' => '-90.7987000',
                'city' => 'Thorp',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54552',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.9330000',
                'longitude' => '-90.4489000',
                'city' => 'Park Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54773',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3673000',
                'longitude' => '-91.3214000',
                'city' => 'Whitehall',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54560',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.9883000',
                'longitude' => '-89.5330000',
                'city' => 'Sayner',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54561',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.9883000',
                'longitude' => '-89.5330000',
                'city' => 'Star Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54545',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.1150000',
                'longitude' => '-89.8310000',
                'city' => 'Manitowish Waters',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54542',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0663000',
                'longitude' => '-89.0844000',
                'city' => 'Long Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54554',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0663000',
                'longitude' => '-89.0844000',
                'city' => 'Phelps',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54720',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8133000',
                'longitude' => '-91.4981000',
                'city' => 'Altoona',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54867',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0156000',
                'longitude' => '-91.4878000',
                'city' => 'Radisson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54876',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.0156000',
                'longitude' => '-91.4878000',
                'city' => 'Stone Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54536',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4495000',
                'longitude' => '-90.1790000',
                'city' => 'Iron Belt',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54565',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4495000',
                'longitude' => '-90.1790000',
                'city' => 'Upson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54525',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4495000',
                'longitude' => '-90.1790000',
                'city' => 'Gile',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54550',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.4495000',
                'longitude' => '-90.1790000',
                'city' => 'Montreal',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54513',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5478000',
                'longitude' => '-90.1014000',
                'city' => 'Brantwood',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54459',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5478000',
                'longitude' => '-90.1014000',
                'city' => 'Ogema',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54564',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5478000',
                'longitude' => '-90.1014000',
                'city' => 'Tripoli',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54410',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4807000',
                'longitude' => '-89.9664000',
                'city' => 'Arpin',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54839',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.2017000',
                'longitude' => '-91.0660000',
                'city' => 'Grand View',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54517',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.2017000',
                'longitude' => '-91.0660000',
                'city' => 'Clam Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54112',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0511000',
                'longitude' => '-87.7533000',
                'city' => 'Coleman',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54758',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5852000',
                'longitude' => '-91.2237000',
                'city' => 'Osseo',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54177',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0982000',
                'longitude' => '-87.6288000',
                'city' => 'Wausaukee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54407',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5683000',
                'longitude' => '-89.4089000',
                'city' => 'Amherst Junction',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54423',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5683000',
                'longitude' => '-89.4089000',
                'city' => 'Custer',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54014',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5843000',
                'longitude' => '-92.4535000',
                'city' => 'Hager City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54723',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5843000',
                'longitude' => '-92.4535000',
                'city' => 'Bay City',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54541',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5651000',
                'longitude' => '-88.6676000',
                'city' => 'Laona',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54418',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1402000',
                'longitude' => '-89.1556000',
                'city' => 'Bryant',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54772',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0449000',
                'longitude' => '-91.9077000',
                'city' => 'Wheeler',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '55808',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.6696000',
                'longitude' => '-92.2259000',
                'city' => 'Duluth',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54767',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7784000',
                'longitude' => '-92.1494000',
                'city' => 'Spring Valley',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54415',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6355000',
                'longitude' => '-89.9943000',
                'city' => 'Blenker',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54480',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0106000',
                'longitude' => '-90.3363000',
                'city' => 'Stetsonville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54425',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0106000',
                'longitude' => '-90.3363000',
                'city' => 'Dorchester',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54765',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1702000',
                'longitude' => '-91.6877000',
                'city' => 'Sand Creek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54735',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7780000',
                'longitude' => '-91.9362000',
                'city' => 'Downsville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54739',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7780000',
                'longitude' => '-91.9362000',
                'city' => 'Elk Mound',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54749',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9531000',
                'longitude' => '-92.0912000',
                'city' => 'Knapp',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54434',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3511000',
                'longitude' => '-90.7929000',
                'city' => 'Jump River',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54439',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3511000',
                'longitude' => '-90.7929000',
                'city' => 'Hannibal',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54611',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2995000',
                'longitude' => '-90.8631000',
                'city' => 'Alma Center',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54861',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5914000',
                'longitude' => '-90.8798000',
                'city' => 'Odanah',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54028',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9663000',
                'longitude' => '-92.3748000',
                'city' => 'Woodville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54002',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9663000',
                'longitude' => '-92.3748000',
                'city' => 'Baldwin',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54559',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5914000',
                'longitude' => '-90.8798000',
                'city' => 'Saxon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54770',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4501000',
                'longitude' => '-91.3085000',
                'city' => 'Strum',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54027',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9577000',
                'longitude' => '-92.2878000',
                'city' => 'Wilson',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54159',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0917000',
                'longitude' => '-87.6118000',
                'city' => 'Porterfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54832',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.3341000',
                'longitude' => '-91.2597000',
                'city' => 'Drummond',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54821',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.3341000',
                'longitude' => '-91.2597000',
                'city' => 'Cable',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54844',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.8518000',
                'longitude' => '-91.1016000',
                'city' => 'Herbster',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54827',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.8518000',
                'longitude' => '-91.1016000',
                'city' => 'Cornucopia',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54124',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8076000',
                'longitude' => '-88.4512000',
                'city' => 'Gillett',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54111',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8076000',
                'longitude' => '-88.4512000',
                'city' => 'Cecil',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54154',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8076000',
                'longitude' => '-88.4512000',
                'city' => 'Oconto Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54127',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8076000',
                'longitude' => '-88.4512000',
                'city' => 'Green Valley',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54816',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.5031000',
                'longitude' => '-91.0751000',
                'city' => 'Benoit',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54850',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.7835000',
                'longitude' => '-90.7939000',
                'city' => 'La Pointe',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54023',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9830000',
                'longitude' => '-92.5632000',
                'city' => 'Roberts',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54170',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5344000',
                'longitude' => '-88.7257000',
                'city' => 'Shiocton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54922',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5344000',
                'longitude' => '-88.7257000',
                'city' => 'Bear Creek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54961',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5344000',
                'longitude' => '-88.7257000',
                'city' => 'New London',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54928',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6655000',
                'longitude' => '-88.8842000',
                'city' => 'Caroline',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54926',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6655000',
                'longitude' => '-88.8842000',
                'city' => 'Big Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54950',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6655000',
                'longitude' => '-88.8842000',
                'city' => 'Marion',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54104',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3245000',
                'longitude' => '-88.2003000',
                'city' => 'Athelstane',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54162',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7311000',
                'longitude' => '-88.4443000',
                'city' => 'Pulaski',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54182',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7311000',
                'longitude' => '-88.4443000',
                'city' => 'Zachow',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54102',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5027000',
                'longitude' => '-87.9917000',
                'city' => 'Amberg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54524',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.9351000',
                'longitude' => '-90.4548000',
                'city' => 'Fifield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54865',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '46.7768000',
                'longitude' => '-91.3851000',
                'city' => 'Port Wing',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54948',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8483000',
                'longitude' => '-88.7869000',
                'city' => 'Leopolis',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54978',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8483000',
                'longitude' => '-88.7869000',
                'city' => 'Tilleda',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54128',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8483000',
                'longitude' => '-88.7869000',
                'city' => 'Gresham',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54161',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1142000',
                'longitude' => '-87.8229000',
                'city' => 'Pound',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54015',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.9754000',
                'longitude' => '-92.4329000',
                'city' => 'Hammond',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54135',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8860000',
                'longitude' => '-88.6356000',
                'city' => 'Keshena',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54933',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6252000',
                'longitude' => '-88.7615000',
                'city' => 'Embarrass',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54458',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4501000',
                'longitude' => '-89.2846000',
                'city' => 'Nelsonville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54858',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.5340000',
                'longitude' => '-92.5013000',
                'city' => 'Milltown',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54303',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5083000',
                'longitude' => '-88.0049000',
                'city' => 'Green Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54301',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5083000',
                'longitude' => '-88.0049000',
                'city' => 'Green Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54819',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.4688000',
                'longitude' => '-91.2688000',
                'city' => 'Bruce',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54764',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7157000',
                'longitude' => '-91.6928000',
                'city' => 'Rock Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54430',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1576000',
                'longitude' => '-88.7636000',
                'city' => 'Elton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54413',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4351000',
                'longitude' => '-90.1271000',
                'city' => 'Babcock',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54469',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3444000',
                'longitude' => '-89.8614000',
                'city' => 'Port Edwards',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54835',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.6736000',
                'longitude' => '-91.2368000',
                'city' => 'Exeland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54743',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4700000',
                'longitude' => '-91.6785000',
                'city' => 'Gilmanton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54760',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4264000',
                'longitude' => '-91.2108000',
                'city' => 'Pigeon Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54915',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2563000',
                'longitude' => '-88.4018000',
                'city' => 'Appleton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54911',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2563000',
                'longitude' => '-88.4018000',
                'city' => 'Appleton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54902',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0145000',
                'longitude' => '-88.5349000',
                'city' => 'Oshkosh',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54937',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7741000',
                'longitude' => '-88.4510000',
                'city' => 'Fond Du Lac',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54913',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2550000',
                'longitude' => '-88.4676000',
                'city' => 'Appleton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53098',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1931000',
                'longitude' => '-88.7184000',
                'city' => 'Watertown',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53094',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1931000',
                'longitude' => '-88.7184000',
                'city' => 'Watertown',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53083',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7604000',
                'longitude' => '-87.7078000',
                'city' => 'Sheboygan',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53044',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7523000',
                'longitude' => '-87.7137000',
                'city' => 'Kohler',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53081',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7523000',
                'longitude' => '-87.7137000',
                'city' => 'Sheboygan',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53963',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4583000',
                'longitude' => '-88.8278000',
                'city' => 'Waupun',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53916',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4583000',
                'longitude' => '-88.8278000',
                'city' => 'Beaver Dam',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53032',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4583000',
                'longitude' => '-88.8278000',
                'city' => 'Horicon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53594',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4583000',
                'longitude' => '-88.8278000',
                'city' => 'Waterloo',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53050',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4987000',
                'longitude' => '-88.5493000',
                'city' => 'Mayville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54956',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1868000',
                'longitude' => '-88.4526000',
                'city' => 'Neenah',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54220',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1000000',
                'longitude' => '-87.6513000',
                'city' => 'Manitowoc',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53038',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0842000',
                'longitude' => '-88.7742000',
                'city' => 'Johnson Creek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53551',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.0833000',
                'longitude' => '-88.9088000',
                'city' => 'Lake Mills',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54136',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2646000',
                'longitude' => '-88.4101000',
                'city' => 'Kimberly',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54914',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2646000',
                'longitude' => '-88.4101000',
                'city' => 'Appleton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54165',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5150000',
                'longitude' => '-88.3280000',
                'city' => 'Seymour',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54941',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8411000',
                'longitude' => '-88.9598000',
                'city' => 'Green Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54901',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0207000',
                'longitude' => '-88.5376000',
                'city' => 'Oshkosh',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54982',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0765000',
                'longitude' => '-89.2851000',
                'city' => 'Wautoma',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54115',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4409000',
                'longitude' => '-88.0487000',
                'city' => 'De Pere',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54245',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1000000',
                'longitude' => '-87.6513000',
                'city' => 'Valders',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54949',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4485000',
                'longitude' => '-89.0267000',
                'city' => 'Manawa',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54216',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4501000',
                'longitude' => '-87.5122000',
                'city' => 'Kewaunee',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54235',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8350000',
                'longitude' => '-87.3670000',
                'city' => 'Sturgeon Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54965',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0145000',
                'longitude' => '-88.5349000',
                'city' => 'Pine River',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53946',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7071000',
                'longitude' => '-88.9909000',
                'city' => 'Markesan',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54313',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5083000',
                'longitude' => '-88.0049000',
                'city' => 'Green Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53006',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5883000',
                'longitude' => '-88.4423000',
                'city' => 'Brownsville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53065',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5883000',
                'longitude' => '-88.4423000',
                'city' => 'Oakfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53048',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5883000',
                'longitude' => '-88.4423000',
                'city' => 'Lomira',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54302',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5335000',
                'longitude' => '-88.0294000',
                'city' => 'Green Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54304',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5335000',
                'longitude' => '-88.0294000',
                'city' => 'Green Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53042',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9168000',
                'longitude' => '-88.0316000',
                'city' => 'Kiel',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54964',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9072000',
                'longitude' => '-88.7340000',
                'city' => 'Pickett',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54923',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9648000',
                'longitude' => '-88.9429000',
                'city' => 'Berlin',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54968',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8505000',
                'longitude' => '-89.1242000',
                'city' => 'Princeton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54960',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9625000',
                'longitude' => '-89.2159000',
                'city' => 'Neshkoro',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54140',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2836000',
                'longitude' => '-88.3103000',
                'city' => 'Little Chute',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54986',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Winneconne',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54180',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Wrightstown',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54979',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8820000',
                'longitude' => '-88.5017000',
                'city' => 'Van Dyne',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53070',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6176000',
                'longitude' => '-87.7978000',
                'city' => 'Oostburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54935',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7741000',
                'longitude' => '-88.4510000',
                'city' => 'Fond Du Lac',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53956',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5423000',
                'longitude' => '-89.0094000',
                'city' => 'Randolph',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53919',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7343000',
                'longitude' => '-88.7864000',
                'city' => 'Brandon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54311',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4471000',
                'longitude' => '-88.0513000',
                'city' => 'Green Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53014',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0323000',
                'longitude' => '-88.1697000',
                'city' => 'Chilton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53034',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3169000',
                'longitude' => '-88.7155000',
                'city' => 'Hustisford',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53039',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3169000',
                'longitude' => '-88.7155000',
                'city' => 'Juneau',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53931',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7343000',
                'longitude' => '-88.7864000',
                'city' => 'Fairwater',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53935',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.5430000',
                'longitude' => '-89.1082000',
                'city' => 'Friesland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53035',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3467000',
                'longitude' => '-88.6022000',
                'city' => 'Iron Ridge',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53925',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3318000',
                'longitude' => '-89.0162000',
                'city' => 'Columbus',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54202',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0667000',
                'longitude' => '-87.1230000',
                'city' => 'Baileys Harbor',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54201',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6015000',
                'longitude' => '-87.4424000',
                'city' => 'Algoma',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54227',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5083000',
                'longitude' => '-88.0049000',
                'city' => 'Maribel',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54208',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3485000',
                'longitude' => '-87.8358000',
                'city' => 'Denmark',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54130',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2830000',
                'longitude' => '-88.2674000',
                'city' => 'Kaukauna',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53933',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7604000',
                'longitude' => '-87.7078000',
                'city' => 'Fox Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54952',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2646000',
                'longitude' => '-88.4101000',
                'city' => 'Menasha',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53939',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6957000',
                'longitude' => '-89.1270000',
                'city' => 'Kingston',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53947',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6957000',
                'longitude' => '-89.1270000',
                'city' => 'Marquette',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53926',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6957000',
                'longitude' => '-89.1270000',
                'city' => 'Dalton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54983',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3176000',
                'longitude' => '-88.9265000',
                'city' => 'Weyauwega',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54155',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5214000',
                'longitude' => '-88.0546000',
                'city' => 'Oneida',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54173',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5962000',
                'longitude' => '-88.0863000',
                'city' => 'Suamico',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54129',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0775000',
                'longitude' => '-88.3021000',
                'city' => 'Hilbert',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53088',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0775000',
                'longitude' => '-88.3021000',
                'city' => 'Stockbridge',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54230',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1609000',
                'longitude' => '-87.9588000',
                'city' => 'Reedsville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54940',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2593000',
                'longitude' => '-88.8678000',
                'city' => 'Fremont',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53073',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7509000',
                'longitude' => '-87.9812000',
                'city' => 'Plymouth',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53085',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7269000',
                'longitude' => '-87.7965000',
                'city' => 'Sheboygan Falls',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53003',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2089000',
                'longitude' => '-88.4597000',
                'city' => 'Ashippun',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53079',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6946000',
                'longitude' => '-88.3655000',
                'city' => 'Saint Cloud',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53019',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6946000',
                'longitude' => '-88.3655000',
                'city' => 'Eden',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53579',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.1830000',
                'longitude' => '-88.9938000',
                'city' => 'Reeseville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53932',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3816000',
                'longitude' => '-89.0519000',
                'city' => 'Fall River',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53922',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4523000',
                'longitude' => '-88.6334000',
                'city' => 'Burnett',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53057',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6769000',
                'longitude' => '-88.2435000',
                'city' => 'Mount Calvary',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54169',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1760000',
                'longitude' => '-88.2587000',
                'city' => 'Sherwood',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54153',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Oconto',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54101',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8757000',
                'longitude' => '-88.1334000',
                'city' => 'Abrams',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54139',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8757000',
                'longitude' => '-88.1334000',
                'city' => 'Lena',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54106',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.4670000',
                'longitude' => '-88.4502000',
                'city' => 'Black Creek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53011',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6586000',
                'longitude' => '-88.0131000',
                'city' => 'Cascade',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54110',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1831000',
                'longitude' => '-88.0573000',
                'city' => 'Brillion',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54152',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5662000',
                'longitude' => '-88.4642000',
                'city' => 'Nichols',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53026',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7752000',
                'longitude' => '-88.0853000',
                'city' => 'Greenbush',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53023',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7752000',
                'longitude' => '-88.0853000',
                'city' => 'Glenbeulah',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53093',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.6665000',
                'longitude' => '-87.9930000',
                'city' => 'Waldo',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54126',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3271000',
                'longitude' => '-88.1604000',
                'city' => 'Greenleaf',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54246',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.3590000',
                'longitude' => '-86.9264000',
                'city' => 'Washington Island',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54217',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5343000',
                'longitude' => '-87.7036000',
                'city' => 'Luxemburg',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54936',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7741000',
                'longitude' => '-88.4510000',
                'city' => 'Fond Du Lac',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54241',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1559000',
                'longitude' => '-87.5664000',
                'city' => 'Two Rivers',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53015',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8346000',
                'longitude' => '-87.8178000',
                'city' => 'Cleveland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53020',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8346000',
                'longitude' => '-87.8178000',
                'city' => 'Elkhart Lake',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54970',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0423000',
                'longitude' => '-89.0949000',
                'city' => 'Redgranite',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54963',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1134000',
                'longitude' => '-88.7145000',
                'city' => 'Omro',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54927',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1134000',
                'longitude' => '-88.7145000',
                'city' => 'Butte Des Morts',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54971',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9113000',
                'longitude' => '-88.7310000',
                'city' => 'Ripon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54947',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1992000',
                'longitude' => '-88.6238000',
                'city' => 'Larsen',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54171',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5083000',
                'longitude' => '-88.0049000',
                'city' => 'Sobieski',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54976',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1774000',
                'longitude' => '-89.2492000',
                'city' => 'Saxeville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53099',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3086000',
                'longitude' => '-88.5160000',
                'city' => 'Woodland',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54228',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2419000',
                'longitude' => '-87.6515000',
                'city' => 'Mishicot',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54969',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2750000',
                'longitude' => '-88.7703000',
                'city' => 'Readfield',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54931',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2750000',
                'longitude' => '-88.7703000',
                'city' => 'Dale',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53049',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8856000',
                'longitude' => '-88.2915000',
                'city' => 'Malone',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54221',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1000000',
                'longitude' => '-87.6513000',
                'city' => 'Manitowoc',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54980',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0353000',
                'longitude' => '-88.7421000',
                'city' => 'Waukau',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54934',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0353000',
                'longitude' => '-88.7421000',
                'city' => 'Eureka',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54113',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.2754000',
                'longitude' => '-88.3163000',
                'city' => 'Combined Locks',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53063',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9180000',
                'longitude' => '-87.7497000',
                'city' => 'Newton',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53016',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3108000',
                'longitude' => '-88.7269000',
                'city' => 'Clyman',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54944',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3333000',
                'longitude' => '-88.6340000',
                'city' => 'Hortonville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54215',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1443000',
                'longitude' => '-87.8346000',
                'city' => 'Kellnersville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54247',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1443000',
                'longitude' => '-87.8346000',
                'city' => 'Whitelaw',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54209',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8331000',
                'longitude' => '-87.3757000',
                'city' => 'Egg Harbor',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54942',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3012000',
                'longitude' => '-88.5348000',
                'city' => 'Greenville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54967',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5850000',
                'longitude' => '-88.1665000',
                'city' => 'Poy Sippi',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54207',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0911000',
                'longitude' => '-87.9811000',
                'city' => 'Collins',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54232',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.0096000',
                'longitude' => '-87.9188000',
                'city' => 'Saint Nazianz',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54240',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.3266000',
                'longitude' => '-87.6270000',
                'city' => 'Tisch Mills',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54204',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.8165000',
                'longitude' => '-87.5647000',
                'city' => 'Brussels',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54213',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7267000',
                'longitude' => '-87.6175000',
                'city' => 'Forestville',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54141',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7754000',
                'longitude' => '-88.0475000',
                'city' => 'Little Suamico',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53061',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.9570000',
                'longitude' => '-88.0956000',
                'city' => 'New Holstein',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54205',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5494000',
                'longitude' => '-87.6203000',
                'city' => 'Casco',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54234',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0627000',
                'longitude' => '-87.1261000',
                'city' => 'Sister Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54212',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.0627000',
                'longitude' => '-87.1261000',
                'city' => 'Fish Creek',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54974',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8076000',
                'longitude' => '-88.6769000',
                'city' => 'Rosendale',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54160',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1351000',
                'longitude' => '-88.1670000',
                'city' => 'Potter',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54210',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1782000',
                'longitude' => '-87.1256000',
                'city' => 'Ellison Bay',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54211',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '45.1782000',
                'longitude' => '-87.1256000',
                'city' => 'Ephraim',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54226',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.6827000',
                'longitude' => '-87.4759000',
                'city' => 'Maplewood',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54229',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.5610000',
                'longitude' => '-87.8297000',
                'city' => 'New Franken',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54932',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.8076000',
                'longitude' => '-88.6769000',
                'city' => 'Eldorado',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53082',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.7604000',
                'longitude' => '-87.7078000',
                'city' => 'Sheboygan',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54137',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.7596000',
                'longitude' => '-88.2553000',
                'city' => 'Krakow',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53047',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.2582000',
                'longitude' => '-88.6298000',
                'city' => 'Lebanon',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53557',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.3077000',
                'longitude' => '-88.8423000',
                'city' => 'Lowell',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '54123',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '44.1760000',
                'longitude' => '-88.2587000',
                'city' => 'Forest Junction',
                'full_state' => 'Wisconsin',
            ],
            [
                'zip' => '53928',
                'country_code' => 'US',
                'state' => 'WI',
                'latitude' => '43.4509000',
                'longitude' => '-89.2367000',
                'city' => 'Doylestown',
                'full_state' => 'Wisconsin',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
