<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WestVirginiaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '25202',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3836000',
                'longitude' => '-81.8364000',
                'city' => 'Tornado',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25143',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3836000',
                'longitude' => '-81.8364000',
                'city' => 'Nitro',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26554',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2740000',
                'longitude' => '-80.3434000',
                'city' => 'Fairmont',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25159',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4254000',
                'longitude' => '-81.8449000',
                'city' => 'Poca',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25177',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4254000',
                'longitude' => '-81.8449000',
                'city' => 'Saint Albans',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25301',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25305',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3520000',
                'longitude' => '-81.6266000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25387',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3520000',
                'longitude' => '-81.6266000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25704',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4151000',
                'longitude' => '-82.4416000',
                'city' => 'Huntington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25703',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4151000',
                'longitude' => '-82.4416000',
                'city' => 'Huntington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26726',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4444000',
                'longitude' => '-78.9755000',
                'city' => 'Keyser',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26133',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2654000',
                'longitude' => '-81.5595000',
                'city' => 'Belleville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26104',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2654000',
                'longitude' => '-81.5595000',
                'city' => 'Parkersburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26501',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6334000',
                'longitude' => '-79.9581000',
                'city' => 'Morgantown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26505',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6334000',
                'longitude' => '-79.9581000',
                'city' => 'Morgantown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25526',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4509000',
                'longitude' => '-80.2603000',
                'city' => 'Hurricane',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26003',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.0590000',
                'longitude' => '-80.7222000',
                'city' => 'Wheeling',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26040',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.0590000',
                'longitude' => '-80.7222000',
                'city' => 'Mcmechen',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26031',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.0590000',
                'longitude' => '-80.7222000',
                'city' => 'Benwood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26060',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.1643000',
                'longitude' => '-80.5919000',
                'city' => 'Valley Grove',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26059',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.1643000',
                'longitude' => '-80.5919000',
                'city' => 'Triadelphia',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25315',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2345000',
                'longitude' => '-81.5405000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26038',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.9152000',
                'longitude' => '-80.7508000',
                'city' => 'Glen Dale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25801',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Beckley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26062',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.4177000',
                'longitude' => '-80.5864000',
                'city' => 'Weirton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26266',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4083000',
                'longitude' => '-80.5619000',
                'city' => 'Upperglade',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26203',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4083000',
                'longitude' => '-80.5619000',
                'city' => 'Erbacon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26452',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4083000',
                'longitude' => '-80.5619000',
                'city' => 'Weston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26206',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4083000',
                'longitude' => '-80.5619000',
                'city' => 'Cowen',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26208',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4083000',
                'longitude' => '-80.5619000',
                'city' => 'Camden On Gauley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26296',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9235000',
                'longitude' => '-79.5246000',
                'city' => 'Whitmer',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26263',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9235000',
                'longitude' => '-79.5246000',
                'city' => 'Dryfork',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26270',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9235000',
                'longitude' => '-79.5246000',
                'city' => 'Harman',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25421',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3592000',
                'longitude' => '-78.0431000',
                'city' => 'Glengary',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25428',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3592000',
                'longitude' => '-78.0431000',
                'city' => 'Inwood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25427',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3592000',
                'longitude' => '-78.0431000',
                'city' => 'Hedgesville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25420',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3592000',
                'longitude' => '-78.0431000',
                'city' => 'Gerrardstown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25413',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3592000',
                'longitude' => '-78.0431000',
                'city' => 'Bunker Hill',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25401',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3592000',
                'longitude' => '-78.0431000',
                'city' => 'Martinsburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25665',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6744000',
                'longitude' => '-82.2750000',
                'city' => 'Borderland',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25661',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6744000',
                'longitude' => '-82.2750000',
                'city' => 'Williamson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25685',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6744000',
                'longitude' => '-82.2750000',
                'city' => 'Naugatuck',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25601',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6744000',
                'longitude' => '-82.2750000',
                'city' => 'Logan',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25667',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6744000',
                'longitude' => '-82.2750000',
                'city' => 'Chattaroy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25691',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6744000',
                'longitude' => '-82.2750000',
                'city' => 'Rawl',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25625',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6744000',
                'longitude' => '-82.2750000',
                'city' => 'Holden',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25678',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Matewan',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26041',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.0548000',
                'longitude' => '-80.6690000',
                'city' => 'Moundsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25652',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8322000',
                'longitude' => '-82.0449000',
                'city' => 'Whitman',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25614',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8322000',
                'longitude' => '-82.0449000',
                'city' => 'Cora',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25130',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8322000',
                'longitude' => '-82.0449000',
                'city' => 'Madison',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25637',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8322000',
                'longitude' => '-82.0449000',
                'city' => 'Mount Gay',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25204',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Twilight',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25093',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Gordon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25181',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Seth',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25206',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Van',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25028',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Bob White',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25411',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6254000',
                'longitude' => '-78.2252000',
                'city' => 'Berkeley Springs',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25021',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Bim',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25208',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Wharton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24724',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3225000',
                'longitude' => '-81.3121000',
                'city' => 'Freeman',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24715',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3225000',
                'longitude' => '-81.3121000',
                'city' => 'Bramwell',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24738',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3225000',
                'longitude' => '-81.3121000',
                'city' => 'Nemours',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24751',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3225000',
                'longitude' => '-81.3121000',
                'city' => 'Wolfe',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24701',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3225000',
                'longitude' => '-81.3121000',
                'city' => 'Bluefield',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26815',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6279000',
                'longitude' => '-79.2456000',
                'city' => 'Sugar Grove',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26807',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6279000',
                'longitude' => '-79.2456000',
                'city' => 'Franklin',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26802',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6279000',
                'longitude' => '-79.2456000',
                'city' => 'Brandywine',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25880',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Mount Hope',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25832',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Daniels',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25827',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Crab Orchard',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25813',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Beaver',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25909',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Prosperity',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25871',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Mabscott',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25873',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7764000',
                'longitude' => '-81.1899000',
                'city' => 'Mac Arthur',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26855',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9947000',
                'longitude' => '-79.1265000',
                'city' => 'Cabins',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26847',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9947000',
                'longitude' => '-79.1265000',
                'city' => 'Petersburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25422',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6318000',
                'longitude' => '-78.2268000',
                'city' => 'Great Cacapon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26260',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1287000',
                'longitude' => '-79.4650000',
                'city' => 'Davis',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25430',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4565000',
                'longitude' => '-77.9647000',
                'city' => 'Kearneysville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26440',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3382000',
                'longitude' => '-80.0228000',
                'city' => 'Thornton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26354',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3382000',
                'longitude' => '-80.0228000',
                'city' => 'Grafton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26378',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0364000',
                'longitude' => '-80.4685000',
                'city' => 'Jane Lew',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26321',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0364000',
                'longitude' => '-80.4685000',
                'city' => 'Alum Bridge',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26338',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0364000',
                'longitude' => '-80.4685000',
                'city' => 'Camden',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26372',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0364000',
                'longitude' => '-80.4685000',
                'city' => 'Horner',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25443',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5603000',
                'longitude' => '-77.9306000',
                'city' => 'Shepherdstown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25419',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5603000',
                'longitude' => '-77.9306000',
                'city' => 'Falling Waters',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25402',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5603000',
                'longitude' => '-77.9306000',
                'city' => 'Martinsburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25514',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2234000',
                'longitude' => '-82.4455000',
                'city' => 'Fort Gay',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25570',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2234000',
                'longitude' => '-82.4455000',
                'city' => 'Wayne',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25517',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2234000',
                'longitude' => '-82.4455000',
                'city' => 'Genoa',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25275',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9475000',
                'longitude' => '-81.7637000',
                'city' => 'Sandyville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25262',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9475000',
                'longitude' => '-81.7637000',
                'city' => 'Millwood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26164',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9475000',
                'longitude' => '-81.7637000',
                'city' => 'Ravenswood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26160',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0618000',
                'longitude' => '-81.3956000',
                'city' => 'Palestine',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26141',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0618000',
                'longitude' => '-81.3956000',
                'city' => 'Creston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25252',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0618000',
                'longitude' => '-81.3956000',
                'city' => 'Le Roy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26143',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0618000',
                'longitude' => '-81.3956000',
                'city' => 'Elizabeth',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26588',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5304000',
                'longitude' => '-80.1237000',
                'city' => 'Rivesville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26301',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5304000',
                'longitude' => '-80.1237000',
                'city' => 'Clarksburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26560',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5304000',
                'longitude' => '-80.1237000',
                'city' => 'Baxter',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26574',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5304000',
                'longitude' => '-80.1237000',
                'city' => 'Grant Town',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26070',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.0590000',
                'longitude' => '-80.7222000',
                'city' => 'Wellsburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26037',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5603000',
                'longitude' => '-77.9306000',
                'city' => 'Follansbee',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26508',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6334000',
                'longitude' => '-79.9581000',
                'city' => 'Morgantown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26502',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6549000',
                'longitude' => '-79.9683000',
                'city' => 'Morgantown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25063',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5313000',
                'longitude' => '-81.0301000',
                'city' => 'Duck',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25141',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5313000',
                'longitude' => '-81.0301000',
                'city' => 'Nebo',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25235',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5313000',
                'longitude' => '-81.0301000',
                'city' => 'Chloe',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25043',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5313000',
                'longitude' => '-81.0301000',
                'city' => 'Clay',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25113',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5313000',
                'longitude' => '-81.0301000',
                'city' => 'Ivydale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26591',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4509000',
                'longitude' => '-80.2603000',
                'city' => 'Worthington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26576',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4509000',
                'longitude' => '-80.2603000',
                'city' => 'Idamay',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26563',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4509000',
                'longitude' => '-80.2603000',
                'city' => 'Carolina',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26572',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4509000',
                'longitude' => '-80.2603000',
                'city' => 'Four States',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26571',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4509000',
                'longitude' => '-80.2603000',
                'city' => 'Farmington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26852',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3340000',
                'longitude' => '-78.9209000',
                'city' => 'Purgitsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26743',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3340000',
                'longitude' => '-78.9209000',
                'city' => 'New Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26710',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3340000',
                'longitude' => '-78.9209000',
                'city' => 'Burlington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26506',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6549000',
                'longitude' => '-79.9683000',
                'city' => 'Morgantown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25875',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Mc Graws',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25882',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Mullens',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25811',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Amigo',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24719',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Covel',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25916',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Sabine',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25870',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Maben',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24867',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'New Richmond',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24726',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Herndon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25617',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Davin',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25928',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Stephenson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25876',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Saulsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25913',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Ravencliff',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24847',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Itmann',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24716',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Bud',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25848',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Glen Rogers',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25810',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Allen Junction',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26105',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3243000',
                'longitude' => '-81.5471000',
                'city' => 'Vienna',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26101',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3243000',
                'longitude' => '-81.5471000',
                'city' => 'Parkersburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24801',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3797000',
                'longitude' => '-81.6471000',
                'city' => 'Welch',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26763',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5032000',
                'longitude' => '-78.7682000',
                'city' => 'Springfield',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26719',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5032000',
                'longitude' => '-78.7682000',
                'city' => 'Fort Ashby',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25545',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4095000',
                'longitude' => '-82.2947000',
                'city' => 'Ona',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25705',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4095000',
                'longitude' => '-82.2947000',
                'city' => 'Huntington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26753',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6455000',
                'longitude' => '-78.7665000',
                'city' => 'Ridgeley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26134',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3760000',
                'longitude' => '-81.2615000',
                'city' => 'Belmont',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25567',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2833000',
                'longitude' => '-81.8187000',
                'city' => 'Sumerco',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25951',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6776000',
                'longitude' => '-80.8921000',
                'city' => 'Hinton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25508',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9732000',
                'longitude' => '-82.0248000',
                'city' => 'Chapmanville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26149',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4919000',
                'longitude' => '-80.9084000',
                'city' => 'Middlebourne',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26416',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1585000',
                'longitude' => '-80.0456000',
                'city' => 'Philippi',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26343',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8322000',
                'longitude' => '-80.3424000',
                'city' => 'Crawford',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26228',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8322000',
                'longitude' => '-80.3424000',
                'city' => 'Kanawha Head',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26047',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.4912000',
                'longitude' => '-80.6031000',
                'city' => 'New Cumberland',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26159',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6020000',
                'longitude' => '-80.9448000',
                'city' => 'Paden City',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26425',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3432000',
                'longitude' => '-79.6729000',
                'city' => 'Rowlesburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24740',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.2689000',
                'longitude' => '-81.2251000',
                'city' => 'Princeton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26527',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.7162000',
                'longitude' => '-80.0586000',
                'city' => 'Cassville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26541',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.7162000',
                'longitude' => '-80.0586000',
                'city' => 'Maidsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26519',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4720000',
                'longitude' => '-79.6902000',
                'city' => 'Albright',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26444',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4720000',
                'longitude' => '-79.6902000',
                'city' => 'Tunnelton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26537',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4720000',
                'longitude' => '-79.6902000',
                'city' => 'Kingwood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25302',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26617',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4688000',
                'longitude' => '-80.8591000',
                'city' => 'Dille',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25211',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4688000',
                'longitude' => '-80.8591000',
                'city' => 'Widen',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26348',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4933000',
                'longitude' => '-80.5560000',
                'city' => 'Folsom',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26377',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4933000',
                'longitude' => '-80.5560000',
                'city' => 'Jacksonburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26437',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4933000',
                'longitude' => '-80.5560000',
                'city' => 'Smithfield',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26273',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7331000',
                'longitude' => '-79.9701000',
                'city' => 'Huttonsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26280',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7331000',
                'longitude' => '-79.9701000',
                'city' => 'Mill Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26074',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.1692000',
                'longitude' => '-80.6020000',
                'city' => 'West Liberty',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26032',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.1692000',
                'longitude' => '-80.6020000',
                'city' => 'Bethany',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26155',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6035000',
                'longitude' => '-80.9366000',
                'city' => 'New Martinsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26175',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6035000',
                'longitude' => '-80.9366000',
                'city' => 'Sistersville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26253',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7331000',
                'longitude' => '-79.9701000',
                'city' => 'Beverly',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26259',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7331000',
                'longitude' => '-79.9701000',
                'city' => 'Dailey',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26293',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7331000',
                'longitude' => '-79.9701000',
                'city' => 'Valley Bend',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26278',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7331000',
                'longitude' => '-79.9701000',
                'city' => 'Mabie',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26282',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7331000',
                'longitude' => '-79.9701000',
                'city' => 'Monterville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26294',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7331000',
                'longitude' => '-79.9701000',
                'city' => 'Valley Head',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25311',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25312',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25314',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25112',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Institute',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25361',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25303',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25304',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26327',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0686000',
                'longitude' => '-80.9310000',
                'city' => 'Berea',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26411',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0686000',
                'longitude' => '-80.9310000',
                'city' => 'New Milton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26421',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0686000',
                'longitude' => '-80.9310000',
                'city' => 'Pullman',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26178',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0686000',
                'longitude' => '-80.9310000',
                'city' => 'Smithville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26325',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0686000',
                'longitude' => '-80.9310000',
                'city' => 'Auburn',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26456',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0686000',
                'longitude' => '-80.9310000',
                'city' => 'West Union',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26362',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0686000',
                'longitude' => '-80.9310000',
                'city' => 'Harrisville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26152',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9262000',
                'longitude' => '-81.0946000',
                'city' => 'Munday',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26136',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9262000',
                'longitude' => '-81.0946000',
                'city' => 'Big Bend',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25261',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9262000',
                'longitude' => '-81.0946000',
                'city' => 'Millstone',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26147',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9262000',
                'longitude' => '-81.0946000',
                'city' => 'Grantsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25267',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9262000',
                'longitude' => '-81.0946000',
                'city' => 'Normantown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26151',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9262000',
                'longitude' => '-81.0946000',
                'city' => 'Mount Zion',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26137',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9262000',
                'longitude' => '-81.0946000',
                'city' => 'Big Springs',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26750',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4823000',
                'longitude' => '-79.0498000',
                'city' => 'Piedmont',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25414',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charles Town',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25389',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26866',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6439000',
                'longitude' => '-79.3304000',
                'city' => 'Upper Tract',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25015',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2345000',
                'longitude' => '-81.5405000',
                'city' => 'Belle',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26555',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4330000',
                'longitude' => '-80.1694000',
                'city' => 'Fairmont',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26559',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4843000',
                'longitude' => '-80.1409000',
                'city' => 'Barrackville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26636',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6729000',
                'longitude' => '-80.7779000',
                'city' => 'Rosedale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26623',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6729000',
                'longitude' => '-80.7779000',
                'city' => 'Frametown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26624',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6729000',
                'longitude' => '-80.7779000',
                'city' => 'Gassaway',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25047',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Clothier',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25205',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Uneeda',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25149',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Ottawa',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25203',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Turtle Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25121',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Lake',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25108',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Hewett',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25529',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Julian',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25081',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Foster',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25053',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Danville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25114',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0548000',
                'longitude' => '-81.8256000',
                'city' => 'Jeffrey',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26426',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2934000',
                'longitude' => '-80.5589000',
                'city' => 'Salem',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26431',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4034000',
                'longitude' => '-80.2856000',
                'city' => 'Shinnston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25244',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8138000',
                'longitude' => '-81.7104000',
                'city' => 'Gay',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25241',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8138000',
                'longitude' => '-81.7104000',
                'city' => 'Evans',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25248',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8138000',
                'longitude' => '-81.7104000',
                'city' => 'Kenna',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25239',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8138000',
                'longitude' => '-81.7104000',
                'city' => 'Cottageville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25271',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8138000',
                'longitude' => '-81.7104000',
                'city' => 'Ripley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25245',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8138000',
                'longitude' => '-81.7104000',
                'city' => 'Given',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26187',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.4177000',
                'longitude' => '-80.5864000',
                'city' => 'Williamstown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26525',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6594000',
                'longitude' => '-79.6382000',
                'city' => 'Bruceton Mills',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25309',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24808',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3359000',
                'longitude' => '-81.4373000',
                'city' => 'Anawalt',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24871',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3359000',
                'longitude' => '-81.4373000',
                'city' => 'Pageton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24848',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3359000',
                'longitude' => '-81.4373000',
                'city' => 'Jenkinjones',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25971',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4248000',
                'longitude' => '-81.0155000',
                'city' => 'Lerona',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24712',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4248000',
                'longitude' => '-81.0155000',
                'city' => 'Athens',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25511',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0247000',
                'longitude' => '-82.4344000',
                'city' => 'Dunlow',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26167',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5692000',
                'longitude' => '-80.7327000',
                'city' => 'Reader',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26162',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5692000',
                'longitude' => '-80.7327000',
                'city' => 'Porters Falls',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26034',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.6126000',
                'longitude' => '-80.5725000',
                'city' => 'Chester',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26050',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.6126000',
                'longitude' => '-80.5725000',
                'city' => 'Newell',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25541',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4405000',
                'longitude' => '-82.1342000',
                'city' => 'Milton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24977',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9625000',
                'longitude' => '-80.6919000',
                'city' => 'Smoot',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24910',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9625000',
                'longitude' => '-80.6919000',
                'city' => 'Alderson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24943',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9625000',
                'longitude' => '-80.6919000',
                'city' => 'Grassy Meadows',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25976',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9625000',
                'longitude' => '-80.6919000',
                'city' => 'Meadow Bridge',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24901',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9625000',
                'longitude' => '-80.6919000',
                'city' => 'Lewisburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25984',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9625000',
                'longitude' => '-80.6919000',
                'city' => 'Rupert',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24931',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9625000',
                'longitude' => '-80.6919000',
                'city' => 'Crawley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25674',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8394000',
                'longitude' => '-82.4064000',
                'city' => 'Kermit',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25669',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8394000',
                'longitude' => '-82.4064000',
                'city' => 'Crum',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25666',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8394000',
                'longitude' => '-82.4064000',
                'city' => 'Breeden',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25699',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8394000',
                'longitude' => '-82.4064000',
                'city' => 'Wilsondale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26030',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.2269000',
                'longitude' => '-80.6534000',
                'city' => 'Beech Bottom',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26058',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.2269000',
                'longitude' => '-80.6534000',
                'city' => 'Short Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26075',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.2269000',
                'longitude' => '-80.6534000',
                'city' => 'Windsor Heights',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26601',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6654000',
                'longitude' => '-80.7077000',
                'city' => 'Sutton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26764',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4402000',
                'longitude' => '-79.5400000',
                'city' => 'Terra Alta',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26451',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2107000',
                'longitude' => '-80.4025000',
                'city' => 'West Milford',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25701',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4151000',
                'longitude' => '-82.4416000',
                'city' => 'Huntington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25504',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4151000',
                'longitude' => '-82.4416000',
                'city' => 'Barboursville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26142',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2693000',
                'longitude' => '-81.5564000',
                'city' => 'Davisville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25686',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6245000',
                'longitude' => '-82.1712000',
                'city' => 'Newtown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25672',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6245000',
                'longitude' => '-82.1712000',
                'city' => 'Edgarton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25688',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6245000',
                'longitude' => '-82.1712000',
                'city' => 'North Matewan',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25692',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6245000',
                'longitude' => '-82.1712000',
                'city' => 'Red Jacket',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25696',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6245000',
                'longitude' => '-82.1712000',
                'city' => 'Varney',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25670',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6245000',
                'longitude' => '-82.1712000',
                'city' => 'Delbarton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25530',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3992000',
                'longitude' => '-82.5215000',
                'city' => 'Kenova',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25033',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6076000',
                'longitude' => '-81.9769000',
                'city' => 'Buffalo',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26521',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.7182000',
                'longitude' => '-80.2057000',
                'city' => 'Blacksville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26570',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.7182000',
                'longitude' => '-80.2057000',
                'city' => 'Fairview',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26818',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0441000',
                'longitude' => '-78.7947000',
                'city' => 'Fisher',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26838',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0441000',
                'longitude' => '-78.7947000',
                'city' => 'Milam',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26836',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0441000',
                'longitude' => '-78.7947000',
                'city' => 'Moorefield',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24881',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4332000',
                'longitude' => '-81.5855000',
                'city' => 'Roderfield',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24878',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4332000',
                'longitude' => '-81.5855000',
                'city' => 'Premier',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24842',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4332000',
                'longitude' => '-81.5855000',
                'city' => 'Welch',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25972',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9701000',
                'longitude' => '-80.7616000',
                'city' => 'Leslie',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25962',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9701000',
                'longitude' => '-80.7616000',
                'city' => 'Rainelle',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26679',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9701000',
                'longitude' => '-80.7616000',
                'city' => 'Mount Nebo',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25864',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9701000',
                'longitude' => '-80.7616000',
                'city' => 'Layland',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26680',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9701000',
                'longitude' => '-80.7616000',
                'city' => 'Nallen',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25958',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9701000',
                'longitude' => '-80.7616000',
                'city' => 'Charmco',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25981',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9701000',
                'longitude' => '-80.7616000',
                'city' => 'Quinwood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25831',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9701000',
                'longitude' => '-80.7616000',
                'city' => 'Danese',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26201',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9919000',
                'longitude' => '-80.2254000',
                'city' => 'Buckhannon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25110',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Hugheston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25102',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Handley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25136',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Montgomery',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25126',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'London',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25139',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Mount Carbon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25036',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Cannelton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25118',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Kimberly',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25162',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Pratt',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25186',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Smithers',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25161',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1816000',
                'longitude' => '-81.3216000',
                'city' => 'Powellton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24962',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7262000',
                'longitude' => '-80.6416000',
                'city' => 'Pence Springs',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24993',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7262000',
                'longitude' => '-80.6416000',
                'city' => 'Wolfcreek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26717',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3852000',
                'longitude' => '-79.1825000',
                'city' => 'Elk Garden',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26033',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6431000',
                'longitude' => '-80.8619000',
                'city' => 'Cameron',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24888',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3685000',
                'longitude' => '-81.5475000',
                'city' => 'Thorpe',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24830',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3685000',
                'longitude' => '-81.5475000',
                'city' => 'Elbert',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24895',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3685000',
                'longitude' => '-81.5475000',
                'city' => 'Wilcoe',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24836',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3685000',
                'longitude' => '-81.5475000',
                'city' => 'Gary',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26590',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6534000',
                'longitude' => '-80.8606000',
                'city' => 'Wana',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26376',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8699000',
                'longitude' => '-80.4511000',
                'city' => 'Ireland',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26631',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8699000',
                'longitude' => '-80.4511000',
                'city' => 'Napier',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26412',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8699000',
                'longitude' => '-80.4511000',
                'city' => 'Orlando',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26447',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8699000',
                'longitude' => '-80.4511000',
                'city' => 'Walkersville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25507',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3992000',
                'longitude' => '-82.5215000',
                'city' => 'Ceredo',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25702',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3992000',
                'longitude' => '-82.5215000',
                'city' => 'Huntington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26055',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6534000',
                'longitude' => '-80.8606000',
                'city' => 'Proctor',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24915',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4333000',
                'longitude' => '-79.8195000',
                'city' => 'Arbovale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26264',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4333000',
                'longitude' => '-79.8195000',
                'city' => 'Durbin',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24944',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4333000',
                'longitude' => '-79.8195000',
                'city' => 'Green Bank',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24934',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4333000',
                'longitude' => '-79.8195000',
                'city' => 'Dunmore',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24920',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4333000',
                'longitude' => '-79.8195000',
                'city' => 'Bartow',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24927',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4333000',
                'longitude' => '-79.8195000',
                'city' => 'Cass',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26250',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1560000',
                'longitude' => '-80.0406000',
                'city' => 'Belington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26405',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1560000',
                'longitude' => '-80.0406000',
                'city' => 'Moatsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26238',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1560000',
                'longitude' => '-80.0406000',
                'city' => 'Volga',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25123',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6123000',
                'longitude' => '-81.9869000',
                'city' => 'Leon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26384',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9354000',
                'longitude' => '-80.8367000',
                'city' => 'Linn',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26611',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9354000',
                'longitude' => '-80.8367000',
                'city' => 'Cedarville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26351',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9354000',
                'longitude' => '-80.8367000',
                'city' => 'Glenville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26430',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9354000',
                'longitude' => '-80.8367000',
                'city' => 'Sand Fork',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26443',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9354000',
                'longitude' => '-80.8367000',
                'city' => 'Troy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26342',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9354000',
                'longitude' => '-80.8367000',
                'city' => 'Coxs Mills',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26287',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1501000',
                'longitude' => '-79.4964000',
                'city' => 'Parsons',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26292',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1501000',
                'longitude' => '-79.4964000',
                'city' => 'Thomas',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26184',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3363000',
                'longitude' => '-81.4260000',
                'city' => 'Waverly',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25840',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9768000',
                'longitude' => '-81.1472000',
                'city' => 'Fayetteville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25901',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9768000',
                'longitude' => '-81.1472000',
                'city' => 'Oak Hill',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25846',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9768000',
                'longitude' => '-81.1472000',
                'city' => 'Glen Jean',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25879',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9768000',
                'longitude' => '-81.1472000',
                'city' => 'Minden',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25119',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9768000',
                'longitude' => '-81.1472000',
                'city' => 'Kincaid',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25855',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9768000',
                'longitude' => '-81.1472000',
                'city' => 'Hilltop',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25917',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9768000',
                'longitude' => '-81.1472000',
                'city' => 'Scarbro',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25152',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9768000',
                'longitude' => '-81.1472000',
                'city' => 'Page',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25969',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6776000',
                'longitude' => '-80.8921000',
                'city' => 'Jumping Branch',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25979',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6776000',
                'longitude' => '-80.8921000',
                'city' => 'Pipestem',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24981',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6776000',
                'longitude' => '-80.8921000',
                'city' => 'Talcott',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25978',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6776000',
                'longitude' => '-80.8921000',
                'city' => 'Nimitz',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24935',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6776000',
                'longitude' => '-80.8921000',
                'city' => 'Forest Hill',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25985',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6776000',
                'longitude' => '-80.8921000',
                'city' => 'Sandstone',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24733',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.2441000',
                'city' => 'Lashmeet',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24747',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.2441000',
                'city' => 'Rock',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24736',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.2441000',
                'city' => 'Matoaka',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24729',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.2441000',
                'city' => 'Hiawatha',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24714',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.2441000',
                'city' => 'Beeson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26237',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9943000',
                'longitude' => '-80.2303000',
                'city' => 'Tallmansville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26267',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9943000',
                'longitude' => '-80.2303000',
                'city' => 'Ellamore',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26150',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0652000',
                'longitude' => '-81.5594000',
                'city' => 'Mineral Wells',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26169',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0652000',
                'longitude' => '-81.5594000',
                'city' => 'Rockport',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25690',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7113000',
                'longitude' => '-82.1847000',
                'city' => 'Ragland',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25676',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7113000',
                'longitude' => '-82.1847000',
                'city' => 'Lenore',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26161',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0727000',
                'longitude' => '-81.0948000',
                'city' => 'Petroleum',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26138',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0727000',
                'longitude' => '-81.0948000',
                'city' => 'Brohard',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26148',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0727000',
                'longitude' => '-81.0948000',
                'city' => 'Macfarlan',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26283',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0964000',
                'longitude' => '-79.6824000',
                'city' => 'Montrose',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26276',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0964000',
                'longitude' => '-79.6824000',
                'city' => 'Kerens',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26271',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0964000',
                'longitude' => '-79.6824000',
                'city' => 'Hendricks',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26269',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0964000',
                'longitude' => '-79.6824000',
                'city' => 'Hambleton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26106',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2693000',
                'longitude' => '-81.5564000',
                'city' => 'Parkersburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '45714',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2654000',
                'longitude' => '-81.5595000',
                'city' => 'Belpre',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25986',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8597000',
                'longitude' => '-80.8560000',
                'city' => 'Spring Dale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25555',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3992000',
                'longitude' => '-82.5215000',
                'city' => 'Prichard',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26180',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1822000',
                'longitude' => '-81.5216000',
                'city' => 'Walker',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26722',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4828000',
                'longitude' => '-78.5574000',
                'city' => 'Green Spring',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25437',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4828000',
                'longitude' => '-78.5574000',
                'city' => 'Points',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25444',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4828000',
                'longitude' => '-78.5574000',
                'city' => 'Slanesville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25431',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4828000',
                'longitude' => '-78.5574000',
                'city' => 'Levels',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26215',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6478000',
                'longitude' => '-80.4093000',
                'city' => 'Cleveland',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26222',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6478000',
                'longitude' => '-80.4093000',
                'city' => 'Hacker Valley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26651',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2740000',
                'longitude' => '-80.8493000',
                'city' => 'Summersville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26714',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2949000',
                'longitude' => '-78.6416000',
                'city' => 'Delray',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26704',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2949000',
                'longitude' => '-78.6416000',
                'city' => 'Augusta',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26761',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2949000',
                'longitude' => '-78.6416000',
                'city' => 'Shanks',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26755',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2949000',
                'longitude' => '-78.6416000',
                'city' => 'Rio',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24957',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9260000',
                'longitude' => '-80.3910000',
                'city' => 'Maxwelton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24938',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9260000',
                'longitude' => '-80.3910000',
                'city' => 'Frankford',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24966',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9260000',
                'longitude' => '-80.3910000',
                'city' => 'Renick',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25276',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8004000',
                'longitude' => '-81.3478000',
                'city' => 'Spencer',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26582',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5260000',
                'longitude' => '-80.3460000',
                'city' => 'Mannington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26410',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3936000',
                'longitude' => '-79.8496000',
                'city' => 'Newburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26757',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3406000',
                'longitude' => '-78.7517000',
                'city' => 'Romney',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25535',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4190000',
                'longitude' => '-82.4386000',
                'city' => 'Lavalette',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25501',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2204000',
                'longitude' => '-81.9564000',
                'city' => 'Alkol',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25573',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2204000',
                'longitude' => '-81.9564000',
                'city' => 'Yawkey',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25565',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2204000',
                'longitude' => '-81.9564000',
                'city' => 'Spurlockville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25506',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2204000',
                'longitude' => '-81.9564000',
                'city' => 'Branchland',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25572',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2204000',
                'longitude' => '-81.9564000',
                'city' => 'Woodville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25523',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2204000',
                'longitude' => '-81.9564000',
                'city' => 'Hamlin',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25564',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2204000',
                'longitude' => '-81.9564000',
                'city' => 'Sod',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25521',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2204000',
                'longitude' => '-81.9564000',
                'city' => 'Griffithsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26035',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.3272000',
                'longitude' => '-80.5909000',
                'city' => 'Colliers',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26330',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4655000',
                'longitude' => '-80.2129000',
                'city' => 'Bridgeport',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25425',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3267000',
                'longitude' => '-77.7493000',
                'city' => 'Harpers Ferry',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25432',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3267000',
                'longitude' => '-77.7493000',
                'city' => 'Millville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24941',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7940000',
                'longitude' => '-80.2908000',
                'city' => 'Gap Mills',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24986',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7940000',
                'longitude' => '-80.2908000',
                'city' => 'White Sulphur Springs',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26845',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0627000',
                'longitude' => '-78.9699000',
                'city' => 'Old Fields',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26036',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.0974000',
                'longitude' => '-80.5554000',
                'city' => 'Dallas',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25079',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4893000',
                'longitude' => '-81.3534000',
                'city' => 'Falling Rock',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25045',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4893000',
                'longitude' => '-81.3534000',
                'city' => 'Clendenin',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25164',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4893000',
                'longitude' => '-81.3534000',
                'city' => 'Procious',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25030',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4893000',
                'longitude' => '-81.3534000',
                'city' => 'Bomont',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25071',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4893000',
                'longitude' => '-81.3534000',
                'city' => 'Elkview',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25286',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4893000',
                'longitude' => '-81.3534000',
                'city' => 'Walton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25510',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4312000',
                'longitude' => '-82.0251000',
                'city' => 'Culloden',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26056',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.4976000',
                'longitude' => '-80.6050000',
                'city' => 'New Manchester',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25005',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5966000',
                'longitude' => '-81.1853000',
                'city' => 'Amma',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25251',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5966000',
                'longitude' => '-81.1853000',
                'city' => 'Left Hand',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25259',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5966000',
                'longitude' => '-81.1853000',
                'city' => 'Looneyville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25266',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5966000',
                'longitude' => '-81.1853000',
                'city' => 'Newton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26568',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4330000',
                'longitude' => '-80.1694000',
                'city' => 'Enterprise',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26814',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7652000',
                'longitude' => '-79.4394000',
                'city' => 'Riverton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26804',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7652000',
                'longitude' => '-79.4394000',
                'city' => 'Circleville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26884',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7652000',
                'longitude' => '-79.4394000',
                'city' => 'Seneca Rocks',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26886',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7652000',
                'longitude' => '-79.4394000',
                'city' => 'Onego',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26291',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4158000',
                'longitude' => '-80.0009000',
                'city' => 'Slatyfork',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26209',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4158000',
                'longitude' => '-80.0009000',
                'city' => 'Snowshoe',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25868',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0518000',
                'longitude' => '-81.1016000',
                'city' => 'Lookout',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25837',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0518000',
                'longitude' => '-81.1016000',
                'city' => 'Edmond',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25862',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0518000',
                'longitude' => '-81.1016000',
                'city' => 'Lansing',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25942',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.0518000',
                'longitude' => '-81.1016000',
                'city' => 'Winona',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25503',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6716000',
                'longitude' => '-82.1671000',
                'city' => 'Ashton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25502',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6716000',
                'longitude' => '-82.1671000',
                'city' => 'Apple Grove',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25520',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6716000',
                'longitude' => '-82.1671000',
                'city' => 'Glenwood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25515',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6716000',
                'longitude' => '-82.1671000',
                'city' => 'Gallipolis Ferry',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25243',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6372000',
                'longitude' => '-81.4016000',
                'city' => 'Gandeeville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26102',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3243000',
                'longitude' => '-81.5471000',
                'city' => 'Parkersburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25650',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Verner',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25635',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Man',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24823',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Coal Mountain',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24827',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Cyclone',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25611',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Bruno',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25630',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Lorado',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25628',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Kistler',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25606',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Accoville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25607',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Amherstdale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25634',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7444000',
                'longitude' => '-81.8747000',
                'city' => 'Mallory',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26366',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3943000',
                'longitude' => '-80.3002000',
                'city' => 'Haywood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26386',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3943000',
                'longitude' => '-80.3002000',
                'city' => 'Lumberport',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24853',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4240000',
                'longitude' => '-81.5049000',
                'city' => 'Kimball',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25213',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5361000',
                'longitude' => '-81.8955000',
                'city' => 'Winfield',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25109',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5361000',
                'longitude' => '-81.8955000',
                'city' => 'Hometown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25124',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5361000',
                'longitude' => '-81.8955000',
                'city' => 'Liberty',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25011',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5361000',
                'longitude' => '-81.8955000',
                'city' => 'Bancroft',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25168',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5361000',
                'longitude' => '-81.8955000',
                'city' => 'Red House',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25070',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5361000',
                'longitude' => '-81.8955000',
                'city' => 'Eleanor',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25133',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4627000',
                'longitude' => '-81.0780000',
                'city' => 'Maysel',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25285',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4627000',
                'longitude' => '-81.0780000',
                'city' => 'Wallback',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25125',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4627000',
                'longitude' => '-81.0780000',
                'city' => 'Lizemores',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25111',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4627000',
                'longitude' => '-81.0780000',
                'city' => 'Indore',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25019',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4627000',
                'longitude' => '-81.0780000',
                'city' => 'Bickmore',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24737',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3124000',
                'longitude' => '-81.2590000',
                'city' => 'Montcalm',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26361',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3943000',
                'longitude' => '-80.3002000',
                'city' => 'Gypsy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26404',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3943000',
                'longitude' => '-80.3002000',
                'city' => 'Meadowbrook',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26463',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3943000',
                'longitude' => '-80.3002000',
                'city' => 'Wyatt',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25550',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8582000',
                'longitude' => '-82.1179000',
                'city' => 'Point Pleasant',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25075',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Eskdale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25132',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Mammoth',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25067',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'East Bank',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25160',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Pond Gap',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25054',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Dawes',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25061',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Drybranch',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25083',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Gallagher',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25086',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Glasgow',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25035',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Cabin Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25039',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Cedar Grove',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25103',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Hansford',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25134',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2193000',
                'longitude' => '-81.4428000',
                'city' => 'Miami',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26534',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6549000',
                'longitude' => '-79.9683000',
                'city' => 'Granville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26241',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9254000',
                'longitude' => '-79.8530000',
                'city' => 'Elkins',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26408',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2803000',
                'longitude' => '-80.3452000',
                'city' => 'Mount Clare',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26323',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2803000',
                'longitude' => '-80.3452000',
                'city' => 'Anmoore',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26306',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2803000',
                'longitude' => '-80.3452000',
                'city' => 'Clarksburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26302',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2803000',
                'longitude' => '-80.3452000',
                'city' => 'Clarksburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26337',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2114000',
                'longitude' => '-81.1570000',
                'city' => 'Cairo',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25059',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1901000',
                'longitude' => '-81.1845000',
                'city' => 'Dixie',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26656',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1901000',
                'longitude' => '-81.1845000',
                'city' => 'Belva',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25090',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1901000',
                'longitude' => '-81.1845000',
                'city' => 'Glen Ferris',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26690',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1901000',
                'longitude' => '-81.1845000',
                'city' => 'Swiss',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25085',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1901000',
                'longitude' => '-81.1845000',
                'city' => 'Gauley Bridge',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25727',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4151000',
                'longitude' => '-82.4416000',
                'city' => 'Huntington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26285',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9292000',
                'longitude' => '-79.8498000',
                'city' => 'Norton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26254',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9292000',
                'longitude' => '-79.8498000',
                'city' => 'Bowden',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26257',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9292000',
                'longitude' => '-79.8498000',
                'city' => 'Coalton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '41230',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4151000',
                'longitude' => '-82.4416000',
                'city' => 'Louisa',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25843',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '40.0590000',
                'longitude' => '-80.7222000',
                'city' => 'Ghent',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24925',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7848000',
                'longitude' => '-80.4562000',
                'city' => 'Caldwell',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24991',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7848000',
                'longitude' => '-80.4562000',
                'city' => 'Williamsburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24916',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7848000',
                'longitude' => '-80.4562000',
                'city' => 'Asbury',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24902',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7848000',
                'longitude' => '-80.4562000',
                'city' => 'Fairlea',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24970',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7848000',
                'longitude' => '-80.4562000',
                'city' => 'Ronceverte',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26610',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.5001000',
                'longitude' => '-80.7578000',
                'city' => 'Birch River',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26146',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5627000',
                'longitude' => '-80.9979000',
                'city' => 'Friendly',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24924',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1443000',
                'longitude' => '-80.2083000',
                'city' => 'Buckeye',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24946',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1443000',
                'longitude' => '-80.2083000',
                'city' => 'Hillsboro',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25234',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7904000',
                'longitude' => '-81.1273000',
                'city' => 'Arnoldsburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25268',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.7904000',
                'longitude' => '-81.1273000',
                'city' => 'Orma',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24828',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4732000',
                'longitude' => '-81.6497000',
                'city' => 'Davy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24816',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4732000',
                'longitude' => '-81.6497000',
                'city' => 'Big Sandy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24843',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4732000',
                'longitude' => '-81.6497000',
                'city' => 'Hensley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25854',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1385000',
                'longitude' => '-81.1017000',
                'city' => 'Hico',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25938',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1385000',
                'longitude' => '-81.1017000',
                'city' => 'Victor',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25812',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1385000',
                'longitude' => '-81.1017000',
                'city' => 'Ansted',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26415',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2843000',
                'longitude' => '-80.9724000',
                'city' => 'Pennsboro',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26562',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6763000',
                'longitude' => '-80.3412000',
                'city' => 'Burton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25621',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6158000',
                'longitude' => '-81.8651000',
                'city' => 'Gilbert',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24882',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6158000',
                'longitude' => '-81.8651000',
                'city' => 'Simon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24851',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6158000',
                'longitude' => '-81.8651000',
                'city' => 'Justice',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24839',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6158000',
                'longitude' => '-81.8651000',
                'city' => 'Hanover',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25651',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6158000',
                'longitude' => '-81.8651000',
                'city' => 'Wharncliffe',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25608',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6158000',
                'longitude' => '-81.8651000',
                'city' => 'Baisden',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24869',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6158000',
                'longitude' => '-81.8651000',
                'city' => 'North Spring',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26170',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3769000',
                'longitude' => '-81.2747000',
                'city' => 'Saint Marys',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25106',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8630000',
                'longitude' => '-82.1279000',
                'city' => 'Henderson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25187',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8630000',
                'longitude' => '-82.1279000',
                'city' => 'Southside',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24854',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6959000',
                'longitude' => '-81.6202000',
                'city' => 'Kopperston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24849',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6959000',
                'longitude' => '-81.6202000',
                'city' => 'Jesse',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24860',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6959000',
                'longitude' => '-81.6202000',
                'city' => 'Matheny',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25845',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6959000',
                'longitude' => '-81.6202000',
                'city' => 'Glen Fork',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24857',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6959000',
                'longitude' => '-81.6202000',
                'city' => 'Lynco',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24870',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6959000',
                'longitude' => '-81.6202000',
                'city' => 'Oceana',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24822',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6959000',
                'longitude' => '-81.6202000',
                'city' => 'Clear Fork',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25920',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7455000',
                'longitude' => '-81.2481000',
                'city' => 'Slab Fork',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25921',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7455000',
                'longitude' => '-81.2481000',
                'city' => 'Sophia',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25908',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7455000',
                'longitude' => '-81.2481000',
                'city' => 'Princewick',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25915',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7455000',
                'longitude' => '-81.2481000',
                'city' => 'Rhodell',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25878',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7455000',
                'longitude' => '-81.2481000',
                'city' => 'Midway',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25823',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7455000',
                'longitude' => '-81.2481000',
                'city' => 'Coal City',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25857',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7455000',
                'longitude' => '-81.2481000',
                'city' => 'Josephine',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26707',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2936000',
                'longitude' => '-79.3471000',
                'city' => 'Bayard',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26739',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2936000',
                'longitude' => '-79.3471000',
                'city' => 'Mount Storm',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26720',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2936000',
                'longitude' => '-79.3471000',
                'city' => 'Gormania',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25755',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4190000',
                'longitude' => '-82.4386000',
                'city' => 'Huntington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26335',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8599000',
                'longitude' => '-80.6613000',
                'city' => 'Burnsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25313',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25064',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3505000',
                'longitude' => '-81.6347000',
                'city' => 'Dunbar',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25438',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2907000',
                'longitude' => '-77.8598000',
                'city' => 'Ranson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25446',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2907000',
                'longitude' => '-77.8598000',
                'city' => 'Summit Point',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25423',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2907000',
                'longitude' => '-77.8598000',
                'city' => 'Halltown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24898',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5847000',
                'longitude' => '-81.5365000',
                'city' => 'Wyoming',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24874',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5847000',
                'longitude' => '-81.5365000',
                'city' => 'Pineville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24859',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5847000',
                'longitude' => '-81.5365000',
                'city' => 'Marianna',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24818',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5847000',
                'longitude' => '-81.5365000',
                'city' => 'Brenton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24834',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5847000',
                'longitude' => '-81.5365000',
                'city' => 'Fanrock',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24880',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5847000',
                'longitude' => '-81.5365000',
                'city' => 'Rock View',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25559',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4182000',
                'longitude' => '-82.3016000',
                'city' => 'Salt Rock',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25537',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4182000',
                'longitude' => '-82.3016000',
                'city' => 'Lesage',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26716',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3051000',
                'longitude' => '-79.5213000',
                'city' => 'Eglon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26705',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3051000',
                'longitude' => '-79.5213000',
                'city' => 'Aurora',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26767',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6531000',
                'longitude' => '-78.7599000',
                'city' => 'Wiley Ford',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26347',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2668000',
                'longitude' => '-80.1315000',
                'city' => 'Flemington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26424',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2668000',
                'longitude' => '-80.1315000',
                'city' => 'Rosemont',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26435',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2668000',
                'longitude' => '-80.1315000',
                'city' => 'Simpson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26349',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2668000',
                'longitude' => '-80.1315000',
                'city' => 'Galloway',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26691',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3289000',
                'longitude' => '-80.6535000',
                'city' => 'Tioga',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26660',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3289000',
                'longitude' => '-80.6535000',
                'city' => 'Calvin',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26205',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3289000',
                'longitude' => '-80.6535000',
                'city' => 'Craigsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25082',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4365000',
                'longitude' => '-82.1372000',
                'city' => 'Fraziers Bottom',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26385',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2005000',
                'longitude' => '-80.4039000',
                'city' => 'Lost Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26731',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1179000',
                'longitude' => '-79.1635000',
                'city' => 'Lahmansville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26833',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.1179000',
                'longitude' => '-79.1635000',
                'city' => 'Maysville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25076',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Ethel',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25639',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Peach Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25624',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Henlawson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25632',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Lyburn',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25547',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Pecks Mill',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25646',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Stollings',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25671',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Dingess',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25649',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Verdunville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25653',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8493000',
                'longitude' => '-81.9911000',
                'city' => 'Wilkinson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24963',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3978000',
                'longitude' => '-80.7985000',
                'city' => 'Peterstown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24918',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3978000',
                'longitude' => '-80.7985000',
                'city' => 'Ballard',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24951',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3978000',
                'longitude' => '-80.7985000',
                'city' => 'Lindside',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25560',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4230000',
                'longitude' => '-81.8399000',
                'city' => 'Scott Depot',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25003',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2912000',
                'longitude' => '-81.8126000',
                'city' => 'Alum Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26434',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4958000',
                'longitude' => '-80.9052000',
                'city' => 'Shirley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26320',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4958000',
                'longitude' => '-80.9052000',
                'city' => 'Alma',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25569',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4520000',
                'longitude' => '-81.9337000',
                'city' => 'Teays',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25989',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7097000',
                'longitude' => '-81.0989000',
                'city' => 'White Oak',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25825',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7097000',
                'longitude' => '-81.0989000',
                'city' => 'Cool Ridge',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25918',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7097000',
                'longitude' => '-81.0989000',
                'city' => 'Shady Spring',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26629',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6615000',
                'longitude' => '-80.7108000',
                'city' => 'Little Birch',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26627',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6615000',
                'longitude' => '-80.7108000',
                'city' => 'Heaters',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26621',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6615000',
                'longitude' => '-80.7108000',
                'city' => 'Flatwoods',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26619',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.6615000',
                'longitude' => '-80.7108000',
                'city' => 'Exchange',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24976',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5905000',
                'longitude' => '-80.5441000',
                'city' => 'Sinks Grove',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24984',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5905000',
                'longitude' => '-80.5441000',
                'city' => 'Waiteville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24974',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5905000',
                'longitude' => '-80.5441000',
                'city' => 'Secondcreek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24983',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5905000',
                'longitude' => '-80.5441000',
                'city' => 'Union',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25260',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0217000',
                'longitude' => '-82.0312000',
                'city' => 'Mason',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25853',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5800000',
                'longitude' => '-81.3839000',
                'city' => 'Helen',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26575',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6859000',
                'longitude' => '-80.4603000',
                'city' => 'Hundred',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26585',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6859000',
                'longitude' => '-80.4603000',
                'city' => 'Metz',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26581',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6859000',
                'longitude' => '-80.4603000',
                'city' => 'Littleton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25557',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2176000',
                'longitude' => '-82.1971000',
                'city' => 'Ranger',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25540',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2176000',
                'longitude' => '-82.1971000',
                'city' => 'Midkiff',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25544',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2176000',
                'longitude' => '-82.1971000',
                'city' => 'Myra',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25031',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1272000',
                'longitude' => '-81.2547000',
                'city' => 'Boomer',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25173',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1272000',
                'longitude' => '-81.2547000',
                'city' => 'Robson',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25115',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1272000',
                'longitude' => '-81.2547000',
                'city' => 'Kanawha Falls',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25040',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1272000',
                'longitude' => '-81.2547000',
                'city' => 'Charlton Heights',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25002',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1272000',
                'longitude' => '-81.2547000',
                'city' => 'Alloy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25057',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1272000',
                'longitude' => '-81.2547000',
                'city' => 'Deep Water',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26339',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2856000',
                'longitude' => '-80.5653000',
                'city' => 'Center Point',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26448',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3402000',
                'longitude' => '-80.4222000',
                'city' => 'Wallace',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25902',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6357000',
                'longitude' => '-81.1023000',
                'city' => 'Odd',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25841',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.6357000',
                'longitude' => '-81.1023000',
                'city' => 'Flat Top',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '21773',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4444000',
                'longitude' => '-78.9755000',
                'city' => 'Myersville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24954',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2275000',
                'longitude' => '-80.0922000',
                'city' => 'Marlinton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26275',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0261000',
                'longitude' => '-79.9448000',
                'city' => 'Junior',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25571',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2779000',
                'longitude' => '-82.1097000',
                'city' => 'West Hamlin',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24861',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3639000',
                'longitude' => '-81.3759000',
                'city' => 'Maybeury',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24844',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3572000',
                'longitude' => '-81.7994000',
                'city' => 'Iaeger',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24850',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3572000',
                'longitude' => '-81.7994000',
                'city' => 'Jolo',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24945',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5456000',
                'longitude' => '-80.6821000',
                'city' => 'Greenville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24985',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.5456000',
                'longitude' => '-80.6821000',
                'city' => 'Wayside',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25306',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25165',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Racine',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25009',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Ashford',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25051',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Costa',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25169',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Ridgeview',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25142',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Nellis',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25154',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Peytona',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25049',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Comfort',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25024',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Bloomingrose',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25148',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.3176000',
                'longitude' => '-81.5781000',
                'city' => 'Orgas',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26039',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.9191000',
                'longitude' => '-80.7476000',
                'city' => 'Glen Easton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26261',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2242000',
                'longitude' => '-80.5306000',
                'city' => 'Richwood',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26681',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2242000',
                'longitude' => '-80.5306000',
                'city' => 'Nettie',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26202',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2242000',
                'longitude' => '-80.5306000',
                'city' => 'Fenwick',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26676',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2242000',
                'longitude' => '-80.5306000',
                'city' => 'Leivasy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26288',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4834000',
                'longitude' => '-80.4179000',
                'city' => 'Webster Springs',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26217',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4834000',
                'longitude' => '-80.4179000',
                'city' => 'Diana',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26298',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4834000',
                'longitude' => '-80.4179000',
                'city' => 'Bergoo',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25534',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1659000',
                'longitude' => '-82.3811000',
                'city' => 'Kiahsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25512',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.1659000',
                'longitude' => '-82.3811000',
                'city' => 'East Lynn',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26615',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8535000',
                'longitude' => '-80.6595000',
                'city' => 'Copen',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25140',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9767000',
                'longitude' => '-81.5319000',
                'city' => 'Naoma',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25193',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9767000',
                'longitude' => '-81.5319000',
                'city' => 'Sylvester',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25174',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9767000',
                'longitude' => '-81.5319000',
                'city' => 'Rock Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25060',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9767000',
                'longitude' => '-81.5319000',
                'city' => 'Dorothy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25048',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9767000',
                'longitude' => '-81.5319000',
                'city' => 'Colcord',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25062',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9767000',
                'longitude' => '-81.5319000',
                'city' => 'Dry Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25008',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9767000',
                'longitude' => '-81.5319000',
                'city' => 'Artie',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25209',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9767000',
                'longitude' => '-81.5319000',
                'city' => 'Whitesville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25505',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9669000',
                'longitude' => '-82.0228000',
                'city' => 'Big Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25524',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.9669000',
                'longitude' => '-82.0228000',
                'city' => 'Harts',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26808',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2997000',
                'longitude' => '-78.4379000',
                'city' => 'High View',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26865',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2997000',
                'longitude' => '-78.4379000',
                'city' => 'Yellow Spring',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26817',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2997000',
                'longitude' => '-78.4379000',
                'city' => 'Bloomery',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26711',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2997000',
                'longitude' => '-78.4379000',
                'city' => 'Capon Bridge',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26181',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2393000',
                'longitude' => '-81.6290000',
                'city' => 'Washington',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24831',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.4408000',
                'city' => 'Elkhorn',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24855',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.4408000',
                'city' => 'Kyle',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24868',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.4408000',
                'city' => 'Northfork',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24829',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4192000',
                'longitude' => '-81.4408000',
                'city' => 'Eckman',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26374',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5014000',
                'longitude' => '-79.8142000',
                'city' => 'Independence',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26520',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5014000',
                'longitude' => '-79.8142000',
                'city' => 'Arthurdale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26542',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5014000',
                'longitude' => '-79.8142000',
                'city' => 'Masontown',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26547',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5014000',
                'longitude' => '-79.8142000',
                'city' => 'Reedsville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26289',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0259000',
                'longitude' => '-79.4458000',
                'city' => 'Red Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26346',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2659000',
                'longitude' => '-81.0572000',
                'city' => 'Ellenboro',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26678',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2828000',
                'longitude' => '-80.8561000',
                'city' => 'Mount Lookout',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26662',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2828000',
                'longitude' => '-80.8561000',
                'city' => 'Canvas',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26675',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2828000',
                'longitude' => '-80.8561000',
                'city' => 'Keslers Cross Lanes',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26671',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2828000',
                'longitude' => '-80.8561000',
                'city' => 'Gilboa',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26667',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2828000',
                'longitude' => '-80.8561000',
                'city' => 'Drennen',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26436',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.3022000',
                'longitude' => '-80.7760000',
                'city' => 'Smithburg',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26823',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0747000',
                'longitude' => '-78.5983000',
                'city' => 'Capon Springs',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26851',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0747000',
                'longitude' => '-78.5983000',
                'city' => 'Wardensville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24892',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3107000',
                'longitude' => '-81.6933000',
                'city' => 'War',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24815',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3107000',
                'longitude' => '-81.6933000',
                'city' => 'Berwind',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24866',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3107000',
                'longitude' => '-81.6933000',
                'city' => 'Newhall',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24894',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3107000',
                'longitude' => '-81.6933000',
                'city' => 'Warriormine',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24884',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3107000',
                'longitude' => '-81.6933000',
                'city' => 'Squire',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24826',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3107000',
                'longitude' => '-81.6933000',
                'city' => 'Cucumber',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25410',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4262000',
                'longitude' => '-77.8120000',
                'city' => 'Bakerton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25442',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.4262000',
                'longitude' => '-77.8120000',
                'city' => 'Shenandoah Junction',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25818',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8967000',
                'longitude' => '-81.1706000',
                'city' => 'Bradley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25904',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8967000',
                'longitude' => '-81.1706000',
                'city' => 'Pax',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25044',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.8967000',
                'longitude' => '-81.1706000',
                'city' => 'Clear Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26544',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6812000',
                'longitude' => '-80.1091000',
                'city' => 'Pentress',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26546',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.6812000',
                'longitude' => '-80.1091000',
                'city' => 'Pursglove',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25253',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9867000',
                'longitude' => '-81.9691000',
                'city' => 'Letart',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25247',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9867000',
                'longitude' => '-81.9691000',
                'city' => 'Hartford',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25265',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.9867000',
                'longitude' => '-81.9691000',
                'city' => 'New Haven',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26561',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5471000',
                'longitude' => '-80.6876000',
                'city' => 'Big Run',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26419',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5471000',
                'longitude' => '-80.6876000',
                'city' => 'Pine Grove',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '20601',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.2654000',
                'longitude' => '-81.5595000',
                'city' => 'Waldorf',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26812',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0441000',
                'longitude' => '-78.7947000',
                'city' => 'Mathias',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26801',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0441000',
                'longitude' => '-78.7947000',
                'city' => 'Baker',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26810',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.0441000',
                'longitude' => '-78.7947000',
                'city' => 'Lost City',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24739',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3396000',
                'longitude' => '-80.9530000',
                'city' => 'Princeton',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24732',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3396000',
                'longitude' => '-80.9530000',
                'city' => 'Kellysville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26236',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8607000',
                'longitude' => '-80.3121000',
                'city' => 'Selbyville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26234',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8607000',
                'longitude' => '-80.3121000',
                'city' => 'Rock Cave',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26218',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8607000',
                'longitude' => '-80.3121000',
                'city' => 'French Creek',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26230',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8607000',
                'longitude' => '-80.3121000',
                'city' => 'Pickens',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26224',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8607000',
                'longitude' => '-80.3121000',
                'city' => 'Helvetia',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25270',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.8028000',
                'longitude' => '-81.3528000',
                'city' => 'Reedy',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25180',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7814000',
                'longitude' => '-81.3428000',
                'city' => 'Saxon',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25007',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7814000',
                'longitude' => '-81.3428000',
                'city' => 'Arnett',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25817',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7814000',
                'longitude' => '-81.3428000',
                'city' => 'Bolt',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25865',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7814000',
                'longitude' => '-81.3428000',
                'city' => 'Lester',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25839',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7814000',
                'longitude' => '-81.3428000',
                'city' => 'Fairdale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25932',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7814000',
                'longitude' => '-81.3428000',
                'city' => 'Surveyor',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25844',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7814000',
                'longitude' => '-81.3428000',
                'city' => 'Glen Daniel',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24846',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4650000',
                'longitude' => '-81.8113000',
                'city' => 'Isaban',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24845',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4650000',
                'longitude' => '-81.8113000',
                'city' => 'Ikes Fork',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24811',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4650000',
                'longitude' => '-81.8113000',
                'city' => 'Avondale',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24872',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4650000',
                'longitude' => '-81.8113000',
                'city' => 'Panther',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24862',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.4650000',
                'longitude' => '-81.8113000',
                'city' => 'Mohawk',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25647',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7648000',
                'longitude' => '-81.9947000',
                'city' => 'Switzer',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25644',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7648000',
                'longitude' => '-81.9947000',
                'city' => 'Sarah Ann',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25612',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7648000',
                'longitude' => '-81.9947000',
                'city' => 'Chauncey',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25638',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.7648000',
                'longitude' => '-81.9947000',
                'city' => 'Omar',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25434',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5309000',
                'longitude' => '-78.4583000',
                'city' => 'Paw Paw',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25107',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2345000',
                'longitude' => '-81.5405000',
                'city' => 'Hernshaw',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25214',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.2345000',
                'longitude' => '-81.5405000',
                'city' => 'Winifrede',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25156',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4388000',
                'longitude' => '-81.4828000',
                'city' => 'Pinch',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24817',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3533000',
                'longitude' => '-81.8024000',
                'city' => 'Bradshaw',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24873',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3533000',
                'longitude' => '-81.8024000',
                'city' => 'Paynesville',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24879',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3533000',
                'longitude' => '-81.8024000',
                'city' => 'Raysal',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '24813',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '37.3533000',
                'longitude' => '-81.8024000',
                'city' => 'Bartley',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25088',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4388000',
                'longitude' => '-81.4828000',
                'city' => 'Glen',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '25320',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '38.4887000',
                'longitude' => '-81.6635000',
                'city' => 'Charleston',
                'full_state' => 'West Virginia',
            ],
            [
                'zip' => '26587',
                'country_code' => 'US',
                'state' => 'WV',
                'latitude' => '39.5401000',
                'longitude' => '-80.3414000',
                'city' => 'Rachel',
                'full_state' => 'West Virginia',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
