<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NewHampshireSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '3102',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Manchester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3104',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Manchester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3064',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7610000',
                'longitude' => '-71.4634000',
                'city' => 'Nashua',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3063',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7610000',
                'longitude' => '-71.4634000',
                'city' => 'Nashua',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3801',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0735000',
                'longitude' => '-70.7636000',
                'city' => 'Portsmouth',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3253',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Meredith',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3768',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8130000',
                'longitude' => '-72.1599000',
                'city' => 'Lyme',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3431',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9375000',
                'longitude' => '-72.2775000',
                'city' => 'Keene',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3275',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9783000',
                'longitude' => '-71.4051000',
                'city' => 'Suncook',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3106',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9783000',
                'longitude' => '-71.4051000',
                'city' => 'Hooksett',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3079',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7854000',
                'longitude' => '-71.2270000',
                'city' => 'Salem',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3223',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Campton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3579',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.7825000',
                'longitude' => '-71.1440000',
                'city' => 'Errol',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3570',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.4740000',
                'longitude' => '-71.1811000',
                'city' => 'Berlin',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3038',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9783000',
                'longitude' => '-71.4051000',
                'city' => 'Derry',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3222',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5917000',
                'longitude' => '-71.7345000',
                'city' => 'Bristol',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3101',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Manchester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3303',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2007000',
                'longitude' => '-71.5348000',
                'city' => 'Concord',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3062',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7298000',
                'longitude' => '-71.4501000',
                'city' => 'Nashua',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3109',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Manchester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3110',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Bedford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3103',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Manchester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3229',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2035000',
                'longitude' => '-71.5397000',
                'city' => 'Contoocook',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3301',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2035000',
                'longitude' => '-71.5397000',
                'city' => 'Concord',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3304',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2035000',
                'longitude' => '-71.5397000',
                'city' => 'Bow',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3307',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2035000',
                'longitude' => '-71.5397000',
                'city' => 'Loudon',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3848',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8816000',
                'longitude' => '-71.3203000',
                'city' => 'Kingston',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3051',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8816000',
                'longitude' => '-71.3203000',
                'city' => 'Hudson',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3046',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8816000',
                'longitude' => '-71.3203000',
                'city' => 'Dunbarton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3855',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8816000',
                'longitude' => '-71.3203000',
                'city' => 'New Durham',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3053',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8816000',
                'longitude' => '-71.3203000',
                'city' => 'Londonderry',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3215',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.9574000',
                'longitude' => '-71.5064000',
                'city' => 'Waterville Valley',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3576',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.8916000',
                'longitude' => '-71.4982000',
                'city' => 'Colebrook',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3264',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7596000',
                'longitude' => '-71.6910000',
                'city' => 'Plymouth',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3441',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7767000',
                'longitude' => '-72.3816000',
                'city' => 'Ashuelot',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3470',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7767000',
                'longitude' => '-72.3816000',
                'city' => 'Winchester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3465',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8222000',
                'longitude' => '-72.1884000',
                'city' => 'Troy',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3447',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8222000',
                'longitude' => '-72.1884000',
                'city' => 'Fitzwilliam',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3044',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9783000',
                'longitude' => '-71.4051000',
                'city' => 'Fremont',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3042',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9783000',
                'longitude' => '-71.4051000',
                'city' => 'Epping',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3077',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9783000',
                'longitude' => '-71.4051000',
                'city' => 'Raymond',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3782',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0735000',
                'longitude' => '-70.7636000',
                'city' => 'Sunapee',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3592',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.9882000',
                'longitude' => '-71.5437000',
                'city' => 'Pittsburg',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3597',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.9882000',
                'longitude' => '-71.5437000',
                'city' => 'West Stewartstown',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3820',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1943000',
                'longitude' => '-70.8765000',
                'city' => 'Dover',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3031',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8246000',
                'longitude' => '-71.6415000',
                'city' => 'Amherst',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3055',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8246000',
                'longitude' => '-71.6415000',
                'city' => 'Milford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3033',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8246000',
                'longitude' => '-71.6415000',
                'city' => 'Brookline',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3057',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8246000',
                'longitude' => '-71.6415000',
                'city' => 'Mont Vernon',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3217',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7092000',
                'longitude' => '-71.4627000',
                'city' => 'Ashland',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3225',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7092000',
                'longitude' => '-71.4627000',
                'city' => 'Center Barnstead',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3784',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6489000',
                'longitude' => '-72.3111000',
                'city' => 'West Lebanon',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3226',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7092000',
                'longitude' => '-71.4627000',
                'city' => 'Center Harbor',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3894',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7092000',
                'longitude' => '-71.4627000',
                'city' => 'Wolfeboro',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3254',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7092000',
                'longitude' => '-71.4627000',
                'city' => 'Moultonborough',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3466',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8552000',
                'longitude' => '-72.5587000',
                'city' => 'West Chesterfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3443',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8552000',
                'longitude' => '-72.5587000',
                'city' => 'Chesterfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3451',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8552000',
                'longitude' => '-72.5587000',
                'city' => 'Hinsdale',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3865',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8278000',
                'longitude' => '-71.0916000',
                'city' => 'Plaistow',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3458',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8808000',
                'longitude' => '-71.9479000',
                'city' => 'Peterborough',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3561',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.3084000',
                'longitude' => '-71.7697000',
                'city' => 'Littleton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3052',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8589000',
                'longitude' => '-71.4907000',
                'city' => 'Litchfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3054',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8589000',
                'longitude' => '-71.4907000',
                'city' => 'Merrimack',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3070',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9757000',
                'longitude' => '-71.6901000',
                'city' => 'New Boston',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3276',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4446000',
                'longitude' => '-71.5920000',
                'city' => 'Tilton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3237',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4470000',
                'longitude' => '-71.4755000',
                'city' => 'Gilmanton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3220',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4470000',
                'longitude' => '-71.4755000',
                'city' => 'Belmont',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3218',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3404000',
                'longitude' => '-71.2632000',
                'city' => 'Barnstead',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3884',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3404000',
                'longitude' => '-71.2632000',
                'city' => 'Strafford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3815',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3404000',
                'longitude' => '-71.2632000',
                'city' => 'Center Strafford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3305',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2035000',
                'longitude' => '-71.5397000',
                'city' => 'Concord',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3777',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.9932000',
                'longitude' => '-72.1281000',
                'city' => 'Orford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3779',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.9932000',
                'longitude' => '-72.1281000',
                'city' => 'Piermont',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3249',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5342000',
                'longitude' => '-71.4743000',
                'city' => 'Gilford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3874',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8846000',
                'longitude' => '-70.9304000',
                'city' => 'Seabrook',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3844',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8846000',
                'longitude' => '-70.9304000',
                'city' => 'Hampton Falls',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3755',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7021000',
                'longitude' => '-72.2922000',
                'city' => 'Hanover',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3575',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.2589000',
                'longitude' => '-71.4393000',
                'city' => 'Bretton Woods',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3256',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6541000',
                'longitude' => '-71.5091000',
                'city' => 'New Hampton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3245',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6541000',
                'longitude' => '-71.5091000',
                'city' => 'Holderness',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3825',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2213000',
                'longitude' => '-71.0411000',
                'city' => 'Barrington',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3741',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6465000',
                'longitude' => '-72.0220000',
                'city' => 'Canaan',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3227',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8076000',
                'longitude' => '-71.4403000',
                'city' => 'Center Sandwich',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3259',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8076000',
                'longitude' => '-71.4403000',
                'city' => 'North Sandwich',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3821',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1943000',
                'longitude' => '-70.8765000',
                'city' => 'Dover',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3872',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4446000',
                'longitude' => '-71.5920000',
                'city' => 'Sanbornville',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3269',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4446000',
                'longitude' => '-71.5920000',
                'city' => 'Sanbornton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3856',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4446000',
                'longitude' => '-71.5920000',
                'city' => 'Newfields',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3743',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3721000',
                'longitude' => '-72.3359000',
                'city' => 'Claremont',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3785',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.1493000',
                'longitude' => '-72.0333000',
                'city' => 'Woodsville',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3048',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7723000',
                'longitude' => '-71.8117000',
                'city' => 'Greenville',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3824',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0773000',
                'longitude' => '-70.9370000',
                'city' => 'Durham',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3809',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5785000',
                'longitude' => '-71.3994000',
                'city' => 'Alton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3246',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5785000',
                'longitude' => '-71.3994000',
                'city' => 'Laconia',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3814',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7576000',
                'longitude' => '-71.1535000',
                'city' => 'Center Ossipee',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3781',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'Plainfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3766',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'Lebanon',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3036',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9542000',
                'longitude' => '-71.2547000',
                'city' => 'Chester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3748',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6464000',
                'longitude' => '-72.1438000',
                'city' => 'Enfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3467',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9073000',
                'longitude' => '-72.5180000',
                'city' => 'Westmoreland',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3282',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.9713000',
                'longitude' => '-72.0795000',
                'city' => 'Wentworth',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3235',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4405000',
                'longitude' => '-71.6453000',
                'city' => 'Franklin',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3588',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.5732000',
                'longitude' => '-71.1897000',
                'city' => 'Milan',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3817',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8561000',
                'longitude' => '-71.2616000',
                'city' => 'Chocorua',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3883',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8561000',
                'longitude' => '-71.2616000',
                'city' => 'South Tamworth',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3897',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8561000',
                'longitude' => '-71.2616000',
                'city' => 'Wonalancet',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3886',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8561000',
                'longitude' => '-71.2616000',
                'city' => 'Tamworth',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3060',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7610000',
                'longitude' => '-71.4634000',
                'city' => 'Nashua',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3811',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8787000',
                'longitude' => '-71.1865000',
                'city' => 'Atkinson',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3826',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8787000',
                'longitude' => '-71.1865000',
                'city' => 'East Hampstead',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3873',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8787000',
                'longitude' => '-71.1865000',
                'city' => 'Sandown',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3841',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8787000',
                'longitude' => '-71.1865000',
                'city' => 'Hampstead',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3867',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3036000',
                'longitude' => '-70.9715000',
                'city' => 'Rochester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3868',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3036000',
                'longitude' => '-70.9715000',
                'city' => 'Rochester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3839',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3036000',
                'longitude' => '-70.9715000',
                'city' => 'Rochester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3835',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3036000',
                'longitude' => '-70.9715000',
                'city' => 'Farmington',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3840',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0735000',
                'longitude' => '-70.7636000',
                'city' => 'Greenland',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3870',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0735000',
                'longitude' => '-70.7636000',
                'city' => 'Rye',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3854',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0735000',
                'longitude' => '-70.7636000',
                'city' => 'New Castle',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3878',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1943000',
                'longitude' => '-70.8765000',
                'city' => 'Somersworth',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3869',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1943000',
                'longitude' => '-70.8765000',
                'city' => 'Rollinsford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3810',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7596000',
                'longitude' => '-71.6910000',
                'city' => 'Alton Bay',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3833',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9337000',
                'longitude' => '-71.0515000',
                'city' => 'Exeter',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3827',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9337000',
                'longitude' => '-71.0515000',
                'city' => 'East Kingston',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3262',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0339000',
                'longitude' => '-71.6895000',
                'city' => 'North Woodstock',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3448',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9339000',
                'longitude' => '-72.2814000',
                'city' => 'Gilsum',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3446',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9339000',
                'longitude' => '-72.2814000',
                'city' => 'Swanzey',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3469',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9339000',
                'longitude' => '-72.2814000',
                'city' => 'West Swanzey',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3845',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0528000',
                'longitude' => '-71.1251000',
                'city' => 'Intervale',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3813',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0528000',
                'longitude' => '-71.1251000',
                'city' => 'Center Conway',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3818',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0528000',
                'longitude' => '-71.1251000',
                'city' => 'Conway',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3860',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0528000',
                'longitude' => '-71.1251000',
                'city' => 'North Conway',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3812',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0528000',
                'longitude' => '-71.1251000',
                'city' => 'Bartlett',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3462',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9057000',
                'longitude' => '-72.4241000',
                'city' => 'Spofford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3837',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4185000',
                'longitude' => '-71.2964000',
                'city' => 'Gilmanton Iron Works',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3849',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8999000',
                'longitude' => '-71.1454000',
                'city' => 'Madison',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3875',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8999000',
                'longitude' => '-71.1454000',
                'city' => 'Silver Lake',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3773',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3662000',
                'longitude' => '-72.1733000',
                'city' => 'Newport',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3853',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2007000',
                'longitude' => '-71.5348000',
                'city' => 'Mirror Lake',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3034',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0515000',
                'longitude' => '-71.2905000',
                'city' => 'Candia',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3858',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8278000',
                'longitude' => '-71.0916000',
                'city' => 'Newton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3819',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8278000',
                'longitude' => '-71.0916000',
                'city' => 'Danville',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3842',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9830000',
                'longitude' => '-70.7698000',
                'city' => 'Hampton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3862',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9830000',
                'longitude' => '-70.7698000',
                'city' => 'North Hampton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3846',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.1396000',
                'longitude' => '-71.1729000',
                'city' => 'Jackson',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3838',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.1396000',
                'longitude' => '-71.1729000',
                'city' => 'Glen',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3045',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9783000',
                'longitude' => '-71.4051000',
                'city' => 'Goffstown',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3251',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5342000',
                'longitude' => '-71.4743000',
                'city' => 'Lincoln',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3864',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5342000',
                'longitude' => '-71.4743000',
                'city' => 'Ossipee',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3583',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.4207000',
                'longitude' => '-71.4753000',
                'city' => 'Jefferson',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3087',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8816000',
                'longitude' => '-71.3203000',
                'city' => 'Windham',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3242',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1814000',
                'longitude' => '-71.8229000',
                'city' => 'Henniker',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3263',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3067000',
                'longitude' => '-71.3258000',
                'city' => 'Pittsfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3258',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3067000',
                'longitude' => '-71.3258000',
                'city' => 'Chichester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3234',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3067000',
                'longitude' => '-71.3258000',
                'city' => 'Epsom',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3574',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.3084000',
                'longitude' => '-71.7697000',
                'city' => 'Bethlehem',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3603',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1333000',
                'longitude' => '-72.4465000',
                'city' => 'Charlestown',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3604',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1333000',
                'longitude' => '-72.4465000',
                'city' => 'Drewsville',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3608',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1333000',
                'longitude' => '-72.4465000',
                'city' => 'Walpole',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3609',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1333000',
                'longitude' => '-72.4465000',
                'city' => 'North Walpole',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3456',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0995000',
                'longitude' => '-72.1953000',
                'city' => 'Marlow',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3605',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0995000',
                'longitude' => '-72.1953000',
                'city' => 'Lempster',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3464',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0995000',
                'longitude' => '-72.1953000',
                'city' => 'Stoddard',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3832',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.9826000',
                'longitude' => '-71.1157000',
                'city' => 'Eaton Center',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3582',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.5732000',
                'longitude' => '-71.1897000',
                'city' => 'Groveton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3278',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2792000',
                'longitude' => '-71.8104000',
                'city' => 'Warner',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '4027',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0735000',
                'longitude' => '-70.7636000',
                'city' => 'Lebanon',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3261',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1291000',
                'longitude' => '-71.2431000',
                'city' => 'Northwood',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3290',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1291000',
                'longitude' => '-71.2431000',
                'city' => 'Nottingham',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3037',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1291000',
                'longitude' => '-71.2431000',
                'city' => 'Deerfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3440',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1176000',
                'longitude' => '-71.8940000',
                'city' => 'Antrim',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3244',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1176000',
                'longitude' => '-71.8940000',
                'city' => 'Hillsborough',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3049',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7387000',
                'longitude' => '-71.5846000',
                'city' => 'Hollis',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3581',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.3983000',
                'longitude' => '-71.2029000',
                'city' => 'Gorham',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3745',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5441000',
                'longitude' => '-72.2499000',
                'city' => 'Cornish',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3746',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5441000',
                'longitude' => '-72.2499000',
                'city' => 'Cornish Flat',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3770',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5441000',
                'longitude' => '-72.2499000',
                'city' => 'Meriden',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3887',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4975000',
                'longitude' => '-70.9612000',
                'city' => 'Union',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3852',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4975000',
                'longitude' => '-70.9612000',
                'city' => 'Milton Mills',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3851',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4975000',
                'longitude' => '-70.9612000',
                'city' => 'Milton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3032',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0515000',
                'longitude' => '-71.2905000',
                'city' => 'Auburn',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3082',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9785000',
                'longitude' => '-71.6950000',
                'city' => 'Lyndeborough',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3280',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1756000',
                'longitude' => '-72.0950000',
                'city' => 'Washington',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3224',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2007000',
                'longitude' => '-71.5348000',
                'city' => 'Canterbury',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3857',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0735000',
                'longitude' => '-70.7636000',
                'city' => 'Newmarket',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3584',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.4913000',
                'longitude' => '-71.5673000',
                'city' => 'Lancaster',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3287',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5295000',
                'longitude' => '-71.8695000',
                'city' => 'Wilmot',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3216',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5295000',
                'longitude' => '-71.8695000',
                'city' => 'Andover',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3076',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7299000',
                'longitude' => '-71.3214000',
                'city' => 'Pelham',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3816',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5859000',
                'longitude' => '-71.2114000',
                'city' => 'Center Tuftonboro',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3830',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5540000',
                'longitude' => '-71.0271000',
                'city' => 'East Wakefield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3240',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6472000',
                'longitude' => '-72.0131000',
                'city' => 'Grafton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3266',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6472000',
                'longitude' => '-72.0131000',
                'city' => 'Rumney',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3289',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5313000',
                'longitude' => '-71.4694000',
                'city' => 'Winnisquam',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3449',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9751000',
                'longitude' => '-71.9799000',
                'city' => 'Hancock',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3257',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4168000',
                'longitude' => '-71.9878000',
                'city' => 'New London',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3233',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4168000',
                'longitude' => '-71.9878000',
                'city' => 'Elkins',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3281',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0977000',
                'longitude' => '-71.7391000',
                'city' => 'Weare',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3461',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8133000',
                'longitude' => '-72.0224000',
                'city' => 'Rindge',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3452',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8133000',
                'longitude' => '-72.0224000',
                'city' => 'Jaffrey',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3890',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7547000',
                'longitude' => '-71.1486000',
                'city' => 'West Ossipee',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3836',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7547000',
                'longitude' => '-71.1486000',
                'city' => 'Freedom',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3850',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.6920000',
                'longitude' => '-71.3025000',
                'city' => 'Melvin Village',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3043',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9517000',
                'longitude' => '-71.8694000',
                'city' => 'Francestown',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3047',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9517000',
                'longitude' => '-71.8694000',
                'city' => 'Greenfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3444',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9083000',
                'longitude' => '-72.0456000',
                'city' => 'Dublin',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3061',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7610000',
                'longitude' => '-71.4634000',
                'city' => 'Nashua',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3241',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1472000',
                'longitude' => '-72.3592000',
                'city' => 'Hebron',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3279',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.9017000',
                'longitude' => '-72.1416000',
                'city' => 'Warren',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3885',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9797000',
                'longitude' => '-70.9519000',
                'city' => 'Stratham',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3442',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0304000',
                'longitude' => '-71.9346000',
                'city' => 'Bennington',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3268',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0309000',
                'longitude' => '-72.0203000',
                'city' => 'Salisbury',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3590',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.6016000',
                'longitude' => '-71.5140000',
                'city' => 'North Stratford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3771',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.2961000',
                'longitude' => '-72.0551000',
                'city' => 'Monroe',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3750',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7021000',
                'longitude' => '-72.2922000',
                'city' => 'Etna',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3756',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.7021000',
                'longitude' => '-72.2922000',
                'city' => 'Lebanon',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3084',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8432000',
                'longitude' => '-71.7331000',
                'city' => 'Temple',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3086',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.8432000',
                'longitude' => '-71.7331000',
                'city' => 'Wilton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3105',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Manchester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3111',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9935000',
                'longitude' => '-71.4608000',
                'city' => 'Manchester',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '4037',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0801000',
                'longitude' => '-71.2830000',
                'city' => 'Fryeburg',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3740',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0309000',
                'longitude' => '-72.0203000',
                'city' => 'Bath',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3231',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.4366000',
                'longitude' => '-71.8200000',
                'city' => 'East Andover',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3243',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5917000',
                'longitude' => '-71.7345000',
                'city' => 'Hill',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3293',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0339000',
                'longitude' => '-71.6895000',
                'city' => 'Woodstock',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3602',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.0802000',
                'longitude' => '-72.4247000',
                'city' => 'Alstead',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3255',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3834000',
                'longitude' => '-72.0816000',
                'city' => 'Newbury',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3284',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3834000',
                'longitude' => '-72.0816000',
                'city' => 'Springfield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3751',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3834000',
                'longitude' => '-72.0816000',
                'city' => 'Georges Mills',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3230',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.5274000',
                'longitude' => '-71.8557000',
                'city' => 'Danbury',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3765',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0918000',
                'longitude' => '-72.0248000',
                'city' => 'Haverhill',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3774',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0918000',
                'longitude' => '-72.0248000',
                'city' => 'North Haverhill',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3769',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.8102000',
                'longitude' => '-72.1550000',
                'city' => 'Lyme Center',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3585',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.2191000',
                'longitude' => '-71.7569000',
                'city' => 'Lisbon',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3580',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.2191000',
                'longitude' => '-71.7569000',
                'city' => 'Franconia',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3455',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9430000',
                'longitude' => '-72.0955000',
                'city' => 'Marlborough',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3457',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9430000',
                'longitude' => '-72.0955000',
                'city' => 'Nelson',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3450',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9430000',
                'longitude' => '-72.0955000',
                'city' => 'Harrisville',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3601',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1472000',
                'longitude' => '-72.3592000',
                'city' => 'Acworth',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3607',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.1472000',
                'longitude' => '-72.3592000',
                'city' => 'South Acworth',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3598',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.3717000',
                'longitude' => '-71.6145000',
                'city' => 'Whitefield',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3595',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.2701000',
                'longitude' => '-71.5501000',
                'city' => 'Twin Mountain',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3445',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9931000',
                'longitude' => '-72.1923000',
                'city' => 'Sullivan',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3753',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3634000',
                'longitude' => '-72.1684000',
                'city' => 'Grantham',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3752',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3634000',
                'longitude' => '-72.1684000',
                'city' => 'Goshen',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3071',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7659000',
                'longitude' => '-71.8107000',
                'city' => 'New Ipswich',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3073',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.7854000',
                'longitude' => '-71.2270000',
                'city' => 'North Salem',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3260',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3360000',
                'longitude' => '-71.9488000',
                'city' => 'North Sutton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3273',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3360000',
                'longitude' => '-71.9488000',
                'city' => 'South Sutton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3221',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.3360000',
                'longitude' => '-71.9488000',
                'city' => 'Bradford',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3272',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '43.2708000',
                'longitude' => '-71.9570000',
                'city' => 'South Newbury',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3871',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9830000',
                'longitude' => '-70.7698000',
                'city' => 'Rye Beach',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3843',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '42.9369000',
                'longitude' => '-70.8305000',
                'city' => 'Hampton',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3780',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0309000',
                'longitude' => '-72.0203000',
                'city' => 'Pike',
                'full_state' => 'New Hampshire',
            ],
            [
                'zip' => '3238',
                'country_code' => 'US',
                'state' => 'NH',
                'latitude' => '44.0309000',
                'longitude' => '-72.0203000',
                'city' => 'Glencliff',
                'full_state' => 'New Hampshire',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
