<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MontanaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '59347',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2665000',
                'longitude' => '-106.6509000',
                'city' => 'Rosebud',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59602',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6012000',
                'longitude' => '-112.0221000',
                'city' => 'Helena',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59601',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6012000',
                'longitude' => '-112.0221000',
                'city' => 'Helena',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59803',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8717000',
                'longitude' => '-113.9931000',
                'city' => 'Missoula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59802',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8717000',
                'longitude' => '-113.9931000',
                'city' => 'Missoula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59405',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5085000',
                'longitude' => '-111.2966000',
                'city' => 'Great Falls',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59404',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5085000',
                'longitude' => '-111.2966000',
                'city' => 'Great Falls',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59106',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7723000',
                'longitude' => '-108.5914000',
                'city' => 'Billings',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59101',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7723000',
                'longitude' => '-108.5914000',
                'city' => 'Billings',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59105',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7774000',
                'longitude' => '-108.5074000',
                'city' => 'Billings',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59102',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7774000',
                'longitude' => '-108.5074000',
                'city' => 'Billings',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59718',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6745000',
                'longitude' => '-111.0383000',
                'city' => 'Bozeman',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59868',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.1916000',
                'longitude' => '-113.5069000',
                'city' => 'Seeley Lake',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59901',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Kalispell',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59327',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8861000',
                'longitude' => '-106.5872000',
                'city' => 'Forsyth',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59401',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5188000',
                'longitude' => '-111.3349000',
                'city' => 'Great Falls',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59047',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6603000',
                'longitude' => '-110.5604000',
                'city' => 'Livingston',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59750',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9973000',
                'longitude' => '-112.5137000',
                'city' => 'Butte',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59030',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6647000',
                'longitude' => '-110.5590000',
                'city' => 'Gardiner',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59632',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2353000',
                'longitude' => '-112.1155000',
                'city' => 'Boulder',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59701',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2353000',
                'longitude' => '-112.1155000',
                'city' => 'Butte',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59631',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2353000',
                'longitude' => '-112.1155000',
                'city' => 'Basin',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59434',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4400000',
                'longitude' => '-113.2117000',
                'city' => 'East Glacier Park',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59635',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5907000',
                'longitude' => '-111.9165000',
                'city' => 'East Helena',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59230',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1937000',
                'longitude' => '-106.6411000',
                'city' => 'Glasgow',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59338',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4112000',
                'longitude' => '-105.8504000',
                'city' => 'Kinsey',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59301',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4112000',
                'longitude' => '-105.8504000',
                'city' => 'Miles City',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59648',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0003000',
                'longitude' => '-112.0617000',
                'city' => 'Wolf Creek',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59463',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0268000',
                'longitude' => '-110.7793000',
                'city' => 'Monarch',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59465',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0268000',
                'longitude' => '-110.7793000',
                'city' => 'Neihart',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59403',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0268000',
                'longitude' => '-110.7793000',
                'city' => 'Great Falls',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59806',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Missoula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59801',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Missoula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59851',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Milltown',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59847',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Lolo',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59840',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Hamilton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59808',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Missoula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59820',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Alberton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59807',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Missoula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59825',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Clinton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59804',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Missoula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59823',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8435000',
                'longitude' => '-114.0275000',
                'city' => 'Bonner',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59873',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5983000',
                'longitude' => '-115.3386000',
                'city' => 'Thompson Falls',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59812',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8709000',
                'longitude' => '-113.9865000',
                'city' => 'Missoula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59831',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3065000',
                'longitude' => '-114.3118000',
                'city' => 'Dixon',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59864',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Ronan',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59903',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Kalispell',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59910',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Big Arm',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59911',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Bigfork',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59920',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Kila',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59937',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Whitefish',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59932',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Somers',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59922',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1990000',
                'longitude' => '-114.3151000',
                'city' => 'Lakeside',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59501',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5514000',
                'longitude' => '-109.6770000',
                'city' => 'Havre',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59483',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5084000',
                'longitude' => '-111.8149000',
                'city' => 'Sun River',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59477',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5084000',
                'longitude' => '-111.8149000',
                'city' => 'Simms',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59443',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5084000',
                'longitude' => '-111.8149000',
                'city' => 'Fort Shaw',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59644',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.3204000',
                'longitude' => '-111.5149000',
                'city' => 'Townsend',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59643',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.3204000',
                'longitude' => '-111.5149000',
                'city' => 'Toston',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59727',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7498000',
                'longitude' => '-112.7497000',
                'city' => 'Divide',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59425',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Conrad',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59833',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.7567000',
                'longitude' => '-114.0770000',
                'city' => 'Florence',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59824',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5857000',
                'longitude' => '-114.0485000',
                'city' => 'Charlo',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59860',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5857000',
                'longitude' => '-114.0485000',
                'city' => 'Polson',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59724',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '44.6367000',
                'longitude' => '-112.5903000',
                'city' => 'Dell',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59725',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '44.6367000',
                'longitude' => '-112.5903000',
                'city' => 'Dillon',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59739',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '44.6367000',
                'longitude' => '-112.5903000',
                'city' => 'Lima',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59412',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3877000',
                'longitude' => '-110.9267000',
                'city' => 'Belt',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59486',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1685000',
                'longitude' => '-111.9454000',
                'city' => 'Valier',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59866',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.2917000',
                'longitude' => '-115.0880000',
                'city' => 'Saint Regis',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59741',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7586000',
                'longitude' => '-111.3084000',
                'city' => 'Manhattan',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59923',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3899000',
                'longitude' => '-115.5496000',
                'city' => 'Libby',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59714',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8563000',
                'longitude' => '-111.3323000',
                'city' => 'Belgrade',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59760',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8938000',
                'longitude' => '-111.5493000',
                'city' => 'Willow Creek',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59752',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8938000',
                'longitude' => '-111.5493000',
                'city' => 'Three Forks',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59211',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.6011000',
                'longitude' => '-104.4596000',
                'city' => 'Antelope',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59254',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.6011000',
                'longitude' => '-104.4596000',
                'city' => 'Plentywood',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59247',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.6011000',
                'longitude' => '-104.4596000',
                'city' => 'Medicine Lake',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59258',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.6011000',
                'longitude' => '-104.4596000',
                'city' => 'Reserve',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59721',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8720000',
                'longitude' => '-112.0992000',
                'city' => 'Cardwell',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59751',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8720000',
                'longitude' => '-112.0992000',
                'city' => 'Silver Star',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59759',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8720000',
                'longitude' => '-112.0992000',
                'city' => 'Whitehall',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59837',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6681000',
                'longitude' => '-113.1433000',
                'city' => 'Hall',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59733',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6681000',
                'longitude' => '-113.1433000',
                'city' => 'Gold Creek',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59832',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6681000',
                'longitude' => '-113.1433000',
                'city' => 'Drummond',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59019',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6419000',
                'longitude' => '-109.2556000',
                'city' => 'Columbus',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59530',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5582000',
                'longitude' => '-110.7713000',
                'city' => 'Inverness',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59522',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5582000',
                'longitude' => '-110.7713000',
                'city' => 'Chester',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59531',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5582000',
                'longitude' => '-110.7713000',
                'city' => 'Joplin',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59935',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4629000',
                'longitude' => '-115.8884000',
                'city' => 'Troy',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59930',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8818000',
                'longitude' => '-115.0505000',
                'city' => 'Rexford',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59917',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8818000',
                'longitude' => '-115.0505000',
                'city' => 'Eureka',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59715',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6745000',
                'longitude' => '-111.0383000',
                'city' => 'Bozeman',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59072',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4516000',
                'longitude' => '-108.5399000',
                'city' => 'Roundup',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59044',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6364000',
                'longitude' => '-109.2508000',
                'city' => 'Laurel',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59069',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7100000',
                'longitude' => '-109.5427000',
                'city' => 'Reed Point',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59061',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5143000',
                'longitude' => '-109.4478000',
                'city' => 'Nye',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59028',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5143000',
                'longitude' => '-109.4478000',
                'city' => 'Fishtail',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59071',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5143000',
                'longitude' => '-109.4478000',
                'city' => 'Roscoe',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59001',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5143000',
                'longitude' => '-109.4478000',
                'city' => 'Absarokee',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59065',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6647000',
                'longitude' => '-110.5590000',
                'city' => 'Pray',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59027',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6647000',
                'longitude' => '-110.5590000',
                'city' => 'Emigrant',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59484',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.9888000',
                'longitude' => '-111.9548000',
                'city' => 'Sweet Grass',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59427',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7306000',
                'longitude' => '-112.3635000',
                'city' => 'Cut Bank',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59417',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7306000',
                'longitude' => '-112.3635000',
                'city' => 'Browning',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59435',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7410000',
                'longitude' => '-111.9571000',
                'city' => 'Ethridge',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59454',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7410000',
                'longitude' => '-111.9571000',
                'city' => 'Kevin',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59466',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7410000',
                'longitude' => '-111.9571000',
                'city' => 'Oilmont',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59474',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7410000',
                'longitude' => '-111.9571000',
                'city' => 'Shelby',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59448',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5678000',
                'longitude' => '-113.0081000',
                'city' => 'Heart Butte',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59038',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2927000',
                'longitude' => '-107.2162000',
                'city' => 'Hysham',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59089',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.1255000',
                'longitude' => '-107.3977000',
                'city' => 'Wyola',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59330',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.1047000',
                'longitude' => '-104.7685000',
                'city' => 'Glendive',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59333',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2668000',
                'longitude' => '-106.4307000',
                'city' => 'Hathaway',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59037',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8969000',
                'longitude' => '-108.3024000',
                'city' => 'Huntley',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59829',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7196000',
                'longitude' => '-114.2657000',
                'city' => 'Darby',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59457',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0659000',
                'longitude' => '-109.4243000',
                'city' => 'Lewistown',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59521',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3169000',
                'longitude' => '-110.0177000',
                'city' => 'Box Elder',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59526',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5351000',
                'longitude' => '-108.7830000',
                'city' => 'Harlem',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59312',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8332000',
                'longitude' => '-106.2678000',
                'city' => 'Angela',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59322',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8332000',
                'longitude' => '-106.2678000',
                'city' => 'Cohagen',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59214',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8332000',
                'longitude' => '-106.2678000',
                'city' => 'Brockway',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59525',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5575000',
                'longitude' => '-110.5455000',
                'city' => 'Gildford',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59540',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5575000',
                'longitude' => '-110.5455000',
                'city' => 'Rudyard',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59523',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5926000',
                'longitude' => '-109.2235000',
                'city' => 'Chinook',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59039',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5986000',
                'longitude' => '-107.8703000',
                'city' => 'Ingomar',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59083',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5986000',
                'longitude' => '-107.8703000',
                'city' => 'Sumatra',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59054',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5986000',
                'longitude' => '-107.8703000',
                'city' => 'Melstone',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59639',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.9559000',
                'longitude' => '-112.6824000',
                'city' => 'Lincoln',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59241',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3935000',
                'longitude' => '-107.0811000',
                'city' => 'Hinsdale',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59223',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.2434000',
                'longitude' => '-106.5999000',
                'city' => 'Fort Peck',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59273',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.2434000',
                'longitude' => '-106.5999000',
                'city' => 'Vandalia',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59633',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8004000',
                'longitude' => '-112.2701000',
                'city' => 'Canyon Creek',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59870',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2458000',
                'longitude' => '-114.1591000',
                'city' => 'Stevensville',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59532',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5763000',
                'longitude' => '-110.0799000',
                'city' => 'Kremlin',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59079',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9022000',
                'longitude' => '-108.3817000',
                'city' => 'Shepherd',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59418',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.9780000',
                'longitude' => '-109.6951000',
                'city' => 'Buffalo',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59452',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.9780000',
                'longitude' => '-109.6951000',
                'city' => 'Hobson',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59464',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.9780000',
                'longitude' => '-109.6951000',
                'city' => 'Moore',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59460',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1753000',
                'longitude' => '-110.1072000',
                'city' => 'Loma',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59520',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1753000',
                'longitude' => '-110.1072000',
                'city' => 'Big Sandy',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59529',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8478000',
                'longitude' => '-108.4127000',
                'city' => 'Hogeland',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59537',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8478000',
                'longitude' => '-108.4127000',
                'city' => 'Loring',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59542',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8478000',
                'longitude' => '-108.4127000',
                'city' => 'Turner',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59872',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.1985000',
                'longitude' => '-114.8851000',
                'city' => 'Superior',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59524',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3974000',
                'longitude' => '-108.2440000',
                'city' => 'Dodson',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59275',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8651000',
                'longitude' => '-104.0516000',
                'city' => 'Westby',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59535',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.9326000',
                'longitude' => '-109.8804000',
                'city' => 'Lloyd',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59913',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3850000',
                'longitude' => '-114.0446000',
                'city' => 'Coram',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59926',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3850000',
                'longitude' => '-114.0446000',
                'city' => 'Martin City',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59912',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3850000',
                'longitude' => '-114.0446000',
                'city' => 'Columbia Falls',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59936',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3850000',
                'longitude' => '-114.0446000',
                'city' => 'West Glacier',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59919',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3850000',
                'longitude' => '-114.0446000',
                'city' => 'Hungry Horse',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59201',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4065000',
                'longitude' => '-105.7136000',
                'city' => 'Wolf Point',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59225',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4065000',
                'longitude' => '-105.7136000',
                'city' => 'Frazer',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59528',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5583000',
                'longitude' => '-110.4252000',
                'city' => 'Hingham',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59351',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2179000',
                'longitude' => '-105.6748000',
                'city' => 'Volborg',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59336',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2179000',
                'longitude' => '-105.6748000',
                'city' => 'Ismay',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59345',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2179000',
                'longitude' => '-105.6748000',
                'city' => 'Powderville',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59451',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0020000',
                'longitude' => '-109.8727000',
                'city' => 'Hilger',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59462',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0020000',
                'longitude' => '-109.8727000',
                'city' => 'Moccasin',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59068',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.1820000',
                'longitude' => '-109.2526000',
                'city' => 'Red Lodge',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59314',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4424000',
                'longitude' => '-105.4043000',
                'city' => 'Biddle',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59316',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4424000',
                'longitude' => '-105.4043000',
                'city' => 'Boyes',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59332',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4424000',
                'longitude' => '-105.4043000',
                'city' => 'Hammond',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59317',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4424000',
                'longitude' => '-105.4043000',
                'city' => 'Broadus',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59441',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0233000',
                'longitude' => '-108.8038000',
                'city' => 'Forest Grove',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59032',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0233000',
                'longitude' => '-108.8038000',
                'city' => 'Grass Range',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59087',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0064000',
                'longitude' => '-108.3477000',
                'city' => 'Winnett',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59058',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0064000',
                'longitude' => '-108.3477000',
                'city' => 'Mosby',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59634',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6012000',
                'longitude' => '-112.0221000',
                'city' => 'Clancy',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59624',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6012000',
                'longitude' => '-112.0221000',
                'city' => 'Helena',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59604',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6012000',
                'longitude' => '-112.0221000',
                'city' => 'Helena',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59545',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4768000',
                'longitude' => '-111.4734000',
                'city' => 'Whitlash',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59461',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4768000',
                'longitude' => '-111.4734000',
                'city' => 'Lothair',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59444',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4768000',
                'longitude' => '-111.4734000',
                'city' => 'Galata',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59270',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.7085000',
                'longitude' => '-104.1501000',
                'city' => 'Sidney',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59343',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4424000',
                'longitude' => '-105.4043000',
                'city' => 'Olive',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59620',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5896000',
                'longitude' => '-112.0391000',
                'city' => 'Helena',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59070',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3606000',
                'longitude' => '-109.1641000',
                'city' => 'Roberts',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59007',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.1854000',
                'longitude' => '-109.2448000',
                'city' => 'Bearcreek',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59623',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5896000',
                'longitude' => '-112.0391000',
                'city' => 'Helena',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59626',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5896000',
                'longitude' => '-112.0391000',
                'city' => 'Helena',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59636',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5896000',
                'longitude' => '-112.0391000',
                'city' => 'Fort Harrison',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59255',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3154000',
                'longitude' => '-105.0739000',
                'city' => 'Poplar',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59213',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3154000',
                'longitude' => '-105.0739000',
                'city' => 'Brockton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59414',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5085000',
                'longitude' => '-111.2966000',
                'city' => 'Black Eagle',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59456',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.2546000',
                'longitude' => '-110.9106000',
                'city' => 'Ledger',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59489',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5582000',
                'longitude' => '-109.3725000',
                'city' => 'Winifred',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59430',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5582000',
                'longitude' => '-109.3725000',
                'city' => 'Denton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59433',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.7149000',
                'longitude' => '-111.6846000',
                'city' => 'Dutton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59468',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.7149000',
                'longitude' => '-111.6846000',
                'city' => 'Power',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59471',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3336000',
                'longitude' => '-108.9579000',
                'city' => 'Roy',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59422',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.8121000',
                'longitude' => '-112.1760000',
                'city' => 'Choteau',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59487',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.6168000',
                'longitude' => '-111.9841000',
                'city' => 'Vaughn',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59436',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.6168000',
                'longitude' => '-111.9841000',
                'city' => 'Fairfield',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59421',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.2717000',
                'longitude' => '-111.6998000',
                'city' => 'Cascade',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59419',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.0770000',
                'longitude' => '-112.3003000',
                'city' => 'Bynum',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59467',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.0770000',
                'longitude' => '-112.3003000',
                'city' => 'Pendroy',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59432',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1924000',
                'longitude' => '-112.4971000',
                'city' => 'Dupuyer',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59036',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6807000',
                'longitude' => '-109.7540000',
                'city' => 'Harlowton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59453',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6807000',
                'longitude' => '-109.7540000',
                'city' => 'Judith Gap',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59222',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8047000',
                'longitude' => '-105.1702000',
                'city' => 'Flaxville',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59043',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6166000',
                'longitude' => '-106.6514000',
                'city' => 'Lame Deer',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59219',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5841000',
                'longitude' => '-104.1865000',
                'city' => 'Dagmar',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59008',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.0066000',
                'longitude' => '-108.3704000',
                'city' => 'Belfry',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59349',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4250000',
                'longitude' => '-105.5716000',
                'city' => 'Terry',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59215',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4250000',
                'longitude' => '-105.5716000',
                'city' => 'Circle',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59341',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8310000',
                'longitude' => '-105.1226000',
                'city' => 'Mildred',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59353',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8310000',
                'longitude' => '-105.1226000',
                'city' => 'Wibaux',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59326',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.8310000',
                'longitude' => '-105.1226000',
                'city' => 'Fallon',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59263',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7899000',
                'longitude' => '-105.4148000',
                'city' => 'Scobey',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59702',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.0144000',
                'longitude' => '-112.5357000',
                'city' => 'Butte',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59713',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5986000',
                'longitude' => '-112.5997000',
                'city' => 'Avon',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59728',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5986000',
                'longitude' => '-112.5997000',
                'city' => 'Elliston',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59703',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9973000',
                'longitude' => '-112.5137000',
                'city' => 'Butte',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59231',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4062000',
                'longitude' => '-106.5494000',
                'city' => 'Saint Marie',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59274',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1433000',
                'longitude' => '-105.5177000',
                'city' => 'Vida',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59248',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.0103000',
                'longitude' => '-106.4457000',
                'city' => 'Nashua',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59261',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.4631000',
                'longitude' => '-107.3380000',
                'city' => 'Saco',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59011',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.1006000',
                'longitude' => '-109.9597000',
                'city' => 'Big Timber',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59078',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.1006000',
                'longitude' => '-109.9597000',
                'city' => 'Shawmut',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59055',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.1006000',
                'longitude' => '-109.9597000',
                'city' => 'Melville',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59719',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6779000',
                'longitude' => '-111.0305000',
                'city' => 'Bozeman',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59771',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6779000',
                'longitude' => '-111.0305000',
                'city' => 'Bozeman',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59772',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6779000',
                'longitude' => '-111.0305000',
                'city' => 'Bozeman',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59642',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5471000',
                'longitude' => '-110.9024000',
                'city' => 'Ringling',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59645',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5471000',
                'longitude' => '-110.9024000',
                'city' => 'White Sulphur Springs',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59077',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3259000',
                'longitude' => '-106.9005000',
                'city' => 'Sand Springs',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59337',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3259000',
                'longitude' => '-106.9005000',
                'city' => 'Jordan',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59318',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3259000',
                'longitude' => '-106.9005000',
                'city' => 'Brusett',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59711',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.1234000',
                'longitude' => '-112.9486000',
                'city' => 'Anaconda',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59410',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4994000',
                'longitude' => '-112.3844000',
                'city' => 'Augusta',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59479',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.1509000',
                'longitude' => '-110.2156000',
                'city' => 'Stanford',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59424',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3203000',
                'longitude' => '-109.9456000',
                'city' => 'Coffee Creek',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59074',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.2999000',
                'longitude' => '-109.2550000',
                'city' => 'Ryegate',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59053',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4548000',
                'longitude' => '-110.3128000',
                'city' => 'Martinsdale',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59046',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4903000',
                'longitude' => '-109.0938000',
                'city' => 'Lavina',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59086',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9959000',
                'longitude' => '-110.6564000',
                'city' => 'Wilsall',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59730',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6779000',
                'longitude' => '-111.0305000',
                'city' => 'Gallatin Gateway',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59262',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4240000',
                'longitude' => '-104.9186000',
                'city' => 'Savage',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59315',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4240000',
                'longitude' => '-104.9186000',
                'city' => 'Bloomfield',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59339',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.2227000',
                'longitude' => '-105.1590000',
                'city' => 'Lindsay',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59313',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.6402000',
                'longitude' => '-104.2301000',
                'city' => 'Baker',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59103',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7774000',
                'longitude' => '-108.5074000',
                'city' => 'Billings',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59108',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7774000',
                'longitude' => '-108.5074000',
                'city' => 'Billings',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59016',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5321000',
                'longitude' => '-106.9547000',
                'city' => 'Busby',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59420',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.8227000',
                'longitude' => '-110.6632000',
                'city' => 'Carter',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59442',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.8227000',
                'longitude' => '-110.6632000',
                'city' => 'Fort Benton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59034',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7347000',
                'longitude' => '-107.5963000',
                'city' => 'Hardin',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59846',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0128000',
                'longitude' => '-114.2291000',
                'city' => 'Huson',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59834',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0128000',
                'longitude' => '-114.2291000',
                'city' => 'Frenchtown',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59416',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1266000',
                'longitude' => '-111.4828000',
                'city' => 'Brady',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59085',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4331000',
                'longitude' => '-109.8289000',
                'city' => 'Two Dot',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59063',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6310000',
                'longitude' => '-108.9173000',
                'city' => 'Park City',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59031',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6022000',
                'longitude' => '-107.4488000',
                'city' => 'Garryowen',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59022',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6022000',
                'longitude' => '-107.4488000',
                'city' => 'Crow Agency',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59050',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3151000',
                'longitude' => '-107.3673000',
                'city' => 'Lodge Grass',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59758',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '44.6583000',
                'longitude' => '-111.0982000',
                'city' => 'West Yellowstone',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59875',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4167000',
                'longitude' => '-114.1492000',
                'city' => 'Victor',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59828',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4167000',
                'longitude' => '-114.1492000',
                'city' => 'Corvallis',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59865',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4423000',
                'longitude' => '-114.1677000',
                'city' => 'Saint Ignatius',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59722',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.3926000',
                'longitude' => '-112.7322000',
                'city' => 'Deer Lodge',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59538',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3557000',
                'longitude' => '-107.8629000',
                'city' => 'Malta',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59014',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.2937000',
                'longitude' => '-108.9126000',
                'city' => 'Bridger',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59015',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9648000',
                'longitude' => '-109.2606000',
                'city' => 'Broadview',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59067',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9648000',
                'longitude' => '-109.2606000',
                'city' => 'Rapelje',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59075',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3093000',
                'longitude' => '-107.9472000',
                'city' => 'Saint Xavier',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59035',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3093000',
                'longitude' => '-107.9472000',
                'city' => 'Fort Smith',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59029',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3923000',
                'longitude' => '-108.9053000',
                'city' => 'Fromberg',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59057',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8651000',
                'longitude' => '-108.9295000',
                'city' => 'Molt',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59104',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7774000',
                'longitude' => '-108.5074000',
                'city' => 'Billings',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59107',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.7774000',
                'longitude' => '-108.5074000',
                'city' => 'Billings',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59546',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.9903000',
                'longitude' => '-108.6960000',
                'city' => 'Zortman',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59527',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.9903000',
                'longitude' => '-108.6960000',
                'city' => 'Hays',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59544',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7695000',
                'longitude' => '-107.6197000',
                'city' => 'Whitewater',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59855',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5984000',
                'longitude' => '-114.1141000',
                'city' => 'Pablo',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59842',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3882000',
                'longitude' => '-115.4070000',
                'city' => 'Haugan',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59867',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3882000',
                'longitude' => '-115.4070000',
                'city' => 'Saltese',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59830',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3882000',
                'longitude' => '-115.4070000',
                'city' => 'De Borgia',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59740',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3478000',
                'longitude' => '-111.7257000',
                'city' => 'Mc Allister',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59729',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3478000',
                'longitude' => '-111.7257000',
                'city' => 'Ennis',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59720',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3478000',
                'longitude' => '-111.7257000',
                'city' => 'Cameron',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59754',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5445000',
                'longitude' => '-112.3274000',
                'city' => 'Twin Bridges',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59745',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6987000',
                'longitude' => '-111.7818000',
                'city' => 'Norris',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59735',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6987000',
                'longitude' => '-111.7818000',
                'city' => 'Harrison',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59747',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6987000',
                'longitude' => '-111.7818000',
                'city' => 'Pony',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59018',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8927000',
                'longitude' => '-110.6006000',
                'city' => 'Clyde Park',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59761',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6170000',
                'longitude' => '-113.4471000',
                'city' => 'Wisdom',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59762',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6170000',
                'longitude' => '-113.4471000',
                'city' => 'Wise River',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59756',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.1766000',
                'longitude' => '-112.7926000',
                'city' => 'Warm Springs',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59003',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8861000',
                'longitude' => '-106.5872000',
                'city' => 'Ashland',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59240',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7933000',
                'longitude' => '-106.2414000',
                'city' => 'Glentana',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59260',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7933000',
                'longitude' => '-106.2414000',
                'city' => 'Richland',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59250',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7933000',
                'longitude' => '-106.2414000',
                'city' => 'Opheim',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59244',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5768000',
                'longitude' => '-106.2086000',
                'city' => 'Larslan',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59821',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.1665000',
                'longitude' => '-114.0808000',
                'city' => 'Arlee',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59402',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5085000',
                'longitude' => '-111.2966000',
                'city' => 'Malmstrom A F B',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59411',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7462000',
                'longitude' => '-113.4233000',
                'city' => 'Babb',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59450',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5876000',
                'longitude' => '-110.7872000',
                'city' => 'Highwood',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59440',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.7818000',
                'longitude' => '-110.9546000',
                'city' => 'Floweree',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59469',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.2656000',
                'longitude' => '-110.4964000',
                'city' => 'Raynesford',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59447',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.2656000',
                'longitude' => '-110.4964000',
                'city' => 'Geyser',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59480',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3574000',
                'longitude' => '-111.1639000',
                'city' => 'Stockett',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59472',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3574000',
                'longitude' => '-111.1639000',
                'city' => 'Sand Coulee',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59446',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.6057000',
                'longitude' => '-110.2609000',
                'city' => 'Geraldine',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59323',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8861000',
                'longitude' => '-106.5872000',
                'city' => 'Colstrip',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59845',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.6077000',
                'longitude' => '-114.6551000',
                'city' => 'Hot Springs',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59221',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.8504000',
                'longitude' => '-104.0439000',
                'city' => 'Fairview',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59863',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.3255000',
                'longitude' => '-114.0879000',
                'city' => 'Ravalli',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59826',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5245000',
                'longitude' => '-113.7067000',
                'city' => 'Condon',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59025',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.0238000',
                'longitude' => '-106.8459000',
                'city' => 'Decker',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '82423',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.0065000',
                'longitude' => '-108.6049000',
                'city' => 'Frannie',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59242',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3378000',
                'longitude' => '-104.4907000',
                'city' => 'Homestead',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59226',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.3378000',
                'longitude' => '-104.4907000',
                'city' => 'Froid',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59311',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '44.6840000',
                'longitude' => '-104.5979000',
                'city' => 'Alzada',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59212',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1384000',
                'longitude' => '-104.2221000',
                'city' => 'Bainville',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59344',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4235000',
                'longitude' => '-104.5048000',
                'city' => 'Plevna',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59259',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.6422000',
                'longitude' => '-105.0715000',
                'city' => 'Richey',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59243',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.6813000',
                'longitude' => '-104.6236000',
                'city' => 'Lambert',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59354',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8844000',
                'longitude' => '-104.5302000',
                'city' => 'Willard',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59324',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8844000',
                'longitude' => '-104.5302000',
                'city' => 'Ekalaka',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59276',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7319000',
                'longitude' => '-105.1659000',
                'city' => 'Whitetail',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59257',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7319000',
                'longitude' => '-105.1659000',
                'city' => 'Redstone',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59041',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6419000',
                'longitude' => '-109.2556000',
                'city' => 'Joliet',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59062',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5898000',
                'longitude' => '-106.2482000',
                'city' => 'Otter',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59218',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1493000',
                'longitude' => '-104.9165000',
                'city' => 'Culbertson',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59843',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0156000',
                'longitude' => '-113.1241000',
                'city' => 'Helmville',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59854',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.0156000',
                'longitude' => '-113.1241000',
                'city' => 'Ovando',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59871',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.0245000',
                'longitude' => '-114.1752000',
                'city' => 'Sula',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59827',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.0245000',
                'longitude' => '-114.1752000',
                'city' => 'Conner',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59856',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4574000',
                'longitude' => '-114.8772000',
                'city' => 'Paradise',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59859',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4574000',
                'longitude' => '-114.8772000',
                'city' => 'Plains',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59874',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.5945000',
                'longitude' => '-115.3464000',
                'city' => 'Trout Creek',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59746',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3642000',
                'longitude' => '-113.4073000',
                'city' => 'Polaris',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59736',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3642000',
                'longitude' => '-113.4073000',
                'city' => 'Jackson',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59732',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6327000',
                'longitude' => '-112.6824000',
                'city' => 'Glen',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59743',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6327000',
                'longitude' => '-112.6824000',
                'city' => 'Melrose',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59020',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.0192000',
                'longitude' => '-109.9320000',
                'city' => 'Cooke City',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59081',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.0192000',
                'longitude' => '-109.9320000',
                'city' => 'Silver Gate',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59710',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4548000',
                'longitude' => '-112.1934000',
                'city' => 'Alder',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59749',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4548000',
                'longitude' => '-112.1934000',
                'city' => 'Sheridan',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59755',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.2930000',
                'longitude' => '-111.9546000',
                'city' => 'Virginia City',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59931',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.0198000',
                'longitude' => '-114.2147000',
                'city' => 'Rollins',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59731',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.3971000',
                'longitude' => '-112.7310000',
                'city' => 'Garrison',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59853',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.9936000',
                'longitude' => '-115.7784000',
                'city' => 'Noxon',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59844',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.9936000',
                'longitude' => '-115.7784000',
                'city' => 'Heron',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59929',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.8356000',
                'longitude' => '-114.3444000',
                'city' => 'Proctor',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59915',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.8356000',
                'longitude' => '-114.3444000',
                'city' => 'Elmo',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59914',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.8356000',
                'longitude' => '-114.3444000',
                'city' => 'Dayton',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59925',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.1010000',
                'longitude' => '-114.6661000',
                'city' => 'Marion',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59010',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.1276000',
                'longitude' => '-107.5584000',
                'city' => 'Bighorn',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59024',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.1276000',
                'longitude' => '-107.5584000',
                'city' => 'Custer',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59858',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.3337000',
                'longitude' => '-113.2950000',
                'city' => 'Philipsburg',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59485',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '47.4313000',
                'longitude' => '-111.5068000',
                'city' => 'Ulm',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59088',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9567000',
                'longitude' => '-108.1590000',
                'city' => 'Worden',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59064',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9567000',
                'longitude' => '-108.1590000',
                'city' => 'Pompeys Pillar',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59927',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5499000',
                'longitude' => '-114.5761000',
                'city' => 'Olney',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59933',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8682000',
                'longitude' => '-115.0115000',
                'city' => 'Stryker',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59918',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8682000',
                'longitude' => '-115.0115000',
                'city' => 'Fortine',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59934',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8682000',
                'longitude' => '-115.0115000',
                'city' => 'Trego',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59928',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5026000',
                'longitude' => '-113.9792000',
                'city' => 'Polebridge',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59921',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5026000',
                'longitude' => '-113.9792000',
                'city' => 'Lake Mc Donald',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59916',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.5026000',
                'longitude' => '-113.9792000',
                'city' => 'Essex',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59253',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.7858000',
                'longitude' => '-105.8420000',
                'city' => 'Peerless',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59256',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8912000',
                'longitude' => '-104.7790000',
                'city' => 'Raymond',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59252',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8912000',
                'longitude' => '-104.7790000',
                'city' => 'Outlook',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59052',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8341000',
                'longitude' => '-109.9464000',
                'city' => 'Mc Leod',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59033',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.8341000',
                'longitude' => '-109.9464000',
                'city' => 'Greycliff',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59638',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.4641000',
                'longitude' => '-111.9810000',
                'city' => 'Jefferson City',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59482',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '48.8841000',
                'longitude' => '-111.9082000',
                'city' => 'Sunburst',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59059',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.5181000',
                'longitude' => '-108.0846000',
                'city' => 'Musselshell',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59841',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '46.3146000',
                'longitude' => '-114.1147000',
                'city' => 'Pinesdale',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59013',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4829000',
                'longitude' => '-108.9682000',
                'city' => 'Boyd',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59026',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.4829000',
                'longitude' => '-108.9682000',
                'city' => 'Edgar',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59006',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.9567000',
                'longitude' => '-108.1590000',
                'city' => 'Ballantine',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '57724',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5519000',
                'longitude' => '-103.9753000',
                'city' => 'Camp Crook',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59319',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.5519000',
                'longitude' => '-103.9753000',
                'city' => 'Capitol',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59012',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.3153000',
                'longitude' => '-106.5048000',
                'city' => 'Birney',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59717',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.6789000',
                'longitude' => '-111.0369000',
                'city' => 'Bozeman',
                'full_state' => 'Montana',
            ],
            [
                'zip' => '59716',
                'country_code' => 'US',
                'state' => 'MT',
                'latitude' => '45.2670000',
                'longitude' => '-111.2903000',
                'city' => 'Big Sky',
                'full_state' => 'Montana',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
