<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MichiganSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '49305',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7415000',
                'longitude' => '-85.2931000',
                'city' => 'Barryton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49332',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7415000',
                'longitude' => '-85.2931000',
                'city' => 'Mecosta',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49706',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4413000',
                'longitude' => '-84.7908000',
                'city' => 'Alanson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49633',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5730000',
                'longitude' => '-85.3507000',
                'city' => 'Fife Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49716',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4926000',
                'longitude' => '-84.7858000',
                'city' => 'Brutus',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49441',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2362000',
                'longitude' => '-86.2433000',
                'city' => 'Muskegon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49452',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2362000',
                'longitude' => '-86.2433000',
                'city' => 'Rothbury',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49444',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2362000',
                'longitude' => '-86.2433000',
                'city' => 'Muskegon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49640',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6670000',
                'longitude' => '-86.0282000',
                'city' => 'Honor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49713',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.1682000',
                'longitude' => '-84.9185000',
                'city' => 'Boyne Falls',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49682',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9739000',
                'longitude' => '-85.6576000',
                'city' => 'Suttons Bay',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49656',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0341000',
                'longitude' => '-85.4488000',
                'city' => 'Luther',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49688',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0341000',
                'longitude' => '-85.4488000',
                'city' => 'Tustin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49442',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2362000',
                'longitude' => '-86.2433000',
                'city' => 'Muskegon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49614',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4151000',
                'longitude' => '-86.1522000',
                'city' => 'Bear Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49684',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.7682000',
                'longitude' => '-85.6085000',
                'city' => 'Traverse City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49685',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.7682000',
                'longitude' => '-85.6085000',
                'city' => 'Traverse City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49686',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.7682000',
                'longitude' => '-85.6085000',
                'city' => 'Traverse City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49667',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3361000',
                'longitude' => '-84.9434000',
                'city' => 'Merritt',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49727',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.1502000',
                'longitude' => '-85.1352000',
                'city' => 'East Jordan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49673',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9088000',
                'longitude' => '-85.5095000',
                'city' => 'Old Mission',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49412',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4678000',
                'longitude' => '-85.9426000',
                'city' => 'Fremont',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49664',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8481000',
                'longitude' => '-85.9516000',
                'city' => 'Maple City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49636',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8481000',
                'longitude' => '-85.9516000',
                'city' => 'Glen Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49625',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Copemish',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49630',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8490000',
                'longitude' => '-85.7956000',
                'city' => 'Empire',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49621',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8490000',
                'longitude' => '-85.7956000',
                'city' => 'Cedar',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48653',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4664000',
                'longitude' => '-85.0007000',
                'city' => 'Roscommon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49651',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4664000',
                'longitude' => '-85.0007000',
                'city' => 'Lake City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49730',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0664000',
                'longitude' => '-84.8525000',
                'city' => 'Elmira',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49431',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9499000',
                'longitude' => '-86.4548000',
                'city' => 'Ludington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49755',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.6354000',
                'longitude' => '-84.7954000',
                'city' => 'Levering',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49720',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.3141000',
                'longitude' => '-85.2632000',
                'city' => 'Charlevoix',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49721',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4108000',
                'longitude' => '-84.6127000',
                'city' => 'Cheboygan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49705',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4108000',
                'longitude' => '-84.6127000',
                'city' => 'Afton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49791',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4108000',
                'longitude' => '-84.6127000',
                'city' => 'Topinabee',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49749',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4108000',
                'longitude' => '-84.6127000',
                'city' => 'Indian River',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49650',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.7248000',
                'longitude' => '-85.8425000',
                'city' => 'Lake Ann',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49449',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7839000',
                'longitude' => '-86.4225000',
                'city' => 'Pentwater',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49740',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4309000',
                'longitude' => '-84.9873000',
                'city' => 'Harbor Springs',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49723',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4309000',
                'longitude' => '-84.9873000',
                'city' => 'Cross Village',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49307',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6993000',
                'longitude' => '-85.4864000',
                'city' => 'Big Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49675',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3672000',
                'longitude' => '-86.2042000',
                'city' => 'Onekama',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49653',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9823000',
                'longitude' => '-85.7177000',
                'city' => 'Lake Leelanau',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49654',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9823000',
                'longitude' => '-85.7177000',
                'city' => 'Leland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49646',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.7311000',
                'longitude' => '-85.1779000',
                'city' => 'Kalkaska',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49676',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.7311000',
                'longitude' => '-85.1779000',
                'city' => 'Rapid City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49455',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6090000',
                'longitude' => '-86.3683000',
                'city' => 'Shelby',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49620',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5862000',
                'longitude' => '-85.5394000',
                'city' => 'Buckley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49649',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5862000',
                'longitude' => '-85.5394000',
                'city' => 'Kingsley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49637',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5862000',
                'longitude' => '-85.5394000',
                'city' => 'Grawn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49666',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5862000',
                'longitude' => '-85.5394000',
                'city' => 'Mayfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49643',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5862000',
                'longitude' => '-85.5394000',
                'city' => 'Interlochen',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49629',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8970000',
                'longitude' => '-85.4150000',
                'city' => 'Elk Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49648',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8970000',
                'longitude' => '-85.4150000',
                'city' => 'Kewadin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49690',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8970000',
                'longitude' => '-85.4150000',
                'city' => 'Williamsburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49644',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.1045000',
                'longitude' => '-85.9852000',
                'city' => 'Irons',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49304',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.1045000',
                'longitude' => '-85.9852000',
                'city' => 'Baldwin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49683',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5033000',
                'longitude' => '-85.7011000',
                'city' => 'Thompsonville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49668',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5033000',
                'longitude' => '-85.7011000',
                'city' => 'Mesick',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49670',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9757000',
                'longitude' => '-85.6487000',
                'city' => 'Northport',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49327',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3334000',
                'longitude' => '-85.8082000',
                'city' => 'Grant',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49509',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2362000',
                'longitude' => '-86.2433000',
                'city' => 'Wyoming',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49420',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6999000',
                'longitude' => '-86.3711000',
                'city' => 'Hart',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49770',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.3738000',
                'longitude' => '-84.9518000',
                'city' => 'Petoskey',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49665',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Marion',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49601',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2490000',
                'longitude' => '-85.4030000',
                'city' => 'Cadillac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49336',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4855000',
                'longitude' => '-85.4446000',
                'city' => 'Morley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49660',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2497000',
                'longitude' => '-86.3332000',
                'city' => 'Manistee',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49635',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6326000',
                'longitude' => '-86.2464000',
                'city' => 'Frankfort',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49712',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.2198000',
                'longitude' => '-85.0184000',
                'city' => 'Boyne City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49701',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7810000',
                'longitude' => '-84.7332000',
                'city' => 'Mackinaw City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49617',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6670000',
                'longitude' => '-86.0282000',
                'city' => 'Beulah',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49632',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3321000',
                'longitude' => '-84.9466000',
                'city' => 'Falmouth',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49612',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8835000',
                'longitude' => '-85.2773000',
                'city' => 'Alden',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49659',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8835000',
                'longitude' => '-85.2773000',
                'city' => 'Mancelona',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49615',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8835000',
                'longitude' => '-85.2773000',
                'city' => 'Bellaire',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49657',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.1945000',
                'longitude' => '-85.2188000',
                'city' => 'Mc Bain',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49677',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8734000',
                'longitude' => '-85.5098000',
                'city' => 'Reed City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49454',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9512000',
                'longitude' => '-86.2870000',
                'city' => 'Scottville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49628',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6344000',
                'longitude' => '-86.2376000',
                'city' => 'Elberta',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49322',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3109000',
                'longitude' => '-85.3566000',
                'city' => 'Coral',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49622',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0668000',
                'longitude' => '-85.2702000',
                'city' => 'Central Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49619',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3694000',
                'longitude' => '-86.0121000',
                'city' => 'Brethren',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49645',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3694000',
                'longitude' => '-86.0121000',
                'city' => 'Kaleva',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49799',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.2784000',
                'longitude' => '-84.6025000',
                'city' => 'Wolverine',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49415',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1244000',
                'longitude' => '-86.1634000',
                'city' => 'Fruitport',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49680',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6391000',
                'longitude' => '-85.2521000',
                'city' => 'South Boardman',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49631',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9015000',
                'longitude' => '-85.2687000',
                'city' => 'Evart',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49674',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.1312000',
                'longitude' => '-85.6130000',
                'city' => 'Omena',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49638',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3114000',
                'longitude' => '-85.6986000',
                'city' => 'Harrietta',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49626',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2472000',
                'longitude' => '-86.3266000',
                'city' => 'Eastlake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49346',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5743000',
                'longitude' => '-85.4537000',
                'city' => 'Stanwood',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49337',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4157000',
                'longitude' => '-85.8024000',
                'city' => 'Newaygo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49405',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8515000',
                'longitude' => '-86.0664000',
                'city' => 'Custer',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49459',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8515000',
                'longitude' => '-86.0664000',
                'city' => 'Walkerville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49718',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7850000',
                'longitude' => '-84.7299000',
                'city' => 'Carp Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49782',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7466000',
                'longitude' => '-85.5183000',
                'city' => 'Beaver Island',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49421',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5677000',
                'longitude' => '-86.0318000',
                'city' => 'Hesperia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49440',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1914000',
                'longitude' => '-86.2629000',
                'city' => 'Muskegon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49402',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0502000',
                'longitude' => '-86.2179000',
                'city' => 'Branch',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49411',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0502000',
                'longitude' => '-86.2179000',
                'city' => 'Free Soil',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49410',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0502000',
                'longitude' => '-86.2179000',
                'city' => 'Fountain',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49338',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6993000',
                'longitude' => '-85.4864000',
                'city' => 'Paris',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49796',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.2698000',
                'longitude' => '-84.9324000',
                'city' => 'Walloon Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49769',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.5526000',
                'longitude' => '-84.7888000',
                'city' => 'Pellston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49729',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0708000',
                'longitude' => '-85.2670000',
                'city' => 'Ellsworth',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49735',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0732000',
                'longitude' => '-84.8171000',
                'city' => 'Gaylord',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49717',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4406000',
                'longitude' => '-84.7762000',
                'city' => 'Burt Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49795',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.1659000',
                'longitude' => '-84.9129000',
                'city' => 'Vanderbilt',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49456',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2362000',
                'longitude' => '-86.2433000',
                'city' => 'Spring Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49611',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9742000',
                'longitude' => '-84.9654000',
                'city' => 'Alba',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49946',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6993000',
                'longitude' => '-85.4864000',
                'city' => 'Lanse',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49627',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.1073000',
                'longitude' => '-85.3567000',
                'city' => 'Eastport',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49775',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7346000',
                'longitude' => '-84.4765000',
                'city' => 'Pointe Aux Pins',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49329',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3934000',
                'longitude' => '-85.4658000',
                'city' => 'Howard City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49689',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.1831000',
                'longitude' => '-85.9311000',
                'city' => 'Wellston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49349',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5530000',
                'longitude' => '-85.7757000',
                'city' => 'White Cloud',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49457',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2576000',
                'longitude' => '-86.2700000',
                'city' => 'Twin Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49445',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2576000',
                'longitude' => '-86.2700000',
                'city' => 'Muskegon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49679',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9032000',
                'longitude' => '-85.2601000',
                'city' => 'Sears',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48625',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.1009000',
                'longitude' => '-85.1467000',
                'city' => 'Harrison',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49309',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8980000',
                'longitude' => '-85.8548000',
                'city' => 'Bitely',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49642',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8980000',
                'longitude' => '-85.8548000',
                'city' => 'Idlewild',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49458',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9530000',
                'longitude' => '-86.2783000',
                'city' => 'Walhalla',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49461',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3404000',
                'longitude' => '-86.2790000',
                'city' => 'Whitehall',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49655',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0404000',
                'longitude' => '-85.4511000',
                'city' => 'Leroy',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49451',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2338000',
                'longitude' => '-86.1076000',
                'city' => 'Ravenna',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49425',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4084000',
                'longitude' => '-86.0820000',
                'city' => 'Holton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49663',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4118000',
                'longitude' => '-85.3984000',
                'city' => 'Manton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49623',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8734000',
                'longitude' => '-85.5098000',
                'city' => 'Chase',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49639',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8734000',
                'longitude' => '-85.5098000',
                'city' => 'Hersey',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49303',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3356000',
                'longitude' => '-85.8137000',
                'city' => 'Bailey',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49330',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3356000',
                'longitude' => '-85.8137000',
                'city' => 'Kent City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49403',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1912000',
                'longitude' => '-85.9390000',
                'city' => 'Conklin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49446',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6130000',
                'longitude' => '-86.3652000',
                'city' => 'New Era',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49448',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1365000',
                'longitude' => '-86.1542000',
                'city' => 'Nunica',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49320',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7438000',
                'longitude' => '-85.2986000',
                'city' => 'Chippewa Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49342',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7438000',
                'longitude' => '-85.2986000',
                'city' => 'Rodney',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49436',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6995000',
                'longitude' => '-86.3570000',
                'city' => 'Mears',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49616',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6299000',
                'longitude' => '-86.0941000',
                'city' => 'Benzonia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49613',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3672000',
                'longitude' => '-86.2042000',
                'city' => 'Arcadia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49437',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4106000',
                'longitude' => '-86.3478000',
                'city' => 'Montague',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49339',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3957000',
                'longitude' => '-85.4712000',
                'city' => 'Pierson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49340',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6290000',
                'longitude' => '-85.2654000',
                'city' => 'Remus',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48075',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4841000',
                'longitude' => '-83.2597000',
                'city' => 'Southfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48076',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4841000',
                'longitude' => '-83.2597000',
                'city' => 'Southfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48340',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Pontiac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48341',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Pontiac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48304',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5457000',
                'longitude' => '-83.2167000',
                'city' => 'Bloomfield Hills',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48025',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5457000',
                'longitude' => '-83.2167000',
                'city' => 'Franklin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48301',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5457000',
                'longitude' => '-83.2167000',
                'city' => 'Bloomfield Hills',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48302',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5457000',
                'longitude' => '-83.2167000',
                'city' => 'Bloomfield Hills',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48084',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5457000',
                'longitude' => '-83.2167000',
                'city' => 'Troy',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48009',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5457000',
                'longitude' => '-83.2167000',
                'city' => 'Birmingham',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48034',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Southfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48150',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Livonia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48226',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48098',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Troy',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48381',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4324000',
                'longitude' => '-83.4823000',
                'city' => 'Milford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48167',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4324000',
                'longitude' => '-83.4823000',
                'city' => 'Northville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48342',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Pontiac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48326',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Auburn Hills',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48328',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Waterford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48329',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Waterford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48382',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Commerce Township',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48442',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Holly',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48309',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Rochester',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48331',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Farmington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48380',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7908000',
                'longitude' => '-83.6262000',
                'city' => 'Milford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48085',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'Troy',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48071',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'Madison Heights',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48307',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6813000',
                'longitude' => '-83.1348000',
                'city' => 'Rochester',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48334',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'Farmington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48073',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'Royal Oak',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48037',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'Southfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48237',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'Oak Park',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48336',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5417000',
                'longitude' => '-83.2200000',
                'city' => 'Farmington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48219',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4707000',
                'longitude' => '-83.2778000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48348',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8248000',
                'longitude' => '-83.2643000',
                'city' => 'Clarkston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48367',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8248000',
                'longitude' => '-83.2643000',
                'city' => 'Leonard',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48371',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8248000',
                'longitude' => '-83.2643000',
                'city' => 'Oxford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48430',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7908000',
                'longitude' => '-83.6262000',
                'city' => 'Fenton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48350',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7908000',
                'longitude' => '-83.6262000',
                'city' => 'Davisburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48235',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48083',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5480000',
                'longitude' => '-83.1858000',
                'city' => 'Troy',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48091',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7908000',
                'longitude' => '-83.6262000',
                'city' => 'Warren',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48067',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4707000',
                'longitude' => '-83.2778000',
                'city' => 'Royal Oak',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48089',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5313000',
                'longitude' => '-83.3660000',
                'city' => 'Warren',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48007',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5313000',
                'longitude' => '-83.3660000',
                'city' => 'Troy',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48390',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5357000',
                'longitude' => '-83.4854000',
                'city' => 'Walled Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48370',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8272000',
                'longitude' => '-83.2697000',
                'city' => 'Oxford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48346',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6843000',
                'longitude' => '-83.3719000',
                'city' => 'Clarkston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48135',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Garden City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48044',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4738000',
                'longitude' => '-83.2608000',
                'city' => 'Macomb',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48038',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4738000',
                'longitude' => '-83.2608000',
                'city' => 'Clinton Township',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48178',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4578000',
                'longitude' => '-83.6494000',
                'city' => 'South Lyon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48360',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6781000',
                'longitude' => '-83.2245000',
                'city' => 'Lake Orion',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48359',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6781000',
                'longitude' => '-83.2245000',
                'city' => 'Lake Orion',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48306',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6781000',
                'longitude' => '-83.2245000',
                'city' => 'Rochester',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48017',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5480000',
                'longitude' => '-83.1858000',
                'city' => 'Clawson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48072',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5480000',
                'longitude' => '-83.1858000',
                'city' => 'Berkley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48240',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4486000',
                'longitude' => '-83.2524000',
                'city' => 'Redford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48165',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7822000',
                'longitude' => '-83.2410000',
                'city' => 'New Hudson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48375',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4387000',
                'longitude' => '-83.4844000',
                'city' => 'Novi',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48374',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4387000',
                'longitude' => '-83.4844000',
                'city' => 'Novi',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48377',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4387000',
                'longitude' => '-83.4844000',
                'city' => 'Novi',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48393',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4387000',
                'longitude' => '-83.4844000',
                'city' => 'Wixom',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48069',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'Pleasant Ridge',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48322',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5146000',
                'longitude' => '-83.4012000',
                'city' => 'West Bloomfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48243',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3320000',
                'longitude' => '-83.0510000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48233',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3320000',
                'longitude' => '-83.0510000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48357',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5929000',
                'longitude' => '-83.5909000',
                'city' => 'Highland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48335',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Farmington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48070',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4486000',
                'longitude' => '-83.2524000',
                'city' => 'Huntington Woods',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48220',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4857000',
                'longitude' => '-83.1425000',
                'city' => 'Ferndale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48030',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4857000',
                'longitude' => '-83.1425000',
                'city' => 'Hazel Park',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48227',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4841000',
                'longitude' => '-83.2597000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48362',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Lake Orion',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48323',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5313000',
                'longitude' => '-83.3660000',
                'city' => 'West Bloomfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48324',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5313000',
                'longitude' => '-83.3660000',
                'city' => 'West Bloomfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48386',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5934000',
                'longitude' => '-83.4458000',
                'city' => 'White Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48327',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5934000',
                'longitude' => '-83.4458000',
                'city' => 'Waterford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48446',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4841000',
                'longitude' => '-83.2597000',
                'city' => 'Lapeer',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48843',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4841000',
                'longitude' => '-83.2597000',
                'city' => 'Howell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48383',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'White Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48066',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4738000',
                'longitude' => '-83.2608000',
                'city' => 'Roseville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48347',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6843000',
                'longitude' => '-83.3719000',
                'city' => 'Clarkston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48080',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4841000',
                'longitude' => '-83.2597000',
                'city' => 'Saint Clair Shores',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48124',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Dearborn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48321',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Auburn Hills',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48152',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5591000',
                'longitude' => '-83.1260000',
                'city' => 'Livonia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48116',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4601000',
                'longitude' => '-83.6548000',
                'city' => 'Brighton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48170',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6473000',
                'longitude' => '-83.3005000',
                'city' => 'Plymouth',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48412',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6386000',
                'longitude' => '-83.2931000',
                'city' => 'Attica',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48216',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3304000',
                'longitude' => '-83.0596000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48197',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4486000',
                'longitude' => '-83.2524000',
                'city' => 'Ypsilanti',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48114',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5591000',
                'longitude' => '-83.1260000',
                'city' => 'Brighton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48026',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5591000',
                'longitude' => '-83.1260000',
                'city' => 'Fraser',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48317',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Utica',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48099',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4738000',
                'longitude' => '-83.2608000',
                'city' => 'Troy',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48316',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6979000',
                'longitude' => '-83.1357000',
                'city' => 'Utica',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48438',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8537000',
                'longitude' => '-83.4516000',
                'city' => 'Goodrich',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48462',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8537000',
                'longitude' => '-83.4516000',
                'city' => 'Ortonville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48094',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6979000',
                'longitude' => '-83.1357000',
                'city' => 'Washington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48068',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4834000',
                'longitude' => '-83.1372000',
                'city' => 'Royal Oak',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48376',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4324000',
                'longitude' => '-83.4823000',
                'city' => 'Novi',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48201',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3343000',
                'longitude' => '-83.0563000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48455',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6348000',
                'longitude' => '-83.2237000',
                'city' => 'Metamora',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48320',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6236000',
                'longitude' => '-83.3561000',
                'city' => 'Keego Harbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48363',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7885000',
                'longitude' => '-83.2431000',
                'city' => 'Oakland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49341',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6214000',
                'longitude' => '-83.1693000',
                'city' => 'Rockford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48356',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Highland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48504',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5313000',
                'longitude' => '-83.3660000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48153',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4324000',
                'longitude' => '-83.4823000',
                'city' => 'Livonia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48168',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4324000',
                'longitude' => '-83.4823000',
                'city' => 'Northville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48186',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3300000',
                'longitude' => '-83.4208000',
                'city' => 'Westland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48174',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Romulus',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48332',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4658000',
                'longitude' => '-83.3758000',
                'city' => 'Farmington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48703',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4739000',
                'longitude' => '-83.2246000',
                'city' => 'Au Gres',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48236',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Grosse Pointe',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48353',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6561000',
                'longitude' => '-83.5760000',
                'city' => 'Hartland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48242',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7323000',
                'longitude' => '-83.4199000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48308',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6402000',
                'longitude' => '-83.2845000',
                'city' => 'Rochester',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49053',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2945000',
                'longitude' => '-85.4259000',
                'city' => 'Galesburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49098',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1842000',
                'longitude' => '-86.2662000',
                'city' => 'Watervliet',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49038',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1833000',
                'longitude' => '-86.3026000',
                'city' => 'Coloma',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49083',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3739000',
                'longitude' => '-85.4506000',
                'city' => 'Richland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49080',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4431000',
                'longitude' => '-85.6537000',
                'city' => 'Plainwell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49348',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7106000',
                'longitude' => '-85.4694000',
                'city' => 'Wayland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49316',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7106000',
                'longitude' => '-85.4694000',
                'city' => 'Caledonia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49090',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4013000',
                'longitude' => '-86.2672000',
                'city' => 'South Haven',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49006',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2920000',
                'longitude' => '-85.5838000',
                'city' => 'Kalamazoo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49001',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2920000',
                'longitude' => '-85.5838000',
                'city' => 'Kalamazoo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49022',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1174000',
                'longitude' => '-86.4501000',
                'city' => 'Benton Harbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49015',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3161000',
                'longitude' => '-85.1878000',
                'city' => 'Battle Creek',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49017',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3161000',
                'longitude' => '-85.1878000',
                'city' => 'Battle Creek',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49113',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3161000',
                'longitude' => '-85.1878000',
                'city' => 'Galien',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49091',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7990000',
                'longitude' => '-85.4201000',
                'city' => 'Sturgis',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49014',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3161000',
                'longitude' => '-85.1878000',
                'city' => 'Battle Creek',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49450',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5227000',
                'longitude' => '-86.1903000',
                'city' => 'Pullman',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49031',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9163000',
                'longitude' => '-86.0152000',
                'city' => 'Cassopolis',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49128',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7983000',
                'longitude' => '-86.6084000',
                'city' => 'Three Oaks',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49117',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7894000',
                'longitude' => '-86.7408000',
                'city' => 'New Buffalo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49085',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1101000',
                'longitude' => '-86.4837000',
                'city' => 'Saint Joseph',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49120',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8333000',
                'longitude' => '-86.2600000',
                'city' => 'Niles',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49093',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9403000',
                'longitude' => '-85.7300000',
                'city' => 'Three Rivers',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49068',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2661000',
                'longitude' => '-84.9700000',
                'city' => 'Marshall',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49052',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1142000',
                'longitude' => '-85.3505000',
                'city' => 'Fulton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49071',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Mattawan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49419',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6759000',
                'longitude' => '-86.0104000',
                'city' => 'Hamilton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49106',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9557000',
                'longitude' => '-86.5559000',
                'city' => 'Bridgman',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49007',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2920000',
                'longitude' => '-85.5838000',
                'city' => 'Kalamazoo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49058',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6501000',
                'longitude' => '-85.2872000',
                'city' => 'Hastings',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49076',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4438000',
                'longitude' => '-84.9251000',
                'city' => 'Olivet',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49065',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1652000',
                'longitude' => '-85.8504000',
                'city' => 'Lawton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49013',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3079000',
                'longitude' => '-86.1174000',
                'city' => 'Bangor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49057',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2086000',
                'longitude' => '-86.1713000',
                'city' => 'Hartford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49048',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1984000',
                'longitude' => '-85.5628000',
                'city' => 'Kalamazoo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49024',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1984000',
                'longitude' => '-85.5628000',
                'city' => 'Portage',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49101',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9556000',
                'longitude' => '-86.4924000',
                'city' => 'Baroda',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49040',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9686000',
                'longitude' => '-85.3198000',
                'city' => 'Colon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49111',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9832000',
                'longitude' => '-86.3034000',
                'city' => 'Eau Claire',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49008',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2583000',
                'longitude' => '-85.6803000',
                'city' => 'Kalamazoo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49010',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5258000',
                'longitude' => '-85.8396000',
                'city' => 'Allegan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49107',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8343000',
                'longitude' => '-86.3644000',
                'city' => 'Buchanan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48897',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7287000',
                'longitude' => '-85.1333000',
                'city' => 'Woodland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49125',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8910000',
                'longitude' => '-86.6035000',
                'city' => 'Sawyer',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49130',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7969000',
                'longitude' => '-86.0834000',
                'city' => 'Union',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49079',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2163000',
                'longitude' => '-85.8968000',
                'city' => 'Paw Paw',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49453',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5755000',
                'longitude' => '-86.2287000',
                'city' => 'Saugatuck',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49045',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1095000',
                'longitude' => '-85.9706000',
                'city' => 'Decatur',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49056',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4056000',
                'longitude' => '-86.0728000',
                'city' => 'Grand Junction',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49042',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8412000',
                'longitude' => '-85.6706000',
                'city' => 'Constantine',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49034',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2395000',
                'longitude' => '-85.3330000',
                'city' => 'Climax',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49047',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9915000',
                'longitude' => '-86.1079000',
                'city' => 'Dowagiac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49099',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7991000',
                'longitude' => '-85.6460000',
                'city' => 'White Pigeon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49032',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9225000',
                'longitude' => '-85.5241000',
                'city' => 'Centreville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49103',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9450000',
                'longitude' => '-86.3387000',
                'city' => 'Berrien Springs',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49097',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1168000',
                'longitude' => '-85.5326000',
                'city' => 'Vicksburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49095',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8917000',
                'longitude' => '-85.8793000',
                'city' => 'Vandalia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49030',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8469000',
                'longitude' => '-85.3204000',
                'city' => 'Burr Oak',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49072',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0086000',
                'longitude' => '-85.4520000',
                'city' => 'Mendon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49026',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3815000',
                'longitude' => '-85.9637000',
                'city' => 'Bloomingdale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49064',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2173000',
                'longitude' => '-86.0522000',
                'city' => 'Lawrence',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49408',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5946000',
                'longitude' => '-86.1084000',
                'city' => 'Fennville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49046',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5000000',
                'longitude' => '-85.4098000',
                'city' => 'Delton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49088',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1951000',
                'longitude' => '-85.4165000',
                'city' => 'Scotts',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49055',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3580000',
                'longitude' => '-85.8812000',
                'city' => 'Gobles',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49067',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0277000',
                'longitude' => '-85.8123000',
                'city' => 'Marcellus',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49070',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5357000',
                'longitude' => '-85.6472000',
                'city' => 'Martin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49087',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1145000',
                'longitude' => '-85.6404000',
                'city' => 'Schoolcraft',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49328',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6201000',
                'longitude' => '-85.7610000',
                'city' => 'Hopkins',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49078',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4571000',
                'longitude' => '-85.6999000',
                'city' => 'Otsego',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49060',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4644000',
                'longitude' => '-85.2875000',
                'city' => 'Hickory Corners',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49011',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0872000',
                'longitude' => '-85.2366000',
                'city' => 'Athens',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49012',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3331000',
                'longitude' => '-85.3538000',
                'city' => 'Augusta',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49021',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4415000',
                'longitude' => '-85.0198000',
                'city' => 'Bellevue',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49073',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4915000',
                'longitude' => '-85.1881000',
                'city' => 'Nashville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49043',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2960000',
                'longitude' => '-86.2685000',
                'city' => 'Covert',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49302',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7146000',
                'longitude' => '-85.4663000',
                'city' => 'Alto',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49033',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2336000',
                'longitude' => '-85.1813000',
                'city' => 'Ceresco',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48204',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3903000',
                'longitude' => '-83.1697000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48238',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3903000',
                'longitude' => '-83.1697000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48202',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48209',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48120',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Dearborn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48211',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4770000',
                'longitude' => '-83.2437000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48223',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48126',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3083000',
                'longitude' => '-83.2148000',
                'city' => 'Dearborn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48122',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3304000',
                'longitude' => '-83.0596000',
                'city' => 'Melvindale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48217',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2988000',
                'longitude' => '-83.1936000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48214',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48228',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48225',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Harper Woods',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48208',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3343000',
                'longitude' => '-83.0563000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48210',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3343000',
                'longitude' => '-83.0563000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48207',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3343000',
                'longitude' => '-83.0563000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48503',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48127',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3083000',
                'longitude' => '-83.2148000',
                'city' => 'Dearborn Heights',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48128',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3083000',
                'longitude' => '-83.2148000',
                'city' => 'Dearborn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48166',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Newport',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49506',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3903000',
                'longitude' => '-83.1697000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48224',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4273000',
                'longitude' => '-82.9875000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48205',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4273000',
                'longitude' => '-82.9875000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48234',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4273000',
                'longitude' => '-82.9875000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48213',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4273000',
                'longitude' => '-82.9875000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48203',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3982000',
                'longitude' => '-83.0910000',
                'city' => 'Highland Park',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48212',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3982000',
                'longitude' => '-83.0910000',
                'city' => 'Hamtramck',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48206',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3982000',
                'longitude' => '-83.0910000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48101',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3083000',
                'longitude' => '-83.2148000',
                'city' => 'Allen Park',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48146',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4747000',
                'longitude' => '-83.2384000',
                'city' => 'Lincoln Park',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48239',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4139000',
                'longitude' => '-83.2589000',
                'city' => 'Redford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48180',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Taylor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48141',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3027000',
                'longitude' => '-83.2626000',
                'city' => 'Inkster',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48125',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3027000',
                'longitude' => '-83.2626000',
                'city' => 'Dearborn Heights',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48229',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2507000',
                'longitude' => '-83.1822000',
                'city' => 'Ecorse',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48218',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3028000',
                'longitude' => '-83.1182000',
                'city' => 'River Rouge',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48105',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Ann Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48215',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3895000',
                'longitude' => '-82.9751000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48121',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3083000',
                'longitude' => '-83.2148000',
                'city' => 'Dearborn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48230',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3705000',
                'longitude' => '-82.9689000',
                'city' => 'Grosse Pointe',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48221',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3304000',
                'longitude' => '-83.0596000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48188',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Canton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48154',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4486000',
                'longitude' => '-83.2524000',
                'city' => 'Livonia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48265',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3746000',
                'longitude' => '-83.0741000',
                'city' => 'Detroit',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48151',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Livonia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48159',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3304000',
                'longitude' => '-83.0596000',
                'city' => 'Maybee',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48185',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2769000',
                'longitude' => '-83.3858000',
                'city' => 'Westland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48103',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2988000',
                'longitude' => '-83.1936000',
                'city' => 'Ann Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48183',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3304000',
                'longitude' => '-83.0596000',
                'city' => 'Trenton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48176',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Saline',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48184',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Wayne',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48189',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4739000',
                'longitude' => '-83.2246000',
                'city' => 'Whitmore Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48112',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4738000',
                'longitude' => '-83.2608000',
                'city' => 'Belleville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48160',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4258000',
                'longitude' => '-83.2493000',
                'city' => 'Milan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48104',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3304000',
                'longitude' => '-83.0596000',
                'city' => 'Ann Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48021',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2988000',
                'longitude' => '-83.1936000',
                'city' => 'Eastpointe',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49252',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0426000',
                'longitude' => '-84.7587000',
                'city' => 'Litchfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48840',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Haslett',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48906',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48819',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Dansville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48912',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7363000',
                'longitude' => '-84.4879000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48864',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7363000',
                'longitude' => '-84.4879000',
                'city' => 'Okemos',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48823',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7363000',
                'longitude' => '-84.4879000',
                'city' => 'East Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48820',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Dewitt',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48813',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Charlotte',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48872',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Perry',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48848',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Laingsburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48827',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Eaton Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48842',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Holt',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49203',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2524000',
                'longitude' => '-84.4170000',
                'city' => 'Jackson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49201',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2524000',
                'longitude' => '-84.4170000',
                'city' => 'Jackson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49283',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2524000',
                'longitude' => '-84.4170000',
                'city' => 'Spring Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49221',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8938000',
                'longitude' => '-84.0351000',
                'city' => 'Adrian',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49242',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9156000',
                'longitude' => '-84.6369000',
                'city' => 'Hillsdale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49236',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0680000',
                'longitude' => '-83.9690000',
                'city' => 'Clinton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48915',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48924',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48836',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6587000',
                'longitude' => '-84.0726000',
                'city' => 'Fowlerville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48137',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6587000',
                'longitude' => '-84.0726000',
                'city' => 'Gregory',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48892',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6587000',
                'longitude' => '-84.0726000',
                'city' => 'Webberville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48418',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6587000',
                'longitude' => '-84.0726000',
                'city' => 'Byron',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48876',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6258000',
                'longitude' => '-84.7402000',
                'city' => 'Potterville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49036',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9436000',
                'longitude' => '-84.9994000',
                'city' => 'Coldwater',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48826',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'East Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48867',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Owosso',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49255',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8277000',
                'longitude' => '-84.9891000',
                'city' => 'Montgomery',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49028',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8277000',
                'longitude' => '-84.9891000',
                'city' => 'Bronson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48911',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48917',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48913',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48933',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48854',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5797000',
                'longitude' => '-84.4461000',
                'city' => 'Mason',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49202',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2524000',
                'longitude' => '-84.4170000',
                'city' => 'Jackson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49220',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9831000',
                'longitude' => '-84.3497000',
                'city' => 'Addison',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49239',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7321000',
                'longitude' => '-84.6313000',
                'city' => 'Frontier',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49266',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7321000',
                'longitude' => '-84.6313000',
                'city' => 'Osseo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49232',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7321000',
                'longitude' => '-84.6313000',
                'city' => 'Camden',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49268',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8961000',
                'longitude' => '-84.0404000',
                'city' => 'Palmyra',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48910',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49094',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9396000',
                'longitude' => '-85.0024000',
                'city' => 'Union City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48895',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Williamston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48429',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Durand',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49082',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8362000',
                'longitude' => '-84.7492000',
                'city' => 'Quincy',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49274',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8362000',
                'longitude' => '-84.7492000',
                'city' => 'Reading',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49288',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7242000',
                'longitude' => '-84.4165000',
                'city' => 'Waldron',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49249',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9724000',
                'longitude' => '-84.5217000',
                'city' => 'Jerome',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49250',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9724000',
                'longitude' => '-84.5217000',
                'city' => 'Jonesville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49262',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9724000',
                'longitude' => '-84.5217000',
                'city' => 'North Adams',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48890',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7602000',
                'longitude' => '-84.9940000',
                'city' => 'Sunfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48879',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Saint Johns',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49286',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0026000',
                'longitude' => '-83.9420000',
                'city' => 'Tecumseh',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49228',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1173000',
                'longitude' => '-84.3515000',
                'city' => 'Blissfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49247',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8495000',
                'longitude' => '-84.3615000',
                'city' => 'Hudson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48821',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7780000',
                'longitude' => '-84.6350000',
                'city' => 'Dimondale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48901',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7332000',
                'longitude' => '-84.5552000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48909',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48844',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6101000',
                'longitude' => '-83.9239000',
                'city' => 'Howell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48825',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7363000',
                'longitude' => '-84.4879000',
                'city' => 'East Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48824',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7363000',
                'longitude' => '-84.4879000',
                'city' => 'East Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49230',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7562000',
                'longitude' => '-84.7612000',
                'city' => 'Brooklyn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48922',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48919',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49271',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7835000',
                'longitude' => '-84.4059000',
                'city' => 'Pittsford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49256',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7271000',
                'longitude' => '-84.2156000',
                'city' => 'Morenci',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49224',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2425000',
                'longitude' => '-84.7531000',
                'city' => 'Albion',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49245',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1438000',
                'longitude' => '-84.8084000',
                'city' => 'Homer',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49229',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0026000',
                'longitude' => '-83.9420000',
                'city' => 'Britton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49265',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0151000',
                'longitude' => '-84.0679000',
                'city' => 'Onsted',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49287',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0151000',
                'longitude' => '-84.0679000',
                'city' => 'Tipton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49248',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8269000',
                'longitude' => '-84.1019000',
                'city' => 'Jasper',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49235',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8269000',
                'longitude' => '-84.1019000',
                'city' => 'Clayton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49289',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8269000',
                'longitude' => '-84.1019000',
                'city' => 'Weston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49279',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8269000',
                'longitude' => '-84.1019000',
                'city' => 'Sand Creek',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49238',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8893000',
                'longitude' => '-83.7819000',
                'city' => 'Deerfield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49270',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8893000',
                'longitude' => '-83.7819000',
                'city' => 'Petersburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48131',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9845000',
                'longitude' => '-83.8278000',
                'city' => 'Dundee',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48158',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0680000',
                'longitude' => '-83.9690000',
                'city' => 'Manchester',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49253',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0290000',
                'longitude' => '-84.1854000',
                'city' => 'Manitou Beach',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49285',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4498000',
                'longitude' => '-84.1825000',
                'city' => 'Stockbridge',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49276',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8335000',
                'longitude' => '-83.8617000',
                'city' => 'Riga',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49267',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8335000',
                'longitude' => '-83.8617000',
                'city' => 'Ottawa Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49240',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2513000',
                'longitude' => '-84.2176000',
                'city' => 'Grass Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49237',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1801000',
                'longitude' => '-84.6448000',
                'city' => 'Concord',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49241',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1801000',
                'longitude' => '-84.6448000',
                'city' => 'Hanover',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49246',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1801000',
                'longitude' => '-84.6448000',
                'city' => 'Horton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48875',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8659000',
                'longitude' => '-84.9042000',
                'city' => 'Portland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49233',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1150000',
                'longitude' => '-84.3462000',
                'city' => 'Cement City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49234',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1150000',
                'longitude' => '-84.3462000',
                'city' => 'Clarklake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49284',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2605000',
                'longitude' => '-84.5964000',
                'city' => 'Springport',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49269',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2605000',
                'longitude' => '-84.5964000',
                'city' => 'Parma',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49261',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1618000',
                'longitude' => '-84.2451000',
                'city' => 'Napoleon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49263',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1618000',
                'longitude' => '-84.2451000',
                'city' => 'Norvell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49258',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0590000',
                'longitude' => '-84.6606000',
                'city' => 'Mosherville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48861',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7625000',
                'longitude' => '-84.9994000',
                'city' => 'Mulliken',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48849',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7625000',
                'longitude' => '-84.9994000',
                'city' => 'Lake Odessa',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49096',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7625000',
                'longitude' => '-84.9994000',
                'city' => 'Vermontville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49264',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3857000',
                'longitude' => '-84.4912000',
                'city' => 'Onondaga',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49277',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3857000',
                'longitude' => '-84.4912000',
                'city' => 'Rives Junction',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48855',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6101000',
                'longitude' => '-83.9239000',
                'city' => 'Howell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49092',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0917000',
                'longitude' => '-84.9850000',
                'city' => 'Tekonsha',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49251',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4512000',
                'longitude' => '-84.4326000',
                'city' => 'Leslie',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49259',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3931000',
                'longitude' => '-84.2489000',
                'city' => 'Munith',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48837',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7560000',
                'longitude' => '-84.7458000',
                'city' => 'Grand Ledge',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48414',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8248000',
                'longitude' => '-84.2216000',
                'city' => 'Bancroft',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48857',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8248000',
                'longitude' => '-84.2216000',
                'city' => 'Morrice',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48822',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8284000',
                'longitude' => '-84.7033000',
                'city' => 'Eagle',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49272',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4315000',
                'longitude' => '-84.2759000',
                'city' => 'Pleasant Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48808',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8173000',
                'longitude' => '-84.4527000',
                'city' => 'Bath',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48851',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8721000',
                'longitude' => '-84.9065000',
                'city' => 'Lyons',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49029',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1098000',
                'longitude' => '-85.0775000',
                'city' => 'Burlington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48882',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8088000',
                'longitude' => '-84.3210000',
                'city' => 'Shaftsburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49254',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1658000',
                'longitude' => '-84.2420000',
                'city' => 'Michigan Center',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49282',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0567000',
                'longitude' => '-84.4702000',
                'city' => 'Somerset Center',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49089',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0669000',
                'longitude' => '-85.1387000',
                'city' => 'Sherwood',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49204',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2438000',
                'longitude' => '-84.4095000',
                'city' => 'Jackson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49227',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9404000',
                'longitude' => '-84.7809000',
                'city' => 'Allen',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48921',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7372000',
                'longitude' => '-84.5520000',
                'city' => 'Lansing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48043',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5903000',
                'longitude' => '-82.8826000',
                'city' => 'Mount Clemens',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48088',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Warren',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48093',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Warren',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48095',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7231000',
                'longitude' => '-83.0350000',
                'city' => 'Washington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48047',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'New Baltimore',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48042',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Macomb',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48312',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Sterling Heights',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48315',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Utica',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48313',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Sterling Heights',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48081',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Saint Clair Shores',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48036',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6212000',
                'longitude' => '-82.9516000',
                'city' => 'Clinton Township',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48035',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5903000',
                'longitude' => '-82.8826000',
                'city' => 'Clinton Township',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48310',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5903000',
                'longitude' => '-82.8826000',
                'city' => 'Sterling Heights',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48048',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7320000',
                'longitude' => '-82.8018000',
                'city' => 'New Haven',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48062',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8100000',
                'longitude' => '-82.7591000',
                'city' => 'Richmond',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48314',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6300000',
                'longitude' => '-83.0316000',
                'city' => 'Sterling Heights',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48065',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8003000',
                'longitude' => '-83.0151000',
                'city' => 'Romeo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48092',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5496000',
                'longitude' => '-83.0323000',
                'city' => 'Warren',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48051',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6845000',
                'longitude' => '-82.7319000',
                'city' => 'New Baltimore',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48090',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5496000',
                'longitude' => '-83.0323000',
                'city' => 'Warren',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48082',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5462000',
                'longitude' => '-82.9044000',
                'city' => 'Saint Clair Shores',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48046',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5903000',
                'longitude' => '-82.8826000',
                'city' => 'Mount Clemens',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48045',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5943000',
                'longitude' => '-82.8793000',
                'city' => 'Harrison Township',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48501',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8003000',
                'longitude' => '-83.0151000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48005',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8042000',
                'longitude' => '-83.0118000',
                'city' => 'Armada',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48096',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8042000',
                'longitude' => '-83.0118000',
                'city' => 'Ray',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48050',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7320000',
                'longitude' => '-82.8018000',
                'city' => 'New Haven',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48015',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4794000',
                'longitude' => '-83.0318000',
                'city' => 'Center Line',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48111',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Belleville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48001',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Algonac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48507',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8442000',
                'longitude' => '-82.8840000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48179',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'South Rockwood',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48433',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Flushing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48318',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6261000',
                'longitude' => '-83.0348000',
                'city' => 'Utica',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48311',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Sterling Heights',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48023',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.6806000',
                'longitude' => '-82.7352000',
                'city' => 'Fair Haven',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48064',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8100000',
                'longitude' => '-82.7591000',
                'city' => 'Casco',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48063',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8100000',
                'longitude' => '-82.7591000',
                'city' => 'Columbus',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48002',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8442000',
                'longitude' => '-82.8840000',
                'city' => 'Allenton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48169',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3304000',
                'longitude' => '-83.0596000',
                'city' => 'Pinckney',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48108',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5275000',
                'longitude' => '-83.0431000',
                'city' => 'Ann Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49347',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3069000',
                'longitude' => '-85.3597000',
                'city' => 'Trufant',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49546',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49501',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49504',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49507',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49345',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1563000',
                'longitude' => '-85.6999000',
                'city' => 'Sparta',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49426',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8652000',
                'longitude' => '-85.8670000',
                'city' => 'Hudsonville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49424',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7855000',
                'longitude' => '-86.0842000',
                'city' => 'Holland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49464',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7922000',
                'longitude' => '-86.1005000',
                'city' => 'Zeeland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49423',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7922000',
                'longitude' => '-86.1005000',
                'city' => 'Holland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49548',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49508',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49544',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49321',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Comstock Park',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49418',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Grandville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49505',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49503',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49428',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Jenison',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49512',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49525',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49417',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0665000',
                'longitude' => '-86.2286000',
                'city' => 'Grand Haven',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49326',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1810000',
                'longitude' => '-85.2487000',
                'city' => 'Gowen',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48838',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1810000',
                'longitude' => '-85.2487000',
                'city' => 'Greenville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49516',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'Grand Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48809',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0913000',
                'longitude' => '-85.2249000',
                'city' => 'Belding',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49315',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8847000',
                'longitude' => '-85.7221000',
                'city' => 'Byron Center',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49331',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9428000',
                'longitude' => '-85.6704000',
                'city' => 'Lowell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49319',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9428000',
                'longitude' => '-85.6704000',
                'city' => 'Cedar Springs',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49333',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'Middleville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49306',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9774000',
                'longitude' => '-85.6007000',
                'city' => 'Belmont',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49301',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'Ada',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49325',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'Freeport',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49401',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'Allendale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49460',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'West Olive',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49318',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2317000',
                'longitude' => '-85.7929000',
                'city' => 'Casnovia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49434',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7756000',
                'longitude' => '-86.1629000',
                'city' => 'Macatawa',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49343',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2836000',
                'longitude' => '-85.5079000',
                'city' => 'Sand Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49323',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7239000',
                'longitude' => '-85.7176000',
                'city' => 'Dorr',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49435',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0570000',
                'longitude' => '-85.9341000',
                'city' => 'Marne',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48815',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8445000',
                'longitude' => '-85.2442000',
                'city' => 'Clarksville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48846',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9818000',
                'longitude' => '-85.0654000',
                'city' => 'Ionia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49404',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9674000',
                'longitude' => '-85.6658000',
                'city' => 'Coopersville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48865',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0692000',
                'longitude' => '-85.1340000',
                'city' => 'Orleans',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49422',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7904000',
                'longitude' => '-86.1090000',
                'city' => 'Holland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48881',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9274000',
                'longitude' => '-85.2014000',
                'city' => 'Saranac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48834',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0692000',
                'longitude' => '-85.1340000',
                'city' => 'Fenwick',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49355',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9528000',
                'longitude' => '-85.4905000',
                'city' => 'Ada',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49335',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7408000',
                'longitude' => '-85.6691000',
                'city' => 'Moline',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48830',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1160000',
                'longitude' => '-85.5513000',
                'city' => 'Elm Hall',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49427',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7819000',
                'longitude' => '-85.8447000',
                'city' => 'Jamestown',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49314',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7819000',
                'longitude' => '-85.8447000',
                'city' => 'Burnips',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48182',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7729000',
                'longitude' => '-83.5675000',
                'city' => 'Temperance',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48187',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3598000',
                'longitude' => '-83.4760000',
                'city' => 'Canton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48134',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1019000',
                'longitude' => '-83.2823000',
                'city' => 'Flat Rock',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48198',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Ypsilanti',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48144',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2833000',
                'longitude' => '-83.7403000',
                'city' => 'Lambertville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48118',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2833000',
                'longitude' => '-83.7403000',
                'city' => 'Chelsea',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48192',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2019000',
                'longitude' => '-83.1570000',
                'city' => 'Wyandotte',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48161',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9186000',
                'longitude' => '-83.4010000',
                'city' => 'Monroe',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48164',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1439000',
                'longitude' => '-83.1837000',
                'city' => 'New Boston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48173',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0689000',
                'longitude' => '-83.2443000',
                'city' => 'Rockwood',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48162',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9123000',
                'longitude' => '-83.3989000',
                'city' => 'Monroe',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48145',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.9123000',
                'longitude' => '-83.3989000',
                'city' => 'La Salle',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48195',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2078000',
                'longitude' => '-83.1824000',
                'city' => 'Southgate',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48191',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1603000',
                'longitude' => '-83.5587000',
                'city' => 'Willis',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48140',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.8888000',
                'longitude' => '-83.5751000',
                'city' => 'Ida',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48117',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.0607000',
                'longitude' => '-83.3946000',
                'city' => 'Carleton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48133',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7921000',
                'longitude' => '-83.5022000',
                'city' => 'Erie',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48138',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1407000',
                'longitude' => '-83.2007000',
                'city' => 'Grosse Ile',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48130',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3361000',
                'longitude' => '-83.8850000',
                'city' => 'Dexter',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48157',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '41.7449000',
                'longitude' => '-83.4685000',
                'city' => 'Luna Pier',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48190',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.1564000',
                'longitude' => '-83.5618000',
                'city' => 'Whittaker',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48109',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2817000',
                'longitude' => '-83.7488000',
                'city' => 'Ann Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48106',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2473000',
                'longitude' => '-83.6829000',
                'city' => 'Ann Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48136',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.3570000',
                'longitude' => '-83.3485000',
                'city' => 'Garden City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48143',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2187000',
                'longitude' => '-83.7273000',
                'city' => 'Lakeland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48113',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.2833000',
                'longitude' => '-83.7403000',
                'city' => 'Ann Arbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48469',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4323000',
                'longitude' => '-82.5453000',
                'city' => 'Port Sanilac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48401',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3494000',
                'longitude' => '-82.6380000',
                'city' => 'Applegate',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48060',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9665000',
                'longitude' => '-82.4227000',
                'city' => 'Port Huron',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48532',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0315000',
                'longitude' => '-83.7723000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48473',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0315000',
                'longitude' => '-83.7723000',
                'city' => 'Swartz Creek',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48139',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.4700000',
                'longitude' => '-83.7995000',
                'city' => 'Hamburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48506',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48502',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48505',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48529',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Burton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48551',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48557',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48552',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48553',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48555',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48550',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Flint',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48509',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0169000',
                'longitude' => '-83.6896000',
                'city' => 'Burton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48519',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0169000',
                'longitude' => '-83.6896000',
                'city' => 'Burton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48458',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0169000',
                'longitude' => '-83.6896000',
                'city' => 'Mount Morris',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48457',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1760000',
                'longitude' => '-83.8953000',
                'city' => 'Montrose',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48444',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0267000',
                'longitude' => '-83.0762000',
                'city' => 'Imlay City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48451',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8238000',
                'longitude' => '-83.9474000',
                'city' => 'Linden',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48471',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4149000',
                'longitude' => '-82.8336000',
                'city' => 'Sandusky',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48461',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2333000',
                'longitude' => '-83.1907000',
                'city' => 'North Branch',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48061',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9665000',
                'longitude' => '-82.4227000',
                'city' => 'Port Huron',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48027',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8991000',
                'longitude' => '-82.7654000',
                'city' => 'Goodells',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48014',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0083000',
                'longitude' => '-82.9378000',
                'city' => 'Capac',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48428',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9510000',
                'longitude' => '-83.1241000',
                'city' => 'Dryden',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48049',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0596000',
                'longitude' => '-82.6901000',
                'city' => 'North Street',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48032',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0596000',
                'longitude' => '-82.6901000',
                'city' => 'Jeddo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48006',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0596000',
                'longitude' => '-82.6901000',
                'city' => 'Avoca',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48074',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9838000',
                'longitude' => '-82.6654000',
                'city' => 'Smiths Creek',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48054',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8246000',
                'longitude' => '-82.4915000',
                'city' => 'East China',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48079',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.8246000',
                'longitude' => '-82.4915000',
                'city' => 'Saint Clair',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48450',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1519000',
                'longitude' => '-82.5826000',
                'city' => 'Lexington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48059',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1519000',
                'longitude' => '-82.5826000',
                'city' => 'Fort Gratiot',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48097',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1519000',
                'longitude' => '-82.5826000',
                'city' => 'Yale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48422',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1519000',
                'longitude' => '-82.5826000',
                'city' => 'Croswell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48440',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0503000',
                'longitude' => '-83.3124000',
                'city' => 'Hadley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48420',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0130000',
                'longitude' => '-83.6928000',
                'city' => 'Clio',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48439',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9233000',
                'longitude' => '-83.6348000',
                'city' => 'Grand Blanc',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48453',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2158000',
                'longitude' => '-82.9926000',
                'city' => 'Marlette',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48416',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2158000',
                'longitude' => '-82.9926000',
                'city' => 'Brown City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48423',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0169000',
                'longitude' => '-83.6896000',
                'city' => 'Davison',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48040',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9113000',
                'longitude' => '-82.4920000',
                'city' => 'Marysville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48427',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5264000',
                'longitude' => '-82.7324000',
                'city' => 'Deckerville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48463',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1650000',
                'longitude' => '-83.5249000',
                'city' => 'Otisville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48419',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5288000',
                'longitude' => '-82.7377000',
                'city' => 'Carsonville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48465',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5288000',
                'longitude' => '-82.7377000',
                'city' => 'Palms',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48454',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2823000',
                'longitude' => '-82.6208000',
                'city' => 'Melvin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48466',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2823000',
                'longitude' => '-82.6208000',
                'city' => 'Peck',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48041',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9921000',
                'longitude' => '-82.7684000',
                'city' => 'Memphis',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48022',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9921000',
                'longitude' => '-82.7684000',
                'city' => 'Emmett',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48039',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.7159000',
                'longitude' => '-82.5019000',
                'city' => 'Marine City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48421',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0503000',
                'longitude' => '-83.3124000',
                'city' => 'Columbiaville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48472',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4149000',
                'longitude' => '-82.8336000',
                'city' => 'Snover',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48437',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0169000',
                'longitude' => '-83.6896000',
                'city' => 'Genesee',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48817',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9840000',
                'longitude' => '-83.9343000',
                'city' => 'Corunna',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48449',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9840000',
                'longitude' => '-83.9343000',
                'city' => 'Lennon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48436',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9562000',
                'longitude' => '-83.8333000',
                'city' => 'Gaines',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48411',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9182000',
                'longitude' => '-83.5008000',
                'city' => 'Atlas',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48460',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1179000',
                'longitude' => '-83.9715000',
                'city' => 'New Lothrop',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48426',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4562000',
                'longitude' => '-82.9758000',
                'city' => 'Decker',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48003',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9155000',
                'longitude' => '-83.0440000',
                'city' => 'Almont',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48028',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.5813000',
                'longitude' => '-82.5625000',
                'city' => 'Harsens Island',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48464',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1527000',
                'longitude' => '-83.4109000',
                'city' => 'Otter Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48435',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1527000',
                'longitude' => '-83.4109000',
                'city' => 'Fostoria',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49958',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.7595000',
                'longitude' => '-88.4494000',
                'city' => 'Pelkie',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49908',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.7595000',
                'longitude' => '-88.4494000',
                'city' => 'Baraga',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49862',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4078000',
                'longitude' => '-86.6506000',
                'city' => 'Munising',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49783',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5023000',
                'longitude' => '-84.3507000',
                'city' => 'Sault Sainte Marie',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49849',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4933000',
                'longitude' => '-87.6691000',
                'city' => 'Ishpeming',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49910',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Bergland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49814',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Champion',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49806',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3489000',
                'longitude' => '-86.9241000',
                'city' => 'Au Train',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49822',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3489000',
                'longitude' => '-86.9241000',
                'city' => 'Deerton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49820',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.2104000',
                'longitude' => '-85.7494000',
                'city' => 'Curtis',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49829',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7437000',
                'longitude' => '-87.0500000',
                'city' => 'Escanaba',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49827',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1174000',
                'longitude' => '-85.5681000',
                'city' => 'Engadine',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49855',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Marquette',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49801',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.8197000',
                'longitude' => '-88.0696000',
                'city' => 'Iron Mountain',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49911',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4743000',
                'longitude' => '-89.9392000',
                'city' => 'Bessemer',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49968',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4743000',
                'longitude' => '-89.9392000',
                'city' => 'Wakefield',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49921',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1178000',
                'longitude' => '-88.5592000',
                'city' => 'Dodgeville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49788',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5432000',
                'longitude' => '-87.3814000',
                'city' => 'Kincheloe',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49920',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0918000',
                'longitude' => '-88.3381000',
                'city' => 'Crystal Falls',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49818',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0559000',
                'longitude' => '-87.5529000',
                'city' => 'Cornell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49819',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0559000',
                'longitude' => '-87.5529000',
                'city' => 'Arnold',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49831',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0559000',
                'longitude' => '-87.5529000',
                'city' => 'Felch',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49841',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0559000',
                'longitude' => '-87.5529000',
                'city' => 'Gwinn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49719',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0014000',
                'longitude' => '-84.3572000',
                'city' => 'Cedarville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49873',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9909000',
                'longitude' => '-87.8266000',
                'city' => 'Perronville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49877',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9909000',
                'longitude' => '-87.8266000',
                'city' => 'Ralph',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49834',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9909000',
                'longitude' => '-87.8266000',
                'city' => 'Foster City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49807',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9909000',
                'longitude' => '-87.8266000',
                'city' => 'Bark River',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49715',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4011000',
                'longitude' => '-84.5756000',
                'city' => 'Brimley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49854',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9568000',
                'longitude' => '-86.2509000',
                'city' => 'Manistique',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49724',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4778000',
                'longitude' => '-84.3563000',
                'city' => 'Dafter',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49861',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3264000',
                'longitude' => '-87.7847000',
                'city' => 'Michigamme',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49964',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0915000',
                'longitude' => '-88.6503000',
                'city' => 'Stambaugh',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49935',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0915000',
                'longitude' => '-88.6503000',
                'city' => 'Iron River',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49915',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0915000',
                'longitude' => '-88.6503000',
                'city' => 'Caspian',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49927',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0915000',
                'longitude' => '-88.6503000',
                'city' => 'Gaastra',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49879',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5187000',
                'longitude' => '-88.1910000',
                'city' => 'Republic',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49728',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3441000',
                'longitude' => '-85.0295000',
                'city' => 'Eckerman',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49760',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Moran',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49912',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5315000',
                'longitude' => '-89.1766000',
                'city' => 'Bruce Crossing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49836',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9928000',
                'longitude' => '-86.0186000',
                'city' => 'Germfask',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49840',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9928000',
                'longitude' => '-86.0186000',
                'city' => 'Gulliver',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49938',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4495000',
                'longitude' => '-90.1642000',
                'city' => 'Ironwood',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49965',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.8939000',
                'longitude' => '-88.8365000',
                'city' => 'Toivola',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49918',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.4792000',
                'longitude' => '-88.0110000',
                'city' => 'Copper Harbor',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49950',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.4792000',
                'longitude' => '-88.0110000',
                'city' => 'Mohawk',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49858',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0976000',
                'longitude' => '-87.5999000',
                'city' => 'Menominee',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49868',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3505000',
                'longitude' => '-85.5124000',
                'city' => 'Newberry',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49762',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0188000',
                'longitude' => '-85.0428000',
                'city' => 'Naubinway',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49853',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3567000',
                'longitude' => '-85.5148000',
                'city' => 'Mc Millan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49874',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.6841000',
                'longitude' => '-87.5274000',
                'city' => 'Powers',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49934',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1942000',
                'longitude' => '-88.4085000',
                'city' => 'Hubbell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49913',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1942000',
                'longitude' => '-88.4085000',
                'city' => 'Calumet',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49945',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1942000',
                'longitude' => '-88.4085000',
                'city' => 'Lake Linden',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49736',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9921000',
                'longitude' => '-83.9068000',
                'city' => 'Goetzville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49725',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9921000',
                'longitude' => '-83.9068000',
                'city' => 'De Tour Village',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49781',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.8694000',
                'longitude' => '-84.7273000',
                'city' => 'Saint Ignace',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49812',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.5857000',
                'longitude' => '-87.5585000',
                'city' => 'Carney',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49805',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.4753000',
                'longitude' => '-88.0293000',
                'city' => 'Allouez',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49752',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.2763000',
                'longitude' => '-84.5056000',
                'city' => 'Kinross',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49880',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0681000',
                'longitude' => '-87.1684000',
                'city' => 'Rock',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49887',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4175000',
                'longitude' => '-87.5996000',
                'city' => 'Stephenson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49969',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.2650000',
                'longitude' => '-89.1725000',
                'city' => 'Watersmeet',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49891',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Trenary',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49916',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.8978000',
                'longitude' => '-88.6295000',
                'city' => 'Chassell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49901',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.2401000',
                'longitude' => '-88.4488000',
                'city' => 'Ahmeek',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49917',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.2401000',
                'longitude' => '-88.4488000',
                'city' => 'Copper City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49952',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.7693000',
                'longitude' => '-88.7508000',
                'city' => 'Nisula',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49808',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.8163000',
                'longitude' => '-87.7334000',
                'city' => 'Big Bay',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49833',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.2878000',
                'longitude' => '-87.4012000',
                'city' => 'Little Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49919',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5408000',
                'longitude' => '-88.6093000',
                'city' => 'Covington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49961',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5408000',
                'longitude' => '-88.6093000',
                'city' => 'Sidnaw',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49970',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5408000',
                'longitude' => '-88.6093000',
                'city' => 'Watton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49878',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0178000',
                'longitude' => '-87.1330000',
                'city' => 'Rapid River',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49837',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0178000',
                'longitude' => '-87.1330000',
                'city' => 'Gladstone',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49872',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.0178000',
                'longitude' => '-87.1330000',
                'city' => 'Perkins',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49896',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.2878000',
                'longitude' => '-87.4012000',
                'city' => 'Wilson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49726',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Drummond Island',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49895',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4100000',
                'longitude' => '-86.6564000',
                'city' => 'Wetmore',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49953',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.8748000',
                'longitude' => '-89.3093000',
                'city' => 'Ontonagon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49866',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5024000',
                'longitude' => '-87.6092000',
                'city' => 'Negaunee',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49870',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Norway',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49892',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Vulcan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49780',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.2352000',
                'longitude' => '-84.6017000',
                'city' => 'Rudyard',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49847',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.6801000',
                'longitude' => '-87.7528000',
                'city' => 'Hermansville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49816',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3471000',
                'longitude' => '-86.9331000',
                'city' => 'Chatham',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49826',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3471000',
                'longitude' => '-86.9331000',
                'city' => 'Rumely',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49825',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3471000',
                'longitude' => '-86.9331000',
                'city' => 'Eben Junction',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49884',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3491000',
                'longitude' => '-86.4709000',
                'city' => 'Shingleton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49845',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7104000',
                'longitude' => '-87.3066000',
                'city' => 'Harris',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49883',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Seney',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49864',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9271000',
                'longitude' => '-86.9647000',
                'city' => 'Nahma',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49871',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5146000',
                'longitude' => '-87.5997000',
                'city' => 'Palmer',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49838',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1134000',
                'longitude' => '-85.5714000',
                'city' => 'Gould City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49922',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1262000',
                'longitude' => '-88.5679000',
                'city' => 'Dollar Bay',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49905',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1262000',
                'longitude' => '-88.5679000',
                'city' => 'Atlantic Mine',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49955',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1262000',
                'longitude' => '-88.5679000',
                'city' => 'Painesdale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49931',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1262000',
                'longitude' => '-88.5679000',
                'city' => 'Houghton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49963',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1262000',
                'longitude' => '-88.5679000',
                'city' => 'South Range',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49930',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '47.1262000',
                'longitude' => '-88.5679000',
                'city' => 'Hancock',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49745',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.9997000',
                'longitude' => '-84.3663000',
                'city' => 'Hessel',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49768',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.6313000',
                'longitude' => '-85.0404000',
                'city' => 'Paradise',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49839',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.6742000',
                'longitude' => '-85.9847000',
                'city' => 'Grand Marais',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49886',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.6903000',
                'longitude' => '-87.5300000',
                'city' => 'Spalding',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49962',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.7617000',
                'longitude' => '-88.4553000',
                'city' => 'Skanee',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49881',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1377000',
                'longitude' => '-88.0941000',
                'city' => 'Sagola',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49902',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1377000',
                'longitude' => '-88.0941000',
                'city' => 'Alpha',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49815',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1377000',
                'longitude' => '-88.0941000',
                'city' => 'Channing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '54521',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1519000',
                'longitude' => '-89.2198000',
                'city' => 'Eagle River',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '54540',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1519000',
                'longitude' => '-89.2198000',
                'city' => 'Land O Lakes',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49852',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7862000',
                'longitude' => '-87.9100000',
                'city' => 'Loretto',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49793',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1911000',
                'longitude' => '-85.0205000',
                'city' => 'Trout Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49947',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5931000',
                'longitude' => '-89.5704000',
                'city' => 'Marenisco',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49925',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.5931000',
                'longitude' => '-89.5704000',
                'city' => 'Ewen',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49821',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.5878000',
                'longitude' => '-87.5642000',
                'city' => 'Daggett',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49863',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.5878000',
                'longitude' => '-87.5642000',
                'city' => 'Nadeau',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49835',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7945000',
                'longitude' => '-86.5532000',
                'city' => 'Garden',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49817',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7945000',
                'longitude' => '-86.5532000',
                'city' => 'Cooks',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49710',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1583000',
                'longitude' => '-84.3611000',
                'city' => 'Barbeau',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49774',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.1583000',
                'longitude' => '-84.3611000',
                'city' => 'Pickford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49959',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4764000',
                'longitude' => '-90.0487000',
                'city' => 'Ramsay',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49848',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4177000',
                'longitude' => '-87.6141000',
                'city' => 'Ingalls',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49802',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.8197000',
                'longitude' => '-88.0696000',
                'city' => 'Kingsford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49876',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.8197000',
                'longitude' => '-88.0696000',
                'city' => 'Quinnesec',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49894',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.7441000',
                'longitude' => '-87.0646000',
                'city' => 'Wells',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49893',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.3290000',
                'longitude' => '-87.6153000',
                'city' => 'Wallace',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49903',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.2314000',
                'longitude' => '-88.4481000',
                'city' => 'Amasa',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49757',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.8484000',
                'longitude' => '-84.6235000',
                'city' => 'Mackinac Island',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49967',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.4829000',
                'longitude' => '-89.0124000',
                'city' => 'Trout Creek',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49748',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3552000',
                'longitude' => '-85.1501000',
                'city' => 'Hulbert',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49948',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.7640000',
                'longitude' => '-89.0845000',
                'city' => 'Mass City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49929',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.7640000',
                'longitude' => '-89.0845000',
                'city' => 'Greenland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49971',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.7521000',
                'longitude' => '-89.5788000',
                'city' => 'White Pine',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49960',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.7462000',
                'longitude' => '-89.1812000',
                'city' => 'Rockland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49885',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '46.3751000',
                'longitude' => '-87.2424000',
                'city' => 'Skandia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48650',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8502000',
                'longitude' => '-83.9679000',
                'city' => 'Pinconning',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48601',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4321000',
                'longitude' => '-83.9426000',
                'city' => 'Saginaw',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48602',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4321000',
                'longitude' => '-83.9426000',
                'city' => 'Saginaw',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48629',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3014000',
                'longitude' => '-84.7574000',
                'city' => 'Houghton Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48811',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1903000',
                'longitude' => '-84.9669000',
                'city' => 'Carson City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48818',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2665000',
                'longitude' => '-84.9200000',
                'city' => 'Crystal',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48640',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6161000',
                'longitude' => '-84.2469000',
                'city' => 'Midland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48749',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0524000',
                'longitude' => '-83.8517000',
                'city' => 'Omer',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48628',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7668000',
                'longitude' => '-84.3372000',
                'city' => 'Hope',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48607',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3825000',
                'longitude' => '-83.9392000',
                'city' => 'Saginaw',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48475',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7073000',
                'longitude' => '-82.9336000',
                'city' => 'Ubly',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48750',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4165000',
                'longitude' => '-83.3241000',
                'city' => 'Oscoda',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48661',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2779000',
                'longitude' => '-84.2430000',
                'city' => 'West Branch',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48739',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3760000',
                'longitude' => '-83.8055000',
                'city' => 'Hale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48706',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6005000',
                'longitude' => '-83.8857000',
                'city' => 'Bay City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48737',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5601000',
                'longitude' => '-83.7336000',
                'city' => 'Glennie',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48617',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8150000',
                'longitude' => '-84.7673000',
                'city' => 'Clare',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48445',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9439000',
                'longitude' => '-82.9935000',
                'city' => 'Kinde',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48723',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4926000',
                'longitude' => '-83.4017000',
                'city' => 'Caro',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48770',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2340000',
                'longitude' => '-83.8122000',
                'city' => 'Whittemore',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48888',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2642000',
                'longitude' => '-84.9145000',
                'city' => 'Stanton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48884',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2642000',
                'longitude' => '-84.9145000',
                'city' => 'Sheridan',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48877',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2642000',
                'longitude' => '-84.9145000',
                'city' => 'Riverdale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48891',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2642000',
                'longitude' => '-84.9145000',
                'city' => 'Vestaburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48856',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1833000',
                'longitude' => '-84.7105000',
                'city' => 'Middleton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48847',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1833000',
                'longitude' => '-84.7105000',
                'city' => 'Ithaca',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48871',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1833000',
                'longitude' => '-84.7105000',
                'city' => 'Perrinton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48761',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4263000',
                'longitude' => '-83.8603000',
                'city' => 'South Branch',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48763',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3260000',
                'longitude' => '-83.6761000',
                'city' => 'Tawas City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48603',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4321000',
                'longitude' => '-83.9426000',
                'city' => 'Saginaw',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48623',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4321000',
                'longitude' => '-83.9426000',
                'city' => 'Freeland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48468',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9437000',
                'longitude' => '-82.7111000',
                'city' => 'Port Hope',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48467',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0432000',
                'longitude' => '-82.9987000',
                'city' => 'Port Austin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49709',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9997000',
                'longitude' => '-84.1514000',
                'city' => 'Atlanta',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48415',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2492000',
                'longitude' => '-83.7921000',
                'city' => 'Birch Run',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48624',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9824000',
                'longitude' => '-84.4930000',
                'city' => 'Gladwin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48642',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6161000',
                'longitude' => '-84.2469000',
                'city' => 'Midland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48604',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4396000',
                'longitude' => '-84.0097000',
                'city' => 'Saginaw',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48730',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2854000',
                'longitude' => '-83.4942000',
                'city' => 'East Tawas',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49707',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0606000',
                'longitude' => '-83.4451000',
                'city' => 'Alpena',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48743',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4230000',
                'longitude' => '-83.8779000',
                'city' => 'Long Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48635',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4230000',
                'longitude' => '-83.8779000',
                'city' => 'Lupton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48734',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3354000',
                'longitude' => '-83.7436000',
                'city' => 'Frankenmuth',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48611',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5994000',
                'longitude' => '-84.0700000',
                'city' => 'Auburn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48829',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4001000',
                'longitude' => '-84.9085000',
                'city' => 'Edmore',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48432',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8059000',
                'longitude' => '-82.9986000',
                'city' => 'Filion',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48413',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8059000',
                'longitude' => '-82.9986000',
                'city' => 'Bad Axe',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49738',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.5003000',
                'longitude' => '-84.5942000',
                'city' => 'Grayling',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48841',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0003000',
                'longitude' => '-84.1824000',
                'city' => 'Henderson',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48733',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5168000',
                'longitude' => '-83.5434000',
                'city' => 'Fairgrove',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48801',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3733000',
                'longitude' => '-84.6682000',
                'city' => 'Alma',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48850',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4314000',
                'longitude' => '-85.2756000',
                'city' => 'Lakeview',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48476',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9143000',
                'longitude' => '-83.9833000',
                'city' => 'Vernon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48885',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2092000',
                'longitude' => '-85.0749000',
                'city' => 'Sidney',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48609',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4321000',
                'longitude' => '-83.9426000',
                'city' => 'Saginaw',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48626',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4174000',
                'longitude' => '-84.2322000',
                'city' => 'Hemlock',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48880',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4080000',
                'longitude' => '-84.6115000',
                'city' => 'Saint Louis',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49765',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.3604000',
                'longitude' => '-84.2327000',
                'city' => 'Onaway',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48658',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9856000',
                'longitude' => '-83.9586000',
                'city' => 'Standish',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48858',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6026000',
                'longitude' => '-84.7693000',
                'city' => 'Mount Pleasant',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48616',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1808000',
                'longitude' => '-84.1171000',
                'city' => 'Chesaning',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48621',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.7266000',
                'longitude' => '-84.0500000',
                'city' => 'Fairview',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48742',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6853000',
                'longitude' => '-83.4109000',
                'city' => 'Lincoln',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48893',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6851000',
                'longitude' => '-84.9660000',
                'city' => 'Weidman',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48622',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8358000',
                'longitude' => '-84.8678000',
                'city' => 'Farwell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49756',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8850000',
                'longitude' => '-84.2995000',
                'city' => 'Lewiston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49733',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6420000',
                'longitude' => '-84.7679000',
                'city' => 'Frederic',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48756',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2756000',
                'longitude' => '-84.2375000',
                'city' => 'Prescott',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48610',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2756000',
                'longitude' => '-84.2375000',
                'city' => 'Alger',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49779',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4270000',
                'longitude' => '-83.8272000',
                'city' => 'Rogers City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48886',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4399000',
                'longitude' => '-85.2834000',
                'city' => 'Six Lakes',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48748',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2831000',
                'longitude' => '-83.4887000',
                'city' => 'National City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48651',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3025000',
                'longitude' => '-84.6446000',
                'city' => 'Prudenville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48726',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6000000',
                'longitude' => '-83.1800000',
                'city' => 'Cass City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48728',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8344000',
                'longitude' => '-83.7725000',
                'city' => 'Curran',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48754',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7242000',
                'longitude' => '-83.2669000',
                'city' => 'Owendale',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48731',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8165000',
                'longitude' => '-83.1824000',
                'city' => 'Elkton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48725',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8165000',
                'longitude' => '-83.1824000',
                'city' => 'Caseville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49744',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0688000',
                'longitude' => '-83.7172000',
                'city' => 'Herron',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49776',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0688000',
                'longitude' => '-83.7172000',
                'city' => 'Posen',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49746',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0688000',
                'longitude' => '-83.7172000',
                'city' => 'Hillman',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49753',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0688000',
                'longitude' => '-83.7172000',
                'city' => 'Lachine',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48632',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7520000',
                'longitude' => '-85.1391000',
                'city' => 'Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48835',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0005000',
                'longitude' => '-84.7696000',
                'city' => 'Fowler',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48656',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.3704000',
                'longitude' => '-84.4116000',
                'city' => 'Saint Helen',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48708',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6005000',
                'longitude' => '-83.8857000',
                'city' => 'Bay City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48831',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0821000',
                'longitude' => '-84.3852000',
                'city' => 'Elsie',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48612',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9824000',
                'longitude' => '-84.4930000',
                'city' => 'Beaverton',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49310',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4076000',
                'longitude' => '-85.0405000',
                'city' => 'Blanchard',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48812',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4076000',
                'longitude' => '-85.0405000',
                'city' => 'Cedar Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48768',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3683000',
                'longitude' => '-83.5849000',
                'city' => 'Vassar',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48878',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6997000',
                'longitude' => '-84.7720000',
                'city' => 'Rosebush',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48618',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7596000',
                'longitude' => '-84.5849000',
                'city' => 'Coleman',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48720',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8275000',
                'longitude' => '-83.2693000',
                'city' => 'Bay Port',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48759',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8275000',
                'longitude' => '-83.2693000',
                'city' => 'Sebewaing',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48755',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8275000',
                'longitude' => '-83.2693000',
                'city' => 'Pigeon',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48832',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3790000',
                'longitude' => '-84.6564000',
                'city' => 'Elwell',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48889',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3790000',
                'longitude' => '-84.6564000',
                'city' => 'Sumner',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48657',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7596000',
                'longitude' => '-84.5849000',
                'city' => 'Sanford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48727',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3193000',
                'longitude' => '-83.1781000',
                'city' => 'Clifford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48762',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9061000',
                'longitude' => '-83.4487000',
                'city' => 'Spruce',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48721',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9061000',
                'longitude' => '-83.4487000',
                'city' => 'Black River',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49766',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.9061000',
                'longitude' => '-83.4487000',
                'city' => 'Ossineke',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48470',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8433000',
                'longitude' => '-82.6552000',
                'city' => 'Ruth',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48441',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8433000',
                'longitude' => '-82.6552000',
                'city' => 'Harbor Beach',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48615',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4079000',
                'longitude' => '-84.4731000',
                'city' => 'Breckenridge',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48701',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5649000',
                'longitude' => '-83.5184000',
                'city' => 'Akron',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48654',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.4185000',
                'longitude' => '-84.1197000',
                'city' => 'Rose City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48659',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0341000',
                'longitude' => '-84.0220000',
                'city' => 'Sterling',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48744',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3350000',
                'longitude' => '-83.3485000',
                'city' => 'Mayville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48883',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5270000',
                'longitude' => '-84.6911000',
                'city' => 'Shepherd',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48806',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1853000',
                'longitude' => '-84.4768000',
                'city' => 'Ashley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48866',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0095000',
                'longitude' => '-84.3779000',
                'city' => 'Ovid',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48655',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2587000',
                'longitude' => '-84.2363000',
                'city' => 'Saint Charles',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48614',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2587000',
                'longitude' => '-84.2363000',
                'city' => 'Brant',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48894',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9234000',
                'longitude' => '-84.8014000',
                'city' => 'Westphalia',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48873',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '42.9234000',
                'longitude' => '-84.8014000',
                'city' => 'Pewamo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48633',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.8358000',
                'longitude' => '-84.8678000',
                'city' => 'Lake George',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49777',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.1923000',
                'longitude' => '-83.4383000',
                'city' => 'Presque Isle',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48845',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.0920000',
                'longitude' => '-84.8347000',
                'city' => 'Hubbardston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48417',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2508000',
                'longitude' => '-83.7834000',
                'city' => 'Burt',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48741',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3302000',
                'longitude' => '-83.0809000',
                'city' => 'Kingston',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48667',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6138000',
                'longitude' => '-84.2414000',
                'city' => 'Midland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48674',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6138000',
                'longitude' => '-84.2414000',
                'city' => 'Midland',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48870',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1126000',
                'longitude' => '-84.9846000',
                'city' => 'Palo',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48860',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1126000',
                'longitude' => '-84.9846000',
                'city' => 'Muir',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48637',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4134000',
                'longitude' => '-84.2354000',
                'city' => 'Merrill',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48722',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3393000',
                'longitude' => '-83.7404000',
                'city' => 'Bridgeport',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48766',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.0461000',
                'longitude' => '-83.8495000',
                'city' => 'Twining',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48757',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5167000',
                'longitude' => '-83.7784000',
                'city' => 'Reese',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48747',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5167000',
                'longitude' => '-83.7784000',
                'city' => 'Munger',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48649',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1342000',
                'longitude' => '-84.3072000',
                'city' => 'Oakley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48807',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1342000',
                'longitude' => '-84.3072000',
                'city' => 'Bannister',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48631',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6057000',
                'longitude' => '-84.0722000',
                'city' => 'Kawkawlin',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48634',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6057000',
                'longitude' => '-84.0722000',
                'city' => 'Linwood',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48767',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6576000',
                'longitude' => '-83.2500000',
                'city' => 'Unionville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48735',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6576000',
                'longitude' => '-83.2500000',
                'city' => 'Gagetown',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48853',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1022000',
                'longitude' => '-84.6952000',
                'city' => 'Maple Rapids',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48729',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4147000',
                'longitude' => '-83.1870000',
                'city' => 'Deford',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48760',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4147000',
                'longitude' => '-83.1870000',
                'city' => 'Silverwood',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48652',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7629000',
                'longitude' => '-84.3404000',
                'city' => 'Rhodes',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48620',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.7629000',
                'longitude' => '-84.3404000',
                'city' => 'Edenville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49751',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.0298000',
                'longitude' => '-84.6733000',
                'city' => 'Johannesburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48740',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6562000',
                'longitude' => '-83.2931000',
                'city' => 'Harrisville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48738',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6562000',
                'longitude' => '-83.2931000',
                'city' => 'Greenbush',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48745',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6562000',
                'longitude' => '-83.2931000',
                'city' => 'Mikado',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49747',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.8302000',
                'longitude' => '-83.5733000',
                'city' => 'Hubbard Lake',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49759',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.3581000',
                'longitude' => '-84.2271000',
                'city' => 'Millersburg',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49792',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.3581000',
                'longitude' => '-84.2271000',
                'city' => 'Tower',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49743',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '45.4183000',
                'longitude' => '-83.8194000',
                'city' => 'Hawks',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48705',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6814000',
                'longitude' => '-83.4142000',
                'city' => 'Barton City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48765',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.2317000',
                'longitude' => '-83.8067000',
                'city' => 'Turner',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48852',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.3522000',
                'longitude' => '-85.0480000',
                'city' => 'Mcbrides',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48859',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6009000',
                'longitude' => '-84.7779000',
                'city' => 'Mount Pleasant',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48746',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2560000',
                'longitude' => '-83.3770000',
                'city' => 'Millington',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48707',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4321000',
                'longitude' => '-83.9426000',
                'city' => 'Bay City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48636',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6480000',
                'longitude' => '-84.1304000',
                'city' => 'Luzerne',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48647',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6480000',
                'longitude' => '-84.1304000',
                'city' => 'Mio',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48874',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.1847000',
                'longitude' => '-84.6007000',
                'city' => 'Pompeii',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48662',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4079000',
                'longitude' => '-84.4731000',
                'city' => 'Wheeler',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48613',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.9856000',
                'longitude' => '-83.9586000',
                'city' => 'Bentley',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48619',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.7266000',
                'longitude' => '-84.0500000',
                'city' => 'Comins',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48434',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6728000',
                'longitude' => '-82.7701000',
                'city' => 'Forestville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48456',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6728000',
                'longitude' => '-82.7701000',
                'city' => 'Minden City',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48896',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.5257000',
                'longitude' => '-84.9033000',
                'city' => 'Winn',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48758',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.4524000',
                'longitude' => '-83.6918000',
                'city' => 'Richville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48862',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.2903000',
                'longitude' => '-84.6108000',
                'city' => 'North Star',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '48732',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '43.6005000',
                'longitude' => '-83.8857000',
                'city' => 'Essexville',
                'full_state' => 'Michigan',
            ],
            [
                'zip' => '49734',
                'country_code' => 'US',
                'state' => 'MI',
                'latitude' => '44.6172000',
                'longitude' => '-84.9142000',
                'city' => 'Gaylord',
                'full_state' => 'Michigan',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
