<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MassachusettsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '2043',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2445000',
                'longitude' => '-70.8807000',
                'city' => 'Hingham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1880',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5006000',
                'longitude' => '-71.0739000',
                'city' => 'Wakefield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2139',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3648000',
                'longitude' => '-71.0819000',
                'city' => 'Cambridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2141',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3648000',
                'longitude' => '-71.0819000',
                'city' => 'Cambridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2032',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1913000',
                'longitude' => '-71.2033000',
                'city' => 'East Walpole',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2090',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1913000',
                'longitude' => '-71.2033000',
                'city' => 'Westwood',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2199',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3670000',
                'longitude' => '-71.0954000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2163',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3670000',
                'longitude' => '-71.0954000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2155',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4173000',
                'longitude' => '-71.1111000',
                'city' => 'Medford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2452',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3755000',
                'longitude' => '-71.2377000',
                'city' => 'Waltham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2451',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3755000',
                'longitude' => '-71.2377000',
                'city' => 'Waltham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2420',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4470000',
                'longitude' => '-71.2300000',
                'city' => 'Lexington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2148',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4263000',
                'longitude' => '-71.0770000',
                'city' => 'Malden',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2494',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2792000',
                'longitude' => '-71.2331000',
                'city' => 'Needham Heights',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2151',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4054000',
                'longitude' => '-71.0124000',
                'city' => 'Revere',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1801',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4820000',
                'longitude' => '-71.1509000',
                'city' => 'Woburn',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2067',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1225000',
                'longitude' => '-71.1762000',
                'city' => 'Sharon',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1803',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5013000',
                'longitude' => '-71.1933000',
                'city' => 'Burlington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2184',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2163000',
                'longitude' => '-71.0001000',
                'city' => 'Braintree',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2021',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1570000',
                'longitude' => '-71.1458000',
                'city' => 'Canton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2338',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0411000',
                'longitude' => '-70.8448000',
                'city' => 'Halifax',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2359',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0411000',
                'longitude' => '-70.8448000',
                'city' => 'Pembroke',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2176',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4560000',
                'longitude' => '-71.0678000',
                'city' => 'Melrose',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2364',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9921000',
                'longitude' => '-70.7243000',
                'city' => 'Kingston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2025',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2403000',
                'longitude' => '-70.8054000',
                'city' => 'Cohasset',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2476',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4140000',
                'longitude' => '-71.1548000',
                'city' => 'Arlington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1905',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4644000',
                'longitude' => '-70.9542000',
                'city' => 'Lynn',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1902',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4644000',
                'longitude' => '-70.9542000',
                'city' => 'Lynn',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2370',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1294000',
                'longitude' => '-70.9136000',
                'city' => 'Rockland',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2191',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2209000',
                'longitude' => '-70.9391000',
                'city' => 'North Weymouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2188',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2209000',
                'longitude' => '-70.9391000',
                'city' => 'Weymouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2066',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1989000',
                'longitude' => '-70.7559000',
                'city' => 'Scituate',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1906',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4506000',
                'longitude' => '-71.0097000',
                'city' => 'Saugus',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2061',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1603000',
                'longitude' => '-70.7992000',
                'city' => 'Norwell',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2482',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3049000',
                'longitude' => '-71.2764000',
                'city' => 'Wellesley',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2050',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1017000',
                'longitude' => '-70.7212000',
                'city' => 'Marshfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2368',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1649000',
                'longitude' => '-71.0414000',
                'city' => 'Randolph',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1923',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5626000',
                'longitude' => '-70.9319000',
                'city' => 'Danvers',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1026',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4613000',
                'longitude' => '-72.8899000',
                'city' => 'Cummington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1027',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2707000',
                'longitude' => '-72.6681000',
                'city' => 'Easthampton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1230',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Great Barrington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1089',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'West Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1115',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1108',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1105',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1085',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Westfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1101',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1109',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1104',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1022',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1477000',
                'longitude' => '-72.5950000',
                'city' => 'Chicopee',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1020',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1477000',
                'longitude' => '-72.5950000',
                'city' => 'Chicopee',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1050',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2355000',
                'longitude' => '-72.8787000',
                'city' => 'Huntington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1346',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4772000',
                'longitude' => '-72.6044000',
                'city' => 'Heath',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1375',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4772000',
                'longitude' => '-72.6044000',
                'city' => 'Sunderland',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1103',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1152',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1075',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2044000',
                'longitude' => '-72.6131000',
                'city' => 'South Hadley',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1201',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4500000',
                'longitude' => '-73.2559000',
                'city' => 'Pittsfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1007',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2782000',
                'longitude' => '-72.3998000',
                'city' => 'Belchertown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1235',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3299000',
                'longitude' => '-73.0847000',
                'city' => 'Hinsdale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1011',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3299000',
                'longitude' => '-73.0847000',
                'city' => 'Chester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1267',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7066000',
                'longitude' => '-73.2020000',
                'city' => 'Williamstown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1118',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1056',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1130000',
                'longitude' => '-72.5850000',
                'city' => 'Ludlow',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1301',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5909000',
                'longitude' => '-72.6006000',
                'city' => 'Greenfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1028',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1074000',
                'longitude' => '-72.5752000',
                'city' => 'East Longmeadow',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1354',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6976000',
                'longitude' => '-72.4534000',
                'city' => 'Gill',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1342',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5909000',
                'longitude' => '-72.6006000',
                'city' => 'Deerfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1376',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5909000',
                'longitude' => '-72.6006000',
                'city' => 'Turners Falls',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1069',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1586000',
                'longitude' => '-72.3235000',
                'city' => 'Palmer',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1222',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-73.3559000',
                'city' => 'Ashley Falls',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1259',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-73.3559000',
                'city' => 'Southfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1244',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-73.3559000',
                'city' => 'Mill River',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1257',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-73.3559000',
                'city' => 'Sheffield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1002',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3748000',
                'longitude' => '-72.5170000',
                'city' => 'Amherst',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1144',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1030000',
                'longitude' => '-72.5877000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1236',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3355000',
                'longitude' => '-73.3688000',
                'city' => 'Housatonic',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1266',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3355000',
                'longitude' => '-73.3688000',
                'city' => 'West Stockbridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1243',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4118000',
                'longitude' => '-72.9347000',
                'city' => 'Middlefield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1098',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4118000',
                'longitude' => '-72.9347000',
                'city' => 'Worthington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1264',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3080000',
                'longitude' => '-73.2490000',
                'city' => 'Tyringham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1223',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3080000',
                'longitude' => '-73.2490000',
                'city' => 'Becket',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1238',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3080000',
                'longitude' => '-73.2490000',
                'city' => 'Lee',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1521',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1237000',
                'longitude' => '-72.2034000',
                'city' => 'Holland',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1081',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1237000',
                'longitude' => '-72.2034000',
                'city' => 'Wales',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1010',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1237000',
                'longitude' => '-72.2034000',
                'city' => 'Brimfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1088',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3771000',
                'longitude' => '-72.6014000',
                'city' => 'West Hatfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1066',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3771000',
                'longitude' => '-72.6014000',
                'city' => 'North Hatfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1038',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3771000',
                'longitude' => '-72.6014000',
                'city' => 'Hatfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1226',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4500000',
                'longitude' => '-73.2559000',
                'city' => 'Dalton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1237',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4500000',
                'longitude' => '-73.2559000',
                'city' => 'Lanesboro',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1349',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6075000',
                'longitude' => '-72.5589000',
                'city' => 'Millers Falls',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1255',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0968000',
                'longitude' => '-73.0803000',
                'city' => 'Sandisfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1034',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0968000',
                'longitude' => '-73.0803000',
                'city' => 'Granville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1072',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3748000',
                'longitude' => '-72.5170000',
                'city' => 'Shutesbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1151',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Indian Orchard',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1129',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1107',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1057',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1012000',
                'longitude' => '-72.3143000',
                'city' => 'Monson',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1039',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3721000',
                'longitude' => '-72.6935000',
                'city' => 'Haydenville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1032',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3721000',
                'longitude' => '-72.6935000',
                'city' => 'Goshen',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1096',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3721000',
                'longitude' => '-72.6935000',
                'city' => 'Williamsburg',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1253',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1934000',
                'longitude' => '-73.0879000',
                'city' => 'Otis',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1029',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1934000',
                'longitude' => '-73.0879000',
                'city' => 'East Otis',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1095',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1541000',
                'longitude' => '-72.4858000',
                'city' => 'Wilbraham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1082',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2598000',
                'longitude' => '-72.2379000',
                'city' => 'Ware',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1062',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3193000',
                'longitude' => '-72.6318000',
                'city' => 'Florence',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1035',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3193000',
                'longitude' => '-72.6318000',
                'city' => 'Hadley',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1080',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1586000',
                'longitude' => '-72.3235000',
                'city' => 'Three Rivers',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1009',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1586000',
                'longitude' => '-72.3235000',
                'city' => 'Bondsville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1079',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1586000',
                'longitude' => '-72.3235000',
                'city' => 'Thorndike',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1084',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3914000',
                'longitude' => '-72.8383000',
                'city' => 'West Chesterfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1012',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3914000',
                'longitude' => '-72.8383000',
                'city' => 'Chesterfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1229',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2858000',
                'longitude' => '-73.3115000',
                'city' => 'Glendale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1262',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2858000',
                'longitude' => '-73.3115000',
                'city' => 'Stockbridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1071',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1888000',
                'longitude' => '-72.8576000',
                'city' => 'Russell',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1013',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2044000',
                'longitude' => '-72.6131000',
                'city' => 'Chicopee',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1061',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3193000',
                'longitude' => '-72.6318000',
                'city' => 'Northampton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1240',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3565000',
                'longitude' => '-73.2840000',
                'city' => 'Lenox',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1339',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6285000',
                'longitude' => '-72.8689000',
                'city' => 'Charlemont',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1340',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6285000',
                'longitude' => '-72.8689000',
                'city' => 'Colrain',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1367',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6285000',
                'longitude' => '-72.8689000',
                'city' => 'Rowe',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1506',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2117000',
                'longitude' => '-72.1951000',
                'city' => 'Brookfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1247',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6956000',
                'longitude' => '-73.1112000',
                'city' => 'North Adams',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1337',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6729000',
                'longitude' => '-72.5517000',
                'city' => 'Bernardston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1351',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5360000',
                'longitude' => '-72.5252000',
                'city' => 'Montague',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1347',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5360000',
                'longitude' => '-72.5252000',
                'city' => 'Lake Pleasant',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1054',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5360000',
                'longitude' => '-72.5252000',
                'city' => 'Leverett',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1341',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5113000',
                'longitude' => '-72.6942000',
                'city' => 'Conway',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1036',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0665000',
                'longitude' => '-72.4145000',
                'city' => 'Hampden',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1106',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0583000',
                'longitude' => '-72.5805000',
                'city' => 'Longmeadow',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1060',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3193000',
                'longitude' => '-72.6318000',
                'city' => 'Northampton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1093',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4800000',
                'longitude' => '-72.6093000',
                'city' => 'Whately',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1373',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4800000',
                'longitude' => '-72.6093000',
                'city' => 'South Deerfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1040',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2044000',
                'longitude' => '-72.6131000',
                'city' => 'Holyoke',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1350',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7691000',
                'longitude' => '-72.9455000',
                'city' => 'Monroe Bridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1128',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1184000',
                'longitude' => '-72.5242000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1119',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1184000',
                'longitude' => '-72.5242000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1258',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1934000',
                'longitude' => '-73.3617000',
                'city' => 'South Egremont',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1585',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2153000',
                'longitude' => '-72.1913000',
                'city' => 'West Brookfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1092',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2153000',
                'longitude' => '-72.1913000',
                'city' => 'West Warren',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1083',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2153000',
                'longitude' => '-72.1913000',
                'city' => 'Warren',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1033',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2583000',
                'longitude' => '-72.5159000',
                'city' => 'Granby',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1031',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3075000',
                'longitude' => '-72.2101000',
                'city' => 'Gilbertville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1531',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3075000',
                'longitude' => '-72.2101000',
                'city' => 'New Braintree',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1094',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3075000',
                'longitude' => '-72.2101000',
                'city' => 'Wheelwright',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1037',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3075000',
                'longitude' => '-72.2101000',
                'city' => 'Hardwick',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1360',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6976000',
                'longitude' => '-72.4534000',
                'city' => 'Northfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1073',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2671000',
                'longitude' => '-72.6719000',
                'city' => 'Southampton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1245',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1934000',
                'longitude' => '-73.3617000',
                'city' => 'Monterey',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1344',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1586000',
                'longitude' => '-72.3235000',
                'city' => 'Erving',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1003',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3804000',
                'longitude' => '-72.5267000',
                'city' => 'Amherst',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1004',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3804000',
                'longitude' => '-72.5267000',
                'city' => 'Amherst',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1077',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0575000',
                'longitude' => '-72.7697000',
                'city' => 'Southwick',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1053',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3193000',
                'longitude' => '-72.6318000',
                'city' => 'Leeds',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1338',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6048000',
                'longitude' => '-72.7361000',
                'city' => 'Buckland',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1370',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6048000',
                'longitude' => '-72.7361000',
                'city' => 'Shelburne Falls',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1330',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6048000',
                'longitude' => '-72.7361000',
                'city' => 'Ashfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1070',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4613000',
                'longitude' => '-72.8899000',
                'city' => 'Plainfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1242',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3565000',
                'longitude' => '-73.2840000',
                'city' => 'Lenox Dale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1001',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1586000',
                'longitude' => '-72.3235000',
                'city' => 'Agawam',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1270',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4774000',
                'longitude' => '-73.1719000',
                'city' => 'Windsor',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1254',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3810000',
                'longitude' => '-73.3679000',
                'city' => 'Richmond',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1225',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6266000',
                'longitude' => '-73.1217000',
                'city' => 'Cheshire',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1256',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6266000',
                'longitude' => '-73.1217000',
                'city' => 'Savoy',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1220',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6266000',
                'longitude' => '-73.1217000',
                'city' => 'Adams',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1111',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1008',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1796000',
                'longitude' => '-72.9223000',
                'city' => 'Blandford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1199',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1058000',
                'longitude' => '-72.5926000',
                'city' => 'Springfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1030',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0828000',
                'longitude' => '-72.6329000',
                'city' => 'Feeding Hills',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1116',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0583000',
                'longitude' => '-72.5805000',
                'city' => 'Longmeadow',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1343',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6285000',
                'longitude' => '-72.8689000',
                'city' => 'Drury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1701',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Framingham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2035',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0619000',
                'longitude' => '-71.2512000',
                'city' => 'Foxboro',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2375',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0669000',
                'longitude' => '-71.1027000',
                'city' => 'South Easton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2071',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1426000',
                'longitude' => '-71.2493000',
                'city' => 'South Walpole',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2746',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6327000',
                'longitude' => '-70.9252000',
                'city' => 'New Bedford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2744',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6327000',
                'longitude' => '-70.9252000',
                'city' => 'New Bedford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2302',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0798000',
                'longitude' => '-71.0167000',
                'city' => 'Brockton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2453',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9141000',
                'longitude' => '-70.5566000',
                'city' => 'Waltham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2360',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9141000',
                'longitude' => '-70.5566000',
                'city' => 'Plymouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1520',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3455000',
                'longitude' => '-71.8590000',
                'city' => 'Holden',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2769',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9431000',
                'longitude' => '-71.2871000',
                'city' => 'Rehoboth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1571',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0469000',
                'longitude' => '-71.8759000',
                'city' => 'Dudley',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2667',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9390000',
                'longitude' => '-70.0345000',
                'city' => 'Wellfleet',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2324',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9862000',
                'longitude' => '-70.9776000',
                'city' => 'Bridgewater',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2481',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2839000',
                'longitude' => '-71.3395000',
                'city' => 'Wellesley Hills',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2668',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.2826000',
                'longitude' => '-70.0973000',
                'city' => 'West Barnstable',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2554',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.2826000',
                'longitude' => '-70.0973000',
                'city' => 'Nantucket',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2766',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9431000',
                'longitude' => '-71.2871000',
                'city' => 'Norton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2703',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9431000',
                'longitude' => '-71.2871000',
                'city' => 'Attleboro',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2345',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9141000',
                'longitude' => '-70.5566000',
                'city' => 'Manomet',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2381',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9141000',
                'longitude' => '-70.5566000',
                'city' => 'White Horse Beach',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2563',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Sandwich',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1772',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3452000',
                'longitude' => '-71.5411000',
                'city' => 'Southborough',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1752',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3452000',
                'longitude' => '-71.5411000',
                'city' => 'Marlborough',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2356',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0761000',
                'longitude' => '-71.1083000',
                'city' => 'North Easton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1721',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2552000',
                'longitude' => '-71.4588000',
                'city' => 'Ashland',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2301',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0798000',
                'longitude' => '-71.0167000',
                'city' => 'Brockton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2322',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0798000',
                'longitude' => '-71.0167000',
                'city' => 'Avon',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2379',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0798000',
                'longitude' => '-71.0167000',
                'city' => 'West Bridgewater',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1757',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Milford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1760',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Natick',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1534',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-71.6665000',
                'city' => 'Northbridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1590',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-71.6665000',
                'city' => 'Sutton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1569',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-71.6665000',
                'city' => 'Uxbridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1525',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-71.6665000',
                'city' => 'Linwood',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1588',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-71.6665000',
                'city' => 'Whitinsville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2777',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Swansea',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2720',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Fall River',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2054',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Millis',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1540',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Oxford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2722',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Fall River',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2723',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Fall River',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2726',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Somerset',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2721',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Fall River',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2724',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Fall River',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2790',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Westport',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2653',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7878000',
                'longitude' => '-69.9899000',
                'city' => 'Orleans',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2642',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7878000',
                'longitude' => '-69.9899000',
                'city' => 'Eastham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2631',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7878000',
                'longitude' => '-69.9899000',
                'city' => 'Brewster',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2651',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6836000',
                'longitude' => '-69.9642000',
                'city' => 'North Eastham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2052',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1804000',
                'longitude' => '-71.3029000',
                'city' => 'Medfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1749',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3339000',
                'longitude' => '-71.5616000',
                'city' => 'Hudson',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1746',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9862000',
                'longitude' => '-70.9776000',
                'city' => 'Holliston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2662',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7878000',
                'longitude' => '-69.9899000',
                'city' => 'South Orleans',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2663',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7878000',
                'longitude' => '-69.9899000',
                'city' => 'South Wellfleet',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1507',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1425000',
                'longitude' => '-71.9695000',
                'city' => 'Charlton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1748',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2249000',
                'longitude' => '-71.5161000',
                'city' => 'Hopkinton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2764',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.8403000',
                'longitude' => '-71.2420000',
                'city' => 'North Dighton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1702',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Framingham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2643',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7878000',
                'longitude' => '-69.9899000',
                'city' => 'East Orleans',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2564',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.2625000',
                'longitude' => '-69.9692000',
                'city' => 'Siasconset',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2638',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6682000',
                'longitude' => '-70.1889000',
                'city' => 'Dennis',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2053',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2277000',
                'longitude' => '-71.5209000',
                'city' => 'Medway',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2048',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0292000',
                'longitude' => '-71.2159000',
                'city' => 'Mansfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2771',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.8102000',
                'longitude' => '-71.3383000',
                'city' => 'Seekonk',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2169',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6568000',
                'longitude' => '-71.1394000',
                'city' => 'Quincy',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1538',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1096000',
                'longitude' => '-71.6665000',
                'city' => 'North Uxbridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2767',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0669000',
                'longitude' => '-71.1027000',
                'city' => 'Raynham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2538',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7543000',
                'longitude' => '-70.7192000',
                'city' => 'East Wareham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2571',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7543000',
                'longitude' => '-70.7192000',
                'city' => 'Wareham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2558',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5498000',
                'longitude' => '-70.6138000',
                'city' => 'Onset',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2540',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5498000',
                'longitude' => '-70.6138000',
                'city' => 'Falmouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2648',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5498000',
                'longitude' => '-70.6138000',
                'city' => 'Marstons Mills',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2649',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5498000',
                'longitude' => '-70.6138000',
                'city' => 'Mashpee',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1778',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3025000',
                'longitude' => '-71.2232000',
                'city' => 'Wayland',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2333',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9862000',
                'longitude' => '-70.9776000',
                'city' => 'East Bridgewater',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2660',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6517000',
                'longitude' => '-70.2870000',
                'city' => 'South Dennis',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1583',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1371000',
                'longitude' => '-71.5254000',
                'city' => 'West Boylston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1944',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6111000',
                'longitude' => '-70.6597000',
                'city' => 'Manchester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1966',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6111000',
                'longitude' => '-70.6597000',
                'city' => 'Rockport',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2770',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7791000',
                'longitude' => '-70.9058000',
                'city' => 'Rochester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2543',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5498000',
                'longitude' => '-70.6138000',
                'city' => 'Woods Hole',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2576',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7543000',
                'longitude' => '-70.7192000',
                'city' => 'West Wareham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2655',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6239000',
                'longitude' => '-70.3884000',
                'city' => 'Osterville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1604',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2277000',
                'longitude' => '-71.5209000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2532',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7543000',
                'longitude' => '-70.7192000',
                'city' => 'Buzzards Bay',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2632',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6657000',
                'longitude' => '-70.6116000',
                'city' => 'Centerville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2038',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0858000',
                'longitude' => '-71.3994000',
                'city' => 'Franklin',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2536',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5498000',
                'longitude' => '-70.6138000',
                'city' => 'East Falmouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2556',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5498000',
                'longitude' => '-70.6138000',
                'city' => 'North Falmouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2780',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9033000',
                'longitude' => '-71.0933000',
                'city' => 'Taunton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1610',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2597000',
                'longitude' => '-71.8021000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1655',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2597000',
                'longitude' => '-71.8021000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2718',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9033000',
                'longitude' => '-71.0933000',
                'city' => 'East Taunton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2559',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6657000',
                'longitude' => '-70.6116000',
                'city' => 'Pocasset',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2542',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6657000',
                'longitude' => '-70.6116000',
                'city' => 'Buzzards Bay',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2763',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9815000',
                'longitude' => '-71.3320000',
                'city' => 'Attleboro Falls',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2760',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9815000',
                'longitude' => '-71.3320000',
                'city' => 'North Attleboro',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2133',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3676000',
                'longitude' => '-71.0867000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2142',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3676000',
                'longitude' => '-71.0867000',
                'city' => 'Cambridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2725',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Somerset',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1501',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1951000',
                'longitude' => '-71.8409000',
                'city' => 'Auburn',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2072',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2277000',
                'longitude' => '-71.5209000',
                'city' => 'Stoughton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1581',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2716000',
                'longitude' => '-71.6143000',
                'city' => 'Westborough',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1545',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5823000',
                'longitude' => '-71.8058000',
                'city' => 'Shrewsbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1605',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1742',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2661000',
                'longitude' => '-71.8030000',
                'city' => 'Concord',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2568',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.4507000',
                'longitude' => '-70.6051000',
                'city' => 'Vineyard Haven',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1518',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1075000',
                'longitude' => '-72.0785000',
                'city' => 'Fiskdale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2303',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0798000',
                'longitude' => '-71.0167000',
                'city' => 'Brockton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1566',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1124000',
                'longitude' => '-72.0969000',
                'city' => 'Sturbridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2650',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6871000',
                'longitude' => '-69.9603000',
                'city' => 'North Chatham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2669',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6871000',
                'longitude' => '-69.9603000',
                'city' => 'West Chatham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2459',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6871000',
                'longitude' => '-69.9603000',
                'city' => 'Newton Center',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2633',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6871000',
                'longitude' => '-69.9603000',
                'city' => 'Chatham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2666',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9361000',
                'longitude' => '-70.0298000',
                'city' => 'Truro',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1532',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3028000',
                'longitude' => '-71.6276000',
                'city' => 'Northborough',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1609',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2661000',
                'longitude' => '-71.8030000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1608',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2661000',
                'longitude' => '-71.8030000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2738',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6995000',
                'longitude' => '-70.7642000',
                'city' => 'Marion',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1745',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3452000',
                'longitude' => '-71.5411000',
                'city' => 'Fayville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2673',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6517000',
                'longitude' => '-70.2870000',
                'city' => 'West Yarmouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2675',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7007000',
                'longitude' => '-70.3023000',
                'city' => 'Yarmouth Port',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2630',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7007000',
                'longitude' => '-70.3023000',
                'city' => 'Barnstable',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2637',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7007000',
                'longitude' => '-70.3023000',
                'city' => 'Cummaquid',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2537',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7007000',
                'longitude' => '-70.3023000',
                'city' => 'East Sandwich',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1612',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Paxton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1527',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Millbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1607',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1602',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1603',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2664',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7007000',
                'longitude' => '-70.3023000',
                'city' => 'South Yarmouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1756',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1371000',
                'longitude' => '-71.5254000',
                'city' => 'Mendon',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1747',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1371000',
                'longitude' => '-71.5254000',
                'city' => 'Hopedale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2056',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0622000',
                'longitude' => '-71.3302000',
                'city' => 'Norfolk',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2093',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0622000',
                'longitude' => '-71.3302000',
                'city' => 'Wrentham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2641',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7459000',
                'longitude' => '-70.1811000',
                'city' => 'East Dennis',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2119',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1582',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2716000',
                'longitude' => '-71.6143000',
                'city' => 'Westborough',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2639',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6682000',
                'longitude' => '-70.1889000',
                'city' => 'Dennis Port',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2670',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6682000',
                'longitude' => '-70.1889000',
                'city' => 'West Dennis',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1776',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Sudbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2645',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6657000',
                'longitude' => '-70.6116000',
                'city' => 'Harwich',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2657',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0506000',
                'longitude' => '-70.1883000',
                'city' => 'Provincetown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2601',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6517000',
                'longitude' => '-70.2870000',
                'city' => 'Hyannis',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2635',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6239000',
                'longitude' => '-70.3884000',
                'city' => 'Cotuit',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1568',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1371000',
                'longitude' => '-71.5254000',
                'city' => 'Upton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1862',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5604000',
                'longitude' => '-71.2634000',
                'city' => 'North Billerica',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2646',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6858000',
                'longitude' => '-70.0734000',
                'city' => 'Harwich Port',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2671',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6858000',
                'longitude' => '-70.0734000',
                'city' => 'West Harwich',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2659',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6858000',
                'longitude' => '-70.0734000',
                'city' => 'South Chatham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1606',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2661000',
                'longitude' => '-71.8030000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1852',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2661000',
                'longitude' => '-71.8030000',
                'city' => 'Lowell',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2081',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1107000',
                'longitude' => '-71.2449000',
                'city' => 'Walpole',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1570',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0469000',
                'longitude' => '-71.8759000',
                'city' => 'Webster',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1982',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0833000',
                'longitude' => '-71.0128000',
                'city' => 'South Hamilton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1526',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0706000',
                'longitude' => '-71.7091000',
                'city' => 'Manchaug',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1516',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0706000',
                'longitude' => '-71.7091000',
                'city' => 'Douglas',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2644',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6200000',
                'longitude' => '-70.4880000',
                'city' => 'Forestdale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2652',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0535000',
                'longitude' => '-70.1930000',
                'city' => 'North Truro',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1886',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5858000',
                'longitude' => '-71.4341000',
                'city' => 'Westford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1960',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2958000',
                'longitude' => '-71.7148000',
                'city' => 'Peabody',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1961',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2958000',
                'longitude' => '-71.7148000',
                'city' => 'Peabody',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1562',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2958000',
                'longitude' => '-71.7148000',
                'city' => 'Spencer',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1453',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5244000',
                'longitude' => '-70.9268000',
                'city' => 'Leominster',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2325',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9862000',
                'longitude' => '-70.9776000',
                'city' => 'Bridgewater',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1770',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3025000',
                'longitude' => '-71.2232000',
                'city' => 'Sherborn',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2127',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2534',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6657000',
                'longitude' => '-70.6116000',
                'city' => 'Cataumet',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2357',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0761000',
                'longitude' => '-71.1083000',
                'city' => 'North Easton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1720',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5213000',
                'longitude' => '-71.4338000',
                'city' => 'Acton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1460',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5213000',
                'longitude' => '-71.4338000',
                'city' => 'Littleton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1560',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1888000',
                'longitude' => '-71.7607000',
                'city' => 'South Grafton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2367',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6517000',
                'longitude' => '-70.2870000',
                'city' => 'Plympton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2539',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.3898000',
                'longitude' => '-70.5147000',
                'city' => 'Edgartown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1851',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0798000',
                'longitude' => '-71.0167000',
                'city' => 'Lowell',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1843',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7065000',
                'longitude' => '-71.1639000',
                'city' => 'Lawrence',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1841',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7065000',
                'longitude' => '-71.1639000',
                'city' => 'Lawrence',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1601',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2661000',
                'longitude' => '-71.8030000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2748',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5664000',
                'longitude' => '-71.0773000',
                'city' => 'South Dartmouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2747',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5664000',
                'longitude' => '-71.0773000',
                'city' => 'North Dartmouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2791',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.5664000',
                'longitude' => '-71.0773000',
                'city' => 'Westport Point',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1515',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2667000',
                'longitude' => '-72.0801000',
                'city' => 'East Brookfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2715',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7054000',
                'longitude' => '-71.1533000',
                'city' => 'Dighton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2762',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9815000',
                'longitude' => '-71.3320000',
                'city' => 'Plainville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2702',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7985000',
                'longitude' => '-71.0745000',
                'city' => 'Assonet',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2552',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.3408000',
                'longitude' => '-70.7424000',
                'city' => 'Menemsha',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2535',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.3408000',
                'longitude' => '-70.7424000',
                'city' => 'Chilmark',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2740',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2839000',
                'longitude' => '-71.3395000',
                'city' => 'New Bedford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2019',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1122000',
                'longitude' => '-71.4735000',
                'city' => 'Bellingham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1887',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7065000',
                'longitude' => '-71.1639000',
                'city' => 'Wilmington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2062',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Norwood',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2575',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.4472000',
                'longitude' => '-70.6090000',
                'city' => 'West Tisbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2557',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.4472000',
                'longitude' => '-70.6090000',
                'city' => 'Oak Bluffs',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1535',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'North Brookfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1611',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Cherry Valley',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2865',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Lincoln',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1519',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2625000',
                'longitude' => '-71.8069000',
                'city' => 'Grafton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2114',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2806000',
                'longitude' => '-71.4227000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2361',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1107000',
                'longitude' => '-71.2449000',
                'city' => 'Plymouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2346',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1107000',
                'longitude' => '-71.2449000',
                'city' => 'Middleboro',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2717',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7791000',
                'longitude' => '-70.9058000',
                'city' => 'East Freetown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2739',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6603000',
                'longitude' => '-70.8157000',
                'city' => 'Mattapoisett',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2553',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7469000',
                'longitude' => '-70.6004000',
                'city' => 'Monument Beach',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2743',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7791000',
                'longitude' => '-70.9058000',
                'city' => 'Acushnet',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1550',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0729000',
                'longitude' => '-72.0293000',
                'city' => 'Southbridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2672',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6453000',
                'longitude' => '-70.2862000',
                'city' => 'West Hyannisport',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2647',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6453000',
                'longitude' => '-70.2862000',
                'city' => 'Hyannis Port',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1921',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6327000',
                'longitude' => '-70.9252000',
                'city' => 'Boxford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2030',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2792000',
                'longitude' => '-71.2331000',
                'city' => 'Dover',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1832',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1426000',
                'longitude' => '-71.2493000',
                'city' => 'Haverhill',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2116',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3485000',
                'longitude' => '-71.0841000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2779',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.9033000',
                'longitude' => '-71.0933000',
                'city' => 'Berkley',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1522',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3455000',
                'longitude' => '-71.8590000',
                'city' => 'Jefferson',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2562',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7653000',
                'longitude' => '-70.5242000',
                'city' => 'Sagamore Beach',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2561',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.7653000',
                'longitude' => '-70.5242000',
                'city' => 'Sagamore',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1536',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2107000',
                'longitude' => '-71.6891000',
                'city' => 'North Grafton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1915',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5537000',
                'longitude' => '-70.8777000',
                'city' => 'Beverly',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1653',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3022000',
                'longitude' => '-71.7952000',
                'city' => 'Worcester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1524',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2412000',
                'longitude' => '-71.9095000',
                'city' => 'Leicester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2330',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.8828000',
                'longitude' => '-70.7668000',
                'city' => 'Carver',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2366',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.8828000',
                'longitude' => '-70.7668000',
                'city' => 'South Carver',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2355',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.8828000',
                'longitude' => '-70.7668000',
                'city' => 'North Carver',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1505',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3419000',
                'longitude' => '-71.7437000',
                'city' => 'Boylston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1504',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0060000',
                'longitude' => '-71.5109000',
                'city' => 'Blackstone',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1529',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0060000',
                'longitude' => '-71.5109000',
                'city' => 'Millville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1068',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3541000',
                'longitude' => '-72.0405000',
                'city' => 'Oakham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1543',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3737000',
                'longitude' => '-71.9471000',
                'city' => 'Rutland',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1542',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2412000',
                'longitude' => '-71.9095000',
                'city' => 'Rochdale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1537',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2412000',
                'longitude' => '-71.9095000',
                'city' => 'North Oxford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2719',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6327000',
                'longitude' => '-70.9252000',
                'city' => 'Fairhaven',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2347',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.8916000',
                'longitude' => '-70.9079000',
                'city' => 'Lakeville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2108',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2110',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2284',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2745',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '41.6327000',
                'longitude' => '-70.9252000',
                'city' => 'New Bedford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2138',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3720000',
                'longitude' => '-71.1137000',
                'city' => 'Cambridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2135',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3467000',
                'longitude' => '-71.1500000',
                'city' => 'Brighton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2149',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3419000',
                'longitude' => '-71.0435000',
                'city' => 'Everett',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2210',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3540000',
                'longitude' => '-71.0540000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2109',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3540000',
                'longitude' => '-71.0540000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2111',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3540000',
                'longitude' => '-71.0540000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2152',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3754000',
                'longitude' => '-70.9819000',
                'city' => 'Winthrop',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2140',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3676000',
                'longitude' => '-71.0867000',
                'city' => 'Cambridge',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2118',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3533000',
                'longitude' => '-71.0627000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2128',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2458',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'Newton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2465',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'West Newton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2136',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2553000',
                'longitude' => '-71.1242000',
                'city' => 'Hyde Park',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2462',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'Newton Lower Falls',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2124',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5059000',
                'longitude' => '-71.1321000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2115',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5059000',
                'longitude' => '-71.1321000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2472',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3540000',
                'longitude' => '-71.0540000',
                'city' => 'Watertown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2466',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'Auburndale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2171',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2546000',
                'longitude' => '-71.0052000',
                'city' => 'Quincy',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2170',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2546000',
                'longitude' => '-71.0052000',
                'city' => 'Quincy',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2134',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Allston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2145',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Somerville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1890',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Winchester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2203',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2121',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2113',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2129',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Charlestown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2123',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2150',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Chelsea',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2445',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3388000',
                'longitude' => '-71.1268000',
                'city' => 'Brookline',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2467',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3388000',
                'longitude' => '-71.1268000',
                'city' => 'Chestnut Hill',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2120',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3388000',
                'longitude' => '-71.1268000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2130',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3388000',
                'longitude' => '-71.1268000',
                'city' => 'Jamaica Plain',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2215',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3388000',
                'longitude' => '-71.1268000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2446',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3388000',
                'longitude' => '-71.1268000',
                'city' => 'Brookline',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2143',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3720000',
                'longitude' => '-71.1137000',
                'city' => 'Somerville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2478',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3540000',
                'longitude' => '-71.0540000',
                'city' => 'Belmont',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2456',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3648000',
                'longitude' => '-71.0819000',
                'city' => 'New Town',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2464',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'Newton Upper Falls',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2468',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'Waban',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2460',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'Newtonville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2461',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'Newton Highlands',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2283',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3533000',
                'longitude' => '-71.0627000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2122',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2988000',
                'longitude' => '-71.0597000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2125',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2988000',
                'longitude' => '-71.0597000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2126',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2553000',
                'longitude' => '-71.1242000',
                'city' => 'Mattapan',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2132',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3889000',
                'longitude' => '-71.1028000',
                'city' => 'West Roxbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2186',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2691000',
                'longitude' => '-71.0688000',
                'city' => 'Milton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1908',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Nahant',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1810',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3760000',
                'longitude' => '-71.0614000',
                'city' => 'Andover',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2474',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3540000',
                'longitude' => '-71.0540000',
                'city' => 'Arlington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2131',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2823000',
                'longitude' => '-71.1499000',
                'city' => 'Roslindale',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2026',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3676000',
                'longitude' => '-71.0867000',
                'city' => 'Dedham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2190',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'South Weymouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1510',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3533000',
                'longitude' => '-71.0627000',
                'city' => 'Clinton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1876',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5059000',
                'longitude' => '-71.1321000',
                'city' => 'Tewksbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2144',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Somerville',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2493',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Weston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2180',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3648000',
                'longitude' => '-71.0819000',
                'city' => 'Stoneham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1863',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'North Chelmsford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2421',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3540000',
                'longitude' => '-71.0540000',
                'city' => 'Lexington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1451',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Harvard',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2332',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Duxbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1420',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Fitchburg',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1827',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Dunstable',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2339',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3648000',
                'longitude' => '-71.0819000',
                'city' => 'Hanover',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2222',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2117',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3450000',
                'longitude' => '-71.0880000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1867',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3520000',
                'longitude' => '-71.2080000',
                'city' => 'Reading',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2362',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3540000',
                'longitude' => '-71.0540000',
                'city' => 'Plymouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1970',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Salem',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2201',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3597000',
                'longitude' => '-71.0636000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2205',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3533000',
                'longitude' => '-71.0627000',
                'city' => 'Boston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1826',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Dracut',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2471',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Watertown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1821',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3720000',
                'longitude' => '-71.1137000',
                'city' => 'Billerica',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1922',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Byfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1945',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3568000',
                'longitude' => '-71.0588000',
                'city' => 'Marblehead',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2492',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3025000',
                'longitude' => '-71.2232000',
                'city' => 'Needham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2341',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4441000',
                'longitude' => '-71.2252000',
                'city' => 'Hanson',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2045',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2805000',
                'longitude' => '-70.8723000',
                'city' => 'Hull',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2382',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0793000',
                'longitude' => '-70.9376000',
                'city' => 'Whitman',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1773',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4441000',
                'longitude' => '-71.2252000',
                'city' => 'Lincoln',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2351',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1294000',
                'longitude' => '-70.9136000',
                'city' => 'Abington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1730',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4931000',
                'longitude' => '-71.2585000',
                'city' => 'Bedford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1805',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5013000',
                'longitude' => '-71.1933000',
                'city' => 'Burlington',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1731',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4441000',
                'longitude' => '-71.2252000',
                'city' => 'Hanscom Afb',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2343',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0242000',
                'longitude' => '-70.6803000',
                'city' => 'Holbrook',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2189',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2209000',
                'longitude' => '-70.9391000',
                'city' => 'East Weymouth',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1940',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5408000',
                'longitude' => '-71.0528000',
                'city' => 'Lynnfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1901',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4644000',
                'longitude' => '-70.9542000',
                'city' => 'Lynn',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1904',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5013000',
                'longitude' => '-71.1933000',
                'city' => 'Lynn',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1907',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2792000',
                'longitude' => '-71.2331000',
                'city' => 'Swampscott',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1844',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4644000',
                'longitude' => '-70.9542000',
                'city' => 'Methuen',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1888',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4644000',
                'longitude' => '-70.9542000',
                'city' => 'Woburn',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2185',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.2163000',
                'longitude' => '-71.0001000',
                'city' => 'Braintree',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2041',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.1649000',
                'longitude' => '-71.0414000',
                'city' => 'Green Harbor',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '2047',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.0988000',
                'longitude' => '-70.7164000',
                'city' => 'Humarock',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1718',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4746000',
                'longitude' => '-71.4537000',
                'city' => 'Village Of Nagog Woods',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1719',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4746000',
                'longitude' => '-71.4537000',
                'city' => 'Boxborough',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1864',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6222000',
                'longitude' => '-71.2985000',
                'city' => 'North Reading',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1983',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6385000',
                'longitude' => '-70.9509000',
                'city' => 'Topsfield',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1740',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4361000',
                'longitude' => '-71.6161000',
                'city' => 'Bolton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1951',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.8084000',
                'longitude' => '-70.8715000',
                'city' => 'Newbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1879',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6737000',
                'longitude' => '-71.4244000',
                'city' => 'Tyngsboro',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1833',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7223000',
                'longitude' => '-70.9931000',
                'city' => 'Georgetown',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1462',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5277000',
                'longitude' => '-71.7623000',
                'city' => 'Lunenburg',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1938',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6723000',
                'longitude' => '-70.8402000',
                'city' => 'Ipswich',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1950',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7774000',
                'longitude' => '-71.0760000',
                'city' => 'Newburyport',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1831',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7774000',
                'longitude' => '-71.0760000',
                'city' => 'Haverhill',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1913',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7774000',
                'longitude' => '-71.0760000',
                'city' => 'Amesbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1754',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4330000',
                'longitude' => '-71.4532000',
                'city' => 'Maynard',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1824',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6111000',
                'longitude' => '-71.3579000',
                'city' => 'Chelmsford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1368',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5942000',
                'longitude' => '-72.2239000',
                'city' => 'Royalston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1364',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5942000',
                'longitude' => '-72.2239000',
                'city' => 'Orange',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1331',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5942000',
                'longitude' => '-72.2239000',
                'city' => 'Athol',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1430',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6332000',
                'longitude' => '-71.9103000',
                'city' => 'Ashburnham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1005',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4200000',
                'longitude' => '-72.1038000',
                'city' => 'Barre',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1840',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6222000',
                'longitude' => '-71.2985000',
                'city' => 'Lawrence',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1845',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6222000',
                'longitude' => '-71.2985000',
                'city' => 'North Andover',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1850',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6406000',
                'longitude' => '-71.3089000',
                'city' => 'Lowell',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1450',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6075000',
                'longitude' => '-71.5701000',
                'city' => 'Groton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1854',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6406000',
                'longitude' => '-71.3089000',
                'city' => 'Lowell',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1468',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6067000',
                'longitude' => '-72.0749000',
                'city' => 'Templeton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1930',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6111000',
                'longitude' => '-70.6597000',
                'city' => 'Gloucester',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1564',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4376000',
                'longitude' => '-71.7578000',
                'city' => 'Sterling',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1741',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4574000',
                'longitude' => '-71.3463000',
                'city' => 'Carlisle',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1475',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6863000',
                'longitude' => '-72.0516000',
                'city' => 'Winchendon',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1474',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6645000',
                'longitude' => '-71.7070000',
                'city' => 'West Townsend',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1366',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4907000',
                'longitude' => '-72.1856000',
                'city' => 'Petersham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1949',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5626000',
                'longitude' => '-70.9319000',
                'city' => 'Middleton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1985',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7995000',
                'longitude' => '-70.9946000',
                'city' => 'West Newbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1355',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5904000',
                'longitude' => '-72.3076000',
                'city' => 'New Salem',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1378',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5904000',
                'longitude' => '-72.3076000',
                'city' => 'Warwick',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1969',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7036000',
                'longitude' => '-71.1591000',
                'city' => 'Rowley',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1440',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5778000',
                'longitude' => '-71.9951000',
                'city' => 'Gardner',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1860',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.8314000',
                'longitude' => '-70.9988000',
                'city' => 'Merrimac',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1074',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4172000',
                'longitude' => '-72.0989000',
                'city' => 'South Barre',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1835',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7774000',
                'longitude' => '-71.0760000',
                'city' => 'Haverhill',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1523',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4149000',
                'longitude' => '-71.6793000',
                'city' => 'Lancaster',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1561',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4149000',
                'longitude' => '-71.6793000',
                'city' => 'South Lancaster',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1834',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7774000',
                'longitude' => '-71.0760000',
                'city' => 'Groveland',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1830',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.7774000',
                'longitude' => '-71.0760000',
                'city' => 'Haverhill',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1431',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6780000',
                'longitude' => '-71.8199000',
                'city' => 'Ashby',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1952',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.8521000',
                'longitude' => '-70.9350000',
                'city' => 'Salisbury',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1503',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.3829000',
                'longitude' => '-71.6349000',
                'city' => 'Berlin',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1432',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5608000',
                'longitude' => '-71.5900000',
                'city' => 'Ayer',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1463',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6406000',
                'longitude' => '-71.3089000',
                'city' => 'Pepperell',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1464',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5432000',
                'longitude' => '-71.6494000',
                'city' => 'Shirley',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1541',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4476000',
                'longitude' => '-71.8743000',
                'city' => 'Princeton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '3815',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5604000',
                'longitude' => '-71.2634000',
                'city' => 'Center Strafford',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1472',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6139000',
                'longitude' => '-71.5711000',
                'city' => 'West Groton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1467',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4998000',
                'longitude' => '-71.5856000',
                'city' => 'Still River',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1775',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4266000',
                'longitude' => '-71.4523000',
                'city' => 'Stow',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1936',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6117000',
                'longitude' => '-70.8765000',
                'city' => 'Hamilton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1984',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6117000',
                'longitude' => '-70.8765000',
                'city' => 'Wenham',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1379',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5904000',
                'longitude' => '-72.3076000',
                'city' => 'Wendell',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1937',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6406000',
                'longitude' => '-71.3089000',
                'city' => 'Hathorne',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1473',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5495000',
                'longitude' => '-71.9065000',
                'city' => 'Westminster',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1469',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6616000',
                'longitude' => '-71.7022000',
                'city' => 'Townsend',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1438',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5778000',
                'longitude' => '-71.9951000',
                'city' => 'East Templeton',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1441',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.5495000',
                'longitude' => '-71.9065000',
                'city' => 'Westminster',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1929',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6349000',
                'longitude' => '-70.7778000',
                'city' => 'Essex',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1452',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.4763000',
                'longitude' => '-72.0106000',
                'city' => 'Hubbardston',
                'full_state' => 'Massachusetts',
            ],
            [
                'zip' => '1436',
                'country_code' => 'US',
                'state' => 'MA',
                'latitude' => '42.6067000',
                'longitude' => '-72.0749000',
                'city' => 'Baldwinville',
                'full_state' => 'Massachusetts',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
