<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class KentuckySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '42754',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4849000',
                'longitude' => '-86.3001000',
                'city' => 'Leitchfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42001',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0859000',
                'longitude' => '-88.6085000',
                'city' => 'Paducah',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42102',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9996000',
                'longitude' => '-86.4400000',
                'city' => 'Bowling Green',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42025',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8648000',
                'longitude' => '-88.3514000',
                'city' => 'Benton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42211',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8663000',
                'longitude' => '-87.8341000',
                'city' => 'Cadiz',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42031',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6672000',
                'longitude' => '-88.9905000',
                'city' => 'Clinton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42041',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.5075000',
                'longitude' => '-88.8796000',
                'city' => 'Fulton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42701',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7025000',
                'longitude' => '-85.8599000',
                'city' => 'Elizabethtown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42420',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8346000',
                'longitude' => '-87.5806000',
                'city' => 'Henderson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42409',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5164000',
                'longitude' => '-87.6931000',
                'city' => 'Dixon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42050',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.5750000',
                'longitude' => '-89.1952000',
                'city' => 'Hickman',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42301',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7697000',
                'longitude' => '-87.1185000',
                'city' => 'Owensboro',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42722',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2824000',
                'longitude' => '-85.7681000',
                'city' => 'Canmer',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40160',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8394000',
                'longitude' => '-85.9436000',
                'city' => 'Radcliff',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42240',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8586000',
                'longitude' => '-87.4962000',
                'city' => 'Hopkinsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42276',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8457000',
                'longitude' => '-86.8819000',
                'city' => 'Russellville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42134',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7268000',
                'longitude' => '-86.5844000',
                'city' => 'Franklin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42056',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1502000',
                'longitude' => '-88.9417000',
                'city' => 'La Center',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42022',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1502000',
                'longitude' => '-88.9417000',
                'city' => 'Bandana',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42024',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1502000',
                'longitude' => '-88.9417000',
                'city' => 'Barlow',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42053',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1502000',
                'longitude' => '-88.9417000',
                'city' => 'Kevil',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42339',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3014000',
                'longitude' => '-87.1254000',
                'city' => 'Dunmor',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42368',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3014000',
                'longitude' => '-87.1254000',
                'city' => 'Reynolds Station',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42071',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6081000',
                'longitude' => '-88.3096000',
                'city' => 'Murray',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42334',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6823000',
                'longitude' => '-87.2821000',
                'city' => 'Curdsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42327',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6823000',
                'longitude' => '-87.2821000',
                'city' => 'Calhoun',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42377',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6823000',
                'longitude' => '-87.2821000',
                'city' => 'West Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42369',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4205000',
                'longitude' => '-87.0000000',
                'city' => 'Rockport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42328',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4205000',
                'longitude' => '-87.0000000',
                'city' => 'Centertown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42366',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6841000',
                'longitude' => '-86.8817000',
                'city' => 'Philpot',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42348',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6841000',
                'longitude' => '-86.8817000',
                'city' => 'Hawesville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42378',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6841000',
                'longitude' => '-86.8817000',
                'city' => 'Whitesville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42343',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6841000',
                'longitude' => '-86.8817000',
                'city' => 'Fordsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40162',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6922000',
                'longitude' => '-85.8604000',
                'city' => 'Rineyville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42215',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8781000',
                'longitude' => '-87.6647000',
                'city' => 'Cerulean',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42232',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8781000',
                'longitude' => '-87.6647000',
                'city' => 'Gracey',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42164',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7529000',
                'longitude' => '-86.1894000',
                'city' => 'Scottsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42303',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7697000',
                'longitude' => '-87.1185000',
                'city' => 'Owensboro',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42726',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4952000',
                'longitude' => '-86.2273000',
                'city' => 'Clarkson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42712',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4952000',
                'longitude' => '-86.2273000',
                'city' => 'Big Clifty',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42431',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3358000',
                'longitude' => '-87.5006000',
                'city' => 'Madisonville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42210',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1929000',
                'longitude' => '-86.2696000',
                'city' => 'Brownsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42066',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7393000',
                'longitude' => '-88.6372000',
                'city' => 'Mayfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42450',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3858000',
                'longitude' => '-87.6436000',
                'city' => 'Providence',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42445',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3858000',
                'longitude' => '-87.6436000',
                'city' => 'Princeton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42408',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3858000',
                'longitude' => '-87.6436000',
                'city' => 'Dawson Springs',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42436',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3858000',
                'longitude' => '-87.6436000',
                'city' => 'Manitou',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42441',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3858000',
                'longitude' => '-87.6436000',
                'city' => 'Nebo',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42728',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1109000',
                'longitude' => '-85.3013000',
                'city' => 'Columbia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42029',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8544000',
                'longitude' => '-88.3515000',
                'city' => 'Calvert City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42054',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8544000',
                'longitude' => '-88.3515000',
                'city' => 'Kirksey',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42167',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7100000',
                'longitude' => '-85.6901000',
                'city' => 'Tompkinsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42320',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4093000',
                'longitude' => '-86.8765000',
                'city' => 'Beaver Dam',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40178',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6211000',
                'longitude' => '-86.4440000',
                'city' => 'Westview',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40152',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6211000',
                'longitude' => '-86.4440000',
                'city' => 'Mc Daniels',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40119',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6211000',
                'longitude' => '-86.4440000',
                'city' => 'Falls Of Rough',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40143',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6211000',
                'longitude' => '-86.4440000',
                'city' => 'Hardinsburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40145',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6211000',
                'longitude' => '-86.4440000',
                'city' => 'Hudson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42440',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2362000',
                'longitude' => '-87.4751000',
                'city' => 'Mortons Gap',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42464',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2362000',
                'longitude' => '-87.4751000',
                'city' => 'White Plains',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42156',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9901000',
                'longitude' => '-85.9168000',
                'city' => 'Lucas',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42021',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7830000',
                'longitude' => '-89.0075000',
                'city' => 'Arlington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42351',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8640000',
                'longitude' => '-86.9957000',
                'city' => 'Lewisport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42355',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8640000',
                'longitude' => '-86.9957000',
                'city' => 'Maceo',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42234',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8086000',
                'longitude' => '-87.1597000',
                'city' => 'Guthrie',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42265',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8086000',
                'longitude' => '-87.1597000',
                'city' => 'Olmstead',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42220',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8086000',
                'longitude' => '-87.1597000',
                'city' => 'Elkton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42204',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8086000',
                'longitude' => '-87.1597000',
                'city' => 'Allensville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42286',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8086000',
                'longitude' => '-87.1597000',
                'city' => 'Trenton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42023',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8760000',
                'longitude' => '-89.0068000',
                'city' => 'Bardwell',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42217',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9820000',
                'longitude' => '-87.3567000',
                'city' => 'Crofton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42236',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6611000',
                'longitude' => '-87.6575000',
                'city' => 'Herndon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42254',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6611000',
                'longitude' => '-87.6575000',
                'city' => 'La Fayette',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40175',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8394000',
                'longitude' => '-85.9436000',
                'city' => 'Vine Grove',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42371',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5418000',
                'longitude' => '-87.2593000',
                'city' => 'Rumsey',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42322',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5418000',
                'longitude' => '-87.2593000',
                'city' => 'Beech Grove',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42354',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4031000',
                'longitude' => '-86.8742000',
                'city' => 'Mc Henry',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42333',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4031000',
                'longitude' => '-86.8742000',
                'city' => 'Cromwell',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42349',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4031000',
                'longitude' => '-86.8742000',
                'city' => 'Horse Branch',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42347',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6084000',
                'longitude' => '-86.9984000',
                'city' => 'Hartford',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42376',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6084000',
                'longitude' => '-86.9984000',
                'city' => 'Utica',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42361',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6368000',
                'longitude' => '-86.7230000',
                'city' => 'Olaton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42338',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6368000',
                'longitude' => '-86.7230000',
                'city' => 'Dundee',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42280',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9107000',
                'longitude' => '-87.1051000',
                'city' => 'Sharon Grove',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42256',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9107000',
                'longitude' => '-87.1051000',
                'city' => 'Lewisburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42352',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4896000',
                'longitude' => '-87.1370000',
                'city' => 'Livermore',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42104',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9996000',
                'longitude' => '-86.4400000',
                'city' => 'Bowling Green',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42103',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9996000',
                'longitude' => '-86.4400000',
                'city' => 'Bowling Green',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42718',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3416000',
                'longitude' => '-85.3445000',
                'city' => 'Campbellsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42717',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7913000',
                'longitude' => '-85.3658000',
                'city' => 'Burkesville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42462',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6934000',
                'longitude' => '-87.9162000',
                'city' => 'Waverly',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42461',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6934000',
                'longitude' => '-87.9162000',
                'city' => 'Uniontown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42721',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2739000',
                'longitude' => '-86.2865000',
                'city' => 'Caneyville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42729',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2739000',
                'longitude' => '-86.2865000',
                'city' => 'Cub Run',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42285',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2739000',
                'longitude' => '-86.2865000',
                'city' => 'Sweeden',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42275',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2739000',
                'longitude' => '-86.2865000',
                'city' => 'Roundhill',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42207',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2739000',
                'longitude' => '-86.2865000',
                'city' => 'Bee Spring',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42259',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2739000',
                'longitude' => '-86.2865000',
                'city' => 'Mammoth Cave',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42261',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2333000',
                'longitude' => '-86.6874000',
                'city' => 'Morgantown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42743',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Greensburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42064',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3323000',
                'longitude' => '-88.0872000',
                'city' => 'Marion',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42782',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2586000',
                'longitude' => '-85.5014000',
                'city' => 'Summersville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42702',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7025000',
                'longitude' => '-85.8599000',
                'city' => 'Elizabethtown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42455',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6066000',
                'longitude' => '-87.5355000',
                'city' => 'Sebree',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40033',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5692000',
                'longitude' => '-85.2509000',
                'city' => 'Lebanon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42413',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4181000',
                'longitude' => '-87.4853000',
                'city' => 'Hanson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42784',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4405000',
                'longitude' => '-85.7443000',
                'city' => 'Upton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42776',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4405000',
                'longitude' => '-85.7443000',
                'city' => 'Sonora',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42748',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4405000',
                'longitude' => '-85.7443000',
                'city' => 'Hodgenville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42764',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4405000',
                'longitude' => '-85.7443000',
                'city' => 'Mount Sherman',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42716',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4405000',
                'longitude' => '-85.7443000',
                'city' => 'Buffalo',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42757',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4405000',
                'longitude' => '-85.7443000',
                'city' => 'Magnolia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40052',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5154000',
                'longitude' => '-85.6989000',
                'city' => 'New Hope',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42079',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6419000',
                'longitude' => '-88.6026000',
                'city' => 'Sedalia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42088',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6419000',
                'longitude' => '-88.6026000',
                'city' => 'Wingo',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42040',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6419000',
                'longitude' => '-88.6026000',
                'city' => 'Farmington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42087',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9649000',
                'longitude' => '-89.0844000',
                'city' => 'Wickliffe',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42437',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5498000',
                'longitude' => '-87.9843000',
                'city' => 'Morganfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42404',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5498000',
                'longitude' => '-87.9843000',
                'city' => 'Clay',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42459',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5498000',
                'longitude' => '-87.9843000',
                'city' => 'Sturgis',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40328',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Gravel Switch',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40009',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4932000',
                'longitude' => '-85.1520000',
                'city' => 'Bradfordsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42344',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2119000',
                'longitude' => '-87.1850000',
                'city' => 'Graham',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42367',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2119000',
                'longitude' => '-87.1850000',
                'city' => 'Powderly',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42345',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2119000',
                'longitude' => '-87.1850000',
                'city' => 'Greenville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42129',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9739000',
                'longitude' => '-85.6198000',
                'city' => 'Edmonton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42642',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9881000',
                'longitude' => '-85.0645000',
                'city' => 'Russell Springs',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42629',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9881000',
                'longitude' => '-85.0645000',
                'city' => 'Jamestown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42048',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8469000',
                'longitude' => '-88.2339000',
                'city' => 'Hardin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42085',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.5054000',
                'longitude' => '-88.8745000',
                'city' => 'Water Valley',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40051',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5727000',
                'longitude' => '-85.7450000',
                'city' => 'New Haven',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42045',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0005000',
                'longitude' => '-88.2901000',
                'city' => 'Grand Rivers',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42044',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0005000',
                'longitude' => '-88.2901000',
                'city' => 'Gilbertsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42411',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1130000',
                'longitude' => '-87.8873000',
                'city' => 'Fredonia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42740',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5241000',
                'longitude' => '-85.8976000',
                'city' => 'Glendale',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42788',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5241000',
                'longitude' => '-85.8976000',
                'city' => 'White Mills',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42741',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9918000',
                'longitude' => '-85.3185000',
                'city' => 'Glens Fork',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42742',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9918000',
                'longitude' => '-85.3185000',
                'city' => 'Gradyville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42715',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9918000',
                'longitude' => '-85.3185000',
                'city' => 'Breeding',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42063',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.5611000',
                'longitude' => '-88.5705000',
                'city' => 'Lynnville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42410',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2741000',
                'longitude' => '-87.5152000',
                'city' => 'Earlington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42038',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0494000',
                'longitude' => '-88.0711000',
                'city' => 'Eddyville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42055',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0909000',
                'longitude' => '-88.0830000',
                'city' => 'Kuttawa',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42122',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9915000',
                'longitude' => '-86.4455000',
                'city' => 'Alvaton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42101',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9915000',
                'longitude' => '-86.4455000',
                'city' => 'Bowling Green',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42262',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6431000',
                'longitude' => '-87.4562000',
                'city' => 'Oak Grove',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42003',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0838000',
                'longitude' => '-88.6034000',
                'city' => 'Paducah',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40142',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9972000',
                'longitude' => '-86.1723000',
                'city' => 'Guston',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40108',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9972000',
                'longitude' => '-86.1723000',
                'city' => 'Brandenburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42141',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8912000',
                'longitude' => '-85.8601000',
                'city' => 'Glasgow',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42123',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8912000',
                'longitude' => '-85.8601000',
                'city' => 'Austin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42131',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8912000',
                'longitude' => '-85.8601000',
                'city' => 'Etoile',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42157',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8912000',
                'longitude' => '-85.8601000',
                'city' => 'Mount Hermon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42166',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8912000',
                'longitude' => '-85.8601000',
                'city' => 'Summer Shade',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42124',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8820000',
                'longitude' => '-85.7093000',
                'city' => 'Beaumont',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40037',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6346000',
                'longitude' => '-85.3972000',
                'city' => 'Loretto',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42154',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9739000',
                'longitude' => '-85.6198000',
                'city' => 'Knob Lick',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42133',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7233000',
                'longitude' => '-85.9682000',
                'city' => 'Fountain Run',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42049',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.5950000',
                'longitude' => '-88.4399000',
                'city' => 'Hazel',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42076',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6021000',
                'longitude' => '-88.1464000',
                'city' => 'New Concord',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42020',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7609000',
                'longitude' => '-88.3019000',
                'city' => 'Almo',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42036',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7609000',
                'longitude' => '-88.3019000',
                'city' => 'Dexter',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42223',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6510000',
                'longitude' => '-87.4381000',
                'city' => 'Fort Campbell',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42266',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6510000',
                'longitude' => '-87.4381000',
                'city' => 'Pembroke',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42086',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0838000',
                'longitude' => '-88.6034000',
                'city' => 'West Paducah',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42127',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0982000',
                'longitude' => '-85.8163000',
                'city' => 'Cave City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42749',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0982000',
                'longitude' => '-85.8163000',
                'city' => 'Horse Cave',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42152',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0982000',
                'longitude' => '-85.8163000',
                'city' => 'Hiseville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42140',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6413000',
                'longitude' => '-85.7959000',
                'city' => 'Gamaliel',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42753',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3416000',
                'longitude' => '-85.3445000',
                'city' => 'Knifley',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42733',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3416000',
                'longitude' => '-85.3445000',
                'city' => 'Elk Horn',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42765',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2679000',
                'longitude' => '-85.8900000',
                'city' => 'Munfordville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42321',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1979000',
                'longitude' => '-87.0182000',
                'city' => 'Beech Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42337',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1979000',
                'longitude' => '-87.0182000',
                'city' => 'Drakesboro',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42326',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1979000',
                'longitude' => '-87.0182000',
                'city' => 'Browder',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42324',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1979000',
                'longitude' => '-87.0182000',
                'city' => 'Belton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42323',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1979000',
                'longitude' => '-87.0182000',
                'city' => 'Beechmont',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42350',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4424000',
                'longitude' => '-87.1490000',
                'city' => 'Island',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42151',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7019000',
                'longitude' => '-85.6957000',
                'city' => 'Hestand',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40157',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9816000',
                'longitude' => '-86.3422000',
                'city' => 'Payneville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40171',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9816000',
                'longitude' => '-86.3422000',
                'city' => 'Union Star',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40104',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9816000',
                'longitude' => '-86.3422000',
                'city' => 'Battletown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40176',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9816000',
                'longitude' => '-86.3422000',
                'city' => 'Webster',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40161',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9816000',
                'longitude' => '-86.3422000',
                'city' => 'Rhodelia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42241',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8586000',
                'longitude' => '-87.4962000',
                'city' => 'Hopkinsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42081',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1401000',
                'longitude' => '-88.4007000',
                'city' => 'Smithland',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42028',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1401000',
                'longitude' => '-88.4007000',
                'city' => 'Burna',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42452',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6750000',
                'longitude' => '-87.5490000',
                'city' => 'Robards',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42713',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2679000',
                'longitude' => '-85.8900000',
                'city' => 'Bonnieville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42330',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3634000',
                'longitude' => '-87.2213000',
                'city' => 'Central City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42372',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3634000',
                'longitude' => '-87.2213000',
                'city' => 'Sacramento',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42325',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3634000',
                'longitude' => '-87.2213000',
                'city' => 'Bremen',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42746',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2824000',
                'longitude' => '-85.7681000',
                'city' => 'Hardyville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42170',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9915000',
                'longitude' => '-86.4455000',
                'city' => 'Woodburn',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42457',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7418000',
                'longitude' => '-87.7077000',
                'city' => 'Smith Mills',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42406',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7418000',
                'longitude' => '-87.7077000',
                'city' => 'Corydon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42027',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0371000',
                'longitude' => '-88.6668000',
                'city' => 'Boaz',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40140',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7397000',
                'longitude' => '-86.2573000',
                'city' => 'Garfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40115',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7397000',
                'longitude' => '-86.2573000',
                'city' => 'Custer',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40146',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7397000',
                'longitude' => '-86.2573000',
                'city' => 'Irvington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42202',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6695000',
                'longitude' => '-86.8499000',
                'city' => 'Adairville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42274',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8664000',
                'longitude' => '-86.7121000',
                'city' => 'Rockfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42206',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8664000',
                'longitude' => '-86.7121000',
                'city' => 'Auburn',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40170',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8829000',
                'longitude' => '-86.2843000',
                'city' => 'Stephensport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42171',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0507000',
                'longitude' => '-86.2092000',
                'city' => 'Smiths Grove',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42159',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0507000',
                'longitude' => '-86.2092000',
                'city' => 'Oakland',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42214',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1418000',
                'longitude' => '-85.7008000',
                'city' => 'Center',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42142',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9941000',
                'longitude' => '-85.9140000',
                'city' => 'Glasgow',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42082',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9181000',
                'longitude' => '-88.5171000',
                'city' => 'Symsonia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42135',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7268000',
                'longitude' => '-86.5844000',
                'city' => 'Franklin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42719',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3416000',
                'longitude' => '-85.3445000',
                'city' => 'Campbellsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42160',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1929000',
                'longitude' => '-86.2696000',
                'city' => 'Park City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42453',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1944000',
                'longitude' => '-87.5612000',
                'city' => 'Saint Charles',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42120',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7529000',
                'longitude' => '-86.1894000',
                'city' => 'Adolphus',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42039',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7983000',
                'longitude' => '-88.7925000',
                'city' => 'Fancy Farm',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42051',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7983000',
                'longitude' => '-88.7925000',
                'city' => 'Hickory',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40111',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8348000',
                'longitude' => '-86.6345000',
                'city' => 'Cloverport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42456',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4928000',
                'longitude' => '-87.5012000',
                'city' => 'Slaughters',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42444',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5164000',
                'longitude' => '-87.6931000',
                'city' => 'Poole',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42035',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9064000',
                'longitude' => '-88.8913000',
                'city' => 'Cunningham',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42463',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4772000',
                'longitude' => '-87.8233000',
                'city' => 'Wheatcroft',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42442',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1860000',
                'longitude' => '-87.5537000',
                'city' => 'Nortonville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42061',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8850000',
                'longitude' => '-88.7762000',
                'city' => 'Lowes',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42069',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8850000',
                'longitude' => '-88.7762000',
                'city' => 'Melber',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42032',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7607000',
                'longitude' => '-89.1048000',
                'city' => 'Columbus',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40060',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5692000',
                'longitude' => '-85.2509000',
                'city' => 'Raywick',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42070',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7969000',
                'longitude' => '-88.9025000',
                'city' => 'Milburn',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42163',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0913000',
                'longitude' => '-86.0505000',
                'city' => 'Rocky Hill',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40144',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7828000',
                'longitude' => '-86.4654000',
                'city' => 'Harned',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42375',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8199000',
                'longitude' => '-87.2490000',
                'city' => 'Stanley',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42451',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8199000',
                'longitude' => '-87.2490000',
                'city' => 'Reed',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42458',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8430000',
                'longitude' => '-87.5882000',
                'city' => 'Spottsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40117',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9069000',
                'longitude' => '-86.1221000',
                'city' => 'Ekron',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '45052',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8064000',
                'longitude' => '-87.9762000',
                'city' => 'North Bend',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42544',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0532000',
                'longitude' => '-85.0913000',
                'city' => 'Nancy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42565',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0532000',
                'longitude' => '-85.0913000',
                'city' => 'Windsor',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42724',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Cecilia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42732',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6664000',
                'longitude' => '-85.9576000',
                'city' => 'Eastview',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42731',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7936000',
                'longitude' => '-85.3708000',
                'city' => 'Dubre',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42759',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7936000',
                'longitude' => '-85.3708000',
                'city' => 'Marrowbone',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40062',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6369000',
                'longitude' => '-85.4022000',
                'city' => 'Saint Francis',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42060',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9891000',
                'longitude' => '-88.8905000',
                'city' => 'Lovelaceville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42762',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4304000',
                'longitude' => '-86.4885000',
                'city' => 'Millwood',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '38261',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.4236000',
                'longitude' => '-89.0534000',
                'city' => 'Union City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42078',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2660000',
                'longitude' => '-88.2405000',
                'city' => 'Salem',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42058',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0007000',
                'longitude' => '-88.5159000',
                'city' => 'Ledbetter',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42302',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7675000',
                'longitude' => '-87.1134000',
                'city' => 'Owensboro',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42083',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1463000',
                'longitude' => '-88.4032000',
                'city' => 'Tiline',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42273',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2115000',
                'longitude' => '-86.8916000',
                'city' => 'Rochester',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42047',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2660000',
                'longitude' => '-88.2405000',
                'city' => 'Hampton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42037',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2660000',
                'longitude' => '-88.2405000',
                'city' => 'Dycusburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40068',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4096000',
                'longitude' => '-85.3806000',
                'city' => 'Smithfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40010',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4096000',
                'longitude' => '-85.3806000',
                'city' => 'Buckner',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40601',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1983000',
                'longitude' => '-84.8833000',
                'city' => 'Frankfort',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40203',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2745000',
                'longitude' => '-85.7459000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40206',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2745000',
                'longitude' => '-85.7459000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40031',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'La Grange',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40202',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40299',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40217',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40223',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40222',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40207',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40177',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'West Point',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40208',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40213',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40165',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9906000',
                'longitude' => '-85.7120000',
                'city' => 'Shepherdsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40210',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40201',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2504000',
                'longitude' => '-85.7629000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40204',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2504000',
                'longitude' => '-85.7629000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40065',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2161000',
                'longitude' => '-85.2190000',
                'city' => 'Shelbyville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40006',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5994000',
                'longitude' => '-85.3201000',
                'city' => 'Bedford',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40014',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4034000',
                'longitude' => '-85.3783000',
                'city' => 'Crestwood',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40077',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4034000',
                'longitude' => '-85.3783000',
                'city' => 'Westport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40055',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4034000',
                'longitude' => '-85.3783000',
                'city' => 'Pendleton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40059',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3461000',
                'longitude' => '-85.6205000',
                'city' => 'Prospect',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40026',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3461000',
                'longitude' => '-85.6205000',
                'city' => 'Goshen',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40241',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3461000',
                'longitude' => '-85.6205000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40150',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8325000',
                'longitude' => '-85.7362000',
                'city' => 'Lebanon Junction',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40228',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1513000',
                'longitude' => '-85.5857000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40071',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1513000',
                'longitude' => '-85.5857000',
                'city' => 'Taylorsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40229',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1513000',
                'longitude' => '-85.5857000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40291',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1513000',
                'longitude' => '-85.5857000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40004',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8085000',
                'longitude' => '-85.4675000',
                'city' => 'Bardstown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40022',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2037000',
                'longitude' => '-85.5488000',
                'city' => 'Finchville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41008',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6844000',
                'longitude' => '-85.1651000',
                'city' => 'Carrollton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40218',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40220',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40205',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40214',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40245',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40056',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Pewee Valley',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40243',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2547000',
                'longitude' => '-85.5328000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40047',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0505000',
                'longitude' => '-85.5367000',
                'city' => 'Mount Washington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40013',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9125000',
                'longitude' => '-85.3210000',
                'city' => 'Coxs Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40020',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9125000',
                'longitude' => '-85.3210000',
                'city' => 'Fairfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40008',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9125000',
                'longitude' => '-85.3210000',
                'city' => 'Bloomfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40023',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1866000',
                'longitude' => '-85.5341000',
                'city' => 'Fisherville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40045',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7151000',
                'longitude' => '-85.3784000',
                'city' => 'Milton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40258',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40272',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40155',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9002000',
                'longitude' => '-85.9743000',
                'city' => 'Muldraugh',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40109',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0228000',
                'longitude' => '-85.6894000',
                'city' => 'Brooks',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40209',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2037000',
                'longitude' => '-85.5488000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40212',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40324',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2081000',
                'longitude' => '-84.5528000',
                'city' => 'Georgetown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40003',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2161000',
                'longitude' => '-85.2190000',
                'city' => 'Bagdad',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40242',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2834000',
                'longitude' => '-85.5860000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41083',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7337000',
                'longitude' => '-85.0613000',
                'city' => 'Sanders',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41098',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7337000',
                'longitude' => '-85.0613000',
                'city' => 'Worthville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40342',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0441000',
                'longitude' => '-84.8936000',
                'city' => 'Lawrenceburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40058',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Port Royal',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41045',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7355000',
                'longitude' => '-85.0533000',
                'city' => 'Ghent',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40048',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8085000',
                'longitude' => '-85.4675000',
                'city' => 'Nazareth',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40211',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40219',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40216',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40118',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1845000',
                'longitude' => '-85.7691000',
                'city' => 'Fairdale',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40215',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1845000',
                'longitude' => '-85.7691000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40347',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2017000',
                'longitude' => '-84.8674000',
                'city' => 'Midway',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40012',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8924000',
                'longitude' => '-85.2286000',
                'city' => 'Chaplin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40359',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5413000',
                'longitude' => '-84.8438000',
                'city' => 'Owenton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40067',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2273000',
                'longitude' => '-85.3515000',
                'city' => 'Simpsonville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40250',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2037000',
                'longitude' => '-85.5488000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41086',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6184000',
                'longitude' => '-84.9097000',
                'city' => 'Sparta',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40057',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3459000',
                'longitude' => '-85.1178000',
                'city' => 'Pleasureville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40355',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5413000',
                'longitude' => '-84.8438000',
                'city' => 'New Liberty',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41016',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5350000',
                'longitude' => '-84.8416000',
                'city' => 'Covington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40011',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5242000',
                'longitude' => '-85.1995000',
                'city' => 'Campbellsburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40046',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0187000',
                'longitude' => '-85.3459000',
                'city' => 'Mount Eden',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40019',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2971000',
                'longitude' => '-85.1121000',
                'city' => 'Eminence',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41010',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5350000',
                'longitude' => '-84.8416000',
                'city' => 'Corinth',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40075',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5225000',
                'longitude' => '-85.2073000',
                'city' => 'Turners Station',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40379',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2680000',
                'longitude' => '-84.6839000',
                'city' => 'Stamping Ground',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40511',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2081000',
                'longitude' => '-84.5528000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41503',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2017000',
                'longitude' => '-84.8674000',
                'city' => 'South Williamson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40255',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2441000',
                'longitude' => '-85.7606000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40107',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6623000',
                'longitude' => '-85.5899000',
                'city' => 'Boston',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40622',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1983000',
                'longitude' => '-84.8833000',
                'city' => 'Frankfort',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40621',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1983000',
                'longitude' => '-84.8833000',
                'city' => 'Frankfort',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40602',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1983000',
                'longitude' => '-84.8833000',
                'city' => 'Frankfort',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40252',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2037000',
                'longitude' => '-85.5488000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40121',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8984000',
                'longitude' => '-85.9821000',
                'city' => 'Fort Knox',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40070',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4902000',
                'longitude' => '-85.2764000',
                'city' => 'Sulphur',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40076',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0609000',
                'longitude' => '-85.1557000',
                'city' => 'Waddy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40007',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3873000',
                'longitude' => '-85.1754000',
                'city' => 'Bethlehem',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40036',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3873000',
                'longitude' => '-85.1754000',
                'city' => 'Lockport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40050',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3873000',
                'longitude' => '-85.1754000',
                'city' => 'New Castle',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40292',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2504000',
                'longitude' => '-85.7629000',
                'city' => 'Louisville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40370',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3916000',
                'longitude' => '-84.5346000',
                'city' => 'Sadieville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41501',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4824000',
                'longitude' => '-82.5267000',
                'city' => 'Pikeville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41179',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5907000',
                'longitude' => '-83.3171000',
                'city' => 'Vanceburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41064',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5311000',
                'longitude' => '-84.0336000',
                'city' => 'Mount Olivet',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40351',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1846000',
                'longitude' => '-83.4326000',
                'city' => 'Morehead',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41311',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5760000',
                'longitude' => '-83.7077000',
                'city' => 'Beattyville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41041',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4149000',
                'longitude' => '-83.7338000',
                'city' => 'Flemingsburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40360',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1422000',
                'longitude' => '-83.7671000',
                'city' => 'Owingsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41537',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1752000',
                'longitude' => '-82.6451000',
                'city' => 'Jenkins',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41635',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5558000',
                'longitude' => '-82.6337000',
                'city' => 'Harold',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41858',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Whitesburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40701',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9499000',
                'longitude' => '-84.1020000',
                'city' => 'Corbin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41701',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2487000',
                'longitude' => '-83.1923000',
                'city' => 'Hazard',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41007',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6857000',
                'longitude' => '-84.0687000',
                'city' => 'California',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41002',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6857000',
                'longitude' => '-84.0687000',
                'city' => 'Augusta',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42501',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0933000',
                'longitude' => '-84.6089000',
                'city' => 'Somerset',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41240',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8167000',
                'longitude' => '-82.8092000',
                'city' => 'Paintsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40744',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1327000',
                'longitude' => '-84.0833000',
                'city' => 'London',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41164',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2971000',
                'longitude' => '-83.1828000',
                'city' => 'Olive Hill',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41653',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6093000',
                'longitude' => '-82.7347000',
                'city' => 'Prestonsburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41603',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6093000',
                'longitude' => '-82.7347000',
                'city' => 'Banner',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41256',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8277000',
                'longitude' => '-82.8549000',
                'city' => 'Staffordsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41601',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6093000',
                'longitude' => '-82.7347000',
                'city' => 'Allen',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41102',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4663000',
                'longitude' => '-82.6407000',
                'city' => 'Ashland',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40729',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1327000',
                'longitude' => '-84.0833000',
                'city' => 'East Bernstadt',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40437',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4755000',
                'longitude' => '-84.8196000',
                'city' => 'Hustonville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41056',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6438000',
                'longitude' => '-83.7673000',
                'city' => 'Maysville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41527',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6602000',
                'longitude' => '-82.2789000',
                'city' => 'Forest Hills',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41231',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6602000',
                'longitude' => '-82.2789000',
                'city' => 'Lovely',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41514',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6602000',
                'longitude' => '-82.2789000',
                'city' => 'Belfry',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41833',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9684000',
                'longitude' => '-82.9064000',
                'city' => 'Linefork',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40823',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9684000',
                'longitude' => '-82.9064000',
                'city' => 'Cumberland',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40313',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1846000',
                'longitude' => '-83.4326000',
                'city' => 'Clearfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40371',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1846000',
                'longitude' => '-83.4326000',
                'city' => 'Salt Lick',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42633',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8351000',
                'longitude' => '-84.8441000',
                'city' => 'Monticello',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40965',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6085000',
                'longitude' => '-83.7133000',
                'city' => 'Middlesboro',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40906',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8602000',
                'longitude' => '-83.8751000',
                'city' => 'Barbourville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41264',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1076000',
                'longitude' => '-82.6086000',
                'city' => 'Ulysses',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41201',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1076000',
                'longitude' => '-82.6086000',
                'city' => 'Adams',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40374',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2022000',
                'longitude' => '-83.9320000',
                'city' => 'Sharpsburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41722',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3361000',
                'longitude' => '-83.0951000',
                'city' => 'Bulan',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41743',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3361000',
                'longitude' => '-83.0951000',
                'city' => 'Fisty',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41712',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3361000',
                'longitude' => '-83.0951000',
                'city' => 'Ary',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41773',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2245000',
                'longitude' => '-83.0629000',
                'city' => 'Vicco',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41143',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3346000',
                'longitude' => '-82.9524000',
                'city' => 'Grayson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40403',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3537000',
                'longitude' => '-84.3433000',
                'city' => 'Berea',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40460',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3537000',
                'longitude' => '-84.3433000',
                'city' => 'Orlando',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40456',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3537000',
                'longitude' => '-84.3433000',
                'city' => 'Mount Vernon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41255',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9166000',
                'longitude' => '-82.8956000',
                'city' => 'Sitka',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41226',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9166000',
                'longitude' => '-82.8956000',
                'city' => 'Keaton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41257',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9166000',
                'longitude' => '-82.8956000',
                'city' => 'Stambaugh',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41219',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9166000',
                'longitude' => '-82.8956000',
                'city' => 'Flatgap',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41763',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0314000',
                'longitude' => '-83.1857000',
                'city' => 'Slemp',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41777',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0314000',
                'longitude' => '-83.1857000',
                'city' => 'Yeaddiss',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41039',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4278000',
                'longitude' => '-83.8663000',
                'city' => 'Ewing',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41037',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4278000',
                'longitude' => '-83.8663000',
                'city' => 'Elizaville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41307',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5586000',
                'longitude' => '-83.3850000',
                'city' => 'Athol',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40840',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Helton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42503',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1578000',
                'longitude' => '-84.4835000',
                'city' => 'Somerset',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41762',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1641000',
                'longitude' => '-83.3753000',
                'city' => 'Sizerock',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41822',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3310000',
                'longitude' => '-82.9845000',
                'city' => 'Hindman',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41776',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1827000',
                'longitude' => '-83.3014000',
                'city' => 'Wooton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41713',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1827000',
                'longitude' => '-83.3014000',
                'city' => 'Avawam',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41764',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1827000',
                'longitude' => '-83.3014000',
                'city' => 'Smilax',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41749',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1827000',
                'longitude' => '-83.3014000',
                'city' => 'Hyden',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40484',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5346000',
                'longitude' => '-84.6578000',
                'city' => 'Stanford',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41666',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4424000',
                'longitude' => '-82.8001000',
                'city' => 'Wayland',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41645',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5573000',
                'longitude' => '-82.7602000',
                'city' => 'Langley',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41655',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5573000',
                'longitude' => '-82.7602000',
                'city' => 'Printer',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41649',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5573000',
                'longitude' => '-82.7602000',
                'city' => 'Martin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40486',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4340000',
                'longitude' => '-83.9986000',
                'city' => 'Tyner',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40434',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4340000',
                'longitude' => '-83.9986000',
                'city' => 'Gray Hawk',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40447',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4340000',
                'longitude' => '-83.9986000',
                'city' => 'Mc Kee',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41189',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Tollesboro',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41175',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'South Shore',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42602',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6921000',
                'longitude' => '-85.1347000',
                'city' => 'Albany',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41339',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4429000',
                'longitude' => '-83.4570000',
                'city' => 'Jackson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41314',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4429000',
                'longitude' => '-83.4570000',
                'city' => 'Booneville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40977',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7479000',
                'longitude' => '-83.6922000',
                'city' => 'Pineville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41238',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8277000',
                'longitude' => '-82.8549000',
                'city' => 'Oil Springs',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41274',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8277000',
                'longitude' => '-82.8549000',
                'city' => 'Wittensville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41232',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8277000',
                'longitude' => '-82.8549000',
                'city' => 'Lowmansville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41222',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8277000',
                'longitude' => '-82.8549000',
                'city' => 'Hagerhill',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41254',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8277000',
                'longitude' => '-82.8549000',
                'city' => 'River',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41214',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8661000',
                'longitude' => '-82.5410000',
                'city' => 'Debord',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41267',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8661000',
                'longitude' => '-82.5410000',
                'city' => 'Warfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41262',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8661000',
                'longitude' => '-82.5410000',
                'city' => 'Tomahawk',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41224',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8661000',
                'longitude' => '-82.5410000',
                'city' => 'Inez',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41055',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6149000',
                'longitude' => '-83.8090000',
                'city' => 'Mayslick',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41034',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6149000',
                'longitude' => '-83.8090000',
                'city' => 'Dover',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42539',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3197000',
                'longitude' => '-84.9434000',
                'city' => 'Liberty',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42638',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6994000',
                'longitude' => '-84.4789000',
                'city' => 'Revelo',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42635',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6994000',
                'longitude' => '-84.4789000',
                'city' => 'Pine Knot',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41144',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5776000',
                'longitude' => '-82.8421000',
                'city' => 'Greenup',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40380',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8491000',
                'longitude' => '-83.8484000',
                'city' => 'Stanton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41101',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4747000',
                'longitude' => '-82.6480000',
                'city' => 'Ashland',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40902',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7628000',
                'longitude' => '-83.7013000',
                'city' => 'Arjay',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40856',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7628000',
                'longitude' => '-83.7013000',
                'city' => 'Miracle',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40813',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7628000',
                'longitude' => '-83.7013000',
                'city' => 'Calvin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40940',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7628000',
                'longitude' => '-83.7013000',
                'city' => 'Frakes',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40958',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7628000',
                'longitude' => '-83.7013000',
                'city' => 'Kettle Island',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40988',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7628000',
                'longitude' => '-83.7013000',
                'city' => 'Stoney Fork',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40939',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7628000',
                'longitude' => '-83.7013000',
                'city' => 'Fourmile',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40955',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7628000',
                'longitude' => '-83.7013000',
                'city' => 'Ingram',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41621',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6093000',
                'longitude' => '-82.7347000',
                'city' => 'Dwale',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42519',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9818000',
                'longitude' => '-84.6087000',
                'city' => 'Burnside',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42541',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4732000',
                'longitude' => '-84.8146000',
                'city' => 'Middleburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42603',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8333000',
                'longitude' => '-84.8519000',
                'city' => 'Alpha',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41426',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7573000',
                'longitude' => '-83.0690000',
                'city' => 'Falcon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41465',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7573000',
                'longitude' => '-83.0690000',
                'city' => 'Salyersville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41531',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5806000',
                'longitude' => '-82.2713000',
                'city' => 'Hardy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41519',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5806000',
                'longitude' => '-82.2713000',
                'city' => 'Canada',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41543',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5806000',
                'longitude' => '-82.2713000',
                'city' => 'Mc Andrews',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41555',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5806000',
                'longitude' => '-82.2713000',
                'city' => 'Pinsonfork',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41535',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5806000',
                'longitude' => '-82.2713000',
                'city' => 'Huddy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41567',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5806000',
                'longitude' => '-82.2713000',
                'city' => 'Stone',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41564',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5806000',
                'longitude' => '-82.2713000',
                'city' => 'Sidney',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42653',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6605000',
                'longitude' => '-84.4406000',
                'city' => 'Whitley City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42647',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6605000',
                'longitude' => '-84.4406000',
                'city' => 'Stearns',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40769',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6605000',
                'longitude' => '-84.4406000',
                'city' => 'Williamsburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42649',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.6605000',
                'longitude' => '-84.4406000',
                'city' => 'Strunk',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40489',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4660000',
                'longitude' => '-84.5074000',
                'city' => 'Waynesburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40409',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4660000',
                'longitude' => '-84.5074000',
                'city' => 'Brodhead',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40419',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4660000',
                'longitude' => '-84.5074000',
                'city' => 'Crab Orchard',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41643',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4790000',
                'longitude' => '-82.8327000',
                'city' => 'Lackey',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41622',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4790000',
                'longitude' => '-82.8327000',
                'city' => 'Eastern',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41630',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4790000',
                'longitude' => '-82.8327000',
                'city' => 'Garrett',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41640',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4790000',
                'longitude' => '-82.8327000',
                'city' => 'Hueysville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40322',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9498000',
                'longitude' => '-83.6249000',
                'city' => 'Frenchburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41301',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7329000',
                'longitude' => '-83.5521000',
                'city' => 'Campton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40402',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3191000',
                'longitude' => '-83.8085000',
                'city' => 'Annville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41844',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3415000',
                'longitude' => '-82.8692000',
                'city' => 'Pippa Passes',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41861',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3415000',
                'longitude' => '-82.8692000',
                'city' => 'Raven',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40868',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0890000',
                'longitude' => '-83.3970000',
                'city' => 'Stinnett',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40827',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0890000',
                'longitude' => '-83.3970000',
                'city' => 'Essie',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40803',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0890000',
                'longitude' => '-83.3970000',
                'city' => 'Asher',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40874',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0890000',
                'longitude' => '-83.3970000',
                'city' => 'Warbranch',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40858',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0890000',
                'longitude' => '-83.3970000',
                'city' => 'Mozelle',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40844',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0890000',
                'longitude' => '-83.3970000',
                'city' => 'Hoskinston',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40979',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0890000',
                'longitude' => '-83.3970000',
                'city' => 'Roark',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40810',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0890000',
                'longitude' => '-83.3970000',
                'city' => 'Bledsoe',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42634',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7120000',
                'longitude' => '-84.4831000',
                'city' => 'Parkers Lake',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42631',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7120000',
                'longitude' => '-84.4831000',
                'city' => 'Marshes Siding',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41636',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4576000',
                'longitude' => '-82.7424000',
                'city' => 'Hi Hat',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41651',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4576000',
                'longitude' => '-82.7424000',
                'city' => 'Minnie',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41619',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4576000',
                'longitude' => '-82.7424000',
                'city' => 'Drift',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41604',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4576000',
                'longitude' => '-82.7424000',
                'city' => 'Beaver',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41647',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4576000',
                'longitude' => '-82.7424000',
                'city' => 'Mc Dowell',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41739',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3397000',
                'longitude' => '-83.1249000',
                'city' => 'Dwarf',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40442',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2785000',
                'longitude' => '-84.6546000',
                'city' => 'Kings Mountain',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42567',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2785000',
                'longitude' => '-84.6546000',
                'city' => 'Eubank',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41169',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5232000',
                'longitude' => '-82.6925000',
                'city' => 'Russell',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40962',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1497000',
                'longitude' => '-83.7651000',
                'city' => 'Manchester',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42553',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1750000',
                'longitude' => '-84.6369000',
                'city' => 'Science Hill',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41250',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8465000',
                'longitude' => '-82.4212000',
                'city' => 'Pilgrim',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41203',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8465000',
                'longitude' => '-82.4212000',
                'city' => 'Beauty',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41745',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3520000',
                'longitude' => '-83.4114000',
                'city' => 'Gays Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41390',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3520000',
                'longitude' => '-83.4114000',
                'city' => 'Whick',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41348',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3520000',
                'longitude' => '-83.4114000',
                'city' => 'Lost Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41727',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3520000',
                'longitude' => '-83.4114000',
                'city' => 'Chavies',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41721',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3520000',
                'longitude' => '-83.4114000',
                'city' => 'Buckhorn',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41847',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2276000',
                'longitude' => '-82.9797000',
                'city' => 'Redfox',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41129',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4168000',
                'longitude' => '-82.6039000',
                'city' => 'Catlettsburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41528',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5645000',
                'longitude' => '-82.1407000',
                'city' => 'Freeburn',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40336',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6865000',
                'longitude' => '-83.9689000',
                'city' => 'Irvine',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41562',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4824000',
                'longitude' => '-82.5267000',
                'city' => 'Shelbiana',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41544',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5628000',
                'longitude' => '-82.1360000',
                'city' => 'Mc Carr',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41558',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5628000',
                'longitude' => '-82.1360000',
                'city' => 'Ransom',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41557',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4777000',
                'longitude' => '-82.5167000',
                'city' => 'Raccoon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41502',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4777000',
                'longitude' => '-82.5167000',
                'city' => 'Pikeville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41751',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2510000',
                'longitude' => '-83.1973000',
                'city' => 'Jeff',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41729',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2510000',
                'longitude' => '-83.1973000',
                'city' => 'Combs',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41719',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2510000',
                'longitude' => '-83.1973000',
                'city' => 'Bonnyman',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41774',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2510000',
                'longitude' => '-83.1973000',
                'city' => 'Viper',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41723',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2510000',
                'longitude' => '-83.1973000',
                'city' => 'Busy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41754',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2510000',
                'longitude' => '-83.1973000',
                'city' => 'Krypton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41367',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2510000',
                'longitude' => '-83.1973000',
                'city' => 'Rowdy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41859',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3596000',
                'longitude' => '-82.7950000',
                'city' => 'Dema',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41862',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3596000',
                'longitude' => '-82.7950000',
                'city' => 'Topmost',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41828',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3596000',
                'longitude' => '-82.7950000',
                'city' => 'Kite',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42533',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0973000',
                'longitude' => '-84.6061000',
                'city' => 'Ferguson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41667',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3566000',
                'longitude' => '-82.7105000',
                'city' => 'Weeksbury',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41612',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3566000',
                'longitude' => '-82.7105000',
                'city' => 'Bypro',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41650',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3566000',
                'longitude' => '-82.7105000',
                'city' => 'Melvin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41669',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3566000',
                'longitude' => '-82.7105000',
                'city' => 'Wheelwright',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41606',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3566000',
                'longitude' => '-82.7105000',
                'city' => 'Bevinsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40445',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3001000',
                'longitude' => '-84.2154000',
                'city' => 'Livingston',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41568',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5628000',
                'longitude' => '-82.1360000',
                'city' => 'Stopover',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41547',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5628000',
                'longitude' => '-82.1360000',
                'city' => 'Majestic',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41553',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5628000',
                'longitude' => '-82.1360000',
                'city' => 'Phelps',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41397',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5697000',
                'longitude' => '-83.7057000',
                'city' => 'Zoe',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40078',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4151000',
                'longitude' => '-82.7137000',
                'city' => 'Willisburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41121',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5713000',
                'longitude' => '-82.8401000',
                'city' => 'Argillite',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41132',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3346000',
                'longitude' => '-82.9524000',
                'city' => 'Denton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41146',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3346000',
                'longitude' => '-82.9524000',
                'city' => 'Hitchins',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41168',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3346000',
                'longitude' => '-82.9524000',
                'city' => 'Rush',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41760',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2139000',
                'longitude' => '-83.0649000',
                'city' => 'Scuddy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41759',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2139000',
                'longitude' => '-83.0649000',
                'city' => 'Sassafras',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41731',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2139000',
                'longitude' => '-83.0649000',
                'city' => 'Cornettsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41746',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2139000',
                'longitude' => '-83.0649000',
                'city' => 'Happy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41642',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5558000',
                'longitude' => '-82.6337000',
                'city' => 'Ivel',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41615',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5329000',
                'longitude' => '-82.6308000',
                'city' => 'Dana',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41663',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5329000',
                'longitude' => '-82.6308000',
                'city' => 'Tram',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41659',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5329000',
                'longitude' => '-82.6308000',
                'city' => 'Stanville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41605',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5329000',
                'longitude' => '-82.6308000',
                'city' => 'Betsy Layne',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41260',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8167000',
                'longitude' => '-82.8092000',
                'city' => 'Thelma',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40481',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4340000',
                'longitude' => '-83.9986000',
                'city' => 'Sandgap',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41183',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5169000',
                'longitude' => '-82.7247000',
                'city' => 'Worthington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41139',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5169000',
                'longitude' => '-82.7247000',
                'city' => 'Flatwoods',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41408',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9186000',
                'longitude' => '-83.2524000',
                'city' => 'Cannel City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41425',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9186000',
                'longitude' => '-83.2524000',
                'city' => 'Ezel',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41464',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7510000',
                'longitude' => '-83.0670000',
                'city' => 'Royalton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41421',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9286000',
                'longitude' => '-83.1026000',
                'city' => 'Elkfork',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41413',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9286000',
                'longitude' => '-83.1026000',
                'city' => 'Crockett',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41472',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9286000',
                'longitude' => '-83.1026000',
                'city' => 'West Liberty',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40740',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9437000',
                'longitude' => '-84.0999000',
                'city' => 'Lily',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40771',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9437000',
                'longitude' => '-84.0999000',
                'city' => 'Woodbine',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40734',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9437000',
                'longitude' => '-84.0999000',
                'city' => 'Gray',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40759',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9437000',
                'longitude' => '-84.0999000',
                'city' => 'Rockholds',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40737',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9437000',
                'longitude' => '-84.0999000',
                'city' => 'Keavy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40763',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.7422000',
                'longitude' => '-84.1583000',
                'city' => 'Siler',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40935',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8428000',
                'longitude' => '-83.7697000',
                'city' => 'Flat Lick',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40930',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8428000',
                'longitude' => '-83.7697000',
                'city' => 'Dewitt',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40982',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8428000',
                'longitude' => '-83.7697000',
                'city' => 'Scalf',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40997',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8428000',
                'longitude' => '-83.7697000',
                'city' => 'Walker',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40923',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8649000',
                'longitude' => '-83.8850000',
                'city' => 'Cannon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40943',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8649000',
                'longitude' => '-83.8850000',
                'city' => 'Girdler',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40915',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8649000',
                'longitude' => '-83.8850000',
                'city' => 'Bimble',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40949',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8649000',
                'longitude' => '-83.8850000',
                'city' => 'Heidrick',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40903',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8649000',
                'longitude' => '-83.8850000',
                'city' => 'Artemus',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40953',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8649000',
                'longitude' => '-83.8850000',
                'city' => 'Hinkle',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40806',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9018000',
                'longitude' => '-83.3413000',
                'city' => 'Baxter',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40816',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9018000',
                'longitude' => '-83.3413000',
                'city' => 'Chappell',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40808',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9018000',
                'longitude' => '-83.3413000',
                'city' => 'Big Laurel',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42518',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9898000',
                'longitude' => '-84.6030000',
                'city' => 'Bronston',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40831',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Harlan',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40854',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Loyall',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40815',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Cawood',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40870',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Totz',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40873',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Wallins Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40820',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Cranks',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40824',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Dayhoit',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40865',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8412000',
                'longitude' => '-83.3255000',
                'city' => 'Putney',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41660',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4603000',
                'longitude' => '-82.6594000',
                'city' => 'Teaberry',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41631',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4603000',
                'longitude' => '-82.6594000',
                'city' => 'Grethel',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40862',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9777000',
                'longitude' => '-82.9932000',
                'city' => 'Partridge',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41819',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9777000',
                'longitude' => '-82.9932000',
                'city' => 'Gordon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41364',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4752000',
                'longitude' => '-83.6744000',
                'city' => 'Ricetown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41386',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4752000',
                'longitude' => '-83.6744000',
                'city' => 'Vincent',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40983',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4752000',
                'longitude' => '-83.6744000',
                'city' => 'Sextons Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40914',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1537000',
                'longitude' => '-83.7622000',
                'city' => 'Big Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40941',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1537000',
                'longitude' => '-83.7622000',
                'city' => 'Garrard',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40472',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6865000',
                'longitude' => '-83.9689000',
                'city' => 'Ravenna',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40828',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8682000',
                'longitude' => '-83.1919000',
                'city' => 'Evarts',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41539',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5634000',
                'longitude' => '-82.4468000',
                'city' => 'Kimper',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41571',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5634000',
                'longitude' => '-82.4468000',
                'city' => 'Varney',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40826',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Eolia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41815',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Ermine',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41855',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Thornton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41804',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Blackey',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41826',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Jeremiah',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41837',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Mayking',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41824',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Isom',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41832',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Letcher',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41845',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Premium',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41821',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Hallie',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40312',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1183000',
                'longitude' => '-82.8280000',
                'city' => 'Clay City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41230',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1178000',
                'longitude' => '-82.6076000',
                'city' => 'Louisa',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41538',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3318000',
                'longitude' => '-82.5807000',
                'city' => 'Jonancy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41520',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3318000',
                'longitude' => '-82.5807000',
                'city' => 'Dorton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41560',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3318000',
                'longitude' => '-82.5807000',
                'city' => 'Robinson Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41572',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3318000',
                'longitude' => '-82.5807000',
                'city' => 'Virgie',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41563',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3318000',
                'longitude' => '-82.5807000',
                'city' => 'Shelby Gap',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41834',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2276000',
                'longitude' => '-82.9797000',
                'city' => 'Littcarr',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40385',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6865000',
                'longitude' => '-83.9689000',
                'city' => 'Waco',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40863',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4663000',
                'longitude' => '-82.6407000',
                'city' => 'Pathfork',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41180',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0288000',
                'longitude' => '-82.8381000',
                'city' => 'Webbville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41159',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0288000',
                'longitude' => '-82.8381000',
                'city' => 'Martha',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41124',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0288000',
                'longitude' => '-82.8381000',
                'city' => 'Blaine',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40422',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6448000',
                'longitude' => '-84.7721000',
                'city' => 'Danville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41332',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8017000',
                'longitude' => '-83.4137000',
                'city' => 'Hazel Green',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40819',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8278000',
                'longitude' => '-83.4222000',
                'city' => 'Coldiron',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40845',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8278000',
                'longitude' => '-83.4222000',
                'city' => 'Hulen',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41317',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5523000',
                'longitude' => '-83.3830000',
                'city' => 'Clayhole',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41385',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5523000',
                'longitude' => '-83.3830000',
                'city' => 'Vancleve',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41365',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7329000',
                'longitude' => '-83.5521000',
                'city' => 'Rogers',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41360',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7329000',
                'longitude' => '-83.5521000',
                'city' => 'Pine Ridge',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41004',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6857000',
                'longitude' => '-84.0687000',
                'city' => 'Brooksville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41714',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1641000',
                'longitude' => '-83.3753000',
                'city' => 'Bear Branch',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41766',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1641000',
                'longitude' => '-83.3753000',
                'city' => 'Thousandsticks',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41775',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1641000',
                'longitude' => '-83.3753000',
                'city' => 'Wendover',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40358',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.1422000',
                'longitude' => '-83.7671000',
                'city' => 'Olympia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41735',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.0409000',
                'longitude' => '-83.1719000',
                'city' => 'Delphia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41044',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5351000',
                'longitude' => '-84.0307000',
                'city' => 'Germantown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40387',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8825000',
                'longitude' => '-83.4615000',
                'city' => 'Wellington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41040',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6857000',
                'longitude' => '-84.0687000',
                'city' => 'Falmouth',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41171',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0891000',
                'longitude' => '-83.1252000',
                'city' => 'Sandy Hook',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41149',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0891000',
                'longitude' => '-83.1252000',
                'city' => 'Isonville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41352',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9169000',
                'longitude' => '-83.2603000',
                'city' => 'Mize',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41451',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9169000',
                'longitude' => '-83.2603000',
                'city' => 'Malone',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41043',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7690000',
                'longitude' => '-84.1700000',
                'city' => 'Foster',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41512',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3062000',
                'longitude' => '-82.3495000',
                'city' => 'Ashcamp',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41513',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3062000',
                'longitude' => '-82.3495000',
                'city' => 'Belcher',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41559',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3062000',
                'longitude' => '-82.3495000',
                'city' => 'Regina',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41534',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3062000',
                'longitude' => '-82.3495000',
                'city' => 'Hellier',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41561',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3062000',
                'longitude' => '-82.3495000',
                'city' => 'Rockhouse',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41522',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3062000',
                'longitude' => '-82.3495000',
                'city' => 'Elkhorn City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41141',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6054000',
                'longitude' => '-83.1762000',
                'city' => 'Garrison',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41166',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6054000',
                'longitude' => '-83.1762000',
                'city' => 'Quincy',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41096',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6229000',
                'longitude' => '-83.8031000',
                'city' => 'Washington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40346',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9498000',
                'longitude' => '-83.6249000',
                'city' => 'Means',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40316',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9498000',
                'longitude' => '-83.6249000',
                'city' => 'Denniston',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41817',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3492000',
                'longitude' => '-82.9777000',
                'city' => 'Garner',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41831',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3492000',
                'longitude' => '-82.9777000',
                'city' => 'Leburn',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42516',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3214000',
                'longitude' => '-84.9355000',
                'city' => 'Bethelridge',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42566',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3214000',
                'longitude' => '-84.9355000',
                'city' => 'Yosemite',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '42528',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.3214000',
                'longitude' => '-84.9355000',
                'city' => 'Dunnville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41216',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8127000',
                'longitude' => '-82.8121000',
                'city' => 'East Point',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41271',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8127000',
                'longitude' => '-82.8121000',
                'city' => 'Williamsport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41234',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8127000',
                'longitude' => '-82.8121000',
                'city' => 'Meally',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41204',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8127000',
                'longitude' => '-82.8121000',
                'city' => 'Boons Camp',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41263',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8127000',
                'longitude' => '-82.8121000',
                'city' => 'Tutor Key',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41268',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8127000',
                'longitude' => '-82.8121000',
                'city' => 'West Van Lear',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41265',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8127000',
                'longitude' => '-82.8121000',
                'city' => 'Van Lear',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41135',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.5930000',
                'longitude' => '-83.3221000',
                'city' => 'Emerson',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41835',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1704000',
                'longitude' => '-82.6351000',
                'city' => 'Mc Roberts',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41517',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1704000',
                'longitude' => '-82.6351000',
                'city' => 'Burdine',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41554',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4403000',
                'longitude' => '-82.2695000',
                'city' => 'Phyllis',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41548',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4403000',
                'longitude' => '-82.2695000',
                'city' => 'Mouthcard',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41524',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4403000',
                'longitude' => '-82.2695000',
                'city' => 'Fedscreek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41566',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4403000',
                'longitude' => '-82.2695000',
                'city' => 'Steele',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41540',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4403000',
                'longitude' => '-82.2695000',
                'city' => 'Lick Creek',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40927',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8643000',
                'longitude' => '-83.1948000',
                'city' => 'Closplint',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40847',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8643000',
                'longitude' => '-83.1948000',
                'city' => 'Kenvir',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40801',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8643000',
                'longitude' => '-83.1948000',
                'city' => 'Ages Brookside',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40843',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.8643000',
                'longitude' => '-83.1948000',
                'city' => 'Holmes Mill',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40741',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1923000',
                'longitude' => '-84.1201000',
                'city' => 'London',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41093',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.4189000',
                'longitude' => '-83.7308000',
                'city' => 'Wallingford',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40972',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.2693000',
                'longitude' => '-83.6446000',
                'city' => 'Oneida',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40807',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9699000',
                'longitude' => '-82.9320000',
                'city' => 'Benham',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40855',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9699000',
                'longitude' => '-82.9320000',
                'city' => 'Lynch',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41838',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1840000',
                'longitude' => '-82.7195000',
                'city' => 'Millstone',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41812',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1840000',
                'longitude' => '-82.7195000',
                'city' => 'Deane',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41810',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1840000',
                'longitude' => '-82.7195000',
                'city' => 'Cromona',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41849',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1840000',
                'longitude' => '-82.7195000',
                'city' => 'Seco',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41840',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1840000',
                'longitude' => '-82.7195000',
                'city' => 'Neon',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41825',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.1840000',
                'longitude' => '-82.7195000',
                'city' => 'Jackhorn',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41065',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2954000',
                'longitude' => '-83.6599000',
                'city' => 'Muses Mills',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41049',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2954000',
                'longitude' => '-83.6599000',
                'city' => 'Hillsboro',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41081',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2954000',
                'longitude' => '-83.6599000',
                'city' => 'Plummers Landing',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41062',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6554000',
                'longitude' => '-83.8740000',
                'city' => 'Minerva',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41632',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6789000',
                'longitude' => '-83.0276000',
                'city' => 'Gunlock',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41607',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6695000',
                'longitude' => '-82.7711000',
                'city' => 'Blue River',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41616',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6695000',
                'longitude' => '-82.7711000',
                'city' => 'David',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41602',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6695000',
                'longitude' => '-82.7711000',
                'city' => 'Auxier',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41005',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '36.9777000',
                'longitude' => '-82.9932000',
                'city' => 'Burlington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41174',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7210000',
                'longitude' => '-82.9649000',
                'city' => 'South Portsmouth',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40512',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8491000',
                'longitude' => '-83.8484000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41839',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.4134000',
                'longitude' => '-82.8750000',
                'city' => 'Mousie',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40475',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7496000',
                'longitude' => '-84.3030000',
                'city' => 'Richmond',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40505',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0494000',
                'longitude' => '-84.4944000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40508',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0494000',
                'longitude' => '-84.4944000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40509',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8855000',
                'longitude' => '-84.2513000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41017',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.1028000',
                'longitude' => '-84.5206000',
                'city' => 'Ft Mitchell',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41018',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.1028000',
                'longitude' => '-84.5206000',
                'city' => 'Erlanger',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40507',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0494000',
                'longitude' => '-84.4944000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40390',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.8672000',
                'longitude' => '-84.6661000',
                'city' => 'Wilmore',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40502',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0334000',
                'longitude' => '-84.5060000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40514',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9883000',
                'longitude' => '-84.5587000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40356',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9883000',
                'longitude' => '-84.5587000',
                'city' => 'Nicholasville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40513',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9883000',
                'longitude' => '-84.5587000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40503',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9883000',
                'longitude' => '-84.5587000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40504',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9883000',
                'longitude' => '-84.5587000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40588',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0494000',
                'longitude' => '-84.4944000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40515',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0494000',
                'longitude' => '-84.4944000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40516',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0494000',
                'longitude' => '-84.4944000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40510',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0454000',
                'longitude' => '-84.4973000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41003',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3914000',
                'longitude' => '-84.2993000',
                'city' => 'Berry',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41031',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3914000',
                'longitude' => '-84.2993000',
                'city' => 'Cynthiana',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40464',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6448000',
                'longitude' => '-84.7721000',
                'city' => 'Parksville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41075',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Fort Thomas',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41097',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6424000',
                'longitude' => '-84.5605000',
                'city' => 'Williamstown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40517',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9734000',
                'longitude' => '-84.5025000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40330',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7658000',
                'longitude' => '-84.8522000',
                'city' => 'Harrodsburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40444',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Lancaster',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41048',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Hebron',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40383',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0518000',
                'longitude' => '-84.7341000',
                'city' => 'Versailles',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40536',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0334000',
                'longitude' => '-84.5060000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40506',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0334000',
                'longitude' => '-84.5060000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41014',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Covington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41074',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Dayton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41011',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Covington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41073',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Bellevue',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41015',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Latonia',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41071',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Newport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40069',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6838000',
                'longitude' => '-85.2232000',
                'city' => 'Springfield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40040',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6838000',
                'longitude' => '-85.2232000',
                'city' => 'Mackville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40353',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0581000',
                'longitude' => '-83.9431000',
                'city' => 'Mount Sterling',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41051',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0027000',
                'longitude' => '-84.6295000',
                'city' => 'Independence',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41042',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0027000',
                'longitude' => '-84.6295000',
                'city' => 'Florence',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41094',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0027000',
                'longitude' => '-84.6295000',
                'city' => 'Walton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40350',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3126000',
                'longitude' => '-84.0333000',
                'city' => 'Moorefield',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40311',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3126000',
                'longitude' => '-84.0333000',
                'city' => 'Carlisle',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40423',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6510000',
                'longitude' => '-84.7743000',
                'city' => 'Danville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40461',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6785000',
                'longitude' => '-84.4146000',
                'city' => 'Paint Lick',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40468',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.6501000',
                'longitude' => '-84.9480000',
                'city' => 'Perryville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40523',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0494000',
                'longitude' => '-84.4944000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40361',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2093000',
                'longitude' => '-84.2503000',
                'city' => 'Paris',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40372',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9167000',
                'longitude' => '-84.8578000',
                'city' => 'Salvisa',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40391',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.9994000',
                'longitude' => '-84.1750000',
                'city' => 'Winchester',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41063',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.9392000',
                'longitude' => '-84.5470000',
                'city' => 'Morning View',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41053',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.9392000',
                'longitude' => '-84.5470000',
                'city' => 'Kenton',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40357',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.2093000',
                'longitude' => '-84.2503000',
                'city' => 'North Middletown',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40440',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.5841000',
                'longitude' => '-84.8021000',
                'city' => 'Junction City',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41091',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.9472000',
                'longitude' => '-84.6835000',
                'city' => 'Union',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41035',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0454000',
                'longitude' => '-84.4973000',
                'city' => 'Dry Ridge',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41030',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7643000',
                'longitude' => '-84.6070000',
                'city' => 'Crittenden',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41059',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0643000',
                'longitude' => '-84.4468000',
                'city' => 'Melbourne',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41076',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0643000',
                'longitude' => '-84.4468000',
                'city' => 'Newport',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41001',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.9625000',
                'longitude' => '-84.3860000',
                'city' => 'Alexandria',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41012',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Covington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41006',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7885000',
                'longitude' => '-84.3658000',
                'city' => 'Butler',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41033',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7885000',
                'longitude' => '-84.3658000',
                'city' => 'De Mossville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40348',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.3079000',
                'longitude' => '-84.1512000',
                'city' => 'Millersburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41092',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.8678000',
                'longitude' => '-84.6128000',
                'city' => 'Verona',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40337',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0581000',
                'longitude' => '-83.9431000',
                'city' => 'Jeffersonville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40555',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.0494000',
                'longitude' => '-84.4944000',
                'city' => 'Lexington',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40410',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7158000',
                'longitude' => '-84.6480000',
                'city' => 'Bryantsville',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41095',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7851000',
                'longitude' => '-84.9028000',
                'city' => 'Warsaw',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40476',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7496000',
                'longitude' => '-84.3030000',
                'city' => 'Richmond',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41080',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0399000',
                'longitude' => '-84.7245000',
                'city' => 'Petersburg',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41046',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.7115000',
                'longitude' => '-84.8210000',
                'city' => 'Glencoe',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41022',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0816000',
                'longitude' => '-84.5090000',
                'city' => 'Florence',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '40310',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '37.7517000',
                'longitude' => '-84.7623000',
                'city' => 'Burgin',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '45275',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0027000',
                'longitude' => '-84.6295000',
                'city' => 'Cincinnati',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '45219',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '39.0027000',
                'longitude' => '-84.6295000',
                'city' => 'Cincinnati',
                'full_state' => 'Kentucky',
            ],
            [
                'zip' => '41052',
                'country_code' => 'US',
                'state' => 'KY',
                'latitude' => '38.6384000',
                'longitude' => '-84.5635000',
                'city' => 'Jonesville',
                'full_state' => 'Kentucky',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
