<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class IllinoisSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '62522',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8415000',
                'longitude' => '-88.9518000',
                'city' => 'Decatur',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62521',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8415000',
                'longitude' => '-88.9518000',
                'city' => 'Decatur',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61802',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Urbana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61821',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Champaign',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62650',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7290000',
                'longitude' => '-90.2320000',
                'city' => 'Jacksonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62702',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7426000',
                'longitude' => '-89.6247000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62703',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7426000',
                'longitude' => '-89.6247000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61833',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Tilton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61832',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Danville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62707',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62301',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9325000',
                'longitude' => '-91.4026000',
                'city' => 'Quincy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61866',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3110000',
                'longitude' => '-88.1580000',
                'city' => 'Rantoul',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62681',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1217000',
                'longitude' => '-90.5603000',
                'city' => 'Rushville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61920',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4932000',
                'longitude' => '-88.1734000',
                'city' => 'Charleston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62321',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4138000',
                'longitude' => '-91.1357000',
                'city' => 'Carthage',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62305',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9345000',
                'longitude' => '-91.4080000',
                'city' => 'Quincy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62378',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8853000',
                'longitude' => '-90.6570000',
                'city' => 'Versailles',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62510',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5178000',
                'longitude' => '-89.0520000',
                'city' => 'Assumption',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62557',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5178000',
                'longitude' => '-89.0520000',
                'city' => 'Pana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62550',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5178000',
                'longitude' => '-89.0520000',
                'city' => 'Moweaqua',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62533',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4410000',
                'longitude' => '-89.6472000',
                'city' => 'Farmersville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62640',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4410000',
                'longitude' => '-89.6472000',
                'city' => 'Girard',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62572',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4410000',
                'longitude' => '-89.6472000',
                'city' => 'Waggoner',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62690',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4410000',
                'longitude' => '-89.6472000',
                'city' => 'Virden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62538',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3218000',
                'longitude' => '-89.5794000',
                'city' => 'Harvel',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62546',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3218000',
                'longitude' => '-89.5794000',
                'city' => 'Morrisonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62560',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3218000',
                'longitude' => '-89.5794000',
                'city' => 'Raymond',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62531',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6596000',
                'longitude' => '-89.3856000',
                'city' => 'Edinburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61933',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4853000',
                'longitude' => '-88.3727000',
                'city' => 'Kansas',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62366',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4853000',
                'longitude' => '-88.3727000',
                'city' => 'Pleasant Hill',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62523',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8415000',
                'longitude' => '-88.9518000',
                'city' => 'Decatur',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62535',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8415000',
                'longitude' => '-88.9518000',
                'city' => 'Forsyth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62526',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8415000',
                'longitude' => '-88.9518000',
                'city' => 'Decatur',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62440',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4812000',
                'longitude' => '-88.3755000',
                'city' => 'Lerna',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61938',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4812000',
                'longitude' => '-88.3755000',
                'city' => 'Mattoon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62362',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7791000',
                'longitude' => '-90.7439000',
                'city' => 'Perry',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62323',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7791000',
                'longitude' => '-90.7439000',
                'city' => 'Chambersburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62340',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7791000',
                'longitude' => '-90.7439000',
                'city' => 'Griggsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62353',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7791000',
                'longitude' => '-90.7439000',
                'city' => 'Mount Sterling',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62314',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7791000',
                'longitude' => '-90.7439000',
                'city' => 'Baylis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62570',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5895000',
                'longitude' => '-89.4180000',
                'city' => 'Tovey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62517',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5895000',
                'longitude' => '-89.4180000',
                'city' => 'Bulpitt',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62540',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5895000',
                'longitude' => '-89.4180000',
                'city' => 'Kincaid',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62558',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5895000',
                'longitude' => '-89.4180000',
                'city' => 'Pawnee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62704',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5895000',
                'longitude' => '-89.4180000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62568',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5895000',
                'longitude' => '-89.4180000',
                'city' => 'Taylorville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62443',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4812000',
                'longitude' => '-88.3755000',
                'city' => 'Mason',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61801',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Urbana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61874',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Savoy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61820',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Champaign',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61822',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Champaign',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62401',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1195000',
                'longitude' => '-88.5499000',
                'city' => 'Effingham',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62701',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7984000',
                'longitude' => '-89.6484000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61856',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1094000',
                'longitude' => '-88.2142000',
                'city' => 'Monticello',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61928',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4853000',
                'longitude' => '-88.3727000',
                'city' => 'Gays',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61931',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4853000',
                'longitude' => '-88.3727000',
                'city' => 'Humboldt',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61870',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8963000',
                'longitude' => '-87.6502000',
                'city' => 'Ridge Farm',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61850',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8963000',
                'longitude' => '-87.6502000',
                'city' => 'Indianola',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61846',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8963000',
                'longitude' => '-87.6502000',
                'city' => 'Georgetown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62651',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7290000',
                'longitude' => '-90.2320000',
                'city' => 'Jacksonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61924',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6118000',
                'longitude' => '-87.6978000',
                'city' => 'Chrisman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62946',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7984000',
                'longitude' => '-89.6484000',
                'city' => 'Harrisburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61919',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7981000',
                'longitude' => '-88.2830000',
                'city' => 'Camargo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61953',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7981000',
                'longitude' => '-88.2830000',
                'city' => 'Tuscola',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61824',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1094000',
                'longitude' => '-88.2142000',
                'city' => 'Champaign',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62379',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3581000',
                'longitude' => '-91.4303000',
                'city' => 'Warsaw',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62319',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9325000',
                'longitude' => '-91.4026000',
                'city' => 'Camden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61937',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7974000',
                'longitude' => '-88.5912000',
                'city' => 'Lovington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61929',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7974000',
                'longitude' => '-88.5912000',
                'city' => 'Hammond',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61863',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1094000',
                'longitude' => '-88.2142000',
                'city' => 'Pesotum',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61834',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0387000',
                'longitude' => '-87.6406000',
                'city' => 'Danville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61883',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0387000',
                'longitude' => '-87.6406000',
                'city' => 'Westville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61910',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7138000',
                'longitude' => '-88.3056000',
                'city' => 'Arcola',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62091',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9994000',
                'longitude' => '-89.5753000',
                'city' => 'Walshville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62086',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9994000',
                'longitude' => '-89.5753000',
                'city' => 'Sorento',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62423',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5790000',
                'longitude' => '-87.5904000',
                'city' => 'Dennison',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61944',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5790000',
                'longitude' => '-87.5904000',
                'city' => 'Paris',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61955',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5790000',
                'longitude' => '-87.5904000',
                'city' => 'Vermilion',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62441',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2170000',
                'longitude' => '-87.6643000',
                'city' => 'Marshall',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62477',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2170000',
                'longitude' => '-87.6643000',
                'city' => 'West Union',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62478',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2170000',
                'longitude' => '-87.6643000',
                'city' => 'West York',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62442',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2170000',
                'longitude' => '-87.6643000',
                'city' => 'Martinsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60942',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4685000',
                'longitude' => '-87.6687000',
                'city' => 'Hoopeston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61817',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9288000',
                'longitude' => '-87.7426000',
                'city' => 'Catlin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62363',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6075000',
                'longitude' => '-90.8058000',
                'city' => 'Pittsfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62357',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6075000',
                'longitude' => '-90.8058000',
                'city' => 'New Salem',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61865',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3079000',
                'longitude' => '-87.6981000',
                'city' => 'Potomac',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61811',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3079000',
                'longitude' => '-87.6981000',
                'city' => 'Alvin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61848',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3079000',
                'longitude' => '-87.6981000',
                'city' => 'Henning',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61841',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9097000',
                'longitude' => '-87.8240000',
                'city' => 'Fairmount',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61810',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9097000',
                'longitude' => '-87.8240000',
                'city' => 'Allerton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61876',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9097000',
                'longitude' => '-87.8240000',
                'city' => 'Sidell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62561',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Riverton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60605',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60603',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62551',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8530000',
                'longitude' => '-89.1652000',
                'city' => 'Niantic',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62573',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9310000',
                'longitude' => '-89.0601000',
                'city' => 'Warrensburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61778',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2474000',
                'longitude' => '-89.1255000',
                'city' => 'Waynesville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61723',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2603000',
                'longitude' => '-89.2377000',
                'city' => 'Atlanta',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62544',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7096000',
                'longitude' => '-88.9990000',
                'city' => 'Macon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62056',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1792000',
                'longitude' => '-89.6513000',
                'city' => 'Litchfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62656',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1492000',
                'longitude' => '-89.3655000',
                'city' => 'Lincoln',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62473',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0227000',
                'longitude' => '-88.5752000',
                'city' => 'Watson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62359',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9325000',
                'longitude' => '-91.4026000',
                'city' => 'Paloma',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62639',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1238000',
                'longitude' => '-90.5657000',
                'city' => 'Frederick',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62624',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0172000',
                'longitude' => '-90.4337000',
                'city' => 'Browning',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62618',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0172000',
                'longitude' => '-90.4337000',
                'city' => 'Beardstown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62567',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6404000',
                'longitude' => '-89.1915000',
                'city' => 'Stonington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62347',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9877000',
                'longitude' => '-91.1499000',
                'city' => 'Liberty',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62338',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9877000',
                'longitude' => '-91.1499000',
                'city' => 'Fowler',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62320',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9877000',
                'longitude' => '-91.1499000',
                'city' => 'Camp Point',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62356',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6959000',
                'longitude' => '-91.0413000',
                'city' => 'New Canton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62312',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6959000',
                'longitude' => '-91.0413000',
                'city' => 'Barry',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60963',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4711000',
                'longitude' => '-87.5852000',
                'city' => 'Rossville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62613',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7984000',
                'longitude' => '-89.6484000',
                'city' => 'Athens',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61943',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6544000',
                'longitude' => '-88.0308000',
                'city' => 'Oakland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61930',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6544000',
                'longitude' => '-88.0308000',
                'city' => 'Hindsboro',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61917',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6544000',
                'longitude' => '-88.0308000',
                'city' => 'Brocton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61912',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5325000',
                'longitude' => '-88.0253000',
                'city' => 'Ashmore',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62549',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7708000',
                'longitude' => '-88.8782000',
                'city' => 'Mt Zion',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61858',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1153000',
                'longitude' => '-87.7773000',
                'city' => 'Oakwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61844',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1153000',
                'longitude' => '-87.7773000',
                'city' => 'Fithian',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62664',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1993000',
                'longitude' => '-89.6949000',
                'city' => 'Mason City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62520',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8518000',
                'longitude' => '-89.4134000',
                'city' => 'Dawson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62515',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8518000',
                'longitude' => '-89.4134000',
                'city' => 'Buffalo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62545',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8518000',
                'longitude' => '-89.4134000',
                'city' => 'Mechanicsburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62519',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8518000',
                'longitude' => '-89.4134000',
                'city' => 'Cornland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62044',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3373000',
                'longitude' => '-90.2177000',
                'city' => 'Greenfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62098',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3373000',
                'longitude' => '-90.2177000',
                'city' => 'Wrights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62649',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3373000',
                'longitude' => '-90.2177000',
                'city' => 'Hettick',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62050',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4392000',
                'longitude' => '-90.4030000',
                'city' => 'Hillview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62082',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4392000',
                'longitude' => '-90.4030000',
                'city' => 'Roodhouse',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62016',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4392000',
                'longitude' => '-90.4030000',
                'city' => 'Carrollton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62092',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4392000',
                'longitude' => '-90.4030000',
                'city' => 'White Hall',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60924',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4645000',
                'longitude' => '-87.8007000',
                'city' => 'Cissna Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60960',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4645000',
                'longitude' => '-87.8007000',
                'city' => 'Rankin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60932',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4645000',
                'longitude' => '-87.8007000',
                'city' => 'East Lynn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62643',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2942000',
                'longitude' => '-89.4836000',
                'city' => 'Hartsburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62635',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2942000',
                'longitude' => '-89.4836000',
                'city' => 'Emden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61734',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2942000',
                'longitude' => '-89.4836000',
                'city' => 'Delavan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60957',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4587000',
                'longitude' => '-88.0969000',
                'city' => 'Paxton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62420',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3342000',
                'longitude' => '-87.8858000',
                'city' => 'Casey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60948',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5162000',
                'longitude' => '-88.0712000',
                'city' => 'Loda',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60955',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6759000',
                'longitude' => '-88.1181000',
                'city' => 'Onarga',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60968',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6759000',
                'longitude' => '-88.1181000',
                'city' => 'Thawville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60921',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5682000',
                'longitude' => '-88.2530000',
                'city' => 'Chatsworth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60952',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5682000',
                'longitude' => '-88.2530000',
                'city' => 'Melvin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60936',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5682000',
                'longitude' => '-88.2530000',
                'city' => 'Gibson City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62344',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2319000',
                'longitude' => '-90.9502000',
                'city' => 'Huntsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62316',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2319000',
                'longitude' => '-90.9502000',
                'city' => 'Bowen',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62311',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2319000',
                'longitude' => '-90.9502000',
                'city' => 'Augusta',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60918',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5962000',
                'longitude' => '-88.0366000',
                'city' => 'Buckley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60962',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6127000',
                'longitude' => '-88.1818000',
                'city' => 'Roberts',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60949',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3871000',
                'longitude' => '-88.1266000',
                'city' => 'Ludlow',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62621',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7519000',
                'longitude' => '-90.5358000',
                'city' => 'Bluffs',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62512',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1466000',
                'longitude' => '-89.1981000',
                'city' => 'Beason',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62345',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6353000',
                'longitude' => '-91.0988000',
                'city' => 'Kinderhook',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62343',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7271000',
                'longitude' => '-91.1937000',
                'city' => 'Hull',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62524',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8415000',
                'longitude' => '-88.9518000',
                'city' => 'Decatur',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62661',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5915000',
                'longitude' => '-89.9550000',
                'city' => 'Loami',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62662',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5915000',
                'longitude' => '-89.9550000',
                'city' => 'Lowder',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62692',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5915000',
                'longitude' => '-89.9550000',
                'city' => 'Waverly',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62674',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4364000',
                'longitude' => '-89.9947000',
                'city' => 'Palmyra',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62370',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5351000',
                'longitude' => '-91.0094000',
                'city' => 'Rockport',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62615',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5897000',
                'longitude' => '-89.7503000',
                'city' => 'Auburn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62667',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4778000',
                'longitude' => '-89.9815000',
                'city' => 'Modesto',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62666',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1806000',
                'longitude' => '-89.5797000',
                'city' => 'Middletown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62671',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1806000',
                'longitude' => '-89.5797000',
                'city' => 'New Holland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62642',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1806000',
                'longitude' => '-89.5797000',
                'city' => 'Greenview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61749',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1445000',
                'longitude' => '-89.1927000',
                'city' => 'Kenney',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61727',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1445000',
                'longitude' => '-89.1927000',
                'city' => 'Clinton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62358',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6186000',
                'longitude' => '-91.2875000',
                'city' => 'Niota',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61454',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6791000',
                'longitude' => '-91.0754000',
                'city' => 'Lomax',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62330',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6791000',
                'longitude' => '-91.0754000',
                'city' => 'Dallas City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61455',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6791000',
                'longitude' => '-91.0754000',
                'city' => 'Macomb',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62612',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9481000',
                'longitude' => '-90.2115000',
                'city' => 'Ashland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62691',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9481000',
                'longitude' => '-90.2115000',
                'city' => 'Virginia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62354',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5491000',
                'longitude' => '-91.3778000',
                'city' => 'Nauvoo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62501',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8415000',
                'longitude' => '-88.9518000',
                'city' => 'Argenta',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62325',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0330000',
                'longitude' => '-91.1613000',
                'city' => 'Coatsburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62351',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0330000',
                'longitude' => '-91.1613000',
                'city' => 'Mendon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62074',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9726000',
                'longitude' => '-89.6650000',
                'city' => 'New Douglas',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62611',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8150000',
                'longitude' => '-90.3763000',
                'city' => 'Arenzville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62628',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8150000',
                'longitude' => '-90.3763000',
                'city' => 'Chapin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62631',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8150000',
                'longitude' => '-90.3763000',
                'city' => 'Concord',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62627',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0476000',
                'longitude' => '-90.1477000',
                'city' => 'Chandlerville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61957',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4401000',
                'longitude' => '-88.5966000',
                'city' => 'Windsor',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62705',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7943000',
                'longitude' => '-89.6511000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62554',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9381000',
                'longitude' => '-88.8663000',
                'city' => 'Oreana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61873',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1091000',
                'longitude' => '-88.0450000',
                'city' => 'Saint Joseph',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62665',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7673000',
                'longitude' => '-90.4000000',
                'city' => 'Meredosia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61853',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7290000',
                'longitude' => '-90.2320000',
                'city' => 'Mahomet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61777',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7290000',
                'longitude' => '-90.2320000',
                'city' => 'Wapella',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62677',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8869000',
                'longitude' => '-90.0111000',
                'city' => 'Pleasant Plains',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62670',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7235000',
                'longitude' => '-90.0429000',
                'city' => 'New Berlin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62601',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7235000',
                'longitude' => '-90.0429000',
                'city' => 'Alexander',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62682',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2013000',
                'longitude' => '-89.7003000',
                'city' => 'San Jose',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62629',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6724000',
                'longitude' => '-89.6969000',
                'city' => 'Chatham',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62536',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6724000',
                'longitude' => '-89.6969000',
                'city' => 'Glenarm',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62638',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4794000',
                'longitude' => '-90.1062000',
                'city' => 'Franklin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62683',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4794000',
                'longitude' => '-90.1062000',
                'city' => 'Scottville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61880',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9854000',
                'longitude' => '-88.2572000',
                'city' => 'Tolono',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62539',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8534000',
                'longitude' => '-89.2452000',
                'city' => 'Illiopolis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62625',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9389000',
                'longitude' => '-89.6772000',
                'city' => 'Cantrall',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61854',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2094000',
                'longitude' => '-88.5045000',
                'city' => 'Mansfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62794',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7943000',
                'longitude' => '-89.6511000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62684',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8935000',
                'longitude' => '-89.6000000',
                'city' => 'Sherman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62563',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7488000',
                'longitude' => '-89.5341000',
                'city' => 'Rochester',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62659',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0112000',
                'longitude' => '-89.8507000',
                'city' => 'Lincolns New Salem',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62465',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3515000',
                'longitude' => '-88.6222000',
                'city' => 'Strasburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61839',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1220000',
                'longitude' => '-88.6511000',
                'city' => 'De Land',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62547',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7605000',
                'longitude' => '-89.2595000',
                'city' => 'Mount Auburn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62556',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4222000',
                'longitude' => '-89.4537000',
                'city' => 'Palmer',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62015',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1604000',
                'longitude' => '-89.4981000',
                'city' => 'Butler',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62089',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1604000',
                'longitude' => '-89.4981000',
                'city' => 'Taylor Springs',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62049',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1604000',
                'longitude' => '-89.4981000',
                'city' => 'Hillsboro',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62094',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2018000',
                'longitude' => '-89.4053000',
                'city' => 'Witt',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62051',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2018000',
                'longitude' => '-89.4053000',
                'city' => 'Irving',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62246',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0921000',
                'longitude' => '-89.3902000',
                'city' => 'Greenville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62017',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0921000',
                'longitude' => '-89.3902000',
                'city' => 'Coffeen',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62411',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0227000',
                'longitude' => '-88.5752000',
                'city' => 'Altamont',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62077',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0324000',
                'longitude' => '-89.4749000',
                'city' => 'Panama',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62019',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0324000',
                'longitude' => '-89.4749000',
                'city' => 'Donnellson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62011',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1206000',
                'longitude' => '-89.2791000',
                'city' => 'Bingham',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62032',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1206000',
                'longitude' => '-89.2791000',
                'city' => 'Fillmore',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62080',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2868000',
                'longitude' => '-89.1105000',
                'city' => 'Ramsey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62431',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2868000',
                'longitude' => '-89.1105000',
                'city' => 'Herrick',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62075',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2868000',
                'longitude' => '-89.1105000',
                'city' => 'Nokomis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62553',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2868000',
                'longitude' => '-89.1105000',
                'city' => 'Oconee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61951',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7137000',
                'longitude' => '-88.4728000',
                'city' => 'Sullivan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61911',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7137000',
                'longitude' => '-88.4728000',
                'city' => 'Arthur',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61857',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1127000',
                'longitude' => '-87.8737000',
                'city' => 'Muncie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62341',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3925000',
                'longitude' => '-91.3423000',
                'city' => 'Hamilton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62083',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3858000',
                'longitude' => '-89.0855000',
                'city' => 'Rosamond',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62076',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3040000',
                'longitude' => '-89.2851000',
                'city' => 'Ohlman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61872',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9446000',
                'longitude' => '-88.4524000',
                'city' => 'Sadorus',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61813',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9446000',
                'longitude' => '-88.4524000',
                'city' => 'Bement',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61851',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9446000',
                'longitude' => '-88.4524000',
                'city' => 'Ivesdale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62693',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9575000',
                'longitude' => '-89.5515000',
                'city' => 'Williamsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62571',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3892000',
                'longitude' => '-88.9635000',
                'city' => 'Tower Hill',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62565',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3892000',
                'longitude' => '-88.9635000',
                'city' => 'Shelbyville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61847',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3092000',
                'longitude' => '-88.0239000',
                'city' => 'Gifford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61862',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3070000',
                'longitude' => '-87.8764000',
                'city' => 'Penfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61812',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3070000',
                'longitude' => '-87.8764000',
                'city' => 'Armstrong',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61913',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7982000',
                'longitude' => '-88.4636000',
                'city' => 'Atwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62548',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0105000',
                'longitude' => '-89.2891000',
                'city' => 'Mount Pulaski',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61859',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1140000',
                'longitude' => '-87.9539000',
                'city' => 'Ogden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61849',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1140000',
                'longitude' => '-87.9539000',
                'city' => 'Homer',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61871',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1948000',
                'longitude' => '-87.9732000',
                'city' => 'Royal',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62668',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5404000',
                'longitude' => '-90.3321000',
                'city' => 'Murrayville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62694',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5404000',
                'longitude' => '-90.3321000',
                'city' => 'Winchester',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62663',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5404000',
                'longitude' => '-90.3321000',
                'city' => 'Manchester',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62530',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5918000',
                'longitude' => '-89.5828000',
                'city' => 'Divernon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62672',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4471000',
                'longitude' => '-89.7825000',
                'city' => 'Nilwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62688',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0112000',
                'longitude' => '-89.8507000',
                'city' => 'Tallula',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62675',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0112000',
                'longitude' => '-89.8507000',
                'city' => 'Petersburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62673',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1019000',
                'longitude' => '-89.9658000',
                'city' => 'Oakford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61878',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2391000',
                'longitude' => '-88.1864000',
                'city' => 'Thomasboro',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62463',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3494000',
                'longitude' => '-88.6169000',
                'city' => 'Stewardson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62365',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8807000',
                'longitude' => '-91.1106000',
                'city' => 'Plainville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61754',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2623000',
                'longitude' => '-89.2297000',
                'city' => 'Mc Lean',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61450',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4756000',
                'longitude' => '-90.9699000',
                'city' => 'La Harpe',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61420',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4756000',
                'longitude' => '-90.9699000',
                'city' => 'Blandinsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62374',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4756000',
                'longitude' => '-90.9699000',
                'city' => 'Tennessee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62360',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8169000',
                'longitude' => '-91.2429000',
                'city' => 'Payson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62462',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2285000',
                'longitude' => '-88.4975000',
                'city' => 'Sigel',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62313',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2788000',
                'longitude' => '-91.3401000',
                'city' => 'Basco',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62380',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2788000',
                'longitude' => '-91.3401000',
                'city' => 'West Point',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62373',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2788000',
                'longitude' => '-91.3401000',
                'city' => 'Sutter',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61914',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6438000',
                'longitude' => '-88.7418000',
                'city' => 'Bethany',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62346',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1400000',
                'longitude' => '-90.8418000',
                'city' => 'La Prairie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61882',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0113000',
                'longitude' => '-88.7244000',
                'city' => 'Weldon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61830',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0113000',
                'longitude' => '-88.7244000',
                'city' => 'Cisco',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62695',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6277000',
                'longitude' => '-90.2236000',
                'city' => 'Woodson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62543',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9666000',
                'longitude' => '-89.1639000',
                'city' => 'Latham',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61756',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9666000',
                'longitude' => '-89.1639000',
                'city' => 'Maroa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62513',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7605000',
                'longitude' => '-89.2595000',
                'city' => 'Blue Mound',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61936',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8006000',
                'longitude' => '-88.7177000',
                'city' => 'La Place',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61818',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8006000',
                'longitude' => '-88.7177000',
                'city' => 'Cerro Gordo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62444',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2628000',
                'longitude' => '-88.6344000',
                'city' => 'Mode',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62461',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2628000',
                'longitude' => '-88.6344000',
                'city' => 'Shumway',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62445',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1123000',
                'longitude' => '-88.2621000',
                'city' => 'Montrose',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62467',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1123000',
                'longitude' => '-88.2621000',
                'city' => 'Teutopolis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62479',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1123000',
                'longitude' => '-88.2621000',
                'city' => 'Wheeler',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62436',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1123000',
                'longitude' => '-88.2621000',
                'city' => 'Jewett',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62448',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1123000',
                'longitude' => '-88.2621000',
                'city' => 'Newton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61877',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0096000',
                'longitude' => '-88.1611000',
                'city' => 'Sidney',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61956',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0096000',
                'longitude' => '-88.1611000',
                'city' => 'Villa Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61864',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0096000',
                'longitude' => '-88.1611000',
                'city' => 'Philo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61875',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1050000',
                'longitude' => '-88.4264000',
                'city' => 'Seymour',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61884',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1050000',
                'longitude' => '-88.4264000',
                'city' => 'White Heath',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62324',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1132000',
                'longitude' => '-91.0315000',
                'city' => 'Clayton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62349',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1132000',
                'longitude' => '-91.0315000',
                'city' => 'Loraine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62339',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1132000',
                'longitude' => '-91.0315000',
                'city' => 'Golden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61842',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Farmer City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62352',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5635000',
                'longitude' => '-90.6484000',
                'city' => 'Milton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62361',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5635000',
                'longitude' => '-90.6484000',
                'city' => 'Pearl',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62355',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4422000',
                'longitude' => '-90.8697000',
                'city' => 'Nebo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62634',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1492000',
                'longitude' => '-89.3655000',
                'city' => 'Elkhart',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62534',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4795000',
                'longitude' => '-88.8640000',
                'city' => 'Findlay',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62424',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9723000',
                'longitude' => '-88.4553000',
                'city' => 'Dieterich',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62708',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7984000',
                'longitude' => '-89.6484000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62610',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6285000',
                'longitude' => '-90.4549000',
                'city' => 'Alsey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62367',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3263000',
                'longitude' => '-91.1906000',
                'city' => 'Plymouth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61775',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5886000',
                'longitude' => '-88.3830000',
                'city' => 'Strawn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61773',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5886000',
                'longitude' => '-88.3830000',
                'city' => 'Sibley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62336',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4671000',
                'longitude' => '-91.1689000',
                'city' => 'Ferris',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60933',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4634000',
                'longitude' => '-88.2780000',
                'city' => 'Elliott',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62329',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5685000',
                'longitude' => '-91.1653000',
                'city' => 'Colusa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61402',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5685000',
                'longitude' => '-91.1653000',
                'city' => 'Galesburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61814',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2650000',
                'longitude' => '-87.6056000',
                'city' => 'Bismarck',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61855',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8896000',
                'longitude' => '-88.7310000',
                'city' => 'Milmine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62532',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7922000',
                'longitude' => '-88.9845000',
                'city' => 'Elwin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62375',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9898000',
                'longitude' => '-90.7703000',
                'city' => 'Timewell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61831',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2212000',
                'longitude' => '-87.8064000',
                'city' => 'Collison',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61826',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Champaign',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61845',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4645000',
                'longitude' => '-88.3721000',
                'city' => 'Foosland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62706',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7943000',
                'longitude' => '-89.6511000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62764',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7943000',
                'longitude' => '-89.6511000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62756',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7943000',
                'longitude' => '-89.6511000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62414',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2502000',
                'longitude' => '-88.8622000',
                'city' => 'Beecher City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62438',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2502000',
                'longitude' => '-88.8622000',
                'city' => 'Lakewood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62422',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2502000',
                'longitude' => '-88.8622000',
                'city' => 'Cowden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62781',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7943000',
                'longitude' => '-89.6511000',
                'city' => 'Springfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62518',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0105000',
                'longitude' => '-89.2891000',
                'city' => 'Chestnut',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62541',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0105000',
                'longitude' => '-89.2891000',
                'city' => 'Lake Fork',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61852',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9060000',
                'longitude' => '-87.9954000',
                'city' => 'Longview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61816',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.9060000',
                'longitude' => '-87.9954000',
                'city' => 'Broadlands',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62085',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0944000',
                'longitude' => '-89.8046000',
                'city' => 'Sawyerville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62023',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0944000',
                'longitude' => '-89.8046000',
                'city' => 'Eagarville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62009',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0944000',
                'longitude' => '-89.8046000',
                'city' => 'Benld',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62088',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0944000',
                'longitude' => '-89.8046000',
                'city' => 'Staunton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62033',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0944000',
                'longitude' => '-89.8046000',
                'city' => 'Gillespie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62093',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0944000',
                'longitude' => '-89.8046000',
                'city' => 'Wilsonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61941',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7982000',
                'longitude' => '-87.9858000',
                'city' => 'Murdock',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61942',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7982000',
                'longitude' => '-87.9858000',
                'city' => 'Newman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62069',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1254000',
                'longitude' => '-89.8178000',
                'city' => 'Mount Olive',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62447',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2223000',
                'longitude' => '-88.4950000',
                'city' => 'Neoga',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62334',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3979000',
                'longitude' => '-91.2457000',
                'city' => 'Elvaston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61843',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3639000',
                'longitude' => '-88.4332000',
                'city' => 'Fisher',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62468',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2710000',
                'longitude' => '-88.2425000',
                'city' => 'Toledo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61401',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6366000',
                'longitude' => '-91.1692000',
                'city' => 'Galesburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62626',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2745000',
                'longitude' => '-89.8812000',
                'city' => 'Carlinville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61815',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1088000',
                'longitude' => '-88.3697000',
                'city' => 'Bondville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61925',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7790000',
                'longitude' => '-88.8727000',
                'city' => 'Dalton City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62514',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7922000',
                'longitude' => '-88.9845000',
                'city' => 'Boody',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62555',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4854000',
                'longitude' => '-89.1931000',
                'city' => 'Owaneco',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61949',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.6436000',
                'longitude' => '-87.8632000',
                'city' => 'Redmon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62660',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8510000',
                'longitude' => '-90.2005000',
                'city' => 'Literberry',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61940',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7978000',
                'longitude' => '-87.8064000',
                'city' => 'Metcalf',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61932',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.7978000',
                'longitude' => '-87.8064000',
                'city' => 'Hume',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62469',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3230000',
                'longitude' => '-88.4479000',
                'city' => 'Trilla',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61840',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3196000',
                'longitude' => '-88.3482000',
                'city' => 'Dewey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61825',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1181000',
                'longitude' => '-88.2488000',
                'city' => 'Champaign',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62428',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2453000',
                'longitude' => '-88.1663000',
                'city' => 'Greenup',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62078',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4821000',
                'longitude' => '-90.4750000',
                'city' => 'Patterson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61735',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1514000',
                'longitude' => '-88.9605000',
                'city' => 'Dewitt',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61750',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1514000',
                'longitude' => '-88.9605000',
                'city' => 'Lane',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62054',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.3008000',
                'longitude' => '-90.4056000',
                'city' => 'Kane',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62537',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.8526000',
                'longitude' => '-89.0851000',
                'city' => 'Harristown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62376',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.0737000',
                'longitude' => '-91.3681000',
                'city' => 'Ursa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62689',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.5009000',
                'longitude' => '-89.7744000',
                'city' => 'Thayer',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62474',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.4577000',
                'longitude' => '-87.9964000',
                'city' => 'Westfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62027',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2895000',
                'longitude' => '-90.5511000',
                'city' => 'Eldred',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62348',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1790000',
                'longitude' => '-91.3756000',
                'city' => 'Lima',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60048',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2853000',
                'longitude' => '-87.9500000',
                'city' => 'Libertyville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60133',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9940000',
                'longitude' => '-88.1922000',
                'city' => 'Hanover Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60005',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0898000',
                'longitude' => '-87.9841000',
                'city' => 'Arlington Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60045',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2485000',
                'longitude' => '-87.8433000',
                'city' => 'Lake Forest',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60062',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Northbrook',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60018',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0388000',
                'longitude' => '-87.8948000',
                'city' => 'Des Plaines',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60140',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0992000',
                'longitude' => '-88.5285000',
                'city' => 'Hampshire',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60631',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0388000',
                'longitude' => '-87.8948000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60656',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0388000',
                'longitude' => '-87.8948000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60007',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9948000',
                'longitude' => '-87.9690000',
                'city' => 'Elk Grove Village',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60020',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3982000',
                'longitude' => '-88.1846000',
                'city' => 'Fox Lake',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60077',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0262000',
                'longitude' => '-87.7573000',
                'city' => 'Skokie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60177',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0406000',
                'longitude' => '-88.2846000',
                'city' => 'South Elgin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60123',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0406000',
                'longitude' => '-88.2846000',
                'city' => 'Elgin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60026',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0725000',
                'longitude' => '-87.8081000',
                'city' => 'Glenview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60056',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0282000',
                'longitude' => '-87.9872000',
                'city' => 'Mount Prospect',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60002',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4796000',
                'longitude' => '-88.0988000',
                'city' => 'Antioch',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60073',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3554000',
                'longitude' => '-88.0751000',
                'city' => 'Round Lake',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60087',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3639000',
                'longitude' => '-87.8309000',
                'city' => 'Waukegan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60064',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3639000',
                'longitude' => '-87.8309000',
                'city' => 'North Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60047',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1968000',
                'longitude' => '-88.0967000',
                'city' => 'Lake Zurich',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60118',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1004000',
                'longitude' => '-88.2774000',
                'city' => 'Dundee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60015',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Deerfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60085',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3639000',
                'longitude' => '-87.8309000',
                'city' => 'Waukegan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60156',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1685000',
                'longitude' => '-88.2910000',
                'city' => 'Lake In The Hills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60172',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9842000',
                'longitude' => '-88.0878000',
                'city' => 'Roselle',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60523',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8500000',
                'longitude' => '-87.9461000',
                'city' => 'Oak Brook',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60013',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2133000',
                'longitude' => '-88.2455000',
                'city' => 'Cary',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60203',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0456000',
                'longitude' => '-87.6877000',
                'city' => 'Evanston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60202',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0456000',
                'longitude' => '-87.6877000',
                'city' => 'Evanston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60046',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4194000',
                'longitude' => '-88.0786000',
                'city' => 'Lake Villa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60069',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1987000',
                'longitude' => '-87.9556000',
                'city' => 'Lincolnshire',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60706',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9804000',
                'longitude' => '-87.8400000',
                'city' => 'Harwood Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60037',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1878000',
                'longitude' => '-87.7957000',
                'city' => 'Fort Sheridan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60016',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0388000',
                'longitude' => '-87.8948000',
                'city' => 'Des Plaines',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60044',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2567000',
                'longitude' => '-87.8375000',
                'city' => 'Lake Bluff',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60004',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0898000',
                'longitude' => '-87.9841000',
                'city' => 'Arlington Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60067',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1156000',
                'longitude' => '-88.0495000',
                'city' => 'Palatine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60010',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1539000',
                'longitude' => '-88.1340000',
                'city' => 'Barrington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60193',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9842000',
                'longitude' => '-88.0878000',
                'city' => 'Schaumburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60157',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9842000',
                'longitude' => '-88.0878000',
                'city' => 'Medinah',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60604',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60173',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0535000',
                'longitude' => '-88.0250000',
                'city' => 'Schaumburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60008',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0898000',
                'longitude' => '-87.9841000',
                'city' => 'Rolling Meadows',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60142',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1704000',
                'longitude' => '-88.4301000',
                'city' => 'Huntley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60074',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1156000',
                'longitude' => '-88.0495000',
                'city' => 'Palatine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60095',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1156000',
                'longitude' => '-88.0495000',
                'city' => 'Palatine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60068',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0048000',
                'longitude' => '-87.8353000',
                'city' => 'Park Ridge',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60090',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1403000',
                'longitude' => '-87.9134000',
                'city' => 'Wheeling',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60102',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1685000',
                'longitude' => '-88.2910000',
                'city' => 'Algonquin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60061',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2853000',
                'longitude' => '-87.9500000',
                'city' => 'Vernon Hills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60060',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2853000',
                'longitude' => '-87.9500000',
                'city' => 'Mundelein',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60096',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4507000',
                'longitude' => '-87.8389000',
                'city' => 'Winthrop Harbor',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60053',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0725000',
                'longitude' => '-87.8081000',
                'city' => 'Morton Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60099',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4507000',
                'longitude' => '-87.8389000',
                'city' => 'Zion',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60120',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0406000',
                'longitude' => '-88.2846000',
                'city' => 'Elgin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60124',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0300000',
                'longitude' => '-88.4309000',
                'city' => 'Elgin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60084',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2552000',
                'longitude' => '-88.1391000',
                'city' => 'Wauconda',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61603',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61606',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61554',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5628000',
                'longitude' => '-89.6447000',
                'city' => 'Pekin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61264',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Milan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61265',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Moline',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61279',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3961000',
                'longitude' => '-90.9011000',
                'city' => 'Reynolds',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61284',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3961000',
                'longitude' => '-90.9011000',
                'city' => 'Taylor Ridge',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61704',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Bloomington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61523',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Chillicothe',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61570',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9238000',
                'longitude' => '-89.2905000',
                'city' => 'Washburn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61614',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61427',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Cuba',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61531',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5604000',
                'longitude' => '-90.0305000',
                'city' => 'Farmington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61242',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6982000',
                'longitude' => '-90.3103000',
                'city' => 'Cordova',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61563',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Saint David',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61611',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'East Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61738',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'El Paso',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61530',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Eureka',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61273',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4322000',
                'longitude' => '-90.4156000',
                'city' => 'Orion',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61240',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4322000',
                'longitude' => '-90.4156000',
                'city' => 'Coal Valley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61204',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5079000',
                'longitude' => '-90.5753000',
                'city' => 'Rock Island',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61491',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0630000',
                'longitude' => '-89.7751000',
                'city' => 'Wyoming',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61525',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8642000',
                'longitude' => '-89.6743000',
                'city' => 'Dunlap',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61535',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4947000',
                'longitude' => '-89.6552000',
                'city' => 'Groveland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61534',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4947000',
                'longitude' => '-89.6552000',
                'city' => 'Green Valley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61615',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8434000',
                'longitude' => '-89.6210000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61559',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8434000',
                'longitude' => '-89.6210000',
                'city' => 'Princeville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61528',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8434000',
                'longitude' => '-89.6210000',
                'city' => 'Edwards',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61526',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8434000',
                'longitude' => '-89.6210000',
                'city' => 'Edelstein',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61517',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8434000',
                'longitude' => '-89.6210000',
                'city' => 'Brimfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61529',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6948000',
                'longitude' => '-90.0025000',
                'city' => 'Elmwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61540',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0254000',
                'longitude' => '-89.4062000',
                'city' => 'Lacon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61375',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9197000',
                'longitude' => '-89.2932000',
                'city' => 'Varna',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61760',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9197000',
                'longitude' => '-89.2932000',
                'city' => 'Minonk',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61479',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9407000',
                'longitude' => '-89.6327000',
                'city' => 'Speer',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61565',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9407000',
                'longitude' => '-89.6327000',
                'city' => 'Sparland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61571',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Washington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61411',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3260000',
                'longitude' => '-90.6105000',
                'city' => 'Adair',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61440',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3260000',
                'longitude' => '-90.6105000',
                'city' => 'Industry',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61616',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61607',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61452',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2329000',
                'longitude' => '-90.6230000',
                'city' => 'Littleton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61776',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Towanda',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61550',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6078000',
                'longitude' => '-89.4669000',
                'city' => 'Morton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61612',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61604',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61601',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61761',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Normal',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61602',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61201',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5361000',
                'longitude' => '-90.6521000',
                'city' => 'Rock Island',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61282',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5361000',
                'longitude' => '-90.6521000',
                'city' => 'Silvis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61244',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5361000',
                'longitude' => '-90.6521000',
                'city' => 'East Moline',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61605',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61443',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0936000',
                'longitude' => '-89.8707000',
                'city' => 'Kewanee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61434',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0936000',
                'longitude' => '-89.8707000',
                'city' => 'Galva',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61483',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0936000',
                'longitude' => '-89.8707000',
                'city' => 'Toulon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61722',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Arrowsmith',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61361',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3813000',
                'longitude' => '-89.8370000',
                'city' => 'Sheffield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61344',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3813000',
                'longitude' => '-89.8370000',
                'city' => 'Mineral',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61436',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9087000',
                'longitude' => '-90.2818000',
                'city' => 'Gilson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61448',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9087000',
                'longitude' => '-90.2818000',
                'city' => 'Knoxville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61430',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9087000',
                'longitude' => '-90.2818000',
                'city' => 'East Galesburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61428',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9087000',
                'longitude' => '-90.2818000',
                'city' => 'Dahinda',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61477',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6112000',
                'longitude' => '-90.2733000',
                'city' => 'Smithfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61431',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6112000',
                'longitude' => '-90.2733000',
                'city' => 'Ellisville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61256',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5572000',
                'longitude' => '-90.3892000',
                'city' => 'Hampton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61774',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4341000',
                'longitude' => '-89.3103000',
                'city' => 'Stanford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61721',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4341000',
                'longitude' => '-89.3103000',
                'city' => 'Armington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61410',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Abingdon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61462',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9106000',
                'longitude' => '-90.6458000',
                'city' => 'Monmouth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61478',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7917000',
                'longitude' => '-90.7825000',
                'city' => 'Smithshire',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61501',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2243000',
                'longitude' => '-90.3547000',
                'city' => 'Astoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62644',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2979000',
                'longitude' => '-90.0598000',
                'city' => 'Havana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62326',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4557000',
                'longitude' => '-90.6682000',
                'city' => 'Colchester',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61413',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1790000',
                'longitude' => '-90.3168000',
                'city' => 'Alpha',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61472',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1790000',
                'longitude' => '-90.3168000',
                'city' => 'Rio',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61490',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1790000',
                'longitude' => '-90.3168000',
                'city' => 'Woodhull',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61520',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5604000',
                'longitude' => '-90.0305000',
                'city' => 'Canton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61439',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8917000',
                'longitude' => '-90.3867000',
                'city' => 'Henderson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61488',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8917000',
                'longitude' => '-90.3867000',
                'city' => 'Wataga',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61564',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4968000',
                'longitude' => '-89.6471000',
                'city' => 'South Pekin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61610',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4968000',
                'longitude' => '-89.6471000',
                'city' => 'Creve Coeur',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61546',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4080000',
                'longitude' => '-89.6443000',
                'city' => 'Manito',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61755',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5332000',
                'longitude' => '-89.3542000',
                'city' => 'Mackinaw',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61537',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1162000',
                'longitude' => '-89.3596000',
                'city' => 'Henry',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61458',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7774000',
                'longitude' => '-90.0166000',
                'city' => 'Maquon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61572',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7774000',
                'longitude' => '-90.0166000',
                'city' => 'Yates City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61752',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5373000',
                'longitude' => '-89.3517000',
                'city' => 'Le Roy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61533',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6929000',
                'longitude' => '-89.8896000',
                'city' => 'Glasford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61569',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6929000',
                'longitude' => '-89.8896000',
                'city' => 'Trivoli',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61560',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1121000',
                'longitude' => '-89.3623000',
                'city' => 'Putnam',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61336',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1121000',
                'longitude' => '-89.3623000',
                'city' => 'Magnolia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61748',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6440000',
                'longitude' => '-88.7861000',
                'city' => 'Hudson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61753',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6440000',
                'longitude' => '-88.7861000',
                'city' => 'Lexington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61548',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7918000',
                'longitude' => '-89.3650000',
                'city' => 'Metamora',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61231',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3320000',
                'longitude' => '-90.6693000',
                'city' => 'Aledo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61469',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0981000',
                'longitude' => '-90.9437000',
                'city' => 'Oquawka',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61442',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0981000',
                'longitude' => '-90.9437000',
                'city' => 'Keithsburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61467',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0264000',
                'longitude' => '-90.2806000',
                'city' => 'Oneida',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61701',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5819000',
                'longitude' => '-89.1326000',
                'city' => 'Bloomington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61725',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5819000',
                'longitude' => '-89.1326000',
                'city' => 'Carlock',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61720',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6083000',
                'longitude' => '-88.4849000',
                'city' => 'Anchor',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61739',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6083000',
                'longitude' => '-88.4849000',
                'city' => 'Fairbury',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61731',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6083000',
                'longitude' => '-88.4849000',
                'city' => 'Cropsey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61736',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3965000',
                'longitude' => '-88.8710000',
                'city' => 'Downs',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61547',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5609000',
                'longitude' => '-89.8137000',
                'city' => 'Mapleton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61539',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5609000',
                'longitude' => '-89.8137000',
                'city' => 'Kingston Mines',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61759',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4300000',
                'longitude' => '-89.3129000',
                'city' => 'Minier',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61516',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8528000',
                'longitude' => '-89.1208000',
                'city' => 'Benson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61561',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8466000',
                'longitude' => '-89.1182000',
                'city' => 'Roanoke',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61541',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9815000',
                'longitude' => '-89.2386000',
                'city' => 'La Rose',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61369',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9815000',
                'longitude' => '-89.2386000',
                'city' => 'Toluca',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61417',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7327000',
                'longitude' => '-90.6656000',
                'city' => 'Berwick',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61473',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7327000',
                'longitude' => '-90.6656000',
                'city' => 'Roseville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61790',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Normal',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61733',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6281000',
                'longitude' => '-89.3300000',
                'city' => 'Deer Creek',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61254',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5001000',
                'longitude' => '-90.2216000',
                'city' => 'Geneseo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61241',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5001000',
                'longitude' => '-90.2216000',
                'city' => 'Colona',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61545',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9197000',
                'longitude' => '-89.2932000',
                'city' => 'Lowpoint',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61451',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8375000',
                'longitude' => '-89.8890000',
                'city' => 'Laura',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61771',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6154000',
                'longitude' => '-89.2048000',
                'city' => 'Secor',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61729',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6154000',
                'longitude' => '-89.2048000',
                'city' => 'Congerville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61568',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4220000',
                'longitude' => '-89.4140000',
                'city' => 'Tremont',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61747',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4220000',
                'longitude' => '-89.4140000',
                'city' => 'Hopedale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61475',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5569000',
                'longitude' => '-90.6773000',
                'city' => 'Sciota',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61438',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5569000',
                'longitude' => '-90.6773000',
                'city' => 'Good Hope',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61474',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8027000',
                'longitude' => '-90.3986000',
                'city' => 'Saint Augustine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61466',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0895000',
                'longitude' => '-90.4759000',
                'city' => 'North Henderson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61412',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0895000',
                'longitude' => '-90.4759000',
                'city' => 'Alexis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61415',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6620000',
                'longitude' => '-90.4355000',
                'city' => 'Avon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61745',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3124000',
                'longitude' => '-88.9751000',
                'city' => 'Heyworth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61770',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4268000',
                'longitude' => '-88.5260000',
                'city' => 'Saybrook',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61281',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2947000',
                'longitude' => '-90.2929000',
                'city' => 'Sherrard',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61233',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2947000',
                'longitude' => '-90.2929000',
                'city' => 'Andover',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61262',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2947000',
                'longitude' => '-90.2929000',
                'city' => 'Lynn Center',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61238',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2947000',
                'longitude' => '-90.2929000',
                'city' => 'Cambridge',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61426',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1190000',
                'longitude' => '-89.7051000',
                'city' => 'Castleton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61421',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1190000',
                'longitude' => '-89.7051000',
                'city' => 'Bradford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61435',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0622000',
                'longitude' => '-90.5538000',
                'city' => 'Gerlaw',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61414',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0783000',
                'longitude' => '-90.2257000',
                'city' => 'Altona',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61544',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7125000',
                'longitude' => '-90.2684000',
                'city' => 'London Mills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61424',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0754000',
                'longitude' => '-89.6309000',
                'city' => 'Camp Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61629',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61278',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5572000',
                'longitude' => '-90.3892000',
                'city' => 'Rapids City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61236',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5572000',
                'longitude' => '-90.3892000',
                'city' => 'Barstow',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61275',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5572000',
                'longitude' => '-90.3892000',
                'city' => 'Port Byron',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61732',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5221000',
                'longitude' => '-89.1772000',
                'city' => 'Danvers',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61274',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Osco',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61230',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7893000',
                'longitude' => '-90.2222000',
                'city' => 'Albany',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61250',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6617000',
                'longitude' => '-90.0738000',
                'city' => 'Erie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61542',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4009000',
                'longitude' => '-90.1540000',
                'city' => 'Lewistown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61744',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7427000',
                'longitude' => '-89.0113000',
                'city' => 'Gridley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61465',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1932000',
                'longitude' => '-90.3813000',
                'city' => 'New Windsor',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61468',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1932000',
                'longitude' => '-90.3813000',
                'city' => 'Ophiem',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61276',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3140000',
                'longitude' => '-90.5670000',
                'city' => 'Preemption',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61567',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3313000',
                'longitude' => '-89.9309000',
                'city' => 'Topeka',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61272',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3336000',
                'longitude' => '-90.9539000',
                'city' => 'New Boston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61237',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3336000',
                'longitude' => '-90.9539000',
                'city' => 'Buffalo Prairie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61260',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3336000',
                'longitude' => '-90.9539000',
                'city' => 'Joy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61259',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3336000',
                'longitude' => '-90.9539000',
                'city' => 'Illinois City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62617',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1555000',
                'longitude' => '-90.0113000',
                'city' => 'Bath',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62655',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.1555000',
                'longitude' => '-90.0113000',
                'city' => 'Kilbourne',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61235',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4223000',
                'longitude' => '-90.0141000',
                'city' => 'Atkinson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61702',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Bloomington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62633',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.2323000',
                'longitude' => '-89.8477000',
                'city' => 'Easton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61423',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8867000',
                'longitude' => '-90.5264000',
                'city' => 'Cameron',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61536',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6930000',
                'longitude' => '-89.7956000',
                'city' => 'Hanna City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61552',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8477000',
                'longitude' => '-89.5379000',
                'city' => 'Mossville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61453',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1015000',
                'longitude' => '-90.7998000',
                'city' => 'Little York',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61476',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1015000',
                'longitude' => '-90.7998000',
                'city' => 'Seaton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61345',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2965000',
                'longitude' => '-89.7908000',
                'city' => 'Neponset',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61314',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2965000',
                'longitude' => '-89.7908000',
                'city' => 'Buda',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61486',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2024000',
                'longitude' => '-90.5858000',
                'city' => 'Viola',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61532',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3686000',
                'longitude' => '-89.8260000',
                'city' => 'Forest City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61447',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8684000',
                'longitude' => '-90.7537000',
                'city' => 'Kirkwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61489',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9199000',
                'longitude' => '-90.0108000',
                'city' => 'Williamsfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61418',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8487000',
                'longitude' => '-90.8671000',
                'city' => 'Biggsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61437',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8487000',
                'longitude' => '-90.8671000',
                'city' => 'Gladstone',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61553',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5521000',
                'longitude' => '-90.0359000',
                'city' => 'Norris',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61482',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4177000',
                'longitude' => '-90.4984000',
                'city' => 'Table Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61484',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4177000',
                'longitude' => '-90.4984000',
                'city' => 'Vermont',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61257',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6982000',
                'longitude' => '-90.3103000',
                'city' => 'Hillsdale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61637',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61251',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6576000',
                'longitude' => '-90.0766000',
                'city' => 'Fenton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61524',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4964000',
                'longitude' => '-90.0385000',
                'city' => 'Dunfermline',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61519',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4964000',
                'longitude' => '-90.0385000',
                'city' => 'Bryant',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61543',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4964000',
                'longitude' => '-90.0385000',
                'city' => 'Liverpool',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61630',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61625',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6927000',
                'longitude' => '-89.5934000',
                'city' => 'Peoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61234',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3936000',
                'longitude' => '-89.9106000',
                'city' => 'Annawan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61239',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5152000',
                'longitude' => '-90.4439000',
                'city' => 'Carbon Cliff',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61724',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3444000',
                'longitude' => '-88.5284000',
                'city' => 'Bellflower',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61728',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5661000',
                'longitude' => '-88.6149000',
                'city' => 'Colfax',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61737',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4434000',
                'longitude' => '-88.7388000',
                'city' => 'Ellsworth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61730',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5443000',
                'longitude' => '-88.7176000',
                'city' => 'Cooksville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61758',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5645000',
                'longitude' => '-88.9012000',
                'city' => 'Merna',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61471',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6961000',
                'longitude' => '-90.8300000',
                'city' => 'Raritan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61480',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6961000',
                'longitude' => '-90.8300000',
                'city' => 'Stronghurst',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61460',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6961000',
                'longitude' => '-90.8300000',
                'city' => 'Media',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61726',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7439000',
                'longitude' => '-88.8817000',
                'city' => 'Chenoa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61441',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.3526000',
                'longitude' => '-90.3259000',
                'city' => 'Ipava',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61263',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2579000',
                'longitude' => '-90.6112000',
                'city' => 'Matherville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61709',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Bloomington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61710',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Bloomington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61416',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4937000',
                'longitude' => '-90.5636000',
                'city' => 'Bardolph',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61422',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4937000',
                'longitude' => '-90.5636000',
                'city' => 'Bushnell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61459',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4937000',
                'longitude' => '-90.5636000',
                'city' => 'Marietta',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61470',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5499000',
                'longitude' => '-90.5075000',
                'city' => 'Prairie City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61432',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6178000',
                'longitude' => '-90.1681000',
                'city' => 'Fairview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61299',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5059000',
                'longitude' => '-90.5699000',
                'city' => 'Rock Island',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61433',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5599000',
                'longitude' => '-90.1787000',
                'city' => 'Fiatt',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61232',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3974000',
                'longitude' => '-90.7627000',
                'city' => 'Andalusia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61772',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.4820000',
                'longitude' => '-88.9963000',
                'city' => 'Shirley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61425',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8161000',
                'longitude' => '-91.0290000',
                'city' => 'Carman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61485',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0352000',
                'longitude' => '-90.0991000',
                'city' => 'Victoria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61252',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7893000',
                'longitude' => '-90.2222000',
                'city' => 'Fulton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61368',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3276000',
                'longitude' => '-89.6819000',
                'city' => 'Tiskilwa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61379',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3276000',
                'longitude' => '-89.6819000',
                'city' => 'Wyanet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61449',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1808000',
                'longitude' => '-89.8406000',
                'city' => 'La Fayette',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61364',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7953000',
                'longitude' => '-89.1997000',
                'city' => 'Streator',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61419',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1981000',
                'longitude' => '-90.1197000',
                'city' => 'Bishop Hill',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61277',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4202000',
                'longitude' => '-90.0223000',
                'city' => 'Prophetstown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61742',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6338000',
                'longitude' => '-89.2803000',
                'city' => 'Goodfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60661',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60654',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60611',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60614',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60622',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60610',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60601',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60606',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8798000',
                'longitude' => '-87.6398000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60633',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1403000',
                'longitude' => '-87.9134000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60602',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60014',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Crystal Lake',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60657',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60608',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8527000',
                'longitude' => '-87.6244000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60616',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8527000',
                'longitude' => '-87.6244000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60607',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8782000',
                'longitude' => '-87.6619000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60612',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8782000',
                'longitude' => '-87.6619000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60639',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8837000',
                'longitude' => '-87.6232000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60406',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8837000',
                'longitude' => '-87.6232000',
                'city' => 'Blue Island',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60647',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60620',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8798000',
                'longitude' => '-87.6398000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60644',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60660',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60626',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60625',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60651',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60634',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8758000',
                'longitude' => '-87.6427000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60617',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60643',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7680000',
                'longitude' => '-87.6220000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60659',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60804',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8175000',
                'longitude' => '-87.7328000',
                'city' => 'Cicero',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60623',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8175000',
                'longitude' => '-87.7328000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60514',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8085000',
                'longitude' => '-87.9337000',
                'city' => 'Clarendon Hills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60558',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8085000',
                'longitude' => '-87.9337000',
                'city' => 'Western Springs',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60640',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60070',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1403000',
                'longitude' => '-87.9134000',
                'city' => 'Prospect Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60089',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1403000',
                'longitude' => '-87.9134000',
                'city' => 'Buffalo Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60522',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8085000',
                'longitude' => '-87.9337000',
                'city' => 'Hinsdale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60561',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Darien',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60544',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Plainfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60653',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60513',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Brookfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60645',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7465000',
                'longitude' => '-87.8040000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60707',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Elmwood Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60681',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60630',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60638',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60505',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Aurora',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60453',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Oak Lawn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60302',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8880000',
                'longitude' => '-87.6340000',
                'city' => 'Oak Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60148',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Lombard',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '46222',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8736000',
                'longitude' => '-87.6373000',
                'city' => 'Indianapolis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60641',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60649',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8798000',
                'longitude' => '-87.6398000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60670',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60646',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60618',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60613',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8921000',
                'longitude' => '-87.6311000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60624',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8782000',
                'longitude' => '-87.6619000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60632',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60615',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60637',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60609',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60628',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60619',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60652',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60621',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60629',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60636',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60181',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Villa Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60201',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Evanston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60025',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Glenview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60106',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Bensenville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60655',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60527',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Willowbrook',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60478',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Country Club Hills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60134',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8903000',
                'longitude' => '-88.3134000',
                'city' => 'Geneva',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62901',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7300000',
                'longitude' => '-89.2209000',
                'city' => 'Carbondale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62872',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3132000',
                'longitude' => '-88.9061000',
                'city' => 'Opdyke',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62816',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3132000',
                'longitude' => '-88.9061000',
                'city' => 'Bonnie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62234',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6724000',
                'longitude' => '-89.9935000',
                'city' => 'Collinsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62221',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5154000',
                'longitude' => '-89.9747000',
                'city' => 'Belleville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62220',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5154000',
                'longitude' => '-89.9747000',
                'city' => 'Belleville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62095',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8908000',
                'longitude' => '-90.1837000',
                'city' => 'Wood River',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62035',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8908000',
                'longitude' => '-90.1837000',
                'city' => 'Godfrey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62062',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6787000',
                'longitude' => '-89.9831000',
                'city' => 'Maryville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62232',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6787000',
                'longitude' => '-89.9831000',
                'city' => 'Caseyville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62864',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3173000',
                'longitude' => '-88.9035000',
                'city' => 'Mount Vernon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62812',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0054000',
                'longitude' => '-88.9149000',
                'city' => 'Benton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62208',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5154000',
                'longitude' => '-89.9878000',
                'city' => 'Fairview Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62285',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5154000',
                'longitude' => '-89.9878000',
                'city' => 'Smithton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62226',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5154000',
                'longitude' => '-89.9878000',
                'city' => 'Belleville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62223',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5154000',
                'longitude' => '-89.9878000',
                'city' => 'Belleville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62293',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6027000',
                'longitude' => '-89.6840000',
                'city' => 'Trenton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62060',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7028000',
                'longitude' => '-90.1512000',
                'city' => 'Madison',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62090',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7028000',
                'longitude' => '-90.1512000',
                'city' => 'Venice',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62040',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7028000',
                'longitude' => '-90.1512000',
                'city' => 'Granite City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62882',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6101000',
                'longitude' => '-89.1936000',
                'city' => 'Sandoval',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62231',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6101000',
                'longitude' => '-89.1936000',
                'city' => 'Carlyle',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62801',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6101000',
                'longitude' => '-89.1936000',
                'city' => 'Centralia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62219',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6025000',
                'longitude' => '-89.4349000',
                'city' => 'Beckemeyer',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62230',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6089000',
                'longitude' => '-89.6079000',
                'city' => 'Breese',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62245',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6089000',
                'longitude' => '-89.6079000',
                'city' => 'Germantown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62216',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6089000',
                'longitude' => '-89.6079000',
                'city' => 'Aviston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62240',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'East Carondelet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62206',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'East Saint Louis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62070',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2282000',
                'longitude' => '-90.7145000',
                'city' => 'Mozier',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62053',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2282000',
                'longitude' => '-90.7145000',
                'city' => 'Kampsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62045',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2282000',
                'longitude' => '-90.7145000',
                'city' => 'Hamburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62052',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2282000',
                'longitude' => '-90.7145000',
                'city' => 'Jerseyville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62814',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5334000',
                'longitude' => '-89.1314000',
                'city' => 'Bluford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62263',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5334000',
                'longitude' => '-89.1314000',
                'city' => 'Nashville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62426',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9229000',
                'longitude' => '-88.6669000',
                'city' => 'Edgewood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62838',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9229000',
                'longitude' => '-88.6669000',
                'city' => 'Farina',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62863',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4139000',
                'longitude' => '-87.7673000',
                'city' => 'Mount Carmel',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62271',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4374000',
                'longitude' => '-89.5534000',
                'city' => 'Okawville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62214',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4374000',
                'longitude' => '-89.5534000',
                'city' => 'Addieville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62854',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8329000',
                'longitude' => '-88.7788000',
                'city' => 'Kinmundy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62849',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8329000',
                'longitude' => '-88.7788000',
                'city' => 'Iuka',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62215',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5221000',
                'longitude' => '-89.6108000',
                'city' => 'Albers',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62265',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5221000',
                'longitude' => '-89.6108000',
                'city' => 'New Baden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62848',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4385000',
                'longitude' => '-89.1662000',
                'city' => 'Irvington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62898',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4385000',
                'longitude' => '-89.1662000',
                'city' => 'Woodlawn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62893',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4385000',
                'longitude' => '-89.1662000',
                'city' => 'Walnut Hill',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62877',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4385000',
                'longitude' => '-89.1662000',
                'city' => 'Richview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62024',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8560000',
                'longitude' => '-90.0941000',
                'city' => 'East Alton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62087',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8560000',
                'longitude' => '-90.0941000',
                'city' => 'South Roxana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62084',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8560000',
                'longitude' => '-90.0941000',
                'city' => 'Roxana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62048',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8560000',
                'longitude' => '-90.0941000',
                'city' => 'Hartford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62917',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7381000',
                'longitude' => '-88.5396000',
                'city' => 'Carrier Mills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62002',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8560000',
                'longitude' => '-90.0941000',
                'city' => 'Alton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62225',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5154000',
                'longitude' => '-89.9878000',
                'city' => 'Scott Air Force Base',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62010',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8871000',
                'longitude' => '-90.0810000',
                'city' => 'Bethalto',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62018',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8871000',
                'longitude' => '-90.0810000',
                'city' => 'Cottage Hills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62935',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8268000',
                'longitude' => '-88.5277000',
                'city' => 'Galatia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62930',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8268000',
                'longitude' => '-88.5277000',
                'city' => 'Eldorado',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62201',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6222000',
                'longitude' => '-90.1560000',
                'city' => 'East Saint Louis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62205',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6222000',
                'longitude' => '-90.1560000',
                'city' => 'East Saint Louis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62204',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6222000',
                'longitude' => '-90.1560000',
                'city' => 'East Saint Louis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62207',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6222000',
                'longitude' => '-90.1560000',
                'city' => 'East Saint Louis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62938',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.5654000',
                'longitude' => '-88.4104000',
                'city' => 'Golconda',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62947',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.5654000',
                'longitude' => '-88.4104000',
                'city' => 'Herod',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62867',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9282000',
                'longitude' => '-88.1676000',
                'city' => 'New Haven',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62821',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9282000',
                'longitude' => '-88.1676000',
                'city' => 'Carmi',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62869',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9282000',
                'longitude' => '-88.1676000',
                'city' => 'Norris City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62871',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9282000',
                'longitude' => '-88.1676000',
                'city' => 'Omaha',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62835',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9282000',
                'longitude' => '-88.1676000',
                'city' => 'Enfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62830',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4909000',
                'longitude' => '-88.9093000',
                'city' => 'Dix',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62889',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4909000',
                'longitude' => '-88.9093000',
                'city' => 'Texico',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62977',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8269000',
                'longitude' => '-88.5407000',
                'city' => 'Raleigh',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62890',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8269000',
                'longitude' => '-88.5407000',
                'city' => 'Thompsonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62984',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7137000',
                'longitude' => '-88.1903000',
                'city' => 'Shawneetown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62954',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7137000',
                'longitude' => '-88.1903000',
                'city' => 'Junction',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62979',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7992000',
                'longitude' => '-88.2585000',
                'city' => 'Ridgway',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62934',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.6428000',
                'longitude' => '-88.3082000',
                'city' => 'Equality',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62931',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.6428000',
                'longitude' => '-88.3082000',
                'city' => 'Elizabethtown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62685',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0465000',
                'longitude' => '-90.0131000',
                'city' => 'Shipman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62014',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0465000',
                'longitude' => '-90.0131000',
                'city' => 'Bunker Hill',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62021',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0465000',
                'longitude' => '-90.0131000',
                'city' => 'Dorsey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62012',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0465000',
                'longitude' => '-90.0131000',
                'city' => 'Brighton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62883',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2128000',
                'longitude' => '-89.0429000',
                'city' => 'Scheller',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62866',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2128000',
                'longitude' => '-89.0429000',
                'city' => 'Nason',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62894',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2128000',
                'longitude' => '-89.0429000',
                'city' => 'Waltonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62236',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4442000',
                'longitude' => '-90.2021000',
                'city' => 'Columbia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62277',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2136000',
                'longitude' => '-89.9946000',
                'city' => 'Prairie Du Rocher',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62278',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2136000',
                'longitude' => '-89.9946000',
                'city' => 'Red Bud',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62242',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2136000',
                'longitude' => '-89.9946000',
                'city' => 'Evansville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62471',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9609000',
                'longitude' => '-89.0985000',
                'city' => 'Vandalia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62261',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0768000',
                'longitude' => '-90.0930000',
                'city' => 'Modoc',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62982',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.4305000',
                'longitude' => '-88.3483000',
                'city' => 'Rosiclare',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62239',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5206000',
                'longitude' => '-90.2130000',
                'city' => 'Dupo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62034',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7490000',
                'longitude' => '-89.9780000',
                'city' => 'Glen Carbon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62919',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.4924000',
                'longitude' => '-88.1716000',
                'city' => 'Cave In Rock',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62203',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5895000',
                'longitude' => '-90.0588000',
                'city' => 'East Saint Louis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62257',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2472000',
                'longitude' => '-89.7522000',
                'city' => 'Marissa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62255',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2472000',
                'longitude' => '-89.7522000',
                'city' => 'Lenzburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62025',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8089000',
                'longitude' => '-89.9598000',
                'city' => 'Edwardsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62811',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3782000',
                'longitude' => '-87.8572000',
                'city' => 'Bellmont',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62852',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3782000',
                'longitude' => '-87.8572000',
                'city' => 'Keensburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62818',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3782000',
                'longitude' => '-87.8572000',
                'city' => 'Browns',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62855',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5307000',
                'longitude' => '-87.7091000',
                'city' => 'Lancaster',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62410',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5307000',
                'longitude' => '-87.7091000',
                'city' => 'Allendale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62476',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5307000',
                'longitude' => '-87.7091000',
                'city' => 'West Salem',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62806',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3770000',
                'longitude' => '-88.0559000',
                'city' => 'Albion',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62902',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7300000',
                'longitude' => '-89.2209000',
                'city' => 'Carbondale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62903',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7300000',
                'longitude' => '-89.2209000',
                'city' => 'Carbondale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62914',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.0128000',
                'longitude' => '-89.1764000',
                'city' => 'Cairo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62828',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0955000',
                'longitude' => '-88.5363000',
                'city' => 'Dahlgren',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62817',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0955000',
                'longitude' => '-88.5363000',
                'city' => 'Broughton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62960',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1571000',
                'longitude' => '-88.7309000',
                'city' => 'Metropolis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62286',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.1253000',
                'longitude' => '-89.7053000',
                'city' => 'Sparta',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62274',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0796000',
                'longitude' => '-89.3825000',
                'city' => 'Pinckneyville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62881',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6202000',
                'longitude' => '-88.7923000',
                'city' => 'Salem',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62284',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9265000',
                'longitude' => '-89.2726000',
                'city' => 'Smithboro',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62262',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9265000',
                'longitude' => '-89.2726000',
                'city' => 'Mulberry Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62022',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0141000',
                'longitude' => '-90.3162000',
                'city' => 'Dow',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62268',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2596000',
                'longitude' => '-89.5095000',
                'city' => 'Oakdale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62237',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2596000',
                'longitude' => '-89.5095000',
                'city' => 'Coulterville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62996',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1596000',
                'longitude' => '-89.1935000',
                'city' => 'Villa Ridge',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62918',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8036000',
                'longitude' => '-89.0312000',
                'city' => 'Carterville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62933',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8036000',
                'longitude' => '-89.0312000',
                'city' => 'Energy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62952',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5334000',
                'longitude' => '-89.1314000',
                'city' => 'Jonesboro',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62888',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.1995000',
                'longitude' => '-89.3846000',
                'city' => 'Tamaroa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62269',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6787000',
                'longitude' => '-89.9831000',
                'city' => 'O Fallon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62964',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1596000',
                'longitude' => '-89.1935000',
                'city' => 'Mounds',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62970',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1596000',
                'longitude' => '-89.1935000',
                'city' => 'Olmsted',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62976',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1596000',
                'longitude' => '-89.1935000',
                'city' => 'Pulaski',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62418',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0756000',
                'longitude' => '-88.9575000',
                'city' => 'Brownstown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62458',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0756000',
                'longitude' => '-88.9575000',
                'city' => 'Saint Elmo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62857',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8686000',
                'longitude' => '-88.8546000',
                'city' => 'Loogootee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62885',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8686000',
                'longitude' => '-88.8546000',
                'city' => 'Shobonier',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62880',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8686000',
                'longitude' => '-88.8546000',
                'city' => 'Saint Peter',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62958',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7238000',
                'longitude' => '-89.2184000',
                'city' => 'Makanda',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62421',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7367000',
                'longitude' => '-88.0814000',
                'city' => 'Claremont',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62425',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7367000',
                'longitude' => '-88.0814000',
                'city' => 'Dundas',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62832',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0796000',
                'longitude' => '-89.3825000',
                'city' => 'Du Quoin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62959',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7369000',
                'longitude' => '-88.9307000',
                'city' => 'Marion',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62297',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8747000',
                'longitude' => '-89.9467000',
                'city' => 'Walsh',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62241',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8747000',
                'longitude' => '-89.9467000',
                'city' => 'Ellis Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62047',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1545000',
                'longitude' => '-90.6290000',
                'city' => 'Hardin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62063',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1741000',
                'longitude' => '-90.1429000',
                'city' => 'Medora',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62028',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9561000',
                'longitude' => '-90.3395000',
                'city' => 'Elsah',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62844',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2584000',
                'longitude' => '-87.9961000',
                'city' => 'Grayville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62827',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2584000',
                'longitude' => '-87.9961000',
                'city' => 'Crossville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62037',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1101000',
                'longitude' => '-90.4991000',
                'city' => 'Grafton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62031',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1101000',
                'longitude' => '-90.4991000',
                'city' => 'Fieldon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62067',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9058000',
                'longitude' => '-90.0363000',
                'city' => 'Moro',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62983',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8351000',
                'longitude' => '-89.1476000',
                'city' => 'Royalton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62450',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7367000',
                'longitude' => '-88.0814000',
                'city' => 'Olney',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62808',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3250000',
                'longitude' => '-89.1933000',
                'city' => 'Ashley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62013',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0323000',
                'longitude' => '-90.6592000',
                'city' => 'Brussels',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62006',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0323000',
                'longitude' => '-90.6592000',
                'city' => 'Batchtown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62906',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Anna',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62281',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6787000',
                'longitude' => '-89.9831000',
                'city' => 'Saint Jacob',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62907',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8918000',
                'longitude' => '-89.4950000',
                'city' => 'Ava',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62253',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8726000',
                'longitude' => '-89.2283000',
                'city' => 'Keyesport',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62916',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8876000',
                'longitude' => '-89.4976000',
                'city' => 'Campbell Hill',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62994',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8876000',
                'longitude' => '-89.4976000',
                'city' => 'Vergennes',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62807',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7522000',
                'longitude' => '-89.0953000',
                'city' => 'Alma',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62875',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7522000',
                'longitude' => '-89.0953000',
                'city' => 'Patoka',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62892',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7522000',
                'longitude' => '-89.0953000',
                'city' => 'Vernon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62966',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7300000',
                'longitude' => '-89.2209000',
                'city' => 'Murphysboro',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62856',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9972000',
                'longitude' => '-88.9202000',
                'city' => 'Logan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62846',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.1521000',
                'longitude' => '-88.9054000',
                'city' => 'Ina',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62836',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.1521000',
                'longitude' => '-88.9054000',
                'city' => 'Ewing',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62951',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Johnston City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62452',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5918000',
                'longitude' => '-88.0586000',
                'city' => 'Parkersburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62288',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.1253000',
                'longitude' => '-89.7053000',
                'city' => 'Steeleville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62833',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3791000',
                'longitude' => '-88.0611000',
                'city' => 'Ellery',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62815',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3739000',
                'longitude' => '-87.9854000',
                'city' => 'Bone Gap',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62258',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4910000',
                'longitude' => '-89.7940000',
                'city' => 'Mascoutah',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62449',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0042000',
                'longitude' => '-87.9086000',
                'city' => 'Oblong',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62459',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9956000',
                'longitude' => '-88.0275000',
                'city' => 'Sainte Marie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62480',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9956000',
                'longitude' => '-88.0275000',
                'city' => 'Willow Hill',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62475',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9956000',
                'longitude' => '-88.0275000',
                'city' => 'West Liberty',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62419',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5188000',
                'longitude' => '-88.0080000',
                'city' => 'Calhoun',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62244',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2315000',
                'longitude' => '-90.1590000',
                'city' => 'Fults',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62298',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2315000',
                'longitude' => '-90.1590000',
                'city' => 'Waterloo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62256',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2315000',
                'longitude' => '-90.1590000',
                'city' => 'Maeystown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62097',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9332000',
                'longitude' => '-89.8415000',
                'city' => 'Worden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62264',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3066000',
                'longitude' => '-89.9950000',
                'city' => 'New Athens',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62248',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3066000',
                'longitude' => '-89.9950000',
                'city' => 'Hecker',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62243',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3066000',
                'longitude' => '-89.9950000',
                'city' => 'Freeburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62260',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3066000',
                'longitude' => '-89.9950000',
                'city' => 'Millstadt',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62803',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4371000',
                'longitude' => '-89.3703000',
                'city' => 'Hoyleton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62876',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3291000',
                'longitude' => '-89.1907000',
                'city' => 'Radom',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62831',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3291000',
                'longitude' => '-89.1907000',
                'city' => 'Du Bois',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62275',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8899000',
                'longitude' => '-89.7309000',
                'city' => 'Pocahontas',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62001',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8899000',
                'longitude' => '-89.7309000',
                'city' => 'Alhambra',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62250',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5401000',
                'longitude' => '-89.2649000',
                'city' => 'Hoffman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62997',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0179000',
                'longitude' => '-89.6169000',
                'city' => 'Willisville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62238',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0179000',
                'longitude' => '-89.6169000',
                'city' => 'Cutler',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62272',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0179000',
                'longitude' => '-89.6169000',
                'city' => 'Percy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62294',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7327000',
                'longitude' => '-89.8834000',
                'city' => 'Troy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62839',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6671000',
                'longitude' => '-88.4846000',
                'city' => 'Flora',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62897',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0054000',
                'longitude' => '-88.9149000',
                'city' => 'Whittington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62819',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0054000',
                'longitude' => '-88.9149000',
                'city' => 'Buckner',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62837',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3787000',
                'longitude' => '-88.3643000',
                'city' => 'Fairfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62908',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1530000',
                'longitude' => '-88.7335000',
                'city' => 'Belknap',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62254',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6026000',
                'longitude' => '-89.8151000',
                'city' => 'Lebanon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62953',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.2075000',
                'longitude' => '-88.8409000',
                'city' => 'Joppa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62941',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.2075000',
                'longitude' => '-88.8409000',
                'city' => 'Grand Chain',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62956',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.2075000',
                'longitude' => '-88.8409000',
                'city' => 'Karnak',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62454',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0077000',
                'longitude' => '-87.7396000',
                'city' => 'Robinson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62910',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1274000',
                'longitude' => '-88.6336000',
                'city' => 'Brookport',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62427',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9164000',
                'longitude' => '-87.8346000',
                'city' => 'Flat Rock',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62413',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1472000',
                'longitude' => '-87.8120000',
                'city' => 'Annapolis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62433',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1095000',
                'longitude' => '-87.6572000',
                'city' => 'Hutsonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62451',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1095000',
                'longitude' => '-87.6572000',
                'city' => 'Palestine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62942',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7634000',
                'longitude' => '-89.3425000',
                'city' => 'Grand Tower',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62940',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7634000',
                'longitude' => '-89.3425000',
                'city' => 'Gorham',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62927',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9119000',
                'longitude' => '-89.2353000',
                'city' => 'Dowell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62932',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9119000',
                'longitude' => '-89.2353000',
                'city' => 'Elkville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62065',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1567000',
                'longitude' => '-90.6211000',
                'city' => 'Michael',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62292',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2101000',
                'longitude' => '-89.6844000',
                'city' => 'Tilden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62266',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5345000',
                'longitude' => '-89.6945000',
                'city' => 'New Memphis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62464',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.0351000',
                'longitude' => '-87.9077000',
                'city' => 'Stoy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62252',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6127000',
                'longitude' => '-89.3693000',
                'city' => 'Huey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62999',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9049000',
                'longitude' => '-89.0510000',
                'city' => 'Zeigler',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62865',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9008000',
                'longitude' => '-89.0536000',
                'city' => 'Mulkeytown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62233',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9164000',
                'longitude' => '-89.8299000',
                'city' => 'Chester',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62884',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0909000',
                'longitude' => '-89.0493000',
                'city' => 'Sesser',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62860',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9176000',
                'longitude' => '-88.7626000',
                'city' => 'Macedonia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62805',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9176000',
                'longitude' => '-88.7626000',
                'city' => 'Akin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62896',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9176000',
                'longitude' => '-88.7626000',
                'city' => 'West Frankfort',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62810',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0879000',
                'longitude' => '-88.8879000',
                'city' => 'Belle Rive',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62046',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8877000',
                'longitude' => '-89.8441000',
                'city' => 'Hamel',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62992',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.2929000',
                'longitude' => '-88.9738000',
                'city' => 'Ullin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62058',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9664000',
                'longitude' => '-89.7678000',
                'city' => 'Livingston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62859',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0955000',
                'longitude' => '-88.5363000',
                'city' => 'Mc Leansboro',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62061',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7184000',
                'longitude' => '-89.7679000',
                'city' => 'Marine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62249',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7184000',
                'longitude' => '-89.7679000',
                'city' => 'Highland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62895',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2215000',
                'longitude' => '-88.5395000',
                'city' => 'Wayne City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62026',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8089000',
                'longitude' => '-89.9598000',
                'city' => 'Edwardsville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62273',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7391000',
                'longitude' => '-89.6759000',
                'city' => 'Pierron',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62995',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.4186000',
                'longitude' => '-88.9005000',
                'city' => 'Vienna',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62923',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.3634000',
                'longitude' => '-89.0196000',
                'city' => 'Cypress',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62912',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.3634000',
                'longitude' => '-89.0196000',
                'city' => 'Buncombe',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62943',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.4165000',
                'longitude' => '-88.8953000',
                'city' => 'Grantsburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62957',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.3048000',
                'longitude' => '-89.5274000',
                'city' => 'Mc Clure',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62858',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7747000',
                'longitude' => '-88.5063000',
                'city' => 'Louisville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62899',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7747000',
                'longitude' => '-88.5063000',
                'city' => 'Xenia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62928',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.4968000',
                'longitude' => '-88.5846000',
                'city' => 'Eddyville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62823',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5179000',
                'longitude' => '-88.4375000',
                'city' => 'Cisne',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62878',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5179000',
                'longitude' => '-88.4375000',
                'city' => 'Rinard',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62842',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5179000',
                'longitude' => '-88.4375000',
                'city' => 'Geff',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62850',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5179000',
                'longitude' => '-88.4375000',
                'city' => 'Johnsonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62824',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6760000',
                'longitude' => '-88.3532000',
                'city' => 'Clay City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62990',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.3172000',
                'longitude' => '-89.4295000',
                'city' => 'Thebes',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62434',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8753000',
                'longitude' => '-88.4466000',
                'city' => 'Ingraham',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62879',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7588000',
                'longitude' => '-88.3647000',
                'city' => 'Sailor Springs',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62985',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.4651000',
                'longitude' => '-88.7477000',
                'city' => 'Simpson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62439',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7284000',
                'longitude' => '-87.6823000',
                'city' => 'Lawrenceville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62924',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8168000',
                'longitude' => '-89.2307000',
                'city' => 'De Soto',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62868',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6932000',
                'longitude' => '-88.2295000',
                'city' => 'Noble',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62891',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9731000',
                'longitude' => '-89.0530000',
                'city' => 'Valier',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62825',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9731000',
                'longitude' => '-89.0530000',
                'city' => 'Coello',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62822',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9731000',
                'longitude' => '-89.0530000',
                'city' => 'Christopher',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62079',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1700000',
                'longitude' => '-90.1456000',
                'city' => 'Piasa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62030',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1700000',
                'longitude' => '-90.1456000',
                'city' => 'Fidelity',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62961',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.2363000',
                'longitude' => '-89.2677000',
                'city' => 'Millcreek',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62926',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.2363000',
                'longitude' => '-89.2677000',
                'city' => 'Dongola',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62988',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.2363000',
                'longitude' => '-89.2677000',
                'city' => 'Tamms',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62963',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.0809000',
                'longitude' => '-89.1657000',
                'city' => 'Mound City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62081',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2570000',
                'longitude' => '-90.0639000',
                'city' => 'Rockbridge',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62630',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.2570000',
                'longitude' => '-90.0639000',
                'city' => 'Chesterfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62851',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4075000',
                'longitude' => '-88.7926000',
                'city' => 'Keenes',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62887',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.1670000',
                'longitude' => '-88.4570000',
                'city' => 'Springerton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62950',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8029000',
                'longitude' => '-89.5834000',
                'city' => 'Jacob',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62280',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8029000',
                'longitude' => '-89.5834000',
                'city' => 'Rockwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62218',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5385000',
                'longitude' => '-89.4693000',
                'city' => 'Bartelso',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '63102',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5154000',
                'longitude' => '-89.9747000',
                'city' => 'Saint Louis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62282',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3609000',
                'longitude' => '-89.7130000',
                'city' => 'Saint Libory',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62829',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.9959000',
                'longitude' => '-88.4964000',
                'city' => 'Dale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62870',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.6178000',
                'longitude' => '-89.0572000',
                'city' => 'Odin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62962',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1724000',
                'longitude' => '-89.3528000',
                'city' => 'Miller City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62993',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1724000',
                'longitude' => '-89.3528000',
                'city' => 'Unity',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62969',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.1724000',
                'longitude' => '-89.3528000',
                'city' => 'Olive Branch',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62972',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.6156000',
                'longitude' => '-88.7096000',
                'city' => 'Ozark',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62987',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.6156000',
                'longitude' => '-88.7096000',
                'city' => 'Stonefort',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62967',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.6156000',
                'longitude' => '-88.7096000',
                'city' => 'New Burnside',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62922',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.6156000',
                'longitude' => '-88.7096000',
                'city' => 'Creal Springs',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62217',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.1850000',
                'longitude' => '-89.8434000',
                'city' => 'Baldwin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62481',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1026000',
                'longitude' => '-88.1488000',
                'city' => 'Yale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62432',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '39.1026000',
                'longitude' => '-88.1488000',
                'city' => 'Hidalgo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62853',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.4909000',
                'longitude' => '-88.9093000',
                'city' => 'Kell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62998',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.4614000',
                'longitude' => '-89.2484000',
                'city' => 'Wolf Lake',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62920',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.4614000',
                'longitude' => '-89.2484000',
                'city' => 'Cobden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62973',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.2753000',
                'longitude' => '-89.1851000',
                'city' => 'Perks',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62446',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5177000',
                'longitude' => '-88.2333000',
                'city' => 'Mount Erie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62974',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7693000',
                'longitude' => '-88.8190000',
                'city' => 'Pittsburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62036',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.9481000',
                'longitude' => '-90.5871000',
                'city' => 'Golden Eagle',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62905',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.5338000',
                'longitude' => '-89.2609000',
                'city' => 'Alto Pass',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62975',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.5338000',
                'longitude' => '-89.2609000',
                'city' => 'Pomona',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62886',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3459000',
                'longitude' => '-88.5896000',
                'city' => 'Sims',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62862',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2500000',
                'longitude' => '-88.3042000',
                'city' => 'Mill Shoals',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62820',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.2500000',
                'longitude' => '-88.3042000',
                'city' => 'Burnt Prairie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62417',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7132000',
                'longitude' => '-87.7589000',
                'city' => 'Bridgeport',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62466',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.8361000',
                'longitude' => '-87.6690000',
                'city' => 'Sumner',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62874',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8960000',
                'longitude' => '-88.9265000',
                'city' => 'Orient',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62289',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.5985000',
                'longitude' => '-89.7521000',
                'city' => 'Summerfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62295',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.3094000',
                'longitude' => '-90.2796000',
                'city' => 'Valmeyer',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62948',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8036000',
                'longitude' => '-89.0312000',
                'city' => 'Herrin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62460',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.7265000',
                'longitude' => '-87.6902000',
                'city' => 'Saint Francisville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62939',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.5553000',
                'longitude' => '-88.9688000',
                'city' => 'Goreville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62861',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '38.0340000',
                'longitude' => '-88.0457000',
                'city' => 'Maunie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62915',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7604000',
                'longitude' => '-89.0782000',
                'city' => 'Cambria',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62921',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.7604000',
                'longitude' => '-89.0782000',
                'city' => 'Colp',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '62949',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '37.8289000',
                'longitude' => '-89.1451000',
                'city' => 'Hurst',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60540',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7746000',
                'longitude' => '-88.1517000',
                'city' => 'Naperville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60565',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7746000',
                'longitude' => '-88.1517000',
                'city' => 'Naperville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60563',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7746000',
                'longitude' => '-88.1517000',
                'city' => 'Naperville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60139',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Glendale Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60185',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'West Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60188',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Carol Stream',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60490',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Bolingbrook',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60187',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Wheaton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60559',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Westmont',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60190',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Winfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60504',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Aurora',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60516',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Downers Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60532',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Lisle',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60564',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Naperville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60119',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8881000',
                'longitude' => '-88.3080000',
                'city' => 'Elburn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60103',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9940000',
                'longitude' => '-88.1922000',
                'city' => 'Bartlett',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60107',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9940000',
                'longitude' => '-88.1922000',
                'city' => 'Streamwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60440',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Bolingbrook',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60511',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7670000',
                'longitude' => '-88.5446000',
                'city' => 'Big Rock',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60126',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9842000',
                'longitude' => '-88.0878000',
                'city' => 'Elmhurst',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60137',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8668000',
                'longitude' => '-88.1078000',
                'city' => 'Glen Ellyn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60555',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8203000',
                'longitude' => '-88.1751000',
                'city' => 'Warrenville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60446',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6914000',
                'longitude' => '-88.1130000',
                'city' => 'Romeoville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60191',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9572000',
                'longitude' => '-87.9399000',
                'city' => 'Wood Dale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60143',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9572000',
                'longitude' => '-87.9399000',
                'city' => 'Itasca',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60101',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9572000',
                'longitude' => '-87.9399000',
                'city' => 'Addison',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60538',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7561000',
                'longitude' => '-88.3170000',
                'city' => 'Montgomery',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60506',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7561000',
                'longitude' => '-88.3170000',
                'city' => 'Aurora',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60521',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8022000',
                'longitude' => '-87.9312000',
                'city' => 'Hinsdale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60517',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8785000',
                'longitude' => '-88.2037000',
                'city' => 'Woodridge',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60539',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8572000',
                'longitude' => '-88.3088000',
                'city' => 'Mooseheart',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60554',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Sugar Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60108',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Bloomingdale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60515',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7973000',
                'longitude' => '-88.0110000',
                'city' => 'Downers Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60439',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6733000',
                'longitude' => '-88.0011000',
                'city' => 'Lemont',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60441',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6733000',
                'longitude' => '-88.0011000',
                'city' => 'Lockport',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60175',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1403000',
                'longitude' => '-87.9134000',
                'city' => 'Saint Charles',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60174',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1403000',
                'longitude' => '-87.9134000',
                'city' => 'Saint Charles',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60305',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8854000',
                'longitude' => '-87.8377000',
                'city' => 'River Forest',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60160',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8854000',
                'longitude' => '-87.8377000',
                'city' => 'Melrose Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60189',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Wheaton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60548',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Sandwich',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60542',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7561000',
                'longitude' => '-88.3170000',
                'city' => 'North Aurora',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60566',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9842000',
                'longitude' => '-88.0878000',
                'city' => 'Naperville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60567',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8085000',
                'longitude' => '-87.9337000',
                'city' => 'Naperville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60545',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6657000',
                'longitude' => '-88.5387000',
                'city' => 'Plano',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60035',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Highland Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60510',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8572000',
                'longitude' => '-88.3088000',
                'city' => 'Batavia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60525',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9842000',
                'longitude' => '-88.0878000',
                'city' => 'La Grange',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60151',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8942000',
                'longitude' => '-88.4701000',
                'city' => 'Maple Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60154',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9783000',
                'longitude' => '-87.9668000',
                'city' => 'Westchester',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60184',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8881000',
                'longitude' => '-88.3080000',
                'city' => 'Wayne',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60543',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6822000',
                'longitude' => '-88.3546000',
                'city' => 'Oswego',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60560',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6421000',
                'longitude' => '-88.4515000',
                'city' => 'Yorkville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60546',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8953000',
                'longitude' => '-87.9419000',
                'city' => 'Riverside',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60138',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8953000',
                'longitude' => '-87.9419000',
                'city' => 'Glen Ellyn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60304',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8953000',
                'longitude' => '-87.9419000',
                'city' => 'Oak Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60130',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Forest Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60186',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8085000',
                'longitude' => '-87.9337000',
                'city' => 'West Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60164',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Melrose Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60065',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Northbrook',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60512',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6421000',
                'longitude' => '-88.4515000',
                'city' => 'Bristol',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60541',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6421000',
                'longitude' => '-88.4515000',
                'city' => 'Newark',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60144',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8370000',
                'longitude' => '-88.5237000',
                'city' => 'Kaneville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60171',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'River Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60551',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Sheridan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60402',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Berwyn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60420',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7670000',
                'longitude' => '-88.5446000',
                'city' => 'Dwight',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60455',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7755000',
                'longitude' => '-87.8112000',
                'city' => 'Bridgeview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60419',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Dolton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60827',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6462000',
                'longitude' => '-87.6183000',
                'city' => 'Riverdale',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60409',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6462000',
                'longitude' => '-87.6183000',
                'city' => 'Calumet City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60141',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8721000',
                'longitude' => '-87.9097000',
                'city' => 'Hines',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60163',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8721000',
                'longitude' => '-87.9097000',
                'city' => 'Berkeley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60162',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8721000',
                'longitude' => '-87.9097000',
                'city' => 'Hillside',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60526',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'La Grange Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60423',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Frankfort',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60438',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Lansing',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60422',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5603000',
                'longitude' => '-87.6652000',
                'city' => 'Flossmoor',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60429',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5603000',
                'longitude' => '-87.6652000',
                'city' => 'Hazel Crest',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60425',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5603000',
                'longitude' => '-87.6652000',
                'city' => 'Glenwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60430',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5603000',
                'longitude' => '-87.6652000',
                'city' => 'Homewood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60473',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6095000',
                'longitude' => '-87.6443000',
                'city' => 'South Holland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60426',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6095000',
                'longitude' => '-87.6443000',
                'city' => 'Harvey',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60155',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8899000',
                'longitude' => '-87.8623000',
                'city' => 'Broadview',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60153',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8899000',
                'longitude' => '-87.8623000',
                'city' => 'Maywood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60194',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0582000',
                'longitude' => '-88.0635000',
                'city' => 'Schaumburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60195',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0582000',
                'longitude' => '-88.0635000',
                'city' => 'Schaumburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60462',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6152000',
                'longitude' => '-87.8550000',
                'city' => 'Orland Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60477',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6152000',
                'longitude' => '-87.8550000',
                'city' => 'Tinley Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60467',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6152000',
                'longitude' => '-87.8550000',
                'city' => 'Orland Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60448',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Mokena',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60471',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5061000',
                'longitude' => '-87.6344000',
                'city' => 'Richton Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60805',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7187000',
                'longitude' => '-87.7473000',
                'city' => 'Evergreen Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60415',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7187000',
                'longitude' => '-87.7473000',
                'city' => 'Chicago Ridge',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60459',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7187000',
                'longitude' => '-87.7473000',
                'city' => 'Burbank',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60456',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7187000',
                'longitude' => '-87.7473000',
                'city' => 'Hometown',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60465',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7199000',
                'longitude' => '-87.8159000',
                'city' => 'Palos Hills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60458',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7199000',
                'longitude' => '-87.8159000',
                'city' => 'Justice',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60457',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7199000',
                'longitude' => '-87.8159000',
                'city' => 'Hickory Hills',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60466',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4193000',
                'longitude' => '-87.7440000',
                'city' => 'Park Forest',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60449',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4193000',
                'longitude' => '-87.7440000',
                'city' => 'Monee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60463',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6618000',
                'longitude' => '-87.6835000',
                'city' => 'Palos Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60803',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6618000',
                'longitude' => '-87.6835000',
                'city' => 'Alsip',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60472',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6618000',
                'longitude' => '-87.6835000',
                'city' => 'Robbins',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60445',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6618000',
                'longitude' => '-87.6835000',
                'city' => 'Midlothian',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60469',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6618000',
                'longitude' => '-87.6835000',
                'city' => 'Posen',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60411',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5061000',
                'longitude' => '-87.6344000',
                'city' => 'Chicago Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60476',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5665000',
                'longitude' => '-87.5500000',
                'city' => 'Thornton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60468',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3334000',
                'longitude' => '-87.7906000',
                'city' => 'Peotone',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60443',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Matteson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60501',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7755000',
                'longitude' => '-87.8112000',
                'city' => 'Summit Argo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60417',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7465000',
                'longitude' => '-87.8040000',
                'city' => 'Crete',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60461',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4843000',
                'longitude' => '-87.6844000',
                'city' => 'Olympia Fields',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60131',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9800000',
                'longitude' => '-87.9447000',
                'city' => 'Franklin Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60464',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6318000',
                'longitude' => '-87.8572000',
                'city' => 'Palos Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60452',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5769000',
                'longitude' => '-87.7851000',
                'city' => 'Oak Forest',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60480',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7332000',
                'longitude' => '-87.8758000',
                'city' => 'Willow Springs',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60165',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8899000',
                'longitude' => '-87.8623000',
                'city' => 'Stone Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60475',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5061000',
                'longitude' => '-87.6344000',
                'city' => 'Steger',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60301',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8888000',
                'longitude' => '-87.7936000',
                'city' => 'Oak Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60482',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6685000',
                'longitude' => '-87.8313000',
                'city' => 'Worth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60534',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7755000',
                'longitude' => '-87.8112000',
                'city' => 'Lyons',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60412',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8175000',
                'longitude' => '-87.7328000',
                'city' => 'Chicago Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60454',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Oak Lawn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60303',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Oak Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60104',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Bellwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60401',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3389000',
                'longitude' => '-87.6349000',
                'city' => 'Beecher',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60081',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8880000',
                'longitude' => '-87.6340000',
                'city' => 'Spring Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60428',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5769000',
                'longitude' => '-87.7851000',
                'city' => 'Markham',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60176',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9800000',
                'longitude' => '-87.9447000',
                'city' => 'Schiller Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60178',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8755000',
                'longitude' => '-87.6290000',
                'city' => 'Sycamore',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60432',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Joliet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60901',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Kankakee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60712',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9749000',
                'longitude' => '-87.7730000',
                'city' => 'Lincolnwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60664',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9749000',
                'longitude' => '-87.7730000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60680',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6961000',
                'longitude' => '-87.6384000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60666',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9772000',
                'longitude' => '-87.8979000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61048',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Lena',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60076',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Skokie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60699',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8736000',
                'longitude' => '-87.6373000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60688',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9772000',
                'longitude' => '-87.8979000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60701',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9772000',
                'longitude' => '-87.8979000',
                'city' => 'Chicago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60714',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8839000',
                'longitude' => '-87.6369000',
                'city' => 'Niles',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60481',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3079000',
                'longitude' => '-88.1460000',
                'city' => 'Wilmington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61104',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2672000',
                'longitude' => '-89.0999000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60135',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1009000',
                'longitude' => '-88.6941000',
                'city' => 'Genoa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61080',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.5041000',
                'longitude' => '-89.0396000',
                'city' => 'South Beloit',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61008',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2571000',
                'longitude' => '-88.8428000',
                'city' => 'Belvidere',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61301',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3318000',
                'longitude' => '-89.0978000',
                'city' => 'La Salle',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61101',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2672000',
                'longitude' => '-89.0999000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61102',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2672000',
                'longitude' => '-89.0999000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60435',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5279000',
                'longitude' => '-88.0822000',
                'city' => 'Joliet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60433',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5279000',
                'longitude' => '-88.0822000',
                'city' => 'Joliet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60012',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2432000',
                'longitude' => '-88.3221000',
                'city' => 'Crystal Lake',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60098',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3150000',
                'longitude' => '-88.4530000',
                'city' => 'Woodstock',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61081',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7943000',
                'longitude' => '-89.6981000',
                'city' => 'Sterling',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60451',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5179000',
                'longitude' => '-87.9649000',
                'city' => 'New Lenox',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60914',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1219000',
                'longitude' => '-87.8630000',
                'city' => 'Bourbonnais',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60915',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1219000',
                'longitude' => '-87.8630000',
                'city' => 'Bradley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60115',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9300000',
                'longitude' => '-88.7499000',
                'city' => 'Dekalb',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61354',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3318000',
                'longitude' => '-89.0978000',
                'city' => 'Peru',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61111',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2672000',
                'longitude' => '-89.0999000',
                'city' => 'Loves Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61348',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3318000',
                'longitude' => '-89.0978000',
                'city' => 'Oglesby',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61051',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9638000',
                'longitude' => '-89.7772000',
                'city' => 'Milledgeville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61014',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9638000',
                'longitude' => '-89.7772000',
                'city' => 'Chadwick',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61064',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9638000',
                'longitude' => '-89.7772000',
                'city' => 'Polo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61108',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2566000',
                'longitude' => '-89.0585000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61107',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2566000',
                'longitude' => '-89.0585000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61109',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2566000',
                'longitude' => '-89.0585000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61350',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2986000',
                'longitude' => '-89.0656000',
                'city' => 'Ottawa',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61105',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2566000',
                'longitude' => '-89.0585000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61067',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2960000',
                'longitude' => '-89.6279000',
                'city' => 'Ridott',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61032',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2960000',
                'longitude' => '-89.6279000',
                'city' => 'Freeport',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61084',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1255000',
                'longitude' => '-89.2593000',
                'city' => 'Stillman Valley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61061',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1255000',
                'longitude' => '-89.2593000',
                'city' => 'Oregon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61047',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1255000',
                'longitude' => '-89.2593000',
                'city' => 'Leaf River',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61010',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1255000',
                'longitude' => '-89.2593000',
                'city' => 'Byron',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60050',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3190000',
                'longitude' => '-88.4501000',
                'city' => 'Mchenry',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60424',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1905000',
                'longitude' => '-88.3109000',
                'city' => 'Gardner',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60474',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1905000',
                'longitude' => '-88.3109000',
                'city' => 'South Wilmington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60407',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1905000',
                'longitude' => '-88.3109000',
                'city' => 'Braceville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61019',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2939000',
                'longitude' => '-89.6224000',
                'city' => 'Davis',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61063',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3098000',
                'longitude' => '-89.3621000',
                'city' => 'Pecatonica',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61074',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0998000',
                'longitude' => '-89.9741000',
                'city' => 'Savanna',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61053',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0998000',
                'longitude' => '-89.9741000',
                'city' => 'Mount Carroll',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60097',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3190000',
                'longitude' => '-88.4501000',
                'city' => 'Wonder Lake',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60041',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3190000',
                'longitude' => '-88.4501000',
                'city' => 'Ingleside',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60518',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5907000',
                'longitude' => '-88.9209000',
                'city' => 'Earlville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61088',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2375000',
                'longitude' => '-89.3629000',
                'city' => 'Winnebago',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61077',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2375000',
                'longitude' => '-89.3629000',
                'city' => 'Seward',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61039',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2375000',
                'longitude' => '-89.3629000',
                'city' => 'German Valley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61024',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4336000',
                'longitude' => '-89.3330000',
                'city' => 'Durand',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61325',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2350000',
                'longitude' => '-88.8351000',
                'city' => 'Grand Ridge',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61341',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2350000',
                'longitude' => '-88.8351000',
                'city' => 'Marseilles',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60470',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2350000',
                'longitude' => '-88.8351000',
                'city' => 'Ransom',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61021',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7942000',
                'longitude' => '-89.6021000',
                'city' => 'Dixon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60927',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9377000',
                'longitude' => '-88.2385000',
                'city' => 'Clifton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60934',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9377000',
                'longitude' => '-88.2385000',
                'city' => 'Emington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60946',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9377000',
                'longitude' => '-88.2385000',
                'city' => 'Kempton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60431',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6081000',
                'longitude' => '-88.2058000',
                'city' => 'Joliet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60919',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9510000',
                'longitude' => '-88.1541000',
                'city' => 'Cabery',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60950',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5279000',
                'longitude' => '-88.0822000',
                'city' => 'Manteno',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61285',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9612000',
                'longitude' => '-90.1017000',
                'city' => 'Thomson',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61115',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2672000',
                'longitude' => '-89.0999000',
                'city' => 'Machesney Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60556',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7692000',
                'longitude' => '-88.7779000',
                'city' => 'Waterman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60938',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7670000',
                'longitude' => '-87.9940000',
                'city' => 'Gilman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60930',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8246000',
                'longitude' => '-87.9816000',
                'city' => 'Danforth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61046',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1040000',
                'longitude' => '-89.8334000',
                'city' => 'Lanark',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61036',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4184000',
                'longitude' => '-90.4309000',
                'city' => 'Galena',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61114',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3412000',
                'longitude' => '-89.0489000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61103',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3412000',
                'longitude' => '-89.0489000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61073',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3412000',
                'longitude' => '-89.0489000',
                'city' => 'Roscoe',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61031',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8434000',
                'longitude' => '-89.4854000',
                'city' => 'Franklin Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60520',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7721000',
                'longitude' => '-88.6378000',
                'city' => 'Hinckley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60437',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2155000',
                'longitude' => '-88.5062000',
                'city' => 'Kinsman',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60479',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2155000',
                'longitude' => '-88.5062000',
                'city' => 'Verona',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60444',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2155000',
                'longitude' => '-88.5062000',
                'city' => 'Mazon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61310',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8434000',
                'longitude' => '-89.4854000',
                'city' => 'Amboy',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60447',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4581000',
                'longitude' => '-88.2619000',
                'city' => 'Minooka',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61011',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.5007000',
                'longitude' => '-88.8675000',
                'city' => 'Caledonia',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61065',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.5007000',
                'longitude' => '-88.8675000',
                'city' => 'Poplar Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61356',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3705000',
                'longitude' => '-89.4681000',
                'city' => 'Princeton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61078',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1577000',
                'longitude' => '-89.7421000',
                'city' => 'Shannon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61373',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3437000',
                'longitude' => '-89.0077000',
                'city' => 'Utica',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60442',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4211000',
                'longitude' => '-87.9843000',
                'city' => 'Manhattan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60928',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7712000',
                'longitude' => '-87.8614000',
                'city' => 'Crescent City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60450',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3631000',
                'longitude' => '-88.4309000',
                'city' => 'Morris',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61741',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5279000',
                'longitude' => '-88.0822000',
                'city' => 'Forrest',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61016',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2517000',
                'longitude' => '-88.9508000',
                'city' => 'Cherry Valley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61112',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2517000',
                'longitude' => '-88.9508000',
                'city' => 'Rockford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61270',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9059000',
                'longitude' => '-89.8021000',
                'city' => 'Morrison',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61340',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2622000',
                'longitude' => '-89.2267000',
                'city' => 'Mark',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61363',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2622000',
                'longitude' => '-89.2267000',
                'city' => 'Standard',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61327',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2622000',
                'longitude' => '-89.2267000',
                'city' => 'Hennepin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61326',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2622000',
                'longitude' => '-89.2267000',
                'city' => 'Granville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61330',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5331000',
                'longitude' => '-89.2838000',
                'city' => 'La Moille',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61006',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8448000',
                'longitude' => '-89.2985000',
                'city' => 'Ashton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60180',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3190000',
                'longitude' => '-88.4501000',
                'city' => 'Union',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61360',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3198000',
                'longitude' => '-88.6130000',
                'city' => 'Seneca',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61764',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9904000',
                'longitude' => '-88.7280000',
                'city' => 'Pontiac',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61319',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9904000',
                'longitude' => '-88.7280000',
                'city' => 'Cornell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61313',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9904000',
                'longitude' => '-88.7280000',
                'city' => 'Blackstone',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60460',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9904000',
                'longitude' => '-88.7280000',
                'city' => 'Odell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61042',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7198000',
                'longitude' => '-89.5559000',
                'city' => 'Harmon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61367',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6465000',
                'longitude' => '-89.2279000',
                'city' => 'Sublette',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61007',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2131000',
                'longitude' => '-89.4765000',
                'city' => 'Baileyville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60961',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3631000',
                'longitude' => '-88.4309000',
                'city' => 'Reddick',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60935',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1132000',
                'longitude' => '-88.2340000',
                'city' => 'Essex',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60917',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1132000',
                'longitude' => '-88.2340000',
                'city' => 'Buckingham',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61089',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4924000',
                'longitude' => '-89.7930000',
                'city' => 'Winslow',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61334',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1416000',
                'longitude' => '-89.0622000',
                'city' => 'Lostant',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61370',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1416000',
                'longitude' => '-89.0622000',
                'city' => 'Tonica',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61349',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5605000',
                'longitude' => '-89.4640000',
                'city' => 'Ohio',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60970',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7712000',
                'longitude' => '-87.8614000',
                'city' => 'Watseka',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61376',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5566000',
                'longitude' => '-89.5898000',
                'city' => 'Walnut',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60150',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9297000',
                'longitude' => '-88.9646000',
                'city' => 'Malta',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60553',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9297000',
                'longitude' => '-88.9646000',
                'city' => 'Steward',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60113',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9297000',
                'longitude' => '-88.9646000',
                'city' => 'Creston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60129',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9297000',
                'longitude' => '-88.9646000',
                'city' => 'Esmond',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61068',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9297000',
                'longitude' => '-88.9646000',
                'city' => 'Rochelle',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60408',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2634000',
                'longitude' => '-88.2181000',
                'city' => 'Braidwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61020',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0724000',
                'longitude' => '-88.9980000',
                'city' => 'Davis Junction',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61052',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0724000',
                'longitude' => '-88.9980000',
                'city' => 'Monroe Center',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60146',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0724000',
                'longitude' => '-88.9980000',
                'city' => 'Kirkland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61049',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0724000',
                'longitude' => '-88.9980000',
                'city' => 'Lindenwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61043',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0724000',
                'longitude' => '-88.9980000',
                'city' => 'Holcomb',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60436',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5279000',
                'longitude' => '-88.0822000',
                'city' => 'Joliet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60941',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0494000',
                'longitude' => '-88.0999000',
                'city' => 'Herscher',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60913',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0494000',
                'longitude' => '-88.0999000',
                'city' => 'Bonfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60964',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0266000',
                'longitude' => '-87.7167000',
                'city' => 'Saint Anne',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60421',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4045000',
                'longitude' => '-88.1132000',
                'city' => 'Elwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60969',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0494000',
                'longitude' => '-88.0999000',
                'city' => 'Union Hill',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60956',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9177000',
                'longitude' => '-87.7323000',
                'city' => 'Papineau',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60951',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9177000',
                'longitude' => '-87.7323000',
                'city' => 'Martinton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60931',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7722000',
                'longitude' => '-87.5667000',
                'city' => 'Donovan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60945',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7722000',
                'longitude' => '-87.5667000',
                'city' => 'Iroquois',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60966',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7722000',
                'longitude' => '-87.5667000',
                'city' => 'Sheldon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60912',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9553000',
                'longitude' => '-87.6567000',
                'city' => 'Beaverville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61071',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6311000',
                'longitude' => '-89.7864000',
                'city' => 'Rock Falls',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61243',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6311000',
                'longitude' => '-89.7864000',
                'city' => 'Deer Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61283',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6311000',
                'longitude' => '-89.7864000',
                'city' => 'Tampico',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61044',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2672000',
                'longitude' => '-89.8272000',
                'city' => 'Kent',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61062',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2672000',
                'longitude' => '-89.8272000',
                'city' => 'Pearl City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61338',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4575000',
                'longitude' => '-89.6695000',
                'city' => 'Manlius',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61346',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4575000',
                'longitude' => '-89.6695000',
                'city' => 'New Bedford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61316',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2638000',
                'longitude' => '-89.1232000',
                'city' => 'Cedar Point',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61362',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3286000',
                'longitude' => '-89.3050000',
                'city' => 'Spring Valley',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61322',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3286000',
                'longitude' => '-89.3050000',
                'city' => 'Depue',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61070',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3888000',
                'longitude' => '-89.5303000',
                'city' => 'Rock City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61018',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3888000',
                'longitude' => '-89.5303000',
                'city' => 'Dakota',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60954',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1722000',
                'longitude' => '-87.6627000',
                'city' => 'Momence',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61015',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8672000',
                'longitude' => '-89.2213000',
                'city' => 'Chana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60926',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5652000',
                'longitude' => '-87.8946000',
                'city' => 'Claytonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60953',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.5652000',
                'longitude' => '-87.8946000',
                'city' => 'Milford',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60940',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2401000',
                'longitude' => '-87.6494000',
                'city' => 'Grant Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60410',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4581000',
                'longitude' => '-88.2619000',
                'city' => 'Channahon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60974',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7132000',
                'longitude' => '-87.7308000',
                'city' => 'Woodland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60434',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5279000',
                'longitude' => '-88.0822000',
                'city' => 'Joliet',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60051',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5279000',
                'longitude' => '-88.0822000',
                'city' => 'Mchenry',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61075',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4464000',
                'longitude' => '-90.1565000',
                'city' => 'Scales Mound',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61001',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4464000',
                'longitude' => '-90.1565000',
                'city' => 'Apple River',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60531',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6166000',
                'longitude' => '-88.8000000',
                'city' => 'Leland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60549',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5288000',
                'longitude' => '-88.6813000',
                'city' => 'Serena',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61378',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6950000',
                'longitude' => '-89.0836000',
                'city' => 'West Brooklyn',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61318',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6950000',
                'longitude' => '-89.0836000',
                'city' => 'Compton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60552',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6342000',
                'longitude' => '-88.6846000',
                'city' => 'Somonauk',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61342',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5488000',
                'longitude' => '-89.1223000',
                'city' => 'Mendota',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60416',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.2850000',
                'longitude' => '-88.2856000',
                'city' => 'Coal City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60145',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0940000',
                'longitude' => '-88.8514000',
                'city' => 'Kingston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61372',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5488000',
                'longitude' => '-89.1223000',
                'city' => 'Troy Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61371',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5488000',
                'longitude' => '-89.1223000',
                'city' => 'Triumph',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61038',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2571000',
                'longitude' => '-88.8428000',
                'city' => 'Garden Prairie',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60033',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4219000',
                'longitude' => '-88.6083000',
                'city' => 'Harvard',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61013',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3766000',
                'longitude' => '-89.6357000',
                'city' => 'Cedarville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60920',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0232000',
                'longitude' => '-88.3096000',
                'city' => 'Campus',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60152',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2508000',
                'longitude' => '-88.6106000',
                'city' => 'Marengo',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61012',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4005000',
                'longitude' => '-88.7419000',
                'city' => 'Capron',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61041',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2561000',
                'longitude' => '-90.2845000',
                'city' => 'Hanover',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61085',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2461000',
                'longitude' => '-90.1176000',
                'city' => 'Stockton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61028',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2461000',
                'longitude' => '-90.1176000',
                'city' => 'Elizabeth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61740',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8739000',
                'longitude' => '-88.8557000',
                'city' => 'Flanagan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61743',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8752000',
                'longitude' => '-88.7788000',
                'city' => 'Graymont',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61072',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4549000',
                'longitude' => '-89.0748000',
                'city' => 'Rockton',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61353',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6882000',
                'longitude' => '-88.9850000',
                'city' => 'Paw Paw',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60550',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6882000',
                'longitude' => '-88.9850000',
                'city' => 'Shabbona',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61079',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4453000',
                'longitude' => '-89.1997000',
                'city' => 'Shirland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61312',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5269000',
                'longitude' => '-89.2811000',
                'city' => 'Arlington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61374',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5269000',
                'longitude' => '-89.2811000',
                'city' => 'Van Orin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61323',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4343000',
                'longitude' => '-89.3913000',
                'city' => 'Dover',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61337',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.4343000',
                'longitude' => '-89.3913000',
                'city' => 'Malden',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60929',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8782000',
                'longitude' => '-88.2724000',
                'city' => 'Cullom',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60071',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4696000',
                'longitude' => '-88.4351000',
                'city' => 'Richmond',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60034',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4696000',
                'longitude' => '-88.4351000',
                'city' => 'Hebron',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60072',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3818000',
                'longitude' => '-88.3431000',
                'city' => 'Ringwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61315',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3041000',
                'longitude' => '-89.3624000',
                'city' => 'Bureau',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61320',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3261000',
                'longitude' => '-89.2042000',
                'city' => 'Dalzell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60967',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6158000',
                'longitude' => '-87.5937000',
                'city' => 'Stockland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60973',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.6158000',
                'longitude' => '-87.5937000',
                'city' => 'Wellington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60959',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.7574000',
                'longitude' => '-88.1916000',
                'city' => 'Piper City',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60911',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8782000',
                'longitude' => '-88.2724000',
                'city' => 'Ashkum',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61769',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.8782000',
                'longitude' => '-88.2724000',
                'city' => 'Saunemin',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60537',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5382000',
                'longitude' => '-88.5853000',
                'city' => 'Millington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60922',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0012000',
                'longitude' => '-87.9141000',
                'city' => 'Chebanse',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61261',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7157000',
                'longitude' => '-89.9287000',
                'city' => 'Lyndon',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60586',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.6122000',
                'longitude' => '-88.2030000',
                'city' => 'Plainfield',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61054',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0456000',
                'longitude' => '-89.4312000',
                'city' => 'Mount Morris',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61059',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4943000',
                'longitude' => '-89.9928000',
                'city' => 'Nora',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61087',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4943000',
                'longitude' => '-89.9928000',
                'city' => 'Warren',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61025',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4898000',
                'longitude' => '-90.6127000',
                'city' => 'East Dubuque',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60112',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9322000',
                'longitude' => '-88.7554000',
                'city' => 'Cortland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61060',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.4695000',
                'longitude' => '-89.6489000',
                'city' => 'Orangeville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60944',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7943000',
                'longitude' => '-89.6981000',
                'city' => 'Hopkins Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61050',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3745000',
                'longitude' => '-89.6301000',
                'city' => 'Mc Connell',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61311',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1234000',
                'longitude' => '-88.8288000',
                'city' => 'Ancona',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60530',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7908000',
                'longitude' => '-88.8873000',
                'city' => 'Lee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60111',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9290000',
                'longitude' => '-88.8683000',
                'city' => 'Clare',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61030',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1265000',
                'longitude' => '-89.5767000',
                'city' => 'Forreston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61377',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0547000',
                'longitude' => '-89.0525000',
                'city' => 'Wenona',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61333',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0041000',
                'longitude' => '-88.8959000',
                'city' => 'Long Point',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61321',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.0041000',
                'longitude' => '-88.8959000',
                'city' => 'Dana',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61332',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1886000',
                'longitude' => '-88.9827000',
                'city' => 'Leonore',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61331',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.7171000',
                'longitude' => '-89.3312000',
                'city' => 'Lee Center',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61358',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '40.9847000',
                'longitude' => '-89.0464000',
                'city' => 'Rutland',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61335',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1774000',
                'longitude' => '-89.2086000',
                'city' => 'Mc Nabb',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61359',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3841000',
                'longitude' => '-89.2199000',
                'city' => 'Seatonville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61329',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3841000',
                'longitude' => '-89.2199000',
                'city' => 'Ladd',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61317',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.3841000',
                'longitude' => '-89.2199000',
                'city' => 'Cherry',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60910',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.1219000',
                'longitude' => '-87.8630000',
                'city' => 'Aroma Park',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '61258',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.5238000',
                'longitude' => '-89.9135000',
                'city' => 'Hooppole',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60192',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0385000',
                'longitude' => '-88.2791000',
                'city' => 'Hoffman Estates',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60030',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2567000',
                'longitude' => '-87.8375000',
                'city' => 'Grayslake',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60031',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3425000',
                'longitude' => '-88.0422000',
                'city' => 'Gurnee',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60022',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1063000',
                'longitude' => '-87.7351000',
                'city' => 'Glencoe',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60083',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.3598000',
                'longitude' => '-87.8338000',
                'city' => 'Wadsworth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60196',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0674000',
                'longitude' => '-88.1266000',
                'city' => 'Schaumburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60043',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0789000',
                'longitude' => '-87.7058000',
                'city' => 'Kenilworth',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60091',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0789000',
                'longitude' => '-87.7058000',
                'city' => 'Wilmette',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60040',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1859000',
                'longitude' => '-87.8040000',
                'city' => 'Highwood',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60093',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9948000',
                'longitude' => '-87.9690000',
                'city' => 'Winnetka',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60078',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2572000',
                'longitude' => '-87.9980000',
                'city' => 'Palatine',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60179',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0748000',
                'longitude' => '-88.2119000',
                'city' => 'Hoffman Estates',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60006',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9842000',
                'longitude' => '-88.0878000',
                'city' => 'Arlington Heights',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60079',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Waukegan',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60017',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.8158000',
                'longitude' => '-87.8730000',
                'city' => 'Des Plaines',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60204',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0475000',
                'longitude' => '-87.6793000',
                'city' => 'Evanston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60049',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1946000',
                'longitude' => '-88.0912000',
                'city' => 'Lake Zurich',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60110',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Carpentersville',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60136',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Gilberts',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60088',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1437000',
                'longitude' => '-88.0017000',
                'city' => 'Great Lakes',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60009',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '41.9800000',
                'longitude' => '-87.9447000',
                'city' => 'Elk Grove Village',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60021',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2090000',
                'longitude' => '-88.2346000',
                'city' => 'Fox River Grove',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60042',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.2090000',
                'longitude' => '-88.2346000',
                'city' => 'Island Lake',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60170',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0300000',
                'longitude' => '-88.4309000',
                'city' => 'Plato Center',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60208',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0475000',
                'longitude' => '-87.6793000',
                'city' => 'Evanston',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60159',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0748000',
                'longitude' => '-88.2119000',
                'city' => 'Schaumburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60109',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0992000',
                'longitude' => '-88.5285000',
                'city' => 'Burlington',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60168',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.1286000',
                'longitude' => '-87.8310000',
                'city' => 'Schaumburg',
                'full_state' => 'Illinois',
            ],
            [
                'zip' => '60011',
                'country_code' => 'US',
                'state' => 'IL',
                'latitude' => '42.0674000',
                'longitude' => '-88.1266000',
                'city' => 'Barrington',
                'full_state' => 'Illinois',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
