<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GuamSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '96919',
                'country_code' => 'US',
                'state' => 'GU',
                'latitude' => '13.4630000',
                'longitude' => '-144.7435000',
                'city' => 'Agana Heights',
                'full_state' => 'Guam',
            ],
            [
                'zip' => '96932',
                'country_code' => 'US',
                'state' => 'GU',
                'latitude' => '13.4742000',
                'longitude' => '-144.7478000',
                'city' => 'Hagatna',
                'full_state' => 'Guam',
            ],
            [
                'zip' => '96915',
                'country_code' => 'US',
                'state' => 'GU',
                'latitude' => '13.3963000',
                'longitude' => '-144.1050000',
                'city' => 'Santa Rita',
                'full_state' => 'Guam',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
