<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FloridaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '34112',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1428000',
                'longitude' => '-81.7991000',
                'city' => 'Naples',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34103',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1428000',
                'longitude' => '-81.7991000',
                'city' => 'Naples',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33909',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6349000',
                'longitude' => '-81.9443000',
                'city' => 'Cape Coral',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33904',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6349000',
                'longitude' => '-81.9443000',
                'city' => 'Cape Coral',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34102',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1428000',
                'longitude' => '-81.7991000',
                'city' => 'Naples',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33903',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6416000',
                'longitude' => '-81.8572000',
                'city' => 'North Fort Myers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33901',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6416000',
                'longitude' => '-81.8572000',
                'city' => 'Fort Myers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33990',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.5560000',
                'longitude' => '-81.9358000',
                'city' => 'Cape Coral',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33914',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.5560000',
                'longitude' => '-81.9358000',
                'city' => 'Cape Coral',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34109',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.2651000',
                'longitude' => '-81.8092000',
                'city' => 'Naples',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34110',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.2651000',
                'longitude' => '-81.8092000',
                'city' => 'Naples',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33917',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6660000',
                'longitude' => '-81.8830000',
                'city' => 'North Fort Myers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33916',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6416000',
                'longitude' => '-81.8572000',
                'city' => 'Fort Myers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34134',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3315000',
                'longitude' => '-81.7844000',
                'city' => 'Bonita Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34114',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8609000',
                'longitude' => '-81.3850000',
                'city' => 'Naples',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33957',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4477000',
                'longitude' => '-81.9520000',
                'city' => 'Sanibel',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33908',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4477000',
                'longitude' => '-81.9520000',
                'city' => 'Fort Myers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34113',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9480000',
                'longitude' => '-81.7234000',
                'city' => 'Naples',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33991',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6170000',
                'longitude' => '-82.1084000',
                'city' => 'Cape Coral',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33956',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6170000',
                'longitude' => '-82.1084000',
                'city' => 'Saint James City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34141',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8609000',
                'longitude' => '-81.3850000',
                'city' => 'Ochopee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33971',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6066000',
                'longitude' => '-81.6429000',
                'city' => 'Lehigh Acres',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33972',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6066000',
                'longitude' => '-81.6429000',
                'city' => 'Lehigh Acres',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33931',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4508000',
                'longitude' => '-82.0256000',
                'city' => 'Fort Myers Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34142',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4158000',
                'longitude' => '-81.4169000',
                'city' => 'Immokalee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33907',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.5787000',
                'longitude' => '-81.9685000',
                'city' => 'Fort Myers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34108',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.2502000',
                'longitude' => '-81.8011000',
                'city' => 'Naples',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33905',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6449000',
                'longitude' => '-81.8136000',
                'city' => 'Fort Myers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33919',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.5206000',
                'longitude' => '-81.8994000',
                'city' => 'Fort Myers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33122',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8078000',
                'longitude' => '-80.3460000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33172',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8078000',
                'longitude' => '-80.3460000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33128',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33132',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33131',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33180',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33126',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33167',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33157',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33156',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33134',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33129',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33127',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33155',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33179',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33142',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33055',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Opa Locka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33176',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33166',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33175',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7435000',
                'longitude' => '-80.3581000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33174',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7435000',
                'longitude' => '-80.3581000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33184',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7435000',
                'longitude' => '-80.3581000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33182',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7435000',
                'longitude' => '-80.3581000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33185',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7435000',
                'longitude' => '-80.3581000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33165',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7435000',
                'longitude' => '-80.3581000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33135',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7545000',
                'longitude' => '-80.2213000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33161',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9459000',
                'longitude' => '-80.1898000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33169',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9459000',
                'longitude' => '-80.1898000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33016',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8831000',
                'longitude' => '-80.3084000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33012',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8831000',
                'longitude' => '-80.3084000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33054',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Opa Locka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33193',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33162',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33173',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33090',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33033',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33150',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33027',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33170',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33140',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33125',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33032',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33196',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9459000',
                'longitude' => '-80.1898000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33056',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9459000',
                'longitude' => '-80.1898000',
                'city' => 'Opa Locka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33189',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9459000',
                'longitude' => '-80.1898000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33602',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9459000',
                'longitude' => '-80.1898000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33178',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7770000',
                'longitude' => '-80.1946000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33015',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7770000',
                'longitude' => '-80.1946000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33146',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7770000',
                'longitude' => '-80.1946000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33035',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7770000',
                'longitude' => '-80.1946000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33039',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.5209000',
                'longitude' => '-80.4278000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33137',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.5209000',
                'longitude' => '-80.4278000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33013',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8831000',
                'longitude' => '-80.3084000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33018',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8831000',
                'longitude' => '-80.3084000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33014',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8831000',
                'longitude' => '-80.3084000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33177',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6151000',
                'longitude' => '-80.3479000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33190',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6151000',
                'longitude' => '-80.3479000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33158',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6151000',
                'longitude' => '-80.3479000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33187',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6151000',
                'longitude' => '-80.3479000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33186',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6151000',
                'longitude' => '-80.3479000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33037',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.1671000',
                'longitude' => '-80.3749000',
                'city' => 'Key Largo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33030',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7770000',
                'longitude' => '-80.1946000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33070',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.9143000',
                'longitude' => '-80.6498000',
                'city' => 'Tavernier',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33034',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.4699000',
                'longitude' => '-80.4780000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33031',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.4699000',
                'longitude' => '-80.4780000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33136',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7770000',
                'longitude' => '-80.1946000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33145',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7695000',
                'longitude' => '-80.2291000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33130',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7545000',
                'longitude' => '-80.2213000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33133',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7545000',
                'longitude' => '-80.2213000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33144',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7593000',
                'longitude' => '-80.3068000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33143',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8078000',
                'longitude' => '-80.3460000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33183',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6846000',
                'longitude' => '-80.3673000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33139',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8087000',
                'longitude' => '-80.2803000',
                'city' => 'Miami Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33040',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.5590000',
                'longitude' => '-81.7927000',
                'city' => 'Key West',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33141',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6010000',
                'longitude' => '-80.3513000',
                'city' => 'Miami Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33234',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6010000',
                'longitude' => '-80.3513000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33147',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6010000',
                'longitude' => '-80.3513000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33101',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8928000',
                'longitude' => '-80.1714000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33051',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.7336000',
                'longitude' => '-81.0165000',
                'city' => 'Key Colony Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33042',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.7336000',
                'longitude' => '-81.0165000',
                'city' => 'Summerland Key',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33050',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.7336000',
                'longitude' => '-81.0165000',
                'city' => 'Marathon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33138',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33283',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33154',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33160',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7695000',
                'longitude' => '-80.2291000',
                'city' => 'North Miami Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33024',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33181',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33023',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33168',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33010',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33060',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33242',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6010000',
                'longitude' => '-80.3513000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33199',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7435000',
                'longitude' => '-80.3581000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33326',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7770000',
                'longitude' => '-80.1946000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33311',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7770000',
                'longitude' => '-80.1946000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33149',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.6860000',
                'longitude' => '-80.1657000',
                'city' => 'Key Biscayne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33328',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9729000',
                'longitude' => '-80.1423000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33280',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33036',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.9143000',
                'longitude' => '-80.6498000',
                'city' => 'Islamorada',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33092',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.1671000',
                'longitude' => '-80.3749000',
                'city' => 'Homestead',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33043',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.6732000',
                'longitude' => '-81.3503000',
                'city' => 'Big Pine Key',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33431',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.6732000',
                'longitude' => '-81.3503000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33239',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Miami Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33025',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9402000',
                'longitude' => '-80.2468000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33028',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34232',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33001',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.9268000',
                'longitude' => '-80.6242000',
                'city' => 'Long Key',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33109',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7892000',
                'longitude' => '-80.1390000',
                'city' => 'Miami Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33064',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33017',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33256',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33116',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33238',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32905',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9226000',
                'longitude' => '-80.1577000',
                'city' => 'Palm Bay',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33052',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '24.7076000',
                'longitude' => '-81.0854000',
                'city' => 'Marathon Shores',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33243',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33458',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Jupiter',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33011',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Hialeah',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33269',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33261',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33194',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33020',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.9729000',
                'longitude' => '-80.1423000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33119',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33021',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33009',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Hallandale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33114',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.7746000',
                'longitude' => '-80.1903000',
                'city' => 'Miami',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33487',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '25.8087000',
                'longitude' => '-80.2803000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32805',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32803',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32814',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32927',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Cocoa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32926',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Cocoa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32751',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6682000',
                'longitude' => '-81.3607000',
                'city' => 'Maitland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32790',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6682000',
                'longitude' => '-81.3607000',
                'city' => 'Winter Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32730',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6682000',
                'longitude' => '-81.3607000',
                'city' => 'Casselberry',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32707',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6682000',
                'longitude' => '-81.3607000',
                'city' => 'Casselberry',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32750',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6682000',
                'longitude' => '-81.3607000',
                'city' => 'Longwood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32701',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6682000',
                'longitude' => '-81.3607000',
                'city' => 'Altamonte Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32922',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Cocoa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32789',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Winter Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32715',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Altamonte Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32792',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5436000',
                'longitude' => '-81.3773000',
                'city' => 'Winter Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32903',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0820000',
                'longitude' => '-80.6098000',
                'city' => 'Indialantic',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32804',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6162000',
                'longitude' => '-81.3833000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33896',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3466000',
                'longitude' => '-81.6115000',
                'city' => 'Davenport',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32836',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3466000',
                'longitude' => '-81.6115000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34744',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34743',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32780',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6167000',
                'longitude' => '-80.8063000',
                'city' => 'Titusville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32935',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32904',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32937',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Satellite Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32765',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Oviedo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32907',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Palm Bay',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32909',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Palm Bay',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32940',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34756',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6022000',
                'longitude' => '-81.6714000',
                'city' => 'Montverde',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32820',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5331000',
                'longitude' => '-81.0086000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32833',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5331000',
                'longitude' => '-81.0086000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32810',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5995000',
                'longitude' => '-81.3520000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32773',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8113000',
                'longitude' => '-81.2586000',
                'city' => 'Sanford',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32822',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32825',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32826',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32817',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32812',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32806',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32807',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32835',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32732',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.7364000',
                'longitude' => '-81.1084000',
                'city' => 'Geneva',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34747',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6249000',
                'longitude' => '-81.3896000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32819',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6249000',
                'longitude' => '-81.3896000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32821',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6249000',
                'longitude' => '-81.3896000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32934',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.1352000',
                'longitude' => '-80.6586000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32908',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Palm Bay',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32712',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6843000',
                'longitude' => '-81.5014000',
                'city' => 'Apopka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32901',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32953',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Merritt Island',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32951',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Melbourne Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32132',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Edgewater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32818',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32955',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Rockledge',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32920',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Cape Canaveral',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34739',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8760000',
                'longitude' => '-80.9894000',
                'city' => 'Kenansville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32714',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8113000',
                'longitude' => '-81.2586000',
                'city' => 'Altamonte Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32796',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6065000',
                'longitude' => '-80.8072000',
                'city' => 'Titusville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32754',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6065000',
                'longitude' => '-80.8072000',
                'city' => 'Mims',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34432',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6022000',
                'longitude' => '-81.6714000',
                'city' => 'Dunnellon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34761',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Ocoee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32824',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32837',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3462000',
                'longitude' => '-81.4909000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32912',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0820000',
                'longitude' => '-80.6098000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32936',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0820000',
                'longitude' => '-80.6098000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32766',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6667000',
                'longitude' => '-81.1979000',
                'city' => 'Oviedo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32827',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.4496000',
                'longitude' => '-81.3613000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32949',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0567000',
                'longitude' => '-80.6026000',
                'city' => 'Grant',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32950',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0567000',
                'longitude' => '-80.6026000',
                'city' => 'Malabar',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32931',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3169000',
                'longitude' => '-80.6085000',
                'city' => 'Cocoa Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32808',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6225000',
                'longitude' => '-81.3851000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32976',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5436000',
                'longitude' => '-81.3773000',
                'city' => 'Sebastian',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32952',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Merritt Island',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34746',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3462000',
                'longitude' => '-81.4909000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32954',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Merritt Island',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32923',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Cocoa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32959',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Sharpes',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32902',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0970000',
                'longitude' => '-80.6178000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32839',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.4490000',
                'longitude' => '-81.4101000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32925',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3169000',
                'longitude' => '-80.6085000',
                'city' => 'Patrick Afb',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32932',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Cocoa Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34771',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2521000',
                'longitude' => '-81.2815000',
                'city' => 'Saint Cloud',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34772',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2521000',
                'longitude' => '-81.2815000',
                'city' => 'Saint Cloud',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32941',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Melbourne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32779',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6162000',
                'longitude' => '-81.3833000',
                'city' => 'Longwood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34741',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32802',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34758',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2931000',
                'longitude' => '-81.4416000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34759',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2931000',
                'longitude' => '-81.4416000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32725',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3551000',
                'longitude' => '-80.7283000',
                'city' => 'Deltona',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32815',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.4060000',
                'longitude' => '-80.6149000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32899',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.4060000',
                'longitude' => '-80.6149000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32924',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Cocoa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32709',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5331000',
                'longitude' => '-81.0086000',
                'city' => 'Christmas',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34769',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2521000',
                'longitude' => '-81.2815000',
                'city' => 'Saint Cloud',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32783',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3487000',
                'longitude' => '-80.7265000',
                'city' => 'Titusville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34608',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5336000',
                'longitude' => '-82.5848000',
                'city' => 'Spring Hill',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34613',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5336000',
                'longitude' => '-82.5848000',
                'city' => 'Brooksville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34450',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8323000',
                'longitude' => '-82.3409000',
                'city' => 'Inverness',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34453',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8323000',
                'longitude' => '-82.3409000',
                'city' => 'Inverness',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32603',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6505000',
                'longitude' => '-82.3284000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32612',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6505000',
                'longitude' => '-82.3284000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32159',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9227000',
                'longitude' => '-81.9249000',
                'city' => 'Lady Lake',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33523',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3672000',
                'longitude' => '-82.1937000',
                'city' => 'Dade City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34482',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34491',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Summerfield',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34488',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Silver Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34480',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34421',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Belleview',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34474',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34420',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Belleview',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34479',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34472',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32617',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Anthony',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34470',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34471',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32668',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Morriston',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34475',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32680',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6004000',
                'longitude' => '-82.9766000',
                'city' => 'Old Town',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34442',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Hernando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34446',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Homosassa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34431',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Dunnellon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34452',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Inverness',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34461',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Lecanto',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34465',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Beverly Hills',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34473',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34436',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Floral City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32601',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32607',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32640',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Hawthorne',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32609',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32602',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32641',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34478',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34606',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Spring Hill',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32179',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocklawaha',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32686',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Reddick',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34788',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8059000',
                'longitude' => '-81.8752000',
                'city' => 'Leesburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32667',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Micanopy',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32626',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4840000',
                'longitude' => '-82.8524000',
                'city' => 'Chiefland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32778',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5578000',
                'longitude' => '-81.7667000',
                'city' => 'Tavares',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34711',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5578000',
                'longitude' => '-81.7667000',
                'city' => 'Clermont',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32726',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5578000',
                'longitude' => '-81.7667000',
                'city' => 'Eustis',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32736',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5578000',
                'longitude' => '-81.7667000',
                'city' => 'Eustis',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34428',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Crystal River',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34604',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5548000',
                'longitude' => '-82.3902000',
                'city' => 'Brooksville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32656',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.7846000',
                'longitude' => '-82.0317000',
                'city' => 'Keystone Heights',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32134',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2160000',
                'longitude' => '-82.0578000',
                'city' => 'Fort Mc Coy',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34476',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1679000',
                'longitude' => '-82.1681000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34481',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1679000',
                'longitude' => '-82.1681000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34602',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5564000',
                'longitude' => '-82.3831000',
                'city' => 'Brooksville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32113',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Citra',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32606',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6551000',
                'longitude' => '-82.4227000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32605',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6551000',
                'longitude' => '-82.4227000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34705',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8041000',
                'longitude' => '-81.7309000',
                'city' => 'Astatula',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33513',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6661000',
                'longitude' => '-82.1067000',
                'city' => 'Bushnell',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34748',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8059000',
                'longitude' => '-81.8752000',
                'city' => 'Leesburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34731',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8059000',
                'longitude' => '-81.8752000',
                'city' => 'Fruitland Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32757',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8059000',
                'longitude' => '-81.8752000',
                'city' => 'Mount Dora',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32158',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8059000',
                'longitude' => '-81.8752000',
                'city' => 'Lady Lake',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32776',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8059000',
                'longitude' => '-81.8752000',
                'city' => 'Sorrento',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32669',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Newberry',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32162',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9164000',
                'longitude' => '-81.9231000',
                'city' => 'The Villages',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32653',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6505000',
                'longitude' => '-82.3284000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32608',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6505000',
                'longitude' => '-82.3284000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32610',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6505000',
                'longitude' => '-82.3284000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34762',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Okahumpka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34484',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Oxford',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34749',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8560000',
                'longitude' => '-81.6781000',
                'city' => 'Leesburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32798',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8560000',
                'longitude' => '-81.6781000',
                'city' => 'Zellwood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32784',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8560000',
                'longitude' => '-81.6781000',
                'city' => 'Umatilla',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32195',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9888000',
                'longitude' => '-81.8688000',
                'city' => 'Weirsdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34639',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5564000',
                'longitude' => '-82.3831000',
                'city' => 'Land O Lakes',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33301',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32148',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.5108000',
                'longitude' => '-81.9463000',
                'city' => 'Interlachen',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34785',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8684000',
                'longitude' => '-82.0330000',
                'city' => 'Wildwood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34429',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Crystal River',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32091',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Starke',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34433',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.0480000',
                'longitude' => '-82.4593000',
                'city' => 'Dunnellon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34737',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.7104000',
                'longitude' => '-81.7750000',
                'city' => 'Howey In The Hills',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34797',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.7104000',
                'longitude' => '-81.7750000',
                'city' => 'Yalaha',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32625',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1315000',
                'longitude' => '-83.0333000',
                'city' => 'Cedar Key',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33521',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8615000',
                'longitude' => '-82.0432000',
                'city' => 'Coleman',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33538',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8615000',
                'longitude' => '-82.0432000',
                'city' => 'Lake Panasoffkee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32666',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Melrose',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34434',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8379000',
                'longitude' => '-82.3312000',
                'city' => 'Dunnellon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34601',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5564000',
                'longitude' => '-82.3831000',
                'city' => 'Brooksville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32618',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.5239000',
                'longitude' => '-82.5157000',
                'city' => 'Archer',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32735',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8505000',
                'longitude' => '-81.6878000',
                'city' => 'Grand Island',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32720',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8505000',
                'longitude' => '-81.6878000',
                'city' => 'Deland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33407',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34736',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5577000',
                'longitude' => '-81.8574000',
                'city' => 'Groveland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34448',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.7251000',
                'longitude' => '-82.5442000',
                'city' => 'Homosassa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34498',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.0325000',
                'longitude' => '-82.7178000',
                'city' => 'Yankeetown',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32611',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6505000',
                'longitude' => '-82.3284000',
                'city' => 'Gainesville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34755',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5538000',
                'longitude' => '-81.7693000',
                'city' => 'Minneola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34715',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5578000',
                'longitude' => '-81.7667000',
                'city' => 'Clermont',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34714',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5578000',
                'longitude' => '-81.7667000',
                'city' => 'Clermont',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32703',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8059000',
                'longitude' => '-81.8752000',
                'city' => 'Apopka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34449',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9009000',
                'longitude' => '-82.5862000',
                'city' => 'Inglis',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34447',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8323000',
                'longitude' => '-82.3409000',
                'city' => 'Homosassa Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34423',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8323000',
                'longitude' => '-82.3409000',
                'city' => 'Crystal River',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34753',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5577000',
                'longitude' => '-81.8574000',
                'city' => 'Mascotte',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32621',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4504000',
                'longitude' => '-82.6313000',
                'city' => 'Bronson',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32696',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.3940000',
                'longitude' => '-82.4495000',
                'city' => 'Williston',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34607',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5564000',
                'longitude' => '-82.3831000',
                'city' => 'Spring Hill',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32756',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8560000',
                'longitude' => '-81.6781000',
                'city' => 'Mount Dora',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33525',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3648000',
                'longitude' => '-82.1892000',
                'city' => 'Dade City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33540',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3648000',
                'longitude' => '-82.1892000',
                'city' => 'Zephyrhills',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32619',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6162000',
                'longitude' => '-82.8202000',
                'city' => 'Bell',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32693',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6162000',
                'longitude' => '-82.8202000',
                'city' => 'Trenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32694',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.7861000',
                'longitude' => '-82.1713000',
                'city' => 'Waldo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32631',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.7861000',
                'longitude' => '-82.1713000',
                'city' => 'Earleton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32044',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.7861000',
                'longitude' => '-82.1713000',
                'city' => 'Hampton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32615',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6369000',
                'longitude' => '-82.6114000',
                'city' => 'Alachua',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32042',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.8916000',
                'longitude' => '-82.3332000',
                'city' => 'Graham',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32622',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.8916000',
                'longitude' => '-82.3332000',
                'city' => 'Brooker',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32639',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4487000',
                'longitude' => '-82.6384000',
                'city' => 'Gulf Hammock',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32683',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4487000',
                'longitude' => '-82.6384000',
                'city' => 'Otter Creek',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32359',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6351000',
                'longitude' => '-83.1181000',
                'city' => 'Steinhatchee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32648',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6351000',
                'longitude' => '-83.1181000',
                'city' => 'Horseshoe Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32628',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6351000',
                'longitude' => '-83.1181000',
                'city' => 'Cross City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32777',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8560000',
                'longitude' => '-81.6781000',
                'city' => 'Tangerine',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32616',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6584000',
                'longitude' => '-82.3231000',
                'city' => 'Alachua',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34609',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5548000',
                'longitude' => '-82.3902000',
                'city' => 'Spring Hill',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34610',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5548000',
                'longitude' => '-82.3902000',
                'city' => 'Spring Hill',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34614',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5548000',
                'longitude' => '-82.3902000',
                'city' => 'Brooksville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32692',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.5924000',
                'longitude' => '-82.9819000',
                'city' => 'Suwannee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32182',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.5045000',
                'longitude' => '-81.9444000',
                'city' => 'Orange Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33585',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6622000',
                'longitude' => '-82.1093000',
                'city' => 'Sumterville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33597',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6622000',
                'longitude' => '-82.1093000',
                'city' => 'Webster',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33514',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6622000',
                'longitude' => '-82.1093000',
                'city' => 'Center Hill',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32356',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6335000',
                'longitude' => '-83.1253000',
                'city' => 'Salem',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33537',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.4635000',
                'longitude' => '-82.1847000',
                'city' => 'Lacoochee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33593',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.4635000',
                'longitude' => '-82.1847000',
                'city' => 'Trilby',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33544',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3454000',
                'longitude' => '-82.2742000',
                'city' => 'Wesley Chapel',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33574',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3454000',
                'longitude' => '-82.2742000',
                'city' => 'Saint Leo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33576',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3454000',
                'longitude' => '-82.2742000',
                'city' => 'San Antonio',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32664',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4102000',
                'longitude' => '-82.2140000',
                'city' => 'Mc Intosh',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32681',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4102000',
                'longitude' => '-82.2140000',
                'city' => 'Orange Lake',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34460',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8323000',
                'longitude' => '-82.3409000',
                'city' => 'Lecanto',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34603',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5564000',
                'longitude' => '-82.3831000',
                'city' => 'Brooksville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32767',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9292000',
                'longitude' => '-81.6716000',
                'city' => 'Paisley',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32702',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9292000',
                'longitude' => '-81.6716000',
                'city' => 'Altoona',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32102',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1681000',
                'longitude' => '-81.5481000',
                'city' => 'Astor',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34489',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Silver Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34712',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8059000',
                'longitude' => '-81.8752000',
                'city' => 'Clermont',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34483',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.1862000',
                'longitude' => '-82.1316000',
                'city' => 'Ocala',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33526',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3672000',
                'longitude' => '-82.1937000',
                'city' => 'Dade City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32114',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2169000',
                'longitude' => '-81.0269000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32128',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2169000',
                'longitude' => '-81.0269000',
                'city' => 'Port Orange',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32180',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2326000',
                'longitude' => '-81.4682000',
                'city' => 'Pierson',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32094',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2332000',
                'longitude' => '-82.8210000',
                'city' => 'Wellborn',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32136',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4589000',
                'longitude' => '-81.2601000',
                'city' => 'Flagler Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32110',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4589000',
                'longitude' => '-81.2601000',
                'city' => 'Bunnell',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32025',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1861000',
                'longitude' => '-82.6380000',
                'city' => 'Lake City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32060',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2941000',
                'longitude' => '-82.9830000',
                'city' => 'Live Oak',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32064',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2941000',
                'longitude' => '-82.9830000',
                'city' => 'Live Oak',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32062',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2941000',
                'longitude' => '-82.9830000',
                'city' => 'Mc Alpin',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32759',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8489000',
                'longitude' => '-80.8497000',
                'city' => 'Oak Hill',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32129',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Port Orange',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32117',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32176',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Ormond Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32174',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Ormond Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32173',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Ormond Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32124',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32127',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Port Orange',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32118',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32119',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32721',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Deland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32713',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8762000',
                'longitude' => '-81.3000000',
                'city' => 'Debary',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32763',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9519000',
                'longitude' => '-81.2917000',
                'city' => 'Orange City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32177',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6449000',
                'longitude' => '-81.6423000',
                'city' => 'Palatka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32706',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9769000',
                'longitude' => '-81.2383000',
                'city' => 'Cassadaga',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32168',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9769000',
                'longitude' => '-81.2383000',
                'city' => 'New Smyrna Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32738',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9769000',
                'longitude' => '-81.2383000',
                'city' => 'Deltona',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32744',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9769000',
                'longitude' => '-81.2383000',
                'city' => 'Lake Helen',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32096',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3339000',
                'longitude' => '-82.7607000',
                'city' => 'White Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32724',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2106000',
                'longitude' => '-81.0251000',
                'city' => 'Deland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32169',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2106000',
                'longitude' => '-81.0251000',
                'city' => 'New Smyrna Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32170',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2106000',
                'longitude' => '-81.0251000',
                'city' => 'New Smyrna Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32164',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.5746000',
                'longitude' => '-81.2059000',
                'city' => 'Palm Coast',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32052',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Jasper',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32181',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4933000',
                'longitude' => '-81.5978000',
                'city' => 'Pomona Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32038',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9167000',
                'longitude' => '-82.7007000',
                'city' => 'Fort White',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32115',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32066',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.0533000',
                'longitude' => '-83.1789000',
                'city' => 'Mayo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32141',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Edgewater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32131',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6504000',
                'longitude' => '-81.6325000',
                'city' => 'East Palatka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32189',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6504000',
                'longitude' => '-81.6325000',
                'city' => 'Satsuma',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32187',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6504000',
                'longitude' => '-81.6325000',
                'city' => 'San Mateo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32145',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6504000',
                'longitude' => '-81.6325000',
                'city' => 'Hastings',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32120',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32055',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1900000',
                'longitude' => '-82.6353000',
                'city' => 'Lake City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32071',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2941000',
                'longitude' => '-82.9830000',
                'city' => 'O Brien',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32083',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.0692000',
                'longitude' => '-82.2142000',
                'city' => 'Raiford',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32643',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.8330000',
                'longitude' => '-82.5921000',
                'city' => 'High Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32137',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.5746000',
                'longitude' => '-81.2059000',
                'city' => 'Palm Coast',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32082',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2106000',
                'longitude' => '-81.0251000',
                'city' => 'Ponte Vedra Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32024',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1900000',
                'longitude' => '-82.6353000',
                'city' => 'Lake City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32139',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4776000',
                'longitude' => '-81.6694000',
                'city' => 'Georgetown',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32193',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4776000',
                'longitude' => '-81.6694000',
                'city' => 'Welaka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32112',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4776000',
                'longitude' => '-81.6694000',
                'city' => 'Crescent City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32054',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2145000',
                'longitude' => '-81.0224000',
                'city' => 'Lake Butler',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32801',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2145000',
                'longitude' => '-81.0224000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32697',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.0217000',
                'longitude' => '-82.3380000',
                'city' => 'Worthington Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32135',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4739000',
                'longitude' => '-81.1274000',
                'city' => 'Palm Coast',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32207',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4816000',
                'longitude' => '-81.6668000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32130',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'De Leon Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32178',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6449000',
                'longitude' => '-81.6423000',
                'city' => 'Palatka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32795',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Lake Mary',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32303',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.0238000',
                'longitude' => '-80.9261000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32008',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9668000',
                'longitude' => '-82.9243000',
                'city' => 'Branford',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32157',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4948000',
                'longitude' => '-81.5906000',
                'city' => 'Lake Como',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32138',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.7295000',
                'longitude' => '-81.8852000',
                'city' => 'Grandin',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32140',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.7295000',
                'longitude' => '-81.8852000',
                'city' => 'Florahome',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32125',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32190',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2397000',
                'longitude' => '-81.4817000',
                'city' => 'Seville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32774',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9519000',
                'longitude' => '-81.2917000',
                'city' => 'Orange City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32746',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.9519000',
                'longitude' => '-81.2917000',
                'city' => 'Lake Mary',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32122',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.2320000',
                'longitude' => '-81.0350000',
                'city' => 'Daytona Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32201',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.4933000',
                'longitude' => '-81.5978000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32053',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6018000',
                'longitude' => '-83.0980000',
                'city' => 'Jennings',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32033',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.6504000',
                'longitude' => '-81.6325000',
                'city' => 'Elkton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32811',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32828',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32708',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6703000',
                'longitude' => '-81.3046000',
                'city' => 'Winter Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32764',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8113000',
                'longitude' => '-81.2586000',
                'city' => 'Osteen',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32809',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.4512000',
                'longitude' => '-81.3542000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34787',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3351000',
                'longitude' => '-81.4802000',
                'city' => 'Winter Garden',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32728',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Deltona',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32829',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5369000',
                'longitude' => '-81.2849000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32793',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6162000',
                'longitude' => '-81.3833000',
                'city' => 'Winter Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32771',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6162000',
                'longitude' => '-81.3833000',
                'city' => 'Sanford',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34786',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Windermere',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34734',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5777000',
                'longitude' => '-81.4514000',
                'city' => 'Gotha',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32791',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6162000',
                'longitude' => '-81.3833000',
                'city' => 'Longwood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33897',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3466000',
                'longitude' => '-81.6115000',
                'city' => 'Davenport',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33884',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Winter Haven',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34778',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Winter Garden',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33408',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'North Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34745',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5672000',
                'longitude' => '-81.5857000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32856',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.4512000',
                'longitude' => '-81.3542000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32794',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Maitland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32704',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Apopka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34742',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Kissimmee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33848',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Intercession City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32733',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5995000',
                'longitude' => '-81.3520000',
                'city' => 'Goldenrod',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32857',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5995000',
                'longitude' => '-81.3520000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32752',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5995000',
                'longitude' => '-81.3520000',
                'city' => 'Longwood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32854',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34972',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8745000',
                'longitude' => '-80.9964000',
                'city' => 'Okeechobee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34652',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'New Port Richey',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33314',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32513',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32868',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34760',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5995000',
                'longitude' => '-81.3520000',
                'city' => 'Oakland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32739',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Deltona',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34773',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2458000',
                'longitude' => '-81.2796000',
                'city' => 'Saint Cloud',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32860',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5396000',
                'longitude' => '-81.3799000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32816',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5396000',
                'longitude' => '-81.3799000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32830',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3905000',
                'longitude' => '-81.5340000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32772',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.8113000',
                'longitude' => '-81.2586000',
                'city' => 'Sanford',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32867',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33463',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.6312000',
                'longitude' => '-81.3915000',
                'city' => 'Lake Worth',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32719',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5412000',
                'longitude' => '-81.3728000',
                'city' => 'Winter Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34740',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2998000',
                'longitude' => '-81.4006000',
                'city' => 'Killarney',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32859',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5436000',
                'longitude' => '-81.3773000',
                'city' => 'Orlando',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32762',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.5995000',
                'longitude' => '-81.3520000',
                'city' => 'Oviedo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33898',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3462000',
                'longitude' => '-81.4909000',
                'city' => 'Lake Wales',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33480',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.5243000',
                'longitude' => '-80.0561000',
                'city' => 'Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33405',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.5243000',
                'longitude' => '-80.0561000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33413',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6985000',
                'longitude' => '-80.1191000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33409',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6985000',
                'longitude' => '-80.1191000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33415',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6188000',
                'longitude' => '-80.0528000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33406',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6188000',
                'longitude' => '-80.0528000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33486',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33477',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7095000',
                'longitude' => '-80.0520000',
                'city' => 'Jupiter',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33410',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7095000',
                'longitude' => '-80.0520000',
                'city' => 'Palm Beach Gardens',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33401',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7095000',
                'longitude' => '-80.0520000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33470',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Loxahatchee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33432',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33433',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33435',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boynton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33436',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boynton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33481',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33484',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Delray Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33498',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33428',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33430',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6821000',
                'longitude' => '-80.6737000',
                'city' => 'Belle Glade',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33462',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6188000',
                'longitude' => '-80.0528000',
                'city' => 'Lake Worth',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33461',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6188000',
                'longitude' => '-80.0528000',
                'city' => 'Lake Worth',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33434',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3708000',
                'longitude' => '-80.1940000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33496',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3708000',
                'longitude' => '-80.1940000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33426',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.5267000',
                'longitude' => '-80.0605000',
                'city' => 'Boynton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33469',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8384000',
                'longitude' => '-80.0913000',
                'city' => 'Jupiter',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33414',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8384000',
                'longitude' => '-80.0913000',
                'city' => 'Wellington',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33418',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8384000',
                'longitude' => '-80.0913000',
                'city' => 'Palm Beach Gardens',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33411',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8384000',
                'longitude' => '-80.0913000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33460',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8384000',
                'longitude' => '-80.0913000',
                'city' => 'Lake Worth',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34996',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6985000',
                'longitude' => '-80.1191000',
                'city' => 'Stuart',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33417',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6985000',
                'longitude' => '-80.1191000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33443',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Deerfield Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34994',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Stuart',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33468',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Jupiter',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33402',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33404',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33467',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Lake Worth',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33442',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Deerfield Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33445',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Delray Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33067',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33427',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33483',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4614000',
                'longitude' => '-80.0682000',
                'city' => 'Delray Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33444',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4614000',
                'longitude' => '-80.0682000',
                'city' => 'Delray Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33478',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Jupiter',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33437',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Boynton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33466',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Lake Worth',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33403',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33476',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6821000',
                'longitude' => '-80.6737000',
                'city' => 'Pahokee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33412',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9402000',
                'longitude' => '-80.1010000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33474',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Boynton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33309',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34953',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Port Saint Lucie',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33062',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33425',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Boynton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33454',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Lake Worth',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33416',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33455',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Hobe Sound',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33422',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33420',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'West Palm Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34997',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Stuart',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33441',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3077000',
                'longitude' => '-80.1287000',
                'city' => 'Deerfield Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34983',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Port Saint Lucie',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33465',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6188000',
                'longitude' => '-80.0528000',
                'city' => 'Lake Worth',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34986',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Port Saint Lucie',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33446',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4575000',
                'longitude' => '-80.0708000',
                'city' => 'Delray Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34956',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8384000',
                'longitude' => '-80.0913000',
                'city' => 'Indiantown',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33308',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33447',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Delray Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32960',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Vero Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33071',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33429',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34990',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6914000',
                'longitude' => '-80.0581000',
                'city' => 'Palm City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32966',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.5267000',
                'longitude' => '-80.0605000',
                'city' => 'Vero Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33304',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33319',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3498000',
                'longitude' => '-80.0889000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33497',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Boca Raton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33438',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8264000',
                'longitude' => '-80.6611000',
                'city' => 'Canal Point',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33073',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.4590000',
                'longitude' => '-80.0639000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33493',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.6821000',
                'longitude' => '-80.6737000',
                'city' => 'South Bay',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33755',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33765',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34655',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2420000',
                'longitude' => '-82.7068000',
                'city' => 'New Port Richey',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33704',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7741000',
                'longitude' => '-82.6433000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33730',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7741000',
                'longitude' => '-82.6433000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33770',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Largo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33756',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33713',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33712',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33702',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33701',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33716',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8547000',
                'longitude' => '-82.6453000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33781',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8547000',
                'longitude' => '-82.6453000',
                'city' => 'Pinellas Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33782',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8547000',
                'longitude' => '-82.6453000',
                'city' => 'Pinellas Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33708',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33714',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8899000',
                'longitude' => '-82.6823000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33613',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33764',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34669',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.3644000',
                'longitude' => '-82.6887000',
                'city' => 'Hudson',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34688',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.1436000',
                'longitude' => '-82.7522000',
                'city' => 'Tarpon Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34691',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.1436000',
                'longitude' => '-82.7522000',
                'city' => 'Holiday',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34653',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2420000',
                'longitude' => '-82.7068000',
                'city' => 'New Port Richey',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33767',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Clearwater Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34654',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2420000',
                'longitude' => '-82.7068000',
                'city' => 'New Port Richey',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34667',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2420000',
                'longitude' => '-82.7068000',
                'city' => 'Hudson',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33759',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8882000',
                'longitude' => '-82.6893000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34698',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9639000',
                'longitude' => '-82.7840000',
                'city' => 'Dunedin',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33763',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9639000',
                'longitude' => '-82.7840000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33760',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8899000',
                'longitude' => '-82.6823000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33762',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8899000',
                'longitude' => '-82.6823000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33707',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7732000',
                'longitude' => '-82.7332000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33709',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7732000',
                'longitude' => '-82.7332000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33710',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7732000',
                'longitude' => '-82.7332000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33772',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8406000',
                'longitude' => '-82.7914000',
                'city' => 'Seminole',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33773',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8406000',
                'longitude' => '-82.7914000',
                'city' => 'Largo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33778',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8406000',
                'longitude' => '-82.7914000',
                'city' => 'Largo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33777',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8406000',
                'longitude' => '-82.7914000',
                'city' => 'Seminole',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33776',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8406000',
                'longitude' => '-82.7914000',
                'city' => 'Seminole',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33711',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7642000',
                'longitude' => '-82.6854000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33761',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33757',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33618',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0852000',
                'longitude' => '-82.5396000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33625',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0852000',
                'longitude' => '-82.5396000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33706',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7414000',
                'longitude' => '-82.7536000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33731',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33732',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33771',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Largo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34695',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Safety Harbor',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34668',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2420000',
                'longitude' => '-82.7068000',
                'city' => 'Port Richey',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33715',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33705',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33736',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34689',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Tarpon Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33733',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34683',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Palm Harbor',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34690',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Holiday',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34674',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Hudson',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34677',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Oldsmar',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33703',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34684',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9639000',
                'longitude' => '-82.7840000',
                'city' => 'Palm Harbor',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34685',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Palm Harbor',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33774',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9149000',
                'longitude' => '-82.7916000',
                'city' => 'Largo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33738',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33786',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8804000',
                'longitude' => '-82.8375000',
                'city' => 'Belleair Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33785',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8804000',
                'longitude' => '-82.8375000',
                'city' => 'Indian Rocks Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33779',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Largo',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34680',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2490000',
                'longitude' => '-82.7203000',
                'city' => 'Elfers',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33626',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9669000',
                'longitude' => '-82.8000000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34656',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2420000',
                'longitude' => '-82.7068000',
                'city' => 'New Port Richey',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33729',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8899000',
                'longitude' => '-82.6823000',
                'city' => 'Saint Petersburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34210',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.1436000',
                'longitude' => '-82.7522000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33019',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.0084000',
                'longitude' => '-80.1485000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33316',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33069',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.2327000',
                'longitude' => '-80.1189000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33063',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.2579000',
                'longitude' => '-80.2509000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33394',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33065',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.2579000',
                'longitude' => '-80.2509000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34984',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2665000',
                'longitude' => '-80.2842000',
                'city' => 'Port Saint Lucie',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32958',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8172000',
                'longitude' => '-80.4680000',
                'city' => 'Sebastian',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34952',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2665000',
                'longitude' => '-80.2842000',
                'city' => 'Port Saint Lucie',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34957',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2453000',
                'longitude' => '-80.2264000',
                'city' => 'Jensen Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34946',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4436000',
                'longitude' => '-80.3336000',
                'city' => 'Fort Pierce',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34947',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4436000',
                'longitude' => '-80.3336000',
                'city' => 'Fort Pierce',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32962',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.6367000',
                'longitude' => '-80.4025000',
                'city' => 'Vero Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32963',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.6367000',
                'longitude' => '-80.4025000',
                'city' => 'Vero Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32968',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.6406000',
                'longitude' => '-80.3999000',
                'city' => 'Vero Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34950',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4436000',
                'longitude' => '-80.3336000',
                'city' => 'Fort Pierce',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34949',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4436000',
                'longitude' => '-80.3336000',
                'city' => 'Fort Pierce',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33605',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33606',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33601',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33603',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33679',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33567',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Plant City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33619',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33609',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9440000',
                'longitude' => '-82.5232000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33629',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9440000',
                'longitude' => '-82.5232000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33607',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9440000',
                'longitude' => '-82.5232000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33687',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33614',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33306',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33543',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Wesley Chapel',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33623',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33604',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9958000',
                'longitude' => '-82.4597000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33610',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9958000',
                'longitude' => '-82.4597000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33569',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Riverview',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33624',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33634',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9981000',
                'longitude' => '-82.5660000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33635',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9981000',
                'longitude' => '-82.5660000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33615',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9981000',
                'longitude' => '-82.5660000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33570',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Ruskin',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33584',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9720000',
                'longitude' => '-82.3734000',
                'city' => 'Seffner',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33637',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0222000',
                'longitude' => '-82.5205000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33617',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33558',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0831000',
                'longitude' => '-82.5050000',
                'city' => 'Lutz',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33616',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33611',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33511',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Brandon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33556',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Odessa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33881',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Winter Haven',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33510',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Brandon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33566',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0184000',
                'longitude' => '-82.1273000',
                'city' => 'Plant City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33612',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9524000',
                'longitude' => '-82.4579000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33541',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2345000',
                'longitude' => '-82.1843000',
                'city' => 'Zephyrhills',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33594',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Valrico',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33688',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33647',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9745000',
                'longitude' => '-82.3478000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33565',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0184000',
                'longitude' => '-82.1273000',
                'city' => 'Plant City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33559',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Lutz',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33547',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Lithia',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33563',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0184000',
                'longitude' => '-82.1273000',
                'city' => 'Plant City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33527',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9655000',
                'longitude' => '-82.2697000',
                'city' => 'Dover',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33548',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Lutz',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33598',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7139000',
                'longitude' => '-82.3371000',
                'city' => 'Wimauma',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33672',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0246000',
                'longitude' => '-82.1593000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33620',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0913000',
                'longitude' => '-82.3678000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33564',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0061000',
                'longitude' => '-82.3572000',
                'city' => 'Plant City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33758',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Clearwater',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33549',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0680000',
                'longitude' => '-82.4249000',
                'city' => 'Lutz',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33573',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7139000',
                'longitude' => '-82.3371000',
                'city' => 'Sun City Center',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33572',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7179000',
                'longitude' => '-82.4361000',
                'city' => 'Apollo Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33534',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8503000',
                'longitude' => '-82.3744000',
                'city' => 'Gibsonton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33682',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33813',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0184000',
                'longitude' => '-82.1273000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33509',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Brandon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34230',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33539',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2345000',
                'longitude' => '-82.1843000',
                'city' => 'Zephyrhills',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33592',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Thonotosassa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34237',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0222000',
                'longitude' => '-82.5205000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33853',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0184000',
                'longitude' => '-82.1273000',
                'city' => 'Lake Wales',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33621',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9031000',
                'longitude' => '-82.4958000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33608',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9031000',
                'longitude' => '-82.4958000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33542',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.2345000',
                'longitude' => '-82.1843000',
                'city' => 'Zephyrhills',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33850',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0061000',
                'longitude' => '-82.3572000',
                'city' => 'Lake Alfred',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34231',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33622',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Tampa',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33524',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.9484000',
                'longitude' => '-82.4605000',
                'city' => 'Crystal Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32547',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Fort Walton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32306',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4772000',
                'longitude' => '-84.3467000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32304',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4772000',
                'longitude' => '-84.3467000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32501',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5072000',
                'longitude' => '-87.2518000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32503',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5072000',
                'longitude' => '-87.2518000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32505',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5072000',
                'longitude' => '-87.2518000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32514',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5072000',
                'longitude' => '-87.2518000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32561',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5072000',
                'longitude' => '-87.2518000',
                'city' => 'Gulf Breeze',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32504',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5072000',
                'longitude' => '-87.2518000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32305',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4772000',
                'longitude' => '-84.3467000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32317',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4772000',
                'longitude' => '-84.3467000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32308',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4772000',
                'longitude' => '-84.3467000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32301',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4772000',
                'longitude' => '-84.3467000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32571',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Milton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32583',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Milton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32563',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Gulf Breeze',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32569',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Mary Esther',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32570',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Milton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32534',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32566',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Navarre',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32442',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7751000',
                'longitude' => '-85.2316000',
                'city' => 'Grand Ridge',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32446',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7751000',
                'longitude' => '-85.2316000',
                'city' => 'Marianna',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32460',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7751000',
                'longitude' => '-85.2316000',
                'city' => 'Sneads',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32431',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7751000',
                'longitude' => '-85.2316000',
                'city' => 'Cottondale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32327',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3077000',
                'longitude' => '-84.2487000',
                'city' => 'Crawfordville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32309',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4432000',
                'longitude' => '-84.2773000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32312',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4432000',
                'longitude' => '-84.2773000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32439',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3165000',
                'longitude' => '-86.1206000',
                'city' => 'Freeport',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32413',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3165000',
                'longitude' => '-86.1206000',
                'city' => 'Panama City Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32424',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4400000',
                'longitude' => '-85.0488000',
                'city' => 'Blountstown',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32404',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1599000',
                'longitude' => '-85.6579000',
                'city' => 'Panama City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32405',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1599000',
                'longitude' => '-85.6579000',
                'city' => 'Panama City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32401',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1599000',
                'longitude' => '-85.6579000',
                'city' => 'Panama City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32311',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4250000',
                'longitude' => '-84.2403000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32548',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Fort Walton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32579',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Shalimar',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32578',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Niceville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32507',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32310',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4454000',
                'longitude' => '-84.2819000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32347',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1161000',
                'longitude' => '-83.5758000',
                'city' => 'Perry',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32348',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1161000',
                'longitude' => '-83.5758000',
                'city' => 'Perry',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32433',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Defuniak Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32456',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.8091000',
                'longitude' => '-85.2986000',
                'city' => 'Port Saint Joe',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32351',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4432000',
                'longitude' => '-84.2773000',
                'city' => 'Quincy',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32407',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2053000',
                'longitude' => '-85.8524000',
                'city' => 'Panama City Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32408',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2053000',
                'longitude' => '-85.8524000',
                'city' => 'Panama City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32459',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3165000',
                'longitude' => '-86.1206000',
                'city' => 'Santa Rosa Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32462',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3165000',
                'longitude' => '-86.1206000',
                'city' => 'Vernon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32526',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32425',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7837000',
                'longitude' => '-85.5356000',
                'city' => 'Bonifay',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32531',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Baker',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32539',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Crestview',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32536',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Crestview',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32549',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Fort Walton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32541',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Destin',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32399',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4454000',
                'longitude' => '-84.2819000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32331',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4694000',
                'longitude' => '-83.6260000',
                'city' => 'Greenville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32444',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1599000',
                'longitude' => '-85.6579000',
                'city' => 'Lynn Haven',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32340',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4660000',
                'longitude' => '-83.4090000',
                'city' => 'Madison',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32530',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Bagdad',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32568',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '31.0013000',
                'longitude' => '-87.2617000',
                'city' => 'Mc David',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32535',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '31.0013000',
                'longitude' => '-87.2617000',
                'city' => 'Century',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32540',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Destin',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32426',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.9586000',
                'longitude' => '-85.5170000',
                'city' => 'Campbellton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32440',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.9586000',
                'longitude' => '-85.5170000',
                'city' => 'Graceville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32409',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2498000',
                'longitude' => '-85.6264000',
                'city' => 'Panama City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32509',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3981000',
                'longitude' => '-87.2751000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32550',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3678000',
                'longitude' => '-86.1852000',
                'city' => 'Miramar Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32333',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6165000',
                'longitude' => '-84.4156000',
                'city' => 'Havana',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32448',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7751000',
                'longitude' => '-85.2316000',
                'city' => 'Marianna',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32302',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4432000',
                'longitude' => '-84.2773000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32580',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5058000',
                'longitude' => '-86.4915000',
                'city' => 'Valparaiso',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32502',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32403',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.0666000',
                'longitude' => '-85.5834000',
                'city' => 'Panama City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32577',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Molino',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32511',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5109000',
                'longitude' => '-87.2257000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32320',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.7171000',
                'longitude' => '-84.9896000',
                'city' => 'Apalachicola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32428',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7837000',
                'longitude' => '-85.5356000',
                'city' => 'Chipley',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32455',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7170000',
                'longitude' => '-86.1153000',
                'city' => 'Ponce De Leon',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32633',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Evinston',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32336',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5414000',
                'longitude' => '-83.8663000',
                'city' => 'Lamont',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32344',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5414000',
                'longitude' => '-83.8663000',
                'city' => 'Monticello',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32346',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9149000',
                'longitude' => '-84.3724000',
                'city' => 'Panacea',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32343',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4350000',
                'longitude' => '-84.3251000',
                'city' => 'Midway',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32533',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6077000',
                'longitude' => '-87.3235000',
                'city' => 'Cantonment',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32565',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.9562000',
                'longitude' => '-87.1508000',
                'city' => 'Jay',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32542',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Eglin Afb',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32564',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Holt',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32506',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4063000',
                'longitude' => '-87.2702000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32360',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3868000',
                'longitude' => '-84.7978000',
                'city' => 'Telogia',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32321',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3868000',
                'longitude' => '-84.7978000',
                'city' => 'Bristol',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32334',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3868000',
                'longitude' => '-84.7978000',
                'city' => 'Hosford',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32420',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5499000',
                'longitude' => '-85.5847000',
                'city' => 'Alford',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32438',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5499000',
                'longitude' => '-85.5847000',
                'city' => 'Fountain',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32330',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5688000',
                'longitude' => '-84.7503000',
                'city' => 'Greensboro',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32562',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Gulf Breeze',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32421',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5771000',
                'longitude' => '-85.1259000',
                'city' => 'Altha',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32508',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4022000',
                'longitude' => '-87.2726000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32512',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4022000',
                'longitude' => '-87.2726000',
                'city' => 'Pensacola',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32352',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5825000',
                'longitude' => '-84.5835000',
                'city' => 'Quincy',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32362',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4432000',
                'longitude' => '-84.2773000',
                'city' => 'Woodville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32437',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6245000',
                'longitude' => '-85.7196000',
                'city' => 'Ebro',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32427',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6245000',
                'longitude' => '-85.7196000',
                'city' => 'Caryville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32358',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9149000',
                'longitude' => '-84.3724000',
                'city' => 'Sopchoppy',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32435',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Defuniak Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32464',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.7856000',
                'longitude' => '-85.8493000',
                'city' => 'Westville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32355',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4432000',
                'longitude' => '-84.2773000',
                'city' => 'Saint Marks',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32423',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.9647000',
                'longitude' => '-85.1665000',
                'city' => 'Bascom',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32443',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.9647000',
                'longitude' => '-85.1665000',
                'city' => 'Greenwood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32445',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.9647000',
                'longitude' => '-85.1665000',
                'city' => 'Malone',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32544',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4144000',
                'longitude' => '-86.7330000',
                'city' => 'Hurlburt Field',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32567',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Laurel Hill',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32307',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4454000',
                'longitude' => '-84.2819000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32466',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1599000',
                'longitude' => '-85.6579000',
                'city' => 'Youngstown',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32449',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1194000',
                'longitude' => '-85.2016000',
                'city' => 'Wewahitchka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32465',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1194000',
                'longitude' => '-85.2016000',
                'city' => 'Wewahitchka',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32322',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.8491000',
                'longitude' => '-84.6676000',
                'city' => 'Carrabelle',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32410',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9513000',
                'longitude' => '-85.4085000',
                'city' => 'Mexico Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32324',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6920000',
                'longitude' => '-84.8408000',
                'city' => 'Chattahoochee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32328',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.7296000',
                'longitude' => '-84.8857000',
                'city' => 'Eastpoint',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32430',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4400000',
                'longitude' => '-85.0488000',
                'city' => 'Clarksville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32323',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.8491000',
                'longitude' => '-84.6676000',
                'city' => 'Lanark Village',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32572',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4177000',
                'longitude' => '-87.2156000',
                'city' => 'Milton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32588',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4114000',
                'longitude' => '-86.6029000',
                'city' => 'Niceville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32538',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '31.0100000',
                'longitude' => '-86.3276000',
                'city' => 'Paxton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32332',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6147000',
                'longitude' => '-84.6603000',
                'city' => 'Gretna',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32350',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5764000',
                'longitude' => '-83.4283000',
                'city' => 'Pinetta',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32314',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4432000',
                'longitude' => '-84.2773000',
                'city' => 'Tallahassee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32059',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.4168000',
                'longitude' => '-83.3004000',
                'city' => 'Lee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33825',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.6128000',
                'longitude' => '-81.5058000',
                'city' => 'Avon Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33875',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5006000',
                'longitude' => '-81.4357000',
                'city' => 'Sebring',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33876',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5006000',
                'longitude' => '-81.4357000',
                'city' => 'Sebring',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33880',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8899000',
                'longitude' => '-81.8332000',
                'city' => 'Winter Haven',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33823',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8899000',
                'longitude' => '-81.8332000',
                'city' => 'Auburndale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33801',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33844',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Haines City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33830',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Bartow',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33803',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33838',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.1103000',
                'longitude' => '-81.6164000',
                'city' => 'Dundee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33810',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33868',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Polk City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33809',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33815',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0317000',
                'longitude' => '-81.9504000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33837',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8308000',
                'longitude' => '-81.0934000',
                'city' => 'Davenport',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33440',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7505000',
                'longitude' => '-80.9138000',
                'city' => 'Clewiston',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33920',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7662000',
                'longitude' => '-81.4445000',
                'city' => 'Alva',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34269',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2172000',
                'longitude' => '-81.8595000',
                'city' => 'Arcadia',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33870',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4324000',
                'longitude' => '-81.3486000',
                'city' => 'Sebring',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33852',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2892000',
                'longitude' => '-81.3595000',
                'city' => 'Lake Placid',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33841',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5521000',
                'longitude' => '-81.8087000',
                'city' => 'Fort Meade',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33890',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5521000',
                'longitude' => '-81.8087000',
                'city' => 'Zolfo Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33471',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8308000',
                'longitude' => '-81.0934000',
                'city' => 'Moore Haven',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33805',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0404000',
                'longitude' => '-81.9567000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33860',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Mulberry',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33859',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0343000',
                'longitude' => '-81.7268000',
                'city' => 'Lake Wales',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33839',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0241000',
                'longitude' => '-81.7275000',
                'city' => 'Eagle Lake',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33872',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4928000',
                'longitude' => '-81.4410000',
                'city' => 'Sebring',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33834',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5016000',
                'longitude' => '-81.7938000',
                'city' => 'Bowling Green',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34974',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2432000',
                'longitude' => '-80.8275000',
                'city' => 'Okeechobee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33857',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2432000',
                'longitude' => '-80.8275000',
                'city' => 'Lorida',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33802',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0317000',
                'longitude' => '-81.9504000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33804',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0317000',
                'longitude' => '-81.9504000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33835',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7924000',
                'longitude' => '-81.9810000',
                'city' => 'Bradley',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33851',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0219000',
                'longitude' => '-81.6206000',
                'city' => 'Lake Hamilton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33877',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0219000',
                'longitude' => '-81.6206000',
                'city' => 'Waverly',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34240',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5006000',
                'longitude' => '-81.4357000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33960',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2940000',
                'longitude' => '-81.3684000',
                'city' => 'Venus',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34266',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2172000',
                'longitude' => '-81.8595000',
                'city' => 'Arcadia',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33871',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.2940000',
                'longitude' => '-81.3684000',
                'city' => 'Sebring',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33820',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8689000',
                'longitude' => '-81.7159000',
                'city' => 'Alturas',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33843',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7406000',
                'longitude' => '-81.5355000',
                'city' => 'Frostproof',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33831',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8899000',
                'longitude' => '-81.8332000',
                'city' => 'Bartow',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33811',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0317000',
                'longitude' => '-81.9504000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33930',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7678000',
                'longitude' => '-81.4376000',
                'city' => 'Felda',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33944',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7678000',
                'longitude' => '-81.4376000',
                'city' => 'Palmdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33935',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7678000',
                'longitude' => '-81.4376000',
                'city' => 'Labelle',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33827',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.7445000',
                'longitude' => '-81.5329000',
                'city' => 'Babson Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33806',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0317000',
                'longitude' => '-81.9504000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33807',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0317000',
                'longitude' => '-81.9504000',
                'city' => 'Lakeland',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33873',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Wauchula',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33867',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8072000',
                'longitude' => '-81.3303000',
                'city' => 'River Ranch',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33855',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8072000',
                'longitude' => '-81.3303000',
                'city' => 'Indian Lake Estates',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33856',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.8844000',
                'longitude' => '-81.4228000',
                'city' => 'Nalcrest',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33865',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4913000',
                'longitude' => '-81.7945000',
                'city' => 'Ona',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33849',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '28.0317000',
                'longitude' => '-81.9504000',
                'city' => 'Kathleen',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32206',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32204',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32084',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9631000',
                'longitude' => '-81.4755000',
                'city' => 'Saint Augustine',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32095',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9631000',
                'longitude' => '-81.4755000',
                'city' => 'Saint Augustine',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32202',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3037000',
                'longitude' => '-81.6560000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32209',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3037000',
                'longitude' => '-81.6560000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32035',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6651000',
                'longitude' => '-81.4576000',
                'city' => 'Fernandina Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32034',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6651000',
                'longitude' => '-81.4576000',
                'city' => 'Fernandina Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32086',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9001000',
                'longitude' => '-81.3155000',
                'city' => 'Saint Augustine',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32065',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1437000',
                'longitude' => '-81.7587000',
                'city' => 'Orange Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32068',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1437000',
                'longitude' => '-81.7587000',
                'city' => 'Middleburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32073',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1437000',
                'longitude' => '-81.7587000',
                'city' => 'Orange Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32003',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1665000',
                'longitude' => '-81.7002000',
                'city' => 'Fleming Island',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32244',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1665000',
                'longitude' => '-81.7002000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32246',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2883000',
                'longitude' => '-81.5246000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32222',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32217',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32224',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3219000',
                'longitude' => '-81.4460000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32225',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3219000',
                'longitude' => '-81.4460000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32227',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2830000',
                'longitude' => '-81.3924000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32250',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2848000',
                'longitude' => '-81.4467000',
                'city' => 'Jacksonville Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32216',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32211',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32256',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32097',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6182000',
                'longitude' => '-81.5829000',
                'city' => 'Yulee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32092',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1182000',
                'longitude' => '-81.6283000',
                'city' => 'Saint Augustine',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32259',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1182000',
                'longitude' => '-81.6283000',
                'city' => 'Saint Johns',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32257',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3290000',
                'longitude' => '-81.6635000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32210',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32258',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32233',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3059000',
                'longitude' => '-81.3952000',
                'city' => 'Atlantic Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32266',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3059000',
                'longitude' => '-81.3952000',
                'city' => 'Neptune Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32208',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3290000',
                'longitude' => '-81.6635000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32226',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3937000',
                'longitude' => '-81.4400000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32234',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2985000',
                'longitude' => '-81.9739000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32040',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2833000',
                'longitude' => '-82.1195000',
                'city' => 'Glen Saint Mary',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32087',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2833000',
                'longitude' => '-82.1195000',
                'city' => 'Sanderson',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32063',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2833000',
                'longitude' => '-82.1195000',
                'city' => 'Macclenny',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32223',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.1639000',
                'longitude' => '-81.6034000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32009',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3008000',
                'longitude' => '-81.9784000',
                'city' => 'Bryceville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32220',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3008000',
                'longitude' => '-81.9784000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32043',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.0704000',
                'longitude' => '-81.8637000',
                'city' => 'Green Cove Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32079',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9960000',
                'longitude' => '-81.6806000',
                'city' => 'Penney Farms',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32205',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3290000',
                'longitude' => '-81.6635000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32221',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2463000',
                'longitude' => '-81.7506000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32212',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2463000',
                'longitude' => '-81.7506000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32254',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2499000',
                'longitude' => '-81.5941000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32277',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32239',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32080',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Saint Augustine',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32218',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9001000',
                'longitude' => '-81.3155000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32219',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2563000',
                'longitude' => '-81.6267000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32185',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.2554000',
                'longitude' => '-81.5841000',
                'city' => 'Putnam Hall',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32085',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9001000',
                'longitude' => '-81.3155000',
                'city' => 'Saint Augustine',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32011',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.5573000',
                'longitude' => '-81.8350000',
                'city' => 'Callahan',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32050',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '29.9921000',
                'longitude' => '-81.6833000',
                'city' => 'Middleburg',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32241',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32235',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Jacksonville',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32046',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.6907000',
                'longitude' => '-81.9172000',
                'city' => 'Hilliard',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32058',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.0521000',
                'longitude' => '-82.0848000',
                'city' => 'Lawtey',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32007',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Bostwick',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32067',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Orange Park',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '32004',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '30.3250000',
                'longitude' => '-81.6661000',
                'city' => 'Ponte Vedra Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34205',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4912000',
                'longitude' => '-82.5686000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33980',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9657000',
                'longitude' => '-82.1170000',
                'city' => 'Punta Gorda',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33952',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9657000',
                'longitude' => '-82.1170000',
                'city' => 'Port Charlotte',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33983',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9306000',
                'longitude' => '-82.0506000',
                'city' => 'Punta Gorda',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34288',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.1020000',
                'longitude' => '-82.4434000',
                'city' => 'North Port',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34292',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.1020000',
                'longitude' => '-82.4434000',
                'city' => 'Venice',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33946',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.8575000',
                'longitude' => '-82.2917000',
                'city' => 'Placida',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34234',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34211',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4912000',
                'longitude' => '-82.5686000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34208',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4912000',
                'longitude' => '-82.5686000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34243',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34242',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34235',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34229',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Osprey',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34207',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34293',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Venice',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33948',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9793000',
                'longitude' => '-82.1023000',
                'city' => 'Port Charlotte',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33953',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9793000',
                'longitude' => '-82.1023000',
                'city' => 'Port Charlotte',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33954',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9793000',
                'longitude' => '-82.1023000',
                'city' => 'Port Charlotte',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34286',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.0482000',
                'longitude' => '-82.2409000',
                'city' => 'North Port',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34224',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Englewood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34287',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'North Port',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34239',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34236',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34278',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34233',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3287000',
                'longitude' => '-82.4409000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34202',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3287000',
                'longitude' => '-82.4409000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34238',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3287000',
                'longitude' => '-82.4409000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34203',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3287000',
                'longitude' => '-82.4409000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34228',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3366000',
                'longitude' => '-82.5368000',
                'city' => 'Longboat Key',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34277',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34285',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Venice',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34251',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3462000',
                'longitude' => '-82.1632000',
                'city' => 'Myakka City',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34241',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3231000',
                'longitude' => '-82.4504000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34201',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3744000',
                'longitude' => '-82.5482000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34276',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Sarasota',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34275',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Nokomis',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34223',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.1020000',
                'longitude' => '-82.4434000',
                'city' => 'Englewood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34289',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.0466000',
                'longitude' => '-82.2478000',
                'city' => 'North Port',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34204',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4912000',
                'longitude' => '-82.5686000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33949',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9657000',
                'longitude' => '-82.1170000',
                'city' => 'Port Charlotte',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33951',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9657000',
                'longitude' => '-82.1170000',
                'city' => 'Punta Gorda',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33982',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9657000',
                'longitude' => '-82.1170000',
                'city' => 'Punta Gorda',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33950',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9657000',
                'longitude' => '-82.1170000',
                'city' => 'Punta Gorda',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33981',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9605000',
                'longitude' => '-82.3561000',
                'city' => 'Port Charlotte',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34272',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.1020000',
                'longitude' => '-82.4434000',
                'city' => 'Laurel',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34221',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5141000',
                'longitude' => '-82.5718000',
                'city' => 'Palmetto',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33955',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9369000',
                'longitude' => '-82.0525000',
                'city' => 'Punta Gorda',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33947',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7400000',
                'longitude' => '-82.2602000',
                'city' => 'Rotonda West',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33922',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7400000',
                'longitude' => '-82.2602000',
                'city' => 'Bokeelia',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34222',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4912000',
                'longitude' => '-82.5686000',
                'city' => 'Ellenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34209',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4945000',
                'longitude' => '-82.5546000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34212',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4945000',
                'longitude' => '-82.5546000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34219',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4912000',
                'longitude' => '-82.5686000',
                'city' => 'Parrish',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34280',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.1020000',
                'longitude' => '-82.4434000',
                'city' => 'Bradenton',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34215',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.4913000',
                'longitude' => '-82.6398000',
                'city' => 'Cortez',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34973',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9657000',
                'longitude' => '-82.1170000',
                'city' => 'Okeechobee',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33938',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.9657000',
                'longitude' => '-82.1170000',
                'city' => 'Murdock',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34216',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5040000',
                'longitude' => '-82.7149000',
                'city' => 'Anna Maria',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34217',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.5040000',
                'longitude' => '-82.7149000',
                'city' => 'Bradenton Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '34135',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '27.3406000',
                'longitude' => '-82.5342000',
                'city' => 'Bonita Springs',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33921',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.7400000',
                'longitude' => '-82.2602000',
                'city' => 'Boca Grande',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33322',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1203000',
                'longitude' => '-80.2823000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33388',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1203000',
                'longitude' => '-80.2823000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33334',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1927000',
                'longitude' => '-80.1335000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33317',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33327',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33312',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33331',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33325',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33323',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33332',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1049000',
                'longitude' => '-80.3825000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33329',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33324',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33029',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33076',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.2579000',
                'longitude' => '-80.2509000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33068',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33302',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33351',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3077000',
                'longitude' => '-80.1287000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33313',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3077000',
                'longitude' => '-80.1287000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33066',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33330',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1203000',
                'longitude' => '-80.2823000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33305',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.3122000',
                'longitude' => '-80.1079000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33026',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33315',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1203000',
                'longitude' => '-80.2823000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33004',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.0715000',
                'longitude' => '-80.1872000',
                'city' => 'Dania',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33022',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.2327000',
                'longitude' => '-80.1189000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33321',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33083',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Hollywood',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33335',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33337',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1203000',
                'longitude' => '-80.2823000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33061',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33093',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Pompano Beach',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33082',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Pembroke Pines',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33303',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1171000',
                'longitude' => '-80.1420000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33008',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Hallandale',
                'full_state' => 'Florida',
            ],
            [
                'zip' => '33318',
                'country_code' => 'US',
                'state' => 'FL',
                'latitude' => '26.1636000',
                'longitude' => '-80.2063000',
                'city' => 'Fort Lauderdale',
                'full_state' => 'Florida',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
