<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DelawareSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '19958',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.7756000',
                'longitude' => '-75.1385000',
                'city' => 'Lewes',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19971',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.6517000',
                'longitude' => '-75.1885000',
                'city' => 'Rehoboth Beach',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19966',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.6517000',
                'longitude' => '-75.1885000',
                'city' => 'Millsboro',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19933',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.7409000',
                'longitude' => '-75.6060000',
                'city' => 'Bridgeville',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19934',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1173000',
                'longitude' => '-75.5555000',
                'city' => 'Camden Wyoming',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19939',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.5151000',
                'longitude' => '-75.2357000',
                'city' => 'Dagsboro',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19702',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.5822000',
                'longitude' => '-75.6466000',
                'city' => 'Newark',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19713',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.5822000',
                'longitude' => '-75.6466000',
                'city' => 'Newark',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19940',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.4587000',
                'longitude' => '-75.5763000',
                'city' => 'Delmar',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19906',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1597000',
                'longitude' => '-75.5306000',
                'city' => 'Dover',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19904',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1597000',
                'longitude' => '-75.5306000',
                'city' => 'Dover',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19943',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.0101000',
                'longitude' => '-75.5749000',
                'city' => 'Felton',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19946',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.0108000',
                'longitude' => '-75.4651000',
                'city' => 'Frederica',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19947',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.6930000',
                'longitude' => '-75.3821000',
                'city' => 'Georgetown',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19711',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Newark',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19950',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.8088000',
                'longitude' => '-75.5868000',
                'city' => 'Greenwood',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19720',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.6674000',
                'longitude' => '-75.5666000',
                'city' => 'New Castle',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19701',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.6674000',
                'longitude' => '-75.5666000',
                'city' => 'Bear',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19977',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.3038000',
                'longitude' => '-75.6080000',
                'city' => 'Smyrna',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19808',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.6838000',
                'longitude' => '-75.7493000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19805',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.6838000',
                'longitude' => '-75.7493000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19801',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19804',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19970',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.9172000',
                'longitude' => '-75.4284000',
                'city' => 'Ocean View',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19963',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.9172000',
                'longitude' => '-75.4284000',
                'city' => 'Milford',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19803',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19707',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7861000',
                'longitude' => '-75.6901000',
                'city' => 'Hockessin',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19969',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.6930000',
                'longitude' => '-75.3821000',
                'city' => 'Nassau',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19945',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.4897000',
                'longitude' => '-75.3604000',
                'city' => 'Frankford',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19979',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1173000',
                'longitude' => '-75.5555000',
                'city' => 'Viola',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19901',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1173000',
                'longitude' => '-75.5555000',
                'city' => 'Dover',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19806',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19802',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19810',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7838000',
                'longitude' => '-75.4716000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19807',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19973',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.6411000',
                'longitude' => '-75.6183000',
                'city' => 'Seaford',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19709',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Middletown',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19931',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.5578000',
                'longitude' => '-75.5720000',
                'city' => 'Bethel',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19956',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.5578000',
                'longitude' => '-75.5720000',
                'city' => 'Laurel',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19952',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.0074000',
                'longitude' => '-75.5701000',
                'city' => 'Harrington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19962',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.0074000',
                'longitude' => '-75.5701000',
                'city' => 'Magnolia',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19734',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.4538000',
                'longitude' => '-75.7168000',
                'city' => 'Townsend',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19730',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.4538000',
                'longitude' => '-75.7168000',
                'city' => 'Odessa',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '21842',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.0101000',
                'longitude' => '-75.5749000',
                'city' => 'Ocean City',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19717',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.6838000',
                'longitude' => '-75.7493000',
                'city' => 'Newark',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19953',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1415000',
                'longitude' => '-75.7005000',
                'city' => 'Hartly',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19809',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7838000',
                'longitude' => '-75.4716000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19968',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.7744000',
                'longitude' => '-75.3066000',
                'city' => 'Milton',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19941',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.8062000',
                'longitude' => '-75.5820000',
                'city' => 'Ellendale',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19703',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7838000',
                'longitude' => '-75.4716000',
                'city' => 'Claymont',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19357',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Mendenhall',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19348',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Kennett Square',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19938',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.3038000',
                'longitude' => '-75.6080000',
                'city' => 'Clayton',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19706',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.5822000',
                'longitude' => '-75.6466000',
                'city' => 'Delaware City',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19954',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.9251000',
                'longitude' => '-75.5737000',
                'city' => 'Houston',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19967',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.5498000',
                'longitude' => '-75.0877000',
                'city' => 'Millville',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19930',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.5498000',
                'longitude' => '-75.0877000',
                'city' => 'Bethany Beach',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19944',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.4580000',
                'longitude' => '-75.2251000',
                'city' => 'Fenwick Island',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19960',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.9145000',
                'longitude' => '-75.4236000',
                'city' => 'Lincoln',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19884',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7480000',
                'longitude' => '-75.5495000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19975',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.4580000',
                'longitude' => '-75.2251000',
                'city' => 'Selbyville',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19964',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1670000',
                'longitude' => '-75.7060000',
                'city' => 'Marydel',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '21804',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.0108000',
                'longitude' => '-75.4651000',
                'city' => 'Salisbury',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '21801',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.0108000',
                'longitude' => '-75.4651000',
                'city' => 'Salisbury',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19894',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7480000',
                'longitude' => '-75.5495000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19718',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.6822000',
                'longitude' => '-75.7362000',
                'city' => 'Newark',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19955',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.3011000',
                'longitude' => '-75.6032000',
                'city' => 'Kenton',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19902',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1607000',
                'longitude' => '-75.5223000',
                'city' => 'Dover Afb',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19961',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1607000',
                'longitude' => '-75.5223000',
                'city' => 'Little Creek',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19936',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1607000',
                'longitude' => '-75.5223000',
                'city' => 'Cheswold',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19951',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '38.7771000',
                'longitude' => '-75.3114000',
                'city' => 'Harbeson',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19880',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7480000',
                'longitude' => '-75.5495000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19898',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7480000',
                'longitude' => '-75.5495000',
                'city' => 'Wilmington',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19980',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.1156000',
                'longitude' => '-75.5424000',
                'city' => 'Woodside',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19716',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.6822000',
                'longitude' => '-75.7362000',
                'city' => 'Newark',
                'full_state' => 'Delaware',
            ],
            [
                'zip' => '19342',
                'country_code' => 'US',
                'state' => 'DE',
                'latitude' => '39.7453000',
                'longitude' => '-75.5447000',
                'city' => 'Glen Mills',
                'full_state' => 'Delaware',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
