<?php

namespace Database\Seeders\ImmutableData;

use App\Enums\SalesChannelFieldDefinitionDataTypeEnum;
use App\Models\Integration;
use App\Models\SalesChannelFieldDefinition;
use Illuminate\Database\Seeder;
use Modules\Ebay\Enums\EbayListingDurationCodeTypeEnum;
use Modules\Ebay\Enums\EbayListingTypeCodeTypeEnum;

class SalesChannelFieldDefinitionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        /**
         * Amazon US
         */
        //$integration = Integration::whereName(Integration::NAME_AMAZON_US)->first();

        /**
         * Shopify
         */
        //$integration = Integration::whereName(Integration::NAME_SHOPIFY)->first();

        /**
         * eBay
         */
        $integration = Integration::whereName(Integration::NAME_EBAY)->first();
        SalesChannelFieldDefinition::upsert([
            [
                'integration_id' => $integration->id,
                'field_name' => 'ApplicationData',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string|max:32']),
                'sort_order' => 0,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'SKU',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'Title',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|max:80']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'BuyItNowPrice',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['sometimes|numeric|decimal:2']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'StartPrice',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|numeric|decimal:2']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'PrimaryCategoryID',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|integer|digits_between:1,10']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'ConditionDescription',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['sometimes|string|max:1000']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'ConditionID',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|integer']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'Country',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string|max:2']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'Currency',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string|max:3']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'Description',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::HTML,
                'validation_rules' => json_encode(['required|string|max:500000']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'Brand',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string|max:65']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'ManufacturerPartNumber',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string|max:65']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'ListingDuration',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['sometimes|string|in:' . implode(',', array_column(EbayListingDurationCodeTypeEnum::cases(), 'value'))]),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'ListingType',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string|in:' . implode(',', array_column(EbayListingTypeCodeTypeEnum::cases(), 'value'))]),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'Location',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string|max:45']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'UPC',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'Quantity',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|integer|min:1']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'PaymentProfileName',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'ReturnProfileName',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'ShippingProfileName',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::STRING,
                'validation_rules' => json_encode(['required|string']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'PictureURL',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::JSON,
                'validation_rules' => json_encode(['sometimes|array|max:24']),
                'sort_order' => 1,
            ],
            [
                'integration_id' => $integration->id,
                'field_name' => 'ebaySiteId',
                'data_type' => SalesChannelFieldDefinitionDataTypeEnum::CUSTOM,
                'validation_rules' => json_encode(['required|integer']),
                'sort_order' => 0,
            ]
        ],
            ['integration_id', 'field_name'],
            ['field_name', 'data_type', 'validation_rules', 'sort_order']
        );

        /**
         * Magento 2
         */
        //$integration = Integration::whereName(Integration::NAME_MAGENTO)->first();

        /**
         * WooCommerce
         */
        //$integration = Integration::whereName(Integration::NAME_WOOCOMMERCE)->first();
    }
}
