<?php

namespace Database\Seeders\ImmutableData;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use Illuminate\Database\Seeder;

class IntegrationsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_SKU_IO]);
        $integration->description = 'Manual Orders';
        $integration->integration_settings_template = [];
        $integration->image_url = '/images/SKUIO_LOGO.png';
        $integration->supports_multiple_instances = false;
        $integration->integration_type = 'store';
        $integration->save();

        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = IntegrationInstance::with([])->firstOrNew(['integration_id' => $integration->id]);
        $integrationInstance->name = Integration::NAME_SKU_IO;
        $integrationInstance->country = null;
        $integrationInstance->connection_settings = json_encode([]);
        $integrationInstance->integration_settings = json_encode([]);
        $integrationInstance->save();

        /*
        |--------------------------------------------------------------------------
        | Sales Channels
        |--------------------------------------------------------------------------
        */

        /**
         * Amazon US
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_AMAZON_US]);
        $integration->description = 'Automate Amazon Inventory Control';
        $integration->integration_settings_template = [
            'orders' => ['download' => ['last_updated_after' => null, 'status' => [], 'auto_download' => ['enabled' => true, 'frequency_mins' => 15]]],
            'inventory' => ['master_of_stock' => null],
            'communications' => ['email_customers' => false],
        ];
        $integration->image_url = '/images/sales_channels/amazon_us_square.png';
        $integration->supports_multiple_instances = true;
        $integration->integration_type = Integration::TYPE_SALES_CHANNEL;
        $integration->integration_sub_type = 'marketplace';
        $integration->save();

        /**
         * Shopify
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_SHOPIFY]);
        $integration->name = Integration::NAME_SHOPIFY;
        $integration->description = 'Automate Shopify Inventory Control';
        $integration->integration_settings_template = [
            'orders' => ['download' => ['last_updated_after' => null, 'status' => [], 'auto_download' => ['enabled' => false, 'frequency_mins' => 15]]],
            'inventory' => ['master_of_stock' => null],
            'communications' => ['email_customers' => true],
        ];
        $integration->image_url = '/images/sales_channels/shopify_square.png';
        $integration->supports_multiple_instances = true;
        $integration->integration_type = Integration::TYPE_SALES_CHANNEL;
        $integration->save();

        /**
         * eBay
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_EBAY]);
        $integration->name = Integration::NAME_EBAY;
        $integration->description = 'Automate eBay Inventory Control';
        $integration->integration_settings_template = [];
        $integration->image_url = '/images/sales_channels/ebay_square.png';
        $integration->supports_multiple_instances = true;
        $integration->integration_type = Integration::TYPE_SALES_CHANNEL;
        $integration->save();

        /**
         * Magento 2
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_MAGENTO]);
        $integration->name = Integration::NAME_MAGENTO;
        $integration->description = 'Automate Magento Inventory Control';
        $integration->integration_settings_template = [
            'orders' => ['download' => ['last_updated_after' => null, 'status' => [], 'auto_download' => ['enabled' => false, 'frequency_mins' => 15]]],
            'inventory' => ['master_of_stock' => null],
            'communications' => ['email_customers' => true],
        ];
        $integration->image_url = '/images/sales_channels/magento.png';
        $integration->supports_multiple_instances = true;
        $integration->integration_type = Integration::TYPE_SALES_CHANNEL;
        $integration->save();

        /**
         * WooCommerce
         */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_WOOCOMMERCE]);
        $integration->description = 'Automate WooCommerce Inventory Control';
        $integration->integration_settings_template = [];
        $integration->image_url = '/images/sales_channels/woocommerce_square.png';
        $integration->supports_multiple_instances = true;
        $integration->integration_type = Integration::TYPE_SALES_CHANNEL;
        $integration->save();

        /*
        |--------------------------------------------------------------------------
        | Shipping Providers
        |--------------------------------------------------------------------------
        */

        /**
         * ShipStation
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_SHIPSTATION]);
        $integration->description = 'Automate order fulfillment with Shipstation';
        $integration->integration_settings_template = [];
        $integration->image_url = '/images/shipping_providers/shipstation_square.png';
        $integration->supports_multiple_instances = false;
        $integration->integration_type = Integration::TYPE_SHIPPING_PROVIDER;
        $integration->save();

        /**
         * ShipMyOrders (3PL)
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_SHIPMYORDERS]);
        $integration->description = 'Automate order fulfillment with ShipMyOrders';
        $integration->integration_settings_template = [];
        $integration->image_url = '/images/shipping_providers/shipmyorders.png';
        $integration->supports_multiple_instances = false;
        $integration->integration_type = Integration::TYPE_SHIPPING_PROVIDER;
        $integration->save();

        /**
         * Starshipit
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_STARSHIPIT]);
        $integration->description = 'Automate order fulfillment with Starshipit';
        $integration->integration_settings_template = ['webhook_url' => route('webhooks.starshipit')];
        $integration->image_url = '/images/shipping_providers/starshipit.svg';
        $integration->supports_multiple_instances = false;
        $integration->integration_type = Integration::TYPE_SHIPPING_PROVIDER;
        $integration->save();

        /**
         * Veracore
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_VERACORE]);
        $integration->description = 'Automate order fulfillment with Veracore';
        $integration->image_url = '/images/shipping_providers/veracore.png';
        $integration->supports_multiple_instances = false;
        $integration->integration_type = Integration::TYPE_SHIPPING_PROVIDER;
        $integration->save();

        /*
        |--------------------------------------------------------------------------
        | Accounting
        |--------------------------------------------------------------------------
        */

        /**
         * Xero
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_XERO]);
        $integration->name = Integration::NAME_XERO;
        $integration->description = 'Automate Xero Accounting';
        $integration->integration_settings_template = [];
        $integration->image_url = '/images/accounting/xero.png';
        $integration->supports_multiple_instances = false;
        $integration->integration_type = Integration::ACCOUNTING;
        $integration->save();

        /**
         * Qbo
         */
        /** @var Integration $integration */
        $integration = Integration::with([])->firstOrNew(['name' => Integration::NAME_QBO]);
        $integration->name = Integration::NAME_QBO;
        $integration->description = 'Automate QuickBooks Online Accounting';
        $integration->integration_settings_template = [];
        $integration->image_url = '/images/accounting/quickbooks.png';
        $integration->supports_multiple_instances = false;
        $integration->integration_type = Integration::ACCOUNTING;
        $integration->save();
    }
}
