<?php

namespace Database\Seeders\ImmutableData;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConstantsCountriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countries = [
            [
                'code' => 'WorldWide',
                'name' => 'WorldWide',
                'phone_code' => null,
                'continent_name' => 'WorldWide',
                'continent_code' => 'WorldWide',
            ],
            [
                'code' => 'AF',
                'name' => 'Afghanistan',
                'phone_code' => 93,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'AL',
                'name' => 'Albania',
                'phone_code' => 355,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'AQ',
                'name' => 'Antarctica',
                'phone_code' => 672,
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
            ],
            [
                'code' => 'DZ',
                'name' => 'Algeria',
                'phone_code' => 213,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'AS',
                'name' => 'American Samoa',
                'phone_code' => 684,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'AD',
                'name' => 'Andorra',
                'phone_code' => 376,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'AO',
                'name' => 'Angola',
                'phone_code' => 244,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'AG',
                'name' => 'Antigua And Barbuda',
                'phone_code' => 268,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'AZ',
                'name' => 'Azerbaijan',
                'phone_code' => 994,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'AR',
                'name' => 'Argentina',
                'phone_code' => 54,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'AU',
                'name' => 'Australia',
                'phone_code' => 61,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'AT',
                'name' => 'Austria',
                'phone_code' => 43,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'BS',
                'name' => 'Bahamas The',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'BH',
                'name' => 'Bahrain',
                'phone_code' => 973,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'BD',
                'name' => 'Bangladesh',
                'phone_code' => 880,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'AM',
                'name' => 'Armenia',
                'phone_code' => 374,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'BB',
                'name' => 'Barbados',
                'phone_code' => 246,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'BE',
                'name' => 'Belgium',
                'phone_code' => 32,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'BM',
                'name' => 'Bermuda',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'BT',
                'name' => 'Bhutan',
                'phone_code' => 975,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'BO',
                'name' => 'Bolivia',
                'phone_code' => 591,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'BA',
                'name' => 'Bosnia and Herzegovina',
                'phone_code' => 387,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'BW',
                'name' => 'Botswana',
                'phone_code' => 267,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'BV',
                'name' => 'Bouvet Island',
                'phone_code' => 47,
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
            ],
            [
                'code' => 'BR',
                'name' => 'Brazil',
                'phone_code' => 55,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'BZ',
                'name' => 'Belize',
                'phone_code' => 501,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'IO',
                'name' => 'British Indian Ocean Territory',
                'phone_code' => 246,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'SB',
                'name' => 'Solomon Islands',
                'phone_code' => 677,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'VG',
                'name' => 'Virgin Islands (British)',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'BN',
                'name' => 'Brunei',
                'phone_code' => 673,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'BG',
                'name' => 'Bulgaria',
                'phone_code' => 359,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'MM',
                'name' => 'Myanmar',
                'phone_code' => 95,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'BI',
                'name' => 'Burundi',
                'phone_code' => 257,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'BY',
                'name' => 'Belarus',
                'phone_code' => 375,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'KH',
                'name' => 'Cambodia',
                'phone_code' => 855,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'CM',
                'name' => 'Cameroon',
                'phone_code' => 237,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'CA',
                'name' => 'Canada',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'CV',
                'name' => 'Cape Verde',
                'phone_code' => 238,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'KY',
                'name' => 'Cayman Islands',
                'phone_code' => 345,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'CF',
                'name' => 'Central African Republic',
                'phone_code' => 236,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'LK',
                'name' => 'Sri Lanka',
                'phone_code' => 94,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'TD',
                'name' => 'Chad',
                'phone_code' => 235,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'CL',
                'name' => 'Chile',
                'phone_code' => 56,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'CN',
                'name' => 'China',
                'phone_code' => 86,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'TW',
                'name' => 'Taiwan',
                'phone_code' => 886,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'CX',
                'name' => 'Christmas Island',
                'phone_code' => 61,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'CC',
                'name' => 'Cocos (Keeling) Islands',
                'phone_code' => 672,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'CO',
                'name' => 'Colombia',
                'phone_code' => 57,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'KM',
                'name' => 'Comoros',
                'phone_code' => 269,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'YT',
                'name' => 'Mayotte',
                'phone_code' => 269,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'CG',
                'name' => 'Congo',
                'phone_code' => 242,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'CD',
                'name' => 'Congo The Democratic Republic Of The',
                'phone_code' => 242,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'CK',
                'name' => 'Cook Islands',
                'phone_code' => 682,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'CR',
                'name' => 'Costa Rica',
                'phone_code' => 506,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'HR',
                'name' => 'Croatia (Hrvatska)',
                'phone_code' => 385,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'CU',
                'name' => 'Cuba',
                'phone_code' => 53,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'CY',
                'name' => 'Cyprus',
                'phone_code' => 357,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'CZ',
                'name' => 'Czech Republic',
                'phone_code' => 420,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'BJ',
                'name' => 'Benin',
                'phone_code' => 229,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'DK',
                'name' => 'Denmark',
                'phone_code' => 45,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'DM',
                'name' => 'Dominica',
                'phone_code' => 767,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'DO',
                'name' => 'Dominican Republic',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'EC',
                'name' => 'Ecuador',
                'phone_code' => 593,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'SV',
                'name' => 'El Salvador',
                'phone_code' => 503,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'GQ',
                'name' => 'Equatorial Guinea',
                'phone_code' => 240,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'ET',
                'name' => 'Ethiopia',
                'phone_code' => 251,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'ER',
                'name' => 'Eritrea',
                'phone_code' => 291,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'EE',
                'name' => 'Estonia',
                'phone_code' => 372,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'FO',
                'name' => 'Faroe Islands',
                'phone_code' => 298,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'FK',
                'name' => 'Falkland Islands',
                'phone_code' => 500,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'GS',
                'name' => 'South Georgia',
                'phone_code' => 500,
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
            ],
            [
                'code' => 'FJ',
                'name' => 'Fiji Islands',
                'phone_code' => 679,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'FI',
                'name' => 'Finland',
                'phone_code' => 358,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'AX',
                'name' => 'Åland Islands',
                'phone_code' => 358,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'FR',
                'name' => 'France',
                'phone_code' => 33,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'GF',
                'name' => 'French Guiana',
                'phone_code' => 594,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'PF',
                'name' => 'French Polynesia',
                'phone_code' => 689,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'TF',
                'name' => 'French Southern Territories',
                'phone_code' => 262,
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
            ],
            [
                'code' => 'DJ',
                'name' => 'Djibouti',
                'phone_code' => 253,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'GA',
                'name' => 'Gabon',
                'phone_code' => 241,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'GE',
                'name' => 'Georgia',
                'phone_code' => 995,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'GM',
                'name' => 'Gambia The',
                'phone_code' => 220,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'PS',
                'name' => 'Palestinian Territory Occupied',
                'phone_code' => 970,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'DE',
                'name' => 'Germany',
                'phone_code' => 49,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'GH',
                'name' => 'Ghana',
                'phone_code' => 233,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'GI',
                'name' => 'Gibraltar',
                'phone_code' => 350,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'KI',
                'name' => 'Kiribati',
                'phone_code' => 686,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'GR',
                'name' => 'Greece',
                'phone_code' => 30,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'GL',
                'name' => 'Greenland',
                'phone_code' => 299,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'GD',
                'name' => 'Grenada',
                'phone_code' => 473,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'GP',
                'name' => 'Guadeloupe',
                'phone_code' => 590,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'GU',
                'name' => 'Guam',
                'phone_code' => 1,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'GT',
                'name' => 'Guatemala',
                'phone_code' => 502,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'GN',
                'name' => 'Guinea',
                'phone_code' => 224,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'GY',
                'name' => 'Guyana',
                'phone_code' => 592,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'HT',
                'name' => 'Haiti',
                'phone_code' => 509,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'HM',
                'name' => 'Heard and McDonald Islands',
                'phone_code' => 672,
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
            ],
            [
                'code' => 'VA',
                'name' => 'Vatican City State (Holy See)',
                'phone_code' => 39,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'HN',
                'name' => 'Honduras',
                'phone_code' => 504,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'HK',
                'name' => 'Hong Kong S.A.R.',
                'phone_code' => 852,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'HU',
                'name' => 'Hungary',
                'phone_code' => 36,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'IS',
                'name' => 'Iceland',
                'phone_code' => 354,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'IN',
                'name' => 'India',
                'phone_code' => 91,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'ID',
                'name' => 'Indonesia',
                'phone_code' => 62,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'IR',
                'name' => 'Iran',
                'phone_code' => 98,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'IQ',
                'name' => 'Iraq',
                'phone_code' => 964,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'IE',
                'name' => 'Ireland',
                'phone_code' => 353,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'IL',
                'name' => 'Israel',
                'phone_code' => 972,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'IT',
                'name' => 'Italy',
                'phone_code' => 39,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'CI',
                'name' => 'Cote D Ivoire (Ivory Coast)',
                'phone_code' => 225,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'JM',
                'name' => 'Jamaica',
                'phone_code' => 876,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'JP',
                'name' => 'Japan',
                'phone_code' => 81,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'KZ',
                'name' => 'Kazakhstan',
                'phone_code' => 7,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'JO',
                'name' => 'Jordan',
                'phone_code' => 962,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'KE',
                'name' => 'Kenya',
                'phone_code' => 254,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'KP',
                'name' => 'Korea North',
                'phone_code' => 850,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'KR',
                'name' => 'Korea South',
                'phone_code' => 82,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'KW',
                'name' => 'Kuwait',
                'phone_code' => 965,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'KG',
                'name' => 'Kyrgyzstan',
                'phone_code' => 996,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'LA',
                'name' => 'Laos',
                'phone_code' => 856,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'LB',
                'name' => 'Lebanon',
                'phone_code' => 961,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'LS',
                'name' => 'Lesotho',
                'phone_code' => 266,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'LV',
                'name' => 'Latvia',
                'phone_code' => 371,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'LR',
                'name' => 'Liberia',
                'phone_code' => 231,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'LY',
                'name' => 'Libya',
                'phone_code' => 218,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'LI',
                'name' => 'Liechtenstein',
                'phone_code' => 423,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'LT',
                'name' => 'Lithuania',
                'phone_code' => 370,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'LU',
                'name' => 'Luxembourg',
                'phone_code' => 352,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'MO',
                'name' => 'Macau S.A.R.',
                'phone_code' => 853,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'MG',
                'name' => 'Madagascar',
                'phone_code' => 261,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'MW',
                'name' => 'Malawi',
                'phone_code' => 265,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'MY',
                'name' => 'Malaysia',
                'phone_code' => 60,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'MV',
                'name' => 'Maldives',
                'phone_code' => 960,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'ML',
                'name' => 'Mali',
                'phone_code' => 223,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'MT',
                'name' => 'Malta',
                'phone_code' => 356,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'MQ',
                'name' => 'Martinique',
                'phone_code' => 596,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'MR',
                'name' => 'Mauritania',
                'phone_code' => 222,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'MU',
                'name' => 'Mauritius',
                'phone_code' => 230,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'MX',
                'name' => 'Mexico',
                'phone_code' => 52,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'MC',
                'name' => 'Monaco',
                'phone_code' => 377,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'MN',
                'name' => 'Mongolia',
                'phone_code' => 976,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'MD',
                'name' => 'Moldova',
                'phone_code' => 373,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'ME',
                'name' => 'Montenegro',
                'phone_code' => 382,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'MS',
                'name' => 'Montserrat',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'MA',
                'name' => 'Morocco',
                'phone_code' => 212,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'MZ',
                'name' => 'Mozambique',
                'phone_code' => 258,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'OM',
                'name' => 'Oman',
                'phone_code' => 968,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'NA',
                'name' => 'Namibia',
                'phone_code' => 264,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'NR',
                'name' => 'Nauru',
                'phone_code' => 674,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'NP',
                'name' => 'Nepal',
                'phone_code' => 977,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'NL',
                'name' => 'Netherlands The',
                'phone_code' => 31,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'AN',
                'name' => 'Netherlands Antilles',
                'phone_code' => 599,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'CW',
                'name' => 'Curaçao',
                'phone_code' => 599,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'AW',
                'name' => 'Aruba',
                'phone_code' => 297,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'SX',
                'name' => 'Sint Maarten',
                'phone_code' => 599,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'BQ',
                'name' => 'Bonaire, Sint Eustatius and Saba',
                'phone_code' => 599,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'NC',
                'name' => 'New Caledonia',
                'phone_code' => 687,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'VU',
                'name' => 'Vanuatu',
                'phone_code' => 678,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'NZ',
                'name' => 'New Zealand',
                'phone_code' => 64,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'NI',
                'name' => 'Nicaragua',
                'phone_code' => 505,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'NE',
                'name' => 'Niger',
                'phone_code' => 227,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'NG',
                'name' => 'Nigeria',
                'phone_code' => 234,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'NU',
                'name' => 'Niue',
                'phone_code' => 683,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'NF',
                'name' => 'Norfolk Island',
                'phone_code' => 672,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'NO',
                'name' => 'Norway',
                'phone_code' => 47,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'MP',
                'name' => 'Northern Mariana Islands',
                'phone_code' => 1,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'UM',
                'name' => 'United States Minor Outlying Islands',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'FM',
                'name' => 'Micronesia',
                'phone_code' => 691,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'MH',
                'name' => 'Marshall Islands',
                'phone_code' => 692,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'PW',
                'name' => 'Palau',
                'phone_code' => 680,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'PK',
                'name' => 'Pakistan',
                'phone_code' => 92,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'PA',
                'name' => 'Panama',
                'phone_code' => 507,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'PG',
                'name' => 'Papua new Guinea',
                'phone_code' => 675,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'PY',
                'name' => 'Paraguay',
                'phone_code' => 595,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'PE',
                'name' => 'Peru',
                'phone_code' => 51,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'PH',
                'name' => 'Philippines',
                'phone_code' => 63,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'PN',
                'name' => 'Pitcairn Island',
                'phone_code' => 64,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'PL',
                'name' => 'Poland',
                'phone_code' => 48,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'PT',
                'name' => 'Portugal',
                'phone_code' => 351,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'GW',
                'name' => 'Guinea-Bissau',
                'phone_code' => 245,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'TL',
                'name' => 'Timor-Leste',
                'phone_code' => 670,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'PR',
                'name' => 'Puerto Rico',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'QA',
                'name' => 'Qatar',
                'phone_code' => 974,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'RE',
                'name' => 'Reunion',
                'phone_code' => 262,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'RO',
                'name' => 'Romania',
                'phone_code' => 40,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'RU',
                'name' => 'Russia',
                'phone_code' => 70,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'RW',
                'name' => 'Rwanda',
                'phone_code' => 250,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'BL',
                'name' => 'Saint Barthelemy',
                'phone_code' => 590,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'SH',
                'name' => 'Saint Helena',
                'phone_code' => 290,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'KN',
                'name' => 'Saint Kitts And Nevis',
                'phone_code' => 869,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'AI',
                'name' => 'Anguilla',
                'phone_code' => 264,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'LC',
                'name' => 'Saint Lucia',
                'phone_code' => 758,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'MF',
                'name' => 'Saint Martin',
                'phone_code' => 590,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'PM',
                'name' => 'Saint Pierre and Miquelon',
                'phone_code' => 508,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'VC',
                'name' => 'Saint Vincent And The Grenadines',
                'phone_code' => 784,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'SM',
                'name' => 'San Marino',
                'phone_code' => 378,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'ST',
                'name' => 'Sao Tome and Principe',
                'phone_code' => 239,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'SA',
                'name' => 'Saudi Arabia',
                'phone_code' => 966,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'SN',
                'name' => 'Senegal',
                'phone_code' => 221,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'RS',
                'name' => 'Serbia',
                'phone_code' => 381,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'SC',
                'name' => 'Seychelles',
                'phone_code' => 248,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'SL',
                'name' => 'Sierra Leone',
                'phone_code' => 232,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'SG',
                'name' => 'Singapore',
                'phone_code' => 65,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'SK',
                'name' => 'Slovakia',
                'phone_code' => 421,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'VN',
                'name' => 'Vietnam',
                'phone_code' => 84,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'SI',
                'name' => 'Slovenia',
                'phone_code' => 386,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'SO',
                'name' => 'Somalia',
                'phone_code' => 252,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'ZA',
                'name' => 'South Africa',
                'phone_code' => 27,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'ZW',
                'name' => 'Zimbabwe',
                'phone_code' => 263,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'ES',
                'name' => 'Spain',
                'phone_code' => 34,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'SS',
                'name' => 'South Sudan',
                'phone_code' => 211,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'EH',
                'name' => 'Western Sahara',
                'phone_code' => 212,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'SD',
                'name' => 'Sudan',
                'phone_code' => 249,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'SR',
                'name' => 'Suriname',
                'phone_code' => 597,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'SJ',
                'name' => 'Svalbard And Jan Mayen Islands',
                'phone_code' => 47,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'SZ',
                'name' => 'Swaziland',
                'phone_code' => 268,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'SE',
                'name' => 'Sweden',
                'phone_code' => 46,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'CH',
                'name' => 'Switzerland',
                'phone_code' => 41,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'SY',
                'name' => 'Syria',
                'phone_code' => 963,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'TJ',
                'name' => 'Tajikistan',
                'phone_code' => 992,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'TH',
                'name' => 'Thailand',
                'phone_code' => 66,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'TG',
                'name' => 'Togo',
                'phone_code' => 228,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'TK',
                'name' => 'Tokelau',
                'phone_code' => 690,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'TO',
                'name' => 'Tonga',
                'phone_code' => 676,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'TT',
                'name' => 'Trinidad And Tobago',
                'phone_code' => 868,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'AE',
                'name' => 'United Arab Emirates',
                'phone_code' => 971,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'TN',
                'name' => 'Tunisia',
                'phone_code' => 216,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'TR',
                'name' => 'Turkey',
                'phone_code' => 90,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'TM',
                'name' => 'Turkmenistan',
                'phone_code' => 993,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'TC',
                'name' => 'Turks And Caicos Islands',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'TV',
                'name' => 'Tuvalu',
                'phone_code' => 688,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'UG',
                'name' => 'Uganda',
                'phone_code' => 256,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'UA',
                'name' => 'Ukraine',
                'phone_code' => 380,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'MK',
                'name' => 'Macedonia',
                'phone_code' => 389,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'EG',
                'name' => 'Egypt',
                'phone_code' => 20,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'GB',
                'name' => 'United Kingdom',
                'phone_code' => 44,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'GG',
                'name' => 'Guernsey',
                'phone_code' => 44,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'JE',
                'name' => 'Jersey',
                'phone_code' => 44,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'IM',
                'name' => 'Isle of Man',
                'phone_code' => 44,
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'TZ',
                'name' => 'Tanzania',
                'phone_code' => 255,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'US',
                'name' => 'United States',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'VI',
                'name' => 'Virgin Islands (US)',
                'phone_code' => 1,
                'continent_name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'BF',
                'name' => 'Burkina Faso',
                'phone_code' => 226,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'UY',
                'name' => 'Uruguay',
                'phone_code' => 598,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'UZ',
                'name' => 'Uzbekistan',
                'phone_code' => 998,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'VE',
                'name' => 'Venezuela',
                'phone_code' => 58,
                'continent_name' => 'South America',
                'continent_code' => 'SA',
            ],
            [
                'code' => 'WF',
                'name' => 'Wallis And Futuna Islands',
                'phone_code' => 681,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'WS',
                'name' => 'Samoa',
                'phone_code' => 684,
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'YE',
                'name' => 'Yemen',
                'phone_code' => 967,
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'ZM',
                'name' => 'Zambia',
                'phone_code' => 260,
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
            ],
        ];

        DB::table('constants_countries')->delete();

        DB::table('constants_countries')->insert($countries);
    }
}
