<?php

namespace Database\Seeders\ImmutableData;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConstantsContinentsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $continents = [
            [
                'code' => 'Asia',
                'name' => 'Asia',
                'continent_code' => 'AS',
            ],
            [
                'code' => 'Europe',
                'name' => 'Europe',
                'continent_code' => 'EU',
            ],
            [
                'code' => 'Antarctica',
                'name' => 'Antarctica',
                'continent_code' => 'AN',
            ],
            [
                'code' => 'Africa',
                'name' => 'Africa',
                'continent_code' => 'AF',
            ],
            [
                'code' => 'Oceania',
                'name' => 'Oceania',
                'continent_code' => 'OC',
            ],
            [
                'code' => 'North America',
                'name' => 'North America',
                'continent_code' => 'NA',
            ],
            [
                'code' => 'South America',
                'name' => 'South America',
                'continent_code' => 'SA',
            ],

        ];

        DB::table('constants_continents')->delete();

        DB::table('constants_continents')->insert($continents);
    }
}
