<?php

namespace Database\Seeders\ImmutableData\CAZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NunavutSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => 'X0A0R0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '45.8851000',
                'longitude' => '-72.4808000',
                'city' => 'Pangnirtung',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0V0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '74.6288000',
                'longitude' => '-95.0244000',
                'city' => 'Resolute',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0C0H0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '74.6288000',
                'longitude' => '-95.0244000',
                'city' => 'Repulse Bay',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0W0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '56.5428000',
                'longitude' => '-79.2298000',
                'city' => 'Sanikiluaq',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0E0C0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '68.6284000',
                'longitude' => '-95.8995000',
                'city' => 'Gjoa Haven',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0E1J0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '68.6284000',
                'longitude' => '-95.8995000',
                'city' => 'Gjoa Haven',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0X0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '72.9647000',
                'longitude' => '-84.4931000',
                'city' => 'Nanisivik',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0A0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '73.0329000',
                'longitude' => '-85.1841000',
                'city' => 'Arctic Bay',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0C0C0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '66.5096000',
                'longitude' => '-86.2485000',
                'city' => 'Coral Harbour',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0E1B0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '69.5356000',
                'longitude' => '-93.5396000',
                'city' => 'Tangier',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0C0G0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '62.8174000',
                'longitude' => '-92.0876000',
                'city' => 'Rankin Inlet',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0E1K0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '68.5346000',
                'longitude' => '-89.8257000',
                'city' => 'Kuujjuaq',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0C0A0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '64.3187000',
                'longitude' => '-96.0337000',
                'city' => 'Baker Lake',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0C0E0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '61.1176000',
                'longitude' => '-94.0726000',
                'city' => 'Arviat',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0C0J0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '62.1654000',
                'longitude' => '-92.5787000',
                'city' => 'Whale Cove',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0C0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '64.2331000',
                'longitude' => '-76.5524000',
                'city' => 'Cape Dorset',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0C0B0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '63.3504000',
                'longitude' => '-90.7063000',
                'city' => 'Chesterfield Inlet',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0S0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '71.8822000',
                'longitude' => '-79.5359000',
                'city' => 'Pond Inlet',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0E0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '69.4892000',
                'longitude' => '-71.2455000',
                'city' => 'Clyde River',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0B0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '67.1247000',
                'longitude' => '-65.1692000',
                'city' => 'Qikiqtarjuaq',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0K0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '68.7764000',
                'longitude' => '-81.2377000',
                'city' => 'Hall Beach',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0H0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '69.4011000',
                'longitude' => '-81.8221000',
                'city' => 'Iqaluit',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0L0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '69.4011000',
                'longitude' => '-81.8221000',
                'city' => 'Igloolik',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0N0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '62.8399000',
                'longitude' => '-69.8704000',
                'city' => 'Kimmirut',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A1H0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '63.7414000',
                'longitude' => '-68.5088000',
                'city' => 'Iqaluit',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0A0J0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '73.7798000',
                'longitude' => '-89.0545000',
                'city' => 'Grise Fiord',
                'full_state' => 'Nunavut',
            ],
            [
                'zip' => 'X0E0E0',
                'country_code' => 'CA',
                'state' => 'NU',
                'latitude' => '67.8242000',
                'longitude' => '-115.0799000',
                'city' => 'Kuujjuaq',
                'full_state' => 'Nunavut',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
